/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import jd.PluginWrapper;
import jd.config.SubConfiguration;
import jd.controlling.AccountController;
import jd.controlling.linkcrawler.LinkCrawlerDeepInspector;
import jd.http.Browser;
import jd.http.Cookies;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.parser.html.HTMLParser;
import jd.parser.html.InputField;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountInvalidException;
import jd.plugins.AccountRequiredException;
import jd.plugins.AccountUnavailableException;
import jd.plugins.BrowserAdapter;
import jd.plugins.DownloadConnectionVerifier;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.components.PluginJSonUtils;
import jd.plugins.components.SiteType;
import org.appwork.storage.JSonMapperException;
import org.appwork.storage.TypeRef;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Exceptions;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.net.URLHelper;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.jdownloader.captcha.v2.CaptchaHosterHelperInterface;
import org.jdownloader.captcha.v2.challenge.cloudflareturnstile.AbstractCloudflareTurnstileCaptcha;
import org.jdownloader.captcha.v2.challenge.cloudflareturnstile.CaptchaHelperHostPluginCloudflareTurnstile;
import org.jdownloader.captcha.v2.challenge.hcaptcha.CaptchaHelperHostPluginHCaptcha;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.CaptchaHelperHostPluginRecaptchaV2;
import org.jdownloader.downloader.hls.HLSDownloader;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.plugins.components.antiDDoSForHost;
import org.jdownloader.plugins.components.config.XFSConfig;
import org.jdownloader.plugins.components.config.XFSConfigVideo;
import org.jdownloader.plugins.components.hls.HlsContainer;
import org.jdownloader.plugins.config.PluginJsonConfig;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.scripting.JavaScriptEngineFactory;
import org.mozilla.javascript.EcmaError;

@HostPlugin(revision="$Revision: 51934 $", interfaceVersion=2, names={}, urls={})
public abstract class XFileSharingProBasic
extends antiDDoSForHost
implements DownloadConnectionVerifier {
    public static final String CAPTCHA_METHOD_ID_XFS_DEFAULT = "xfilesharingprobasic";
    public static final Pattern PATTERN_NORMAL = Pattern.compile("/([a-z0-9]{12})(/([^/]+)(?:\\.html))?", 2);
    public static final Pattern PATTERN_FILE = Pattern.compile("/file/([a-z0-9]{12})", 2);
    public static final Pattern PATTERN_EMBED_VIDEO = Pattern.compile("/embed-([a-z0-9]{12})\\.html", 2);
    public static final Pattern PATTERN_EMBED_VIDEO_2 = Pattern.compile("/e/([a-z0-9]{12})", 2);
    public static final Pattern PATTERN_SHORT = Pattern.compile("/d/([A-Za-z0-9]+)", 2);
    public static final Pattern PATTERN_OFFICIAL_VIDEO_DOWNLOAD = Pattern.compile("/d/([a-z0-9]{12})", 2);
    public static final Pattern PATTERN_IMAGE = Pattern.compile("/(?:th|i)/\\d+/([a-z0-9]{12})", 2);
    protected WeakHashMap<Request, String[]> correctedBrowserRequestMap = new WeakHashMap();
    private static Map<String, AtomicInteger> freeRunning = new HashMap<String, AtomicInteger>();
    protected static final String PROPERTY_ACCOUNT_apikey = "apikey";
    private static final String PROPERTY_PLUGIN_api_domain_with_protocol = "apidomain";
    protected static final String PROPERTY_PLUGIN_REPORT_FILE_AVAILABLECHECK_LAST_FAILURE_TIMESTAMP = "REPORT_FILE_AVAILABLECHECK_LAST_FAILURE_TIMESTAMP";
    protected static final String PROPERTY_PLUGIN_REPORT_FILE_AVAILABLECHECK_LAST_FAILURE_VERSION = "REPORT_FILE_AVAILABLECHECK_LAST_FAILURE_VERSION";
    public static final String PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_FAILURE_TIMESTAMP = "ALT_AVAILABLECHECK_LAST_FAILURE_TIMESTAMP";
    private static final String PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_FAILURE_VERSION = "ALT_AVAILABLECHECK_LAST_FAILURE_VERSION";
    public static final String PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_WORKING = "ALT_AVAILABLECHECK_LAST_WORKING";
    public static final String PROPERTY_PLUGIN_LAST_WORKING_PAYMENT_URL = "last_working_payment_url";
    protected static final String PROPERTY_ACCOUNT_ALLOW_API_DOWNLOAD_ATTEMPT_IN_WEBSITE_MODE = "allow_api_download_attempt_in_website_mode";
    private String videoStreamDownloadurl = null;
    private boolean hasCheckedEmbedHandling = false;
    protected static final String PROPERTY_REFERER_REQUIRED = "PROPERTY_REFERER_REQUIRED";
    private final ThreadLocal<WeakHashMap<Browser, Boolean>> correctBrowserMap = new ThreadLocal();
    private static WeakHashMap<Account, Boolean> TRUST_ACCOUNT_API = new WeakHashMap();

    public XFileSharingProBasic(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Override
    public Browser createNewBrowserInstance() {
        Browser br = super.createNewBrowserInstance();
        br.setFollowRedirects(true);
        return br;
    }

    public static final String getDefaultAnnotationPatternPart() {
        return "/(d/[A-Za-z0-9]+|(d|e)/[a-z0-9]{12}|embed-[a-z0-9]{12}\\.html|[a-z0-9]{12}(/[^/]+(?:\\.html)?)?)";
    }

    public static String[] buildAnnotationUrls(List<String[]> pluginDomains) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String[] domains : pluginDomains) {
            ret.add("https?://(?:www\\.)?" + XFileSharingProBasic.buildHostsPatternPart(domains) + "(?::\\d+)?" + XFileSharingProBasic.getDefaultAnnotationPatternPart());
        }
        return ret.toArray(new String[0]);
    }

    protected List<String> getDeadDomains() {
        return null;
    }

    @Override
    protected String getDefaultFileName(DownloadLink link) {
        return this.getFallbackFilename(link, this.br);
    }

    @Override
    public LazyPlugin.FEATURE[] getFeatures() {
        ArrayList<LazyPlugin.FEATURE> ret = new ArrayList<LazyPlugin.FEATURE>();
        if (this.enableAccountApiOnlyMode()) {
            ret.add(LazyPlugin.FEATURE.API_KEY_LOGIN);
        } else if (this.requiresCookieLogin()) {
            ret.add(LazyPlugin.FEATURE.COOKIE_LOGIN_ONLY);
        } else {
            ret.add(LazyPlugin.FEATURE.COOKIE_LOGIN_OPTIONAL);
        }
        if (this.isImagehoster()) {
            ret.add(LazyPlugin.FEATURE.IMAGE_HOST);
        }
        if (this.isVideohoster(null)) {
            ret.add(LazyPlugin.FEATURE.VIDEO_STREAMING);
        }
        return ret.toArray(new LazyPlugin.FEATURE[0]);
    }

    @Override
    public String getAGBLink() {
        return this.getMainPage() + "/tos.html";
    }

    public String getPurchasePremiumURL() {
        return this.getMainPage() + "/premium.html";
    }

    @Override
    public boolean isResumeable(DownloadLink link, Account account) {
        if (this.isPremium(account)) {
            return true;
        }
        return this.isFree(account);
    }

    protected boolean isPremium(Account account) {
        Account.AccountType type = account != null ? account.getType() : null;
        return Account.AccountType.PREMIUM.equals((Object)type) || Account.AccountType.LIFETIME.equals((Object)type);
    }

    protected boolean isFree(Account account) {
        Account.AccountType type = account != null ? account.getType() : null;
        return Account.AccountType.FREE.equals((Object)type);
    }

    public int getMaxChunks(Account account) {
        if (this.isPremium(account)) {
            return 0;
        }
        if (this.isFree(account)) {
            return 1;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AtomicInteger getFreeRunning() {
        Map<String, AtomicInteger> map = freeRunning;
        synchronized (map) {
            AtomicInteger ret = freeRunning.get(this.getHost());
            if (ret == null) {
                ret = new AtomicInteger(0);
                freeRunning.put(this.getHost(), ret);
            }
            return ret;
        }
    }

    @Override
    public int getMaxSimultanFreeDownloadNum() {
        int max = this.getMaxSimultaneousFreeAnonymousDownloads();
        if (max == -1) {
            return -1;
        }
        int running = this.getFreeRunning().get();
        int ret = Math.min(running + 1, max);
        return ret;
    }

    public int getMaxSimultaneousFreeAnonymousDownloads() {
        return 1;
    }

    public int getMaxSimultaneousFreeAccountDownloads() {
        return 1;
    }

    @Override
    public int getMaxSimultanPremiumDownloadNum() {
        return Integer.MAX_VALUE;
    }

    protected String getDownloadModeDirectlinkProperty(Account account) {
        if (this.isFree(account)) {
            return "freelink2";
        }
        if (this.isPremium(account)) {
            return "premlink";
        }
        return "freelink";
    }

    protected boolean useHTTPS() {
        return this.websiteSupportsHTTPS() && this.userPrefersHTTPS();
    }

    protected boolean websiteSupportsHTTPS() {
        return true;
    }

    protected boolean userPrefersHTTPS() {
        Class<? extends XFSConfig> cfgO = this.getConfigInterface();
        if (cfgO != null) {
            return !PluginJsonConfig.get(cfgO).isPreferHTTP();
        }
        return true;
    }

    protected String[] supportsPreciseExpireDate() {
        return new String[]{"/?op=payments", "/upgrade"};
    }

    protected boolean isVideohosterEmbed() {
        return false;
    }

    protected boolean isVideohosterEmbedHTML(Browser br) {
        if (br == null) {
            return false;
        }
        String fuid = this.getFUIDFromURL(this.getDownloadLink());
        if (br.containsHTML("/embed-" + fuid + "\\.html")) {
            return true;
        }
        if (br.containsHTML("/e/" + fuid)) {
            return true;
        }
        if (br.containsHTML(fuid + "_t\\.jpg")) {
            return true;
        }
        if (br.containsHTML(fuid + "_o")) {
            return true;
        }
        return br.containsHTML("This video can be watched as embed only\\s*<");
    }

    protected boolean isVideohoster_enforce_video_filename() {
        return false;
    }

    protected boolean isImagehoster() {
        return false;
    }

    protected boolean isVideohoster(Browser br) {
        return this.isVideohosterEmbed() || br != null && this.isVideohosterEmbedHTML(br);
    }

    protected boolean supports_availablecheck_alt() {
        return true;
    }

    protected boolean supports_availablecheck_filesize_alt_fast() {
        return true;
    }

    protected boolean supports_availablecheck_filename_abuse() {
        return true;
    }

    protected boolean supports_availablecheck_filesize_html() {
        return true;
    }

    protected boolean supports_availablecheck_filesize_bytes_from_sharebox() {
        return true;
    }

    protected boolean supports_availablecheck_filesize_via_embedded_video() {
        return false;
    }

    protected boolean requiresWWW() {
        return false;
    }

    protected boolean supportsHEADRequestForDirecturlCheck() {
        return true;
    }

    protected boolean enableAccountApiOnlyMode() {
        return false;
    }

    protected boolean requiresCookieLogin() {
        return false;
    }

    protected boolean trustAvailablecheckVideoEmbed() {
        return false;
    }

    protected boolean allowAPIDownloadIfApikeyIsAvailable(DownloadLink link, Account account) {
        boolean apikey_is_available;
        if (account == null) {
            return false;
        }
        boolean bl = apikey_is_available = this.getAPIKeyFromAccount(account) != null;
        return apikey_is_available && account.hasProperty(PROPERTY_ACCOUNT_ALLOW_API_DOWNLOAD_ATTEMPT_IN_WEBSITE_MODE);
    }

    protected boolean allowAPIAvailablecheckInPremiumModeIfApikeyIsAvailable(Account account) {
        boolean apikey_is_available = this.getAPIKeyFromAccount(account) != null;
        boolean allow_api_availablecheck_in_premium_mode = false;
        if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE || apikey_is_available) {
            // empty if block
        }
        return false;
    }

    protected boolean requiresAPIGetdllinkCloneWorkaround(Account account) {
        boolean allow_dllink_clone_workaround = false;
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            // empty if block
        }
        return false;
    }

    protected boolean preDownloadWaittimeSkippable() {
        return false;
    }

    protected boolean supportsMassLinkcheckOverWebsite() {
        return false;
    }

    protected boolean supportsShortURLs() {
        return true;
    }

    @Override
    public String getLinkID(DownloadLink link) {
        String fuid = this.getFUIDFromURL(link);
        if (fuid != null) {
            return this.getHost() + "://" + fuid;
        }
        return super.getLinkID(link);
    }

    protected boolean isEmbedURL(DownloadLink link) {
        return this.isEmbedURLType(this.getURLType(link));
    }

    protected boolean isEmbedURL(String url) {
        return this.isEmbedURLType(this.getURLType(url));
    }

    protected boolean isEmbedURLType(URL_TYPE type) {
        return URL_TYPE.EMBED_VIDEO.equals((Object)type) || URL_TYPE.EMBED_VIDEO_2.equals((Object)type);
    }

    protected String buildEmbedURLPath(DownloadLink link, String fuid) {
        return this.buildURLPath(link, fuid, URL_TYPE.EMBED_VIDEO);
    }

    protected String buildNormalURLPath(DownloadLink link, String fuid) {
        return this.buildURLPath(link, fuid, URL_TYPE.NORMAL);
    }

    protected String buildImageURLPath(DownloadLink link, String fuid) {
        return this.buildURLPath(link, fuid, URL_TYPE.IMAGE);
    }

    protected String buildNormalFileURLPath(DownloadLink link, String fuid) {
        return this.buildURLPath(link, fuid, URL_TYPE.FILE);
    }

    protected String buildShortURLPath(DownloadLink link, String fuid) {
        return this.buildURLPath(link, fuid, URL_TYPE.SHORT);
    }

    protected String buildURLPath(DownloadLink link, String fuid, URL_TYPE type) {
        switch (type) {
            case EMBED_VIDEO: {
                return "/embed-" + fuid + ".html";
            }
            case EMBED_VIDEO_2: {
                return "/e/" + fuid;
            }
            case FILE: {
                return "/file/" + fuid;
            }
            case IMAGE: {
                return "/" + fuid;
            }
            case NORMAL: {
                return "/" + fuid;
            }
            case SHORT: {
                return "/d/" + fuid;
            }
            case OFFICIAL_VIDEO_DOWNLOAD: {
                return "/d/" + fuid;
            }
        }
        throw new IllegalArgumentException("Unsupported type:" + (Object)((Object)type) + "|" + fuid);
    }

    protected String getNormalizedDownloadURL(DownloadLink link) {
        String fuid = this.getFUIDFromURL(link);
        String base = this.getMainPage(this.br);
        if (fuid == null) {
            return this.getContentURL(link);
        }
        URL_TYPE urltype = this.getURLType(link);
        if (urltype == URL_TYPE.EMBED_VIDEO) {
            return base + this.buildURLPath(link, fuid, URL_TYPE.NORMAL);
        }
        if (urltype == URL_TYPE.IMAGE) {
            return base + this.buildURLPath(link, fuid, URL_TYPE.NORMAL);
        }
        if (urltype == URL_TYPE.EMBED_VIDEO_2) {
            return base + this.buildURLPath(link, fuid, URL_TYPE.OFFICIAL_VIDEO_DOWNLOAD);
        }
        return this.getContentURL(link);
    }

    protected String getPreferredHost(DownloadLink link, URL url) {
        if (this.isImagehoster()) {
            return this.getHost();
        }
        return url.getHost();
    }

    protected boolean allowGetProtocolHttpsAutoHandling(String url) {
        return true;
    }

    protected String getContentURL(DownloadLink link) {
        if (link == null) {
            return null;
        }
        String originalURL = link.getPluginPatternMatcher();
        if (originalURL == null) {
            return null;
        }
        try {
            URL url = new URL(originalURL);
            String urlHost = this.getPreferredHost(link, url);
            String urlHostWithoutWww = urlHost.replaceFirst("(?i)www\\.", "");
            String protocol = this.useHTTPS() ? "https://" : ("https".equalsIgnoreCase(url.getProtocol()) && this.allowGetProtocolHttpsAutoHandling(originalURL) ? "https://" : "http://");
            String pluginHost = this.getHost();
            List<String> deadDomains = this.getDeadDomains();
            String host = deadDomains != null && (deadDomains.contains(urlHost) || deadDomains.contains(urlHostWithoutWww)) ? urlHost.replaceFirst("(?i)" + Pattern.quote(Browser.getHost((URL)url, (boolean)false)) + "$", pluginHost) : urlHost;
            String hostCorrected = this.appendWWWIfRequired(host);
            return originalURL.replaceFirst("(?i)^https?://[^/]+", protocol + hostCorrected);
        }
        catch (MalformedURLException e) {
            this.logger.log((Throwable)e);
            return originalURL;
        }
    }

    @Override
    public String buildExternalDownloadURL(DownloadLink link, PluginForHost buildForThisPlugin) {
        return this.getContentURL(link);
    }

    @Override
    public Browser prepBrowser(Browser prepBr, String host) {
        if (!this.browserPrepped.containsKey(prepBr) || this.browserPrepped.get(prepBr) != Boolean.TRUE) {
            super.prepBrowser(prepBr, host);
            prepBr.setCookie(this.getMainPage(), "lang", "english");
            prepBr.setAllowedResponseCodes(new int[]{500});
        }
        return prepBr;
    }

    @Deprecated
    protected String getMainPage() {
        return this.getMainPage(this.br);
    }

    protected String getMainPage(DownloadLink link) {
        URL url;
        try {
            url = new URL(link.getPluginPatternMatcher());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        String urlHost = this.getPreferredHost(link, url);
        List<String> deadDomains = this.getDeadDomains();
        String domainToUse = deadDomains != null && deadDomains.contains(urlHost) ? this.getHost() : urlHost;
        String protocol = this.useHTTPS() ? "https://" : ("https".equalsIgnoreCase(url.getProtocol()) && this.allowGetProtocolHttpsAutoHandling(url.toExternalForm()) ? "https://" : "http://");
        String finalDomainToUse = this.appendWWWIfRequired(domainToUse);
        return protocol + finalDomainToUse;
    }

    protected String appendWWWIfRequired(String host) {
        if (!this.requiresWWW() || StringUtils.startsWithCaseInsensitive((String)host, (String)"www.")) {
            return host;
        }
        String hostTld = Browser.getHost((String)host, (boolean)false);
        if (!StringUtils.equalsIgnoreCase((String)host, (String)hostTld)) {
            return host;
        }
        return "www." + host;
    }

    protected String getMainPage(Browser br) {
        Request request = br != null ? br.getRequest() : null;
        String host = request != null ? request.getURL().getHost() : this.getHost();
        String protocol = this.useHTTPS() ? "https://" : (request != null && "https".equalsIgnoreCase(request.getURL().getProtocol()) && this.allowGetProtocolHttpsAutoHandling(request.getUrl()) ? "https://" : "http://");
        String finalHost = this.appendWWWIfRequired(host);
        return protocol + finalHost;
    }

    public boolean isPasswordProtectedHTML(Browser br, Form pwForm) {
        String pattern = "<br>\\s*<b>\\s*Passwor(d|t)\\s*:\\s*</b>\\s*(<input|</div)";
        boolean ret = br.containsHTML("<br>\\s*<b>\\s*Passwor(d|t)\\s*:\\s*</b>\\s*(<input|</div)");
        if (ret && !(ret = new org.appwork.utils.Regex(this.correctBR(br), "<br>\\s*<b>\\s*Passwor(d|t)\\s*:\\s*</b>\\s*(<input|</div)").patternFind())) {
            this.logger.warning("File is password protected according to html but is not password protected according to cleaned HTML!");
        }
        return ret;
    }

    protected boolean isPremiumOnlyURL(Browser br) {
        String url;
        String string = url = br != null ? br.getURL() : null;
        if (url == null) {
            return false;
        }
        if (StringUtils.containsIgnoreCase((String)url, (String)"/?op=login&redirect=")) {
            return true;
        }
        if (url.matches("(?i).*/login\\?redirect=.*")) {
            return true;
        }
        String[] supports_precise_expire_date = this.supportsPreciseExpireDate();
        if (supports_precise_expire_date != null) {
            for (String page : supports_precise_expire_date) {
                if (!StringUtils.containsIgnoreCase((String)url, (String)page)) continue;
                return true;
            }
        }
        return false;
    }

    protected String getPremiumOnlyErrorMessage(Browser br) {
        ArrayList<String> texts = new ArrayList<String>();
        texts.add("The file you requested reached max downloads");
        texts.add("This file reached max downloads");
        texts.add("Available Only for Premium Members");
        texts.add("File is available only for Premium users");
        texts.add("Please Buy Premium To download");
        texts.add("This file is not available for free download");
        texts.add("Only Premium user can download this file");
        texts.add("This video is available for Premium Users only");
        texts.add("This file is available for Premium Users only");
        String msg = null;
        for (String text : texts) {
            msg = br.getRegex(">(\\s*" + Pattern.quote(text) + "[^<]*)").getMatch(0);
            if (msg == null) continue;
            break;
        }
        if (msg == null && (msg = br.getRegex(">((\\s*Sorry\\s*,)?\\s*This file (can|only can|can only) be downloaded by[^<]+)").getMatch(0)) == null) {
            msg = br.getRegex(">\\s*(You can download files up to \\d+ [^<]*)").getMatch(0);
        }
        if (msg != null) {
            msg = Encoding.htmlDecode(msg).trim();
            return msg;
        }
        return null;
    }

    public boolean isPremiumOnly(Browser br) {
        if (this.isPremiumOnlyURL(br)) {
            return true;
        }
        String msg = this.getPremiumOnlyErrorMessage(br);
        return msg != null;
    }

    protected boolean isServerUnderMaintenance(Browser br) {
        return br.getHttpConnection().getResponseCode() == 500 || br.containsHTML(">\\s*This server is in maintenance mode");
    }

    protected boolean isOffline(DownloadLink link, Browser br) {
        if (br.getHttpConnection().getResponseCode() == 404) {
            return true;
        }
        if (br.containsHTML("No such file")) {
            return true;
        }
        if (br.containsHTML(">\\s*File Not Found\\s*<")) {
            return true;
        }
        if (br.containsHTML(">\\s*File Deleted\\s*<")) {
            return true;
        }
        if (br.containsHTML(">\\s*The file was removed by")) {
            return true;
        }
        if (br.containsHTML(">[^<>]*Reason for deletion:?") || br.containsHTML(">\\s*File has been removed due to copyright issues\\s*<")) {
            return true;
        }
        if (br.containsHTML(">\\s*The file expired")) {
            return true;
        }
        if (br.containsHTML(">\\s*Sorry, we can't find the page you're looking for")) {
            return true;
        }
        if (br.containsHTML(">\\s*File could not be found due to expiration or removal by the file owner")) {
            return true;
        }
        if (br.containsHTML(">\\s*The file of the above link no longer exists")) {
            return true;
        }
        if (br.containsHTML(">\\s*video you are looking for is not found")) {
            return true;
        }
        if (br.containsHTML(">\\s*The file you were looking for doesn't exist")) {
            return true;
        }
        return br.containsHTML(">\\s*File is no longer available as it");
    }

    protected boolean isReferrerBlocked(Browser br) {
        return br.containsHTML(">\\s*This video cannot be watched under this domain");
    }

    @Override
    public boolean checkLinks(DownloadLink[] urls) {
        String apiKey = this.getAPIKey();
        if (this.enableAccountApiOnlyMode() || this.supportsAPIMassLinkcheck() && this.looksLikeValidAPIKey(apiKey)) {
            return this.massLinkcheckerAPI(urls, apiKey);
        }
        if (this.supportsMassLinkcheckOverWebsite()) {
            return this.massLinkcheckerWebsite(urls);
        }
        return false;
    }

    @Override
    public boolean enoughTrafficFor(DownloadLink link, Account account) throws Exception {
        String dllink = this.getStoredDirectUrl(link, account);
        if (StringUtils.isNotEmpty((String)dllink)) {
            return true;
        }
        return super.enoughTrafficFor(link, account);
    }

    @Override
    public DownloadLink.AvailableStatus requestFileInformation(DownloadLink link) throws Exception {
        return this.requestFileInformation(link, null);
    }

    protected DownloadLink.AvailableStatus requestFileInformation(DownloadLink link, Account account) throws Exception {
        String apikey = this.getAPIKey();
        if (this.supportsAPISingleLinkcheck() && apikey != null) {
            return this.requestFileInformationAPI(link, apikey);
        }
        return this.requestFileInformationWebsite(link, null);
    }

    @Override
    protected boolean looksLikeDownloadableContent(URLConnectionAdapter urlConnection) {
        block6: {
            if (!super.looksLikeDownloadableContent(urlConnection)) {
                long verifiedFileSize = this.getDownloadLink().getVerifiedFileSize();
                if (urlConnection.getResponseCode() != 200 && urlConnection.getResponseCode() != 206 || verifiedFileSize <= 0L || verifiedFileSize != urlConnection.getCompleteContentLength()) {
                    return false;
                }
            }
            try {
                byte[] probe = urlConnection.peek(32);
                if (probe.length <= 0) break block6;
                String probeContext = new String(probe, "UTF-8");
                Request clone = urlConnection.getRequest().cloneRequest();
                clone.setHtmlCode(probeContext);
                Browser br = this.createNewBrowserInstance();
                br.setRequest(clone);
                try {
                    this.checkServerErrors(br, this.getDownloadLink(), null);
                }
                catch (PluginException e) {
                    this.logger.log((Throwable)e);
                    return false;
                }
            }
            catch (IOException e) {
                this.logger.log((Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean probeDirectDownload(DownloadLink link, Account account, Browser br, Request request, boolean setFilesize) throws Exception {
        request.getHeaders().put("Accept-Encoding", "identity");
        String referer = this.getReferer(link);
        if (referer != null) {
            request.getHeaders().put("Referer", referer);
        }
        URLConnectionAdapter con = null;
        try {
            con = this.openAntiDDoSRequestConnection(br, request);
            if (this.looksLikeDownloadableContent(con)) {
                String connectionFilename;
                long completeContentLength = con.getCompleteContentLength();
                if (setFilesize && completeContentLength > 0L) {
                    if (con.isContentDecoded()) {
                        link.setDownloadSize(completeContentLength);
                    } else {
                        link.setVerifiedFileSize(completeContentLength);
                    }
                }
                if (!StringUtils.isEmpty((String)(connectionFilename = Plugin.getFileNameFromConnection(con)))) {
                    link.setFinalFileName(connectionFilename);
                }
                this.storeDirecturl(link, account, con.getURL().toExternalForm());
                boolean bl = true;
                return bl;
            }
            br.followConnection();
            this.runPostRequestTask(br);
            this.correctBR(br);
            boolean bl = false;
            return bl;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public DownloadLink.AvailableStatus requestFileInformationWebsiteXFSOld(DownloadLink link, Account account) throws Exception {
        String fuid;
        boolean isDownload = Plugin.PluginEnvironment.DOWNLOAD.equals((Object)this.getPluginEnvironment());
        String contentURL = this.getContentURL(link);
        if (this.probeDirectDownload(link, account, this.br, (Request)this.br.createGetRequest(this.getContentURL(link)), true)) {
            return DownloadLink.AvailableStatus.TRUE;
        }
        if (this.supportsShortURLs()) {
            this.resolveShortURL(this.br, link, account);
        }
        URL_TYPE urltype = this.getURLType(this.br.getURL());
        PluginException embedException = null;
        if (urltype == URL_TYPE.EMBED_VIDEO) {
            try {
                this.hasCheckedEmbedHandling = true;
                this.requestFileInformationVideoEmbedXFSOld(this.br, link, account, true);
                if (this.trustAvailablecheckVideoEmbed()) {
                    return DownloadLink.AvailableStatus.TRUE;
                }
            }
            catch (PluginException e) {
                embedException = e;
                this.logger.log((Throwable)e);
            }
        }
        if ((fuid = this.getFUIDFromURL(link)) == null) {
            throw new PluginException(0x400000);
        }
        String url = urltype == URL_TYPE.NORMAL || urltype == URL_TYPE.SHORT ? this.getContentURL(link) : this.getMainPage(this.br) + this.buildURLPath(link, fuid, URL_TYPE.NORMAL);
        if (!StringUtils.equals((String)url, (String)contentURL) && this.probeDirectDownload(link, account, this.br, (Request)this.br.createGetRequest(url), true)) {
            return DownloadLink.AvailableStatus.TRUE;
        }
        if (this.isOffline(link, this.br)) {
            if (embedException != null) {
                throw embedException;
            }
            if (this.hasCheckedEmbedHandling) {
                this.logger.info("Item looks to be online according to embed check but offline according to official video download handling");
                return DownloadLink.AvailableStatus.TRUE;
            }
            throw new PluginException(32);
        }
        String[] fileInfo = this.internal_getFileInfoArray();
        Browser altbr = this.br.cloneBrowser();
        if (this.isPremiumOnlyURL(this.br)) {
            this.logger.info("PREMIUMONLY linkcheck: Trying alternative linkcheck");
            if (this.internal_supports_availablecheck_filename_abuse()) {
                fileInfo[0] = this.getFnameViaAbuseLink(altbr, link);
            }
            if (this.internal_supports_availablecheck_alt()) {
                this.getFilesizeViaAvailablecheckAlt(altbr, link);
            }
        } else {
            this.scanInfo(fileInfo);
            if (!StringUtils.isEmpty((String)fileInfo[0]) && fileInfo[0].trim().endsWith("&#133;") && this.internal_supports_availablecheck_filename_abuse() && !this.hasCheckedEmbedHandling) {
                this.logger.warning("Found filename is crippled by website -> Looking for full length filename");
                String betterFilename = this.getFnameViaAbuseLink(altbr, link);
                if (betterFilename != null) {
                    this.logger.info("Found full length filename: " + betterFilename);
                    fileInfo[0] = betterFilename;
                } else {
                    this.logger.info("Failed to find full length filename");
                }
            } else if (StringUtils.isEmpty((String)fileInfo[0]) && this.internal_supports_availablecheck_filename_abuse() && !this.hasCheckedEmbedHandling) {
                this.logger.info("Failed to find any filename, trying to obtain filename via getFnameViaAbuseLink");
                String betterFilename = this.getFnameViaAbuseLink(altbr, link);
                if (betterFilename != null) {
                    this.logger.info("Found filename: " + betterFilename);
                    fileInfo[0] = betterFilename;
                } else {
                    this.logger.info("Failed to find any filename -> Fallback will be used");
                }
            }
            if (StringUtils.isEmpty((String)fileInfo[1]) && this.internal_supports_availablecheck_alt()) {
                this.getFilesizeViaAvailablecheckAlt(altbr, link);
            }
        }
        this.processFileInfo(fileInfo, altbr, link);
        if (!StringUtils.isEmpty((String)fileInfo[0])) {
            this.setFilename(fileInfo[0], link, this.br);
        }
        if (!StringUtils.isEmpty((String)fileInfo[1])) {
            link.setDownloadSize(SizeFormatter.getSize((String)fileInfo[1]));
        } else if (!link.isSizeSet() && this.internal_isVideohosterEmbed(this.br) && this.supports_availablecheck_filesize_via_embedded_video() && !isDownload && urltype != URL_TYPE.EMBED_VIDEO) {
            this.requestFileInformationVideoEmbedXFSOld(this.br.cloneBrowser(), link, account, true);
        }
        if (!StringUtils.isEmpty((String)fileInfo[2])) {
            link.setMD5Hash(fileInfo[2].trim());
        }
        return DownloadLink.AvailableStatus.TRUE;
    }

    protected void requestFileInformationVideoEmbedXFSOld(Browser br, DownloadLink link, Account account, boolean findAndSetFilesize) throws Exception {
        String fid = this.getFUIDFromURL(link);
        URL_TYPE currentBrowserURLType = this.getURLType(br.getURL());
        if (currentBrowserURLType != URL_TYPE.EMBED_VIDEO) {
            URL_TYPE type = this.getURLType(link);
            String url = type == URL_TYPE.EMBED_VIDEO ? this.getContentURL(link) : this.getMainPage(br) + this.buildURLPath(link, fid, URL_TYPE.EMBED_VIDEO);
            this.getPage(br, url);
        }
        if (br.getRequest().getHtmlCode().equalsIgnoreCase("File was deleted")) {
            throw new PluginException(32);
        }
        if (this.isOffline(link, br)) {
            throw new PluginException(32);
        }
        this.checkErrors(br, br.getRequest().getHtmlCode(), link, account);
        String dllink = this.getDllink(link, account, br, this.getCorrectBR(br));
        boolean isFilesizeSet = false;
        if (!StringUtils.isEmpty((String)dllink)) {
            this.videoStreamDownloadurl = dllink;
            if (findAndSetFilesize && !dllink.contains(".m3u8") && this.checkDirectLinkAndSetFilesize(link, dllink, true) != null) {
                this.storeDirecturl(link, account, dllink);
                isFilesizeSet = true;
            }
        }
        String[] fileInfo = this.internal_getFileInfoArray();
        this.scanInfo(fileInfo);
        this.processFileInfo(fileInfo, br, link);
        if (!StringUtils.isEmpty((String)fileInfo[0])) {
            this.setFilename(fileInfo[0], link, br);
        }
        if (!StringUtils.isEmpty((String)fileInfo[1]) && !isFilesizeSet) {
            link.setDownloadSize(SizeFormatter.getSize((String)fileInfo[1]));
        }
    }

    protected String isRefererRequired(DownloadLink link) throws PluginException {
        Object ret = link.getProperty(PROPERTY_REFERER_REQUIRED);
        if (ret == null) {
            return null;
        }
        if (ret instanceof Boolean) {
            return ret.toString();
        }
        if ("no".equals(ret) || "bypassEmbed".equals(ret)) {
            return (String)ret;
        }
        throw new PluginException(0x400000, "Unsupported value:" + ret);
    }

    public DownloadLink.AvailableStatus requestFileInformationWebsiteXFSNew(DownloadLink link, Account account) throws Exception {
        boolean isDownload = Plugin.PluginEnvironment.DOWNLOAD.equals((Object)this.getPluginEnvironment());
        PluginException embedException = null;
        URL_TYPE urltype = this.getURLType(link);
        String isRefererRequired = this.isRefererRequired(link);
        if (urltype == URL_TYPE.EMBED_VIDEO_2) {
            try {
                if (!"bypassEmbed".equals(isRefererRequired)) {
                    boolean isChecked;
                    this.hasCheckedEmbedHandling = true;
                    if (!isDownload) {
                        this.requestFileInformationVideoEmbedXFSNew(this.br, link, account, false, true);
                        isChecked = isRefererRequired != null || !this.isReferrerBlocked(this.br);
                    } else if (isRefererRequired != null) {
                        this.requestFileInformationVideoEmbedXFSNew(this.br, link, account, true, true);
                        isChecked = true;
                    } else {
                        this.requestFileInformationVideoEmbedXFSNew(this.br, link, account, false, true);
                        boolean bl = isChecked = !this.isReferrerBlocked(this.br);
                    }
                    if (!link.hasProperty(PROPERTY_REFERER_REQUIRED)) {
                        link.setProperty(PROPERTY_REFERER_REQUIRED, this.isReferrerBlocked(this.br));
                    }
                    if (this.trustAvailablecheckVideoEmbed() && isChecked && isRefererRequired != null) {
                        return DownloadLink.AvailableStatus.TRUE;
                    }
                }
            }
            catch (PluginException e) {
                embedException = e;
                this.logger.log((Throwable)e);
            }
        }
        String fuid = this.getFUIDFromURL(link);
        String url = urltype == URL_TYPE.OFFICIAL_VIDEO_DOWNLOAD ? this.getContentURL(link) : this.getMainPage(this.br) + this.buildURLPath(link, fuid, URL_TYPE.OFFICIAL_VIDEO_DOWNLOAD);
        if (this.probeDirectDownload(link, account, this.br, (Request)this.br.createGetRequest(url), true)) {
            return DownloadLink.AvailableStatus.TRUE;
        }
        if (this.isOffline(link, this.br)) {
            if (!CompareUtils.equals((Object)isRefererRequired, (Object)this.isRefererRequired(link))) {
                return this.requestFileInformationWebsiteXFSNew(link, account);
            }
            if (embedException != null) {
                throw embedException;
            }
            if (this.hasCheckedEmbedHandling) {
                this.logger.info("Item looks to be online according to embed check but offline according to official video download handling");
                return DownloadLink.AvailableStatus.TRUE;
            }
            throw new PluginException(32);
        }
        if (isRefererRequired == null) {
            if ("true".equals(this.isRefererRequired(link))) {
                link.setProperty(PROPERTY_REFERER_REQUIRED, "bypassEmbed");
            } else {
                link.setProperty(PROPERTY_REFERER_REQUIRED, "no");
            }
        }
        String[] fileInfo = this.internal_getFileInfoArray();
        this.scanInfo(fileInfo);
        this.processFileInfo(fileInfo, this.br, link);
        if (!StringUtils.isEmpty((String)fileInfo[0])) {
            this.setFilename(fileInfo[0], link, this.br);
        }
        if (!StringUtils.isEmpty((String)fileInfo[1])) {
            link.setDownloadSize(SizeFormatter.getSize((String)fileInfo[1]));
        }
        return DownloadLink.AvailableStatus.TRUE;
    }

    protected void requestFileInformationVideoEmbedXFSNew(Browser br, DownloadLink link, Account account, boolean isDownload, boolean findAndSetFilesize) throws Exception {
        String fid = this.getFUIDFromURL(link);
        URL_TYPE type = this.getURLType(link);
        String url = type == URL_TYPE.EMBED_VIDEO_2 ? this.getContentURL(link) : this.getMainPage(br) + this.buildURLPath(link, fid, URL_TYPE.EMBED_VIDEO_2);
        String refererSaved = this.getReferer(link);
        if (refererSaved != null) {
            br.getHeaders().put("Referer", refererSaved);
        }
        this.getPage(br, url);
        if (this.isReferrerBlocked(br)) {
            if (isDownload) {
                String referer = this.getUserInput("Enter referer-URL?", link);
                br.getHeaders().put("Referer", referer);
                this.getPage(br.getURL());
                if (!this.isReferrerBlocked(br)) {
                    link.setDownloadPassword(referer);
                } else {
                    link.setDownloadPassword(null);
                }
            } else {
                return;
            }
        }
        this.checkErrors(br, url, link, account);
        if (this.isOffline(link, br)) {
            throw new PluginException(32);
        }
        String dllink = this.getDllink(link, account, br, this.getCorrectBR(br));
        if (!StringUtils.isEmpty((String)dllink)) {
            this.videoStreamDownloadurl = dllink;
            if (findAndSetFilesize && !dllink.contains(".m3u8") && this.checkDirectLinkAndSetFilesize(link, dllink, true) != null) {
                this.storeDirecturl(link, account, dllink);
            }
        }
    }

    protected boolean isXFSOld(URL_TYPE urltype) {
        return urltype == null || urltype == URL_TYPE.IMAGE || urltype == URL_TYPE.NORMAL || urltype == URL_TYPE.EMBED_VIDEO || urltype == URL_TYPE.SHORT || urltype == URL_TYPE.FILE;
    }

    public DownloadLink.AvailableStatus requestFileInformationWebsite(DownloadLink link, Account account) throws Exception {
        URL_TYPE urltype = this.getURLType(link);
        if (this.isXFSOld(urltype)) {
            return this.requestFileInformationWebsiteXFSOld(link, account);
        }
        return this.requestFileInformationWebsiteXFSNew(link, account);
    }

    protected String removeHostNameFromFilename(String filename) {
        String ret = filename;
        if (StringUtils.isNotEmpty((String)ret)) {
            LinkedHashSet<String> hosts = new LinkedHashSet<String>();
            hosts.add(this.getHost());
            String[] siteSupportedNames = this.siteSupportedNames();
            if (siteSupportedNames != null) {
                hosts.addAll(Arrays.asList(siteSupportedNames));
            }
            for (String host : hosts) {
                String host_tag = new org.appwork.utils.Regex(ret, Pattern.compile("(_?" + Pattern.quote(host) + ")", 2)).getMatch(0);
                if (host_tag == null) continue;
                ret = ret.replace(host_tag, "");
            }
        }
        return ret;
    }

    protected void setFilename(String name, DownloadLink link, Browser br) {
        if (StringUtils.isEmpty((String)name)) {
            return;
        }
        if (Encoding.isHtmlEntityCoded((String)name)) {
            name = Encoding.htmlDecode((String)name);
        }
        name = name.replaceAll("(</b>|<b>|\\.html)", "").trim();
        if (this.internal_isVideohoster_enforce_video_filename(link, br)) {
            name = this.applyFilenameExtension(name, ".mp4");
        }
        link.setName(name);
    }

    protected void processFileInfo(String[] fileInfo, Browser altbr, DownloadLink link) {
    }

    protected boolean isShortURL(DownloadLink link) {
        return URL_TYPE.SHORT.equals((Object)this.getURLType(link));
    }

    protected URL_TYPE getURLType(DownloadLink link) {
        return link != null ? this.getURLType(link.getPluginPatternMatcher()) : null;
    }

    protected URL_TYPE getURLType(String url) {
        String shorturlID;
        String path;
        if (url == null) {
            return null;
        }
        try {
            path = new URL(url).getPath();
        }
        catch (MalformedURLException e) {
            this.logger.log((Throwable)e);
            this.logger.info("Unknown URL_TYPE: " + url);
            return null;
        }
        String string = shorturlID = this.supportsShortURLs() ? new org.appwork.utils.Regex(path, PATTERN_SHORT).getMatch(0) : null;
        if (shorturlID != null && shorturlID.length() < 12) {
            return URL_TYPE.SHORT;
        }
        if (new org.appwork.utils.Regex(path, PATTERN_OFFICIAL_VIDEO_DOWNLOAD).patternFind()) {
            return URL_TYPE.OFFICIAL_VIDEO_DOWNLOAD;
        }
        if (new org.appwork.utils.Regex(path, PATTERN_NORMAL).patternFind()) {
            return URL_TYPE.NORMAL;
        }
        if (new org.appwork.utils.Regex(path, PATTERN_EMBED_VIDEO).patternFind()) {
            return URL_TYPE.EMBED_VIDEO;
        }
        if (new org.appwork.utils.Regex(path, PATTERN_EMBED_VIDEO_2).patternFind()) {
            return URL_TYPE.EMBED_VIDEO_2;
        }
        if (new org.appwork.utils.Regex(path, PATTERN_FILE).patternFind()) {
            return URL_TYPE.FILE;
        }
        if (this.isImagehoster() && new org.appwork.utils.Regex(path, PATTERN_IMAGE).patternFind()) {
            return URL_TYPE.IMAGE;
        }
        this.logger.info("Unknown URL_TYPE: " + url);
        return null;
    }

    protected String getFUID(String url, URL_TYPE type) {
        String path;
        if (url == null || type == null) {
            return null;
        }
        try {
            path = new URL(url).getPath();
        }
        catch (MalformedURLException e) {
            this.logger.log((Throwable)e);
            this.logger.info("Unknown URL_TYPE: " + url);
            return null;
        }
        switch (type) {
            case IMAGE: {
                if (this.isImagehoster()) {
                    return new org.appwork.utils.Regex(path, PATTERN_IMAGE).getMatch(0);
                }
                throw new IllegalArgumentException("Unsupported type:" + (Object)((Object)type) + "|" + url);
            }
            case EMBED_VIDEO: {
                return new org.appwork.utils.Regex(path, PATTERN_EMBED_VIDEO).getMatch(0);
            }
            case EMBED_VIDEO_2: {
                return new org.appwork.utils.Regex(path, PATTERN_EMBED_VIDEO_2).getMatch(0);
            }
            case FILE: {
                return new org.appwork.utils.Regex(path, PATTERN_FILE).getMatch(0);
            }
            case SHORT: {
                return new org.appwork.utils.Regex(path, PATTERN_SHORT).getMatch(0);
            }
            case OFFICIAL_VIDEO_DOWNLOAD: {
                return new org.appwork.utils.Regex(path, PATTERN_OFFICIAL_VIDEO_DOWNLOAD).getMatch(0);
            }
            case NORMAL: {
                return new org.appwork.utils.Regex(path, PATTERN_NORMAL).getMatch(0);
            }
        }
        throw new IllegalArgumentException("Unsupported type:" + (Object)((Object)type) + "|" + url);
    }

    protected String getFUID(DownloadLink link, URL_TYPE type) {
        return link != null ? this.getFUID(link.getPluginPatternMatcher(), type) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveShortURL(Browser br, DownloadLink link, Account account) throws Exception {
        DownloadLink downloadLink = link;
        synchronized (downloadLink) {
            String realFUID;
            if (!this.supportsShortURLs()) {
                return;
            }
            if (!this.isShortURL(link)) {
                return;
            }
            String contentURL = this.getContentURL(link);
            if ((br.getURL() == null || !br.getURL().equals(contentURL)) && this.probeDirectDownload(link, account, br, (Request)br.createGetRequest(contentURL), true)) {
                return;
            }
            if (this.isOffline(link, br)) {
                throw new PluginException(32);
            }
            URL_TYPE type = this.getURLType(br.getURL());
            if (type != null && !URL_TYPE.SHORT.equals((Object)type)) {
                this.logger.info("Type of current URL is not a short URL anymore -> Try to extract file_id from URL");
                realFUID = this.getFUID(br.getURL(), type);
            } else {
                Form form = br.getFormbyProperty("name", "F1");
                InputField id = form != null ? form.getInputFieldByName("id") : null;
                realFUID = id != null ? id.getValue() : null;
                type = URL_TYPE.NORMAL;
            }
            if (realFUID == null || !realFUID.matches("[A-Za-z0-9]{12}")) {
                this.checkErrors(br, br.getRequest().getHtmlCode(), link, account);
                throw new PluginException(32, "realFUID:" + realFUID);
            }
            String urlNew = URL_TYPE.FILE.equals((Object)type) ? URLHelper.parseLocation((URL)new URL(this.getMainPage(link)), (String)this.buildNormalFileURLPath(link, realFUID)) : URLHelper.parseLocation((URL)new URL(this.getMainPage(link)), (String)this.buildNormalURLPath(link, realFUID));
            this.logger.info("resolve URL|old: " + contentURL + "|new:" + urlNew);
            link.setPluginPatternMatcher(urlNew);
        }
    }

    public String[] scanInfo(String[] fileInfo) {
        return this.scanInfo(this.getCorrectBR(this.br), fileInfo);
    }

    public String[] scanInfo(String html, String[] fileInfo) {
        String downloadFileTable2;
        String downloadFileTable;
        Pattern pattern_shareboxWithFilenameAndFilesizeBytes;
        String filename;
        DownloadLink link = this.getDownloadLink();
        String urlFUID = this.getFUIDFromURL(link);
        String quotedFUID = null;
        if (urlFUID != null) {
            quotedFUID = Pattern.quote(urlFUID);
        }
        if (StringUtils.isEmpty((String)(filename = new org.appwork.utils.Regex(html, "name=\"fname\"[^>]*value=\"([^\"]+)\"").getMatch(0))) && StringUtils.isEmpty((String)(filename = new org.appwork.utils.Regex(html, "class\\s*=\\s*\"dfilename\"[^>]*>\\s*(?:<div>)?\\s*([^<>\"]*?)</").getMatch(0)))) {
            filename = new org.appwork.utils.Regex(html, "<div[^>]*id\\s*=\\s*\"dfilename\"[^>]*>\\s*(?:<div>)?\\s*([^<>\"]*?)</").getMatch(0);
        }
        boolean preferRoughFilesize = false;
        String filesizeBytesStr = null;
        String filesizeWithUnit = null;
        try {
            filesizeWithUnit = this.getDllinkViaOfficialVideoDownload(this.br.cloneBrowser(), link, null, true);
            if (filesizeWithUnit != null) {
                preferRoughFilesize = true;
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        String[] textareas = new org.appwork.utils.Regex(html, "(?i)<textarea[^>]*>(.*?)</textarea>").getColumn(0);
        Pattern pattern = pattern_shareboxWithFilenameAndFilesizeBytes = quotedFUID != null ? Pattern.compile(quotedFUID + "(?:\\.html)?(?:/[^\\]]+)?\\]([^\"]+) - \\s*(\\d+)\\[/URL\\]") : null;
        if (textareas != null && textareas.length > 0) {
            for (String textarea : textareas) {
                if (filename == null) {
                    org.appwork.utils.Regex targetUrlWithFilename;
                    if (quotedFUID != null && (targetUrlWithFilename = new org.appwork.utils.Regex(textarea, "(?i)^https?://[^/]+/" + quotedFUID + "(?:\\.html)?/([^/#?]+)(\\.html)?$")).patternFind()) {
                        filename = targetUrlWithFilename.getMatch(0);
                    }
                    if (filename == null) {
                        filename = new org.appwork.utils.Regex(textarea, "(?i)\\[URL=[^\\]]+\\]\\[IMG\\][^\\[]+\\[/IMG\\](.*?)\\[/URL\\]").getMatch(0);
                        if (filename == null && !this.supports_availablecheck_filesize_bytes_from_sharebox()) {
                            filename = new org.appwork.utils.Regex(textarea, "\\](.*?)\\[/URL\\]").getMatch(0);
                        }
                        if (filename == null) {
                            filename = new org.appwork.utils.Regex(textarea, "(?i)\\[URL=[^\\]]+\\]\\[IMG\\][^\\[]+\\[/IMG\\](.*?)\\[/URL\\]").getMatch(0);
                        }
                    }
                }
                if ((filename == null || filesizeBytesStr == null) && pattern_shareboxWithFilenameAndFilesizeBytes != null) {
                    org.appwork.utils.Regex shareboxWithFilesizeBytesRegex = new org.appwork.utils.Regex(textarea, pattern_shareboxWithFilenameAndFilesizeBytes);
                    if (filename == null) {
                        filename = shareboxWithFilesizeBytesRegex.getMatch(0);
                    }
                    if (filesizeBytesStr == null) {
                        filesizeBytesStr = shareboxWithFilesizeBytesRegex.getMatch(1);
                    }
                }
                if (filesizeWithUnit == null) {
                    filesizeWithUnit = new org.appwork.utils.Regex(textarea, "(?i)([\\d\\.]+ (?:B|KB|MB|GB))(\\[/URL\\]|</a>)").getMatch(0);
                }
                if (filename != null && filesizeWithUnit != null) break;
            }
        }
        if ((filename == null || filesizeBytesStr == null) && pattern_shareboxWithFilenameAndFilesizeBytes != null) {
            Regex shareboxWithFilesizeBytesRegex = this.br.getRegex(pattern_shareboxWithFilenameAndFilesizeBytes);
            if (filename == null) {
                filename = shareboxWithFilesizeBytesRegex.getMatch(0);
            }
            if (filesizeBytesStr == null) {
                filesizeBytesStr = shareboxWithFilesizeBytesRegex.getMatch(1);
            }
        }
        if (!this.supports_availablecheck_filesize_bytes_from_sharebox() && filesizeBytesStr != null) {
            this.logger.info("Ignoring this possible filesize_bytes string: " + filesizeBytesStr);
            filesizeBytesStr = null;
        }
        if (StringUtils.isEmpty((String)filename) && StringUtils.isEmpty((String)(filename = new org.appwork.utils.Regex(html, "(?i)You have requested.*?https?://(?:www\\.)?[^/]+/" + urlFUID + "/([^<>\"]+)<").getMatch(0))) && StringUtils.isEmpty((String)(filename = new org.appwork.utils.Regex(html, "<h2>\\s*Download File\\s*(?:<(?:span|b)[^>]*>)?\\s*(.+?)\\s*(</(?:span|b|h2)>)").getMatch(0)))) {
            filename = new org.appwork.utils.Regex(html, "Filename:?\\s*(<[^>]+>\\s*)+?([^<>\"]+)").getMatch(1);
        }
        if ((StringUtils.isEmpty((String)filename) || StringUtils.isAllEmpty((String[])new String[]{filesizeWithUnit, filesizeBytesStr})) && (downloadFileTable = new org.appwork.utils.Regex(html, "<h\\d+>\\s*Download\\s*File\\s*</h\\d+>\\s*<table[^>]*>(.*?)</table>").getMatch(0)) != null) {
            if (StringUtils.isEmpty((String)filename)) {
                filename = new org.appwork.utils.Regex(downloadFileTable, "<td>\\s*<font[^>]*>\\s*(.*?)\\s*</font>").getMatch(0);
            }
            if (StringUtils.isAllEmpty((String[])new String[]{filesizeWithUnit, filesizeBytesStr})) {
                filesizeWithUnit = new org.appwork.utils.Regex(downloadFileTable, ">\\s*Size\\s*:\\s*([0-9\\.]+\\s*(TB|GB|MB|KB|B))").getMatch(0);
            }
        }
        if ((StringUtils.isEmpty((String)filename) || StringUtils.isAllEmpty((String[])new String[]{filesizeWithUnit, filesizeBytesStr})) && (downloadFileTable2 = new org.appwork.utils.Regex(html, "(?i)<table[^>]*>.*?<h\\d+[^>]*>\\s*Download\\s*File\\s*</h\\d+>\\s*(.*?)</table>").getMatch(0)) != null) {
            if (StringUtils.isEmpty((String)filename)) {
                filename = new org.appwork.utils.Regex(downloadFileTable2, "<td\\s*style\\s*=\\s*\"font[^>]*>\\s*(.*?)\\s*(</|<br)").getMatch(0);
            }
            if (StringUtils.isAllEmpty((String[])new String[]{filesizeWithUnit, filesizeBytesStr})) {
                filesizeWithUnit = this.scanGenericFileSize(downloadFileTable2);
            }
        }
        if (StringUtils.isEmpty((String)filename)) {
            String curFileName;
            String sharebox3_videohost = "(?i)\\[URL=https?://[^/]+/" + urlFUID + "[^/<>\\]]*?\\]\\[IMG\\][^<>\"\\[\\]]+\\[/IMG\\]([^<>\"]+)\\[/URL\\]";
            if (StringUtils.isEmpty((String)filename)) {
                filename = new org.appwork.utils.Regex(html, "(?i)<h4 [^>]*>\\s*Download\\s*([^<]*?)\\s*</h\\d+>").getMatch(0);
            }
            if (StringUtils.isEmpty((String)filename) && this.isImagehoster()) {
                filename = this.regexImagehosterFilename(this.br);
            }
            if (StringUtils.isEmpty((String)filename)) {
                filename = new org.appwork.utils.Regex(html, sharebox3_videohost).getMatch(0);
                if (StringUtils.isEmpty((String)filename)) {
                    filename = new org.appwork.utils.Regex(html, Pattern.compile("<title>\\s*Watch(?:ing)?\\s*([^<>\"]+)\\s*</title>", 2)).getMatch(0);
                }
                if (StringUtils.isEmpty((String)filename) && this.isImagehoster()) {
                    String websiteName = Browser.getHost((String)this.getHost()).replaceAll("(\\..+)$", "");
                    filename = new org.appwork.utils.Regex(html, Pattern.compile("<title>\\s*(.*?\\.(png|jpe?g|gif))\\s*-\\s*(" + Pattern.quote(this.getHost()) + "|" + Pattern.quote(websiteName) + ")\\s*</title>", 2)).getMatch(0);
                }
            }
            if (this.internal_isVideohosterEmbed(this.br) && (StringUtils.isEmpty((String)filename) || StringUtils.equalsIgnoreCase((String)"No title", (String)filename)) && StringUtils.isNotEmpty((String)(curFileName = this.br.getRegex("var\\s*curFileName\\s*=\\s*\"(.*?)\"").getMatch(0)))) {
                filename = curFileName;
            }
        }
        if (filesizeBytesStr == null) {
            filesizeBytesStr = new org.appwork.utils.Regex(html, "\\((\\d+\\s*bytes)\\)").getMatch(0);
        }
        if (StringUtils.isAllEmpty((String[])new String[]{filesizeWithUnit, filesizeBytesStr})) {
            filesizeWithUnit = new org.appwork.utils.Regex(html, "id\\s*=\\s*\"fsize[^\"]*\"\\s*>\\s*([0-9\\.]+\\s*[MBTGK]+)\\s*<").getMatch(0);
            if (StringUtils.isEmpty((String)filesizeWithUnit)) {
                filesizeWithUnit = new org.appwork.utils.Regex(html, "class\\s*=\\s*\"statd\"\\s*>\\s*size\\s*</span>\\s*<span>\\s*([0-9\\.]+\\s*[MBTGK]+)\\s*<").getMatch(0);
            }
            if (this.supports_availablecheck_filesize_html() && StringUtils.isEmpty((String)filesizeWithUnit)) {
                filesizeWithUnit = this.scanGenericFileSize(html);
            }
        }
        fileInfo[0] = filename;
        fileInfo[1] = preferRoughFilesize && filesizeWithUnit != null ? filesizeWithUnit : (filesizeBytesStr != null ? filesizeBytesStr : filesizeWithUnit);
        return fileInfo;
    }

    protected String scanGenericFileSize(String html) {
        String ret = new org.appwork.utils.Regex(html, "(?:>\\s*|\\(\\s*|\"\\s*|\\[\\s*|\\s+)([0-9\\.]+(?:\\s+|\\&nbsp;)?(bytes)(?!ps|/s|\\w|\\s*Storage|\\s*Disk|\\s*Space|\\s*traffic))").getMatch(0);
        if (StringUtils.isEmpty((String)ret)) {
            ret = new org.appwork.utils.Regex(html, "(?:>\\s*|\\(\\s*|\"\\s*|\\[\\s*|\\s+)([0-9\\.]+(?:\\s+|\\&nbsp;)?(TB|GB|MB|KB)(?!ps|/s|\\w|\\s*Storage|\\s*Disk|\\s*Space|\\s*traffic))").getMatch(0);
        }
        return ret;
    }

    public DownloadLink.AvailableStatus requestFileInformationWebsiteMassLinkcheckerSingle(DownloadLink link) throws IOException, PluginException {
        this.massLinkcheckerWebsite(new DownloadLink[]{link});
        if (!link.isAvailabilityStatusChecked()) {
            return DownloadLink.AvailableStatus.UNCHECKED;
        }
        if (!link.isAvailable()) {
            throw new PluginException(32);
        }
        return DownloadLink.AvailableStatus.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean massLinkcheckerWebsite(DownloadLink[] urls) {
        boolean bl;
        SubConfiguration cfg;
        String checkTypeCurrent;
        boolean linkcheckerSuccess;
        block28: {
            block29: {
                boolean bl2;
                block27: {
                    if (urls == null) return false;
                    if (urls.length == 0) {
                        return false;
                    }
                    linkcheckerSuccess = false;
                    checkTypeCurrent = null;
                    String checkTypeOld = "checkfiles";
                    String checkTypeNew = "check_files";
                    cfg = this.getPluginConfig();
                    Browser br = this.createNewBrowserInstance();
                    this.prepBrowser(br, this.getMainPage(br));
                    br.setCookiesExclusive(true);
                    try {
                        StringBuilder sb = new StringBuilder();
                        ArrayList<Object> links = new ArrayList<Object>();
                        int index = 0;
                        Form checkForm = null;
                        do {
                            boolean bl3;
                            if (index >= urls.length) return linkcheckerSuccess;
                            links.clear();
                            while (index < urls.length && links.size() < 50) {
                                DownloadLink link = urls[index];
                                ++index;
                                if (this.supportsShortURLs() && this.isShortURL(link)) continue;
                                links.add(link);
                            }
                            if (links.isEmpty()) {
                                this.logger.info("All links were short-urls and thus cannot be checked via mass linkchecker");
                                return linkcheckerSuccess;
                            }
                            sb.delete(0, sb.length());
                            for (DownloadLink downloadLink : links) {
                                if (sb.length() > 0) {
                                    sb.append("%0A");
                                }
                                sb.append(URLEncode.encodeURIComponent((String)this.getNormalizedDownloadURL(downloadLink)));
                            }
                            ArrayList<String> checkTypesToTry = new ArrayList<String>();
                            if (checkTypeCurrent != null) {
                                checkTypesToTry.add(checkTypeCurrent);
                            } else {
                                String string = cfg.getStringProperty(PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_WORKING);
                                if (string != null) {
                                    checkTypesToTry.add(string);
                                }
                                if (!checkTypesToTry.contains("check_files")) {
                                    checkTypesToTry.add("check_files");
                                }
                                if (!checkTypesToTry.contains("checkfiles")) {
                                    checkTypesToTry.add("checkfiles");
                                }
                            }
                            boolean bl4 = false;
                            int checkTypeIndex = 0;
                            while (checkTypeIndex < checkTypesToTry.size()) {
                                boolean isValidResponse;
                                checkTypeCurrent = (String)checkTypesToTry.get(checkTypeIndex);
                                ++checkTypeIndex;
                                String checkURL = this.getMainPage(br) + "/?op=" + checkTypeCurrent;
                                if (!this.supports_availablecheck_filesize_alt_fast()) {
                                    this.getPage(br, checkURL);
                                    checkForm = br.getFormByInputFieldKeyValue("op", checkTypeCurrent);
                                    if (checkForm == null) {
                                        this.logger.info("Failed to find Form for checkType: " + checkTypeCurrent);
                                        continue;
                                    }
                                } else {
                                    checkForm = new Form();
                                    checkForm.setMethod(Form.MethodType.POST);
                                    checkForm.setAction(checkURL);
                                    checkForm.put("op", checkTypeCurrent);
                                    checkForm.put("process", "Check+URLs");
                                }
                                checkForm.put("list", sb.toString());
                                this.submitForm(br, checkForm);
                                String example_fuid = this.getFUIDFromURL((DownloadLink)links.get(0));
                                boolean bl5 = isValidResponse = br.getHttpConnection().getResponseCode() != 404 && br.getURL().contains(checkTypeCurrent) && br.containsHTML(example_fuid);
                                if (!isValidResponse) {
                                    this.logger.info("Failed to find check_files Status via checkType: " + checkTypeCurrent);
                                    continue;
                                }
                                bl3 = true;
                                break;
                            }
                            if (!bl3) {
                                this.logger.warning("Failed to find usable linkcheck type");
                                linkcheckerSuccess = false;
                                bl2 = false;
                                if (!linkcheckerSuccess) break block27;
                                cfg.setProperty(PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_WORKING, checkTypeCurrent);
                                return bl2;
                            }
                            for (DownloadLink downloadLink : links) {
                                if (this.massLinkcheckerParseFileInfo(br, downloadLink) == DownloadLink.AvailableStatus.UNCHECKED) {
                                    this.logger.warning("Failed to find any information for current DownloadLink --> Possible mass-linkchecker failure for: " + downloadLink.getPluginPatternMatcher());
                                    continue;
                                }
                                linkcheckerSuccess = true;
                            }
                        } while (linkcheckerSuccess);
                        this.logger.warning("Failed to find at least one valid file status -> Stopping");
                        bl = false;
                        if (!linkcheckerSuccess) break block28;
                        break block29;
                    }
                    catch (Exception e) {
                        this.logger.log((Throwable)e);
                        this.logger.info("Linkchecker has failed due to exception");
                        boolean bl6 = false;
                        return bl6;
                    }
                }
                this.logger.info("Seems like checkfiles availablecheck is not supported by this host");
                cfg.setProperty(PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_FAILURE_TIMESTAMP, System.currentTimeMillis());
                cfg.setProperty(PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_FAILURE_VERSION, this.getPluginVersionHash());
                return bl2;
            }
            cfg.setProperty(PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_WORKING, checkTypeCurrent);
            return bl;
        }
        this.logger.info("Seems like checkfiles availablecheck is not supported by this host");
        cfg.setProperty(PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_FAILURE_TIMESTAMP, System.currentTimeMillis());
        cfg.setProperty(PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_FAILURE_VERSION, this.getPluginVersionHash());
        return bl;
        finally {
            if (linkcheckerSuccess) {
                cfg.setProperty(PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_WORKING, checkTypeCurrent);
            } else {
                this.logger.info("Seems like checkfiles availablecheck is not supported by this host");
                cfg.setProperty(PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_FAILURE_TIMESTAMP, System.currentTimeMillis());
                cfg.setProperty(PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_FAILURE_VERSION, this.getPluginVersionHash());
            }
        }
    }

    protected DownloadLink.AvailableStatus massLinkcheckerParseFileInfo(Browser br, DownloadLink link) {
        String fuid = this.getFUIDFromURL(link);
        boolean isNewLinkchecker = true;
        String html_for_fuid = br.getRegex("<tr>((?!</?tr>).)*?" + fuid + "((?!</?tr>).)*?</tr>").getMatch(-1);
        if (html_for_fuid == null) {
            html_for_fuid = br.getRegex("<font color=\\'(?:green|red)\\'>[^>]*?" + fuid + "[^>]*?</font>").getMatch(-1);
            isNewLinkchecker = false;
        }
        if (html_for_fuid == null) {
            return DownloadLink.AvailableStatus.UNCHECKED;
        }
        boolean isOffline = isNewLinkchecker ? new org.appwork.utils.Regex(html_for_fuid, "Not found").patternFind() : new org.appwork.utils.Regex(html_for_fuid, "<font color='red").patternFind();
        if (isOffline) {
            link.setAvailable(false);
            return DownloadLink.AvailableStatus.FALSE;
        }
        link.setAvailable(true);
        try {
            String size;
            String[] tabla_data = new org.appwork.utils.Regex(html_for_fuid, "<td>?(.*?)</td>").getColumn(0);
            String string = size = tabla_data.length >= 2 ? tabla_data[2] : null;
            if (size != null) {
                link.setDownloadSize(SizeFormatter.getSize((String)size));
            }
        }
        catch (Throwable ignore) {
            this.logger.log(ignore);
            this.logger.warning("Failed to find file size for fuid: " + fuid);
        }
        return DownloadLink.AvailableStatus.TRUE;
    }

    protected String getFnameViaAbuseLink(Browser br, DownloadLink link) throws Exception {
        boolean fnameViaAbuseUnsupported;
        this.getPage(br, this.getMainPage(br) + "/?op=report_file&id=" + this.getFUIDFromURL(link), false);
        if (br.containsHTML(">\\s*No such file\\s*<")) {
            throw new PluginException(32);
        }
        String filename = this.regexFilenameAbuse(br);
        if (filename != null) {
            this.logger.info("Successfully found filename via report_file: " + filename);
            return filename;
        }
        this.logger.info("Failed to find filename via report_file");
        boolean bl = fnameViaAbuseUnsupported = br.getHttpConnection().getResponseCode() == 404 || br.getHttpConnection().getResponseCode() == 500 || !StringUtils.containsIgnoreCase((String)br.getURL(), (String)"report_file") || br.getRequest().getHtmlCode().trim().equalsIgnoreCase("No such file");
        if (fnameViaAbuseUnsupported) {
            this.logger.info("Seems like report_file availablecheck seems not to be supported by this host");
            SubConfiguration config = this.getPluginConfig();
            config.setProperty(PROPERTY_PLUGIN_REPORT_FILE_AVAILABLECHECK_LAST_FAILURE_TIMESTAMP, System.currentTimeMillis());
            config.setProperty(PROPERTY_PLUGIN_REPORT_FILE_AVAILABLECHECK_LAST_FAILURE_VERSION, this.getPluginVersionHash());
        }
        return null;
    }

    public String regexFilenameAbuse(Browser br) {
        String filename = null;
        String filename_src = br.getRegex("(?i)<b>Filename\\s*:?\\s*<[^\n]+</td>").getMatch(-1);
        if (filename_src != null) {
            filename = new org.appwork.utils.Regex(filename_src, ">([^>]+)</td>$").getMatch(0);
        }
        if (filename == null) {
            filename = br.getRegex("(?i)<label>\\s*Filename\\s*</label>\\s*<input[^>]*class=\"form-control form-control-plaintext\"[^>]*value=\"([^\"]+)\"").getMatch(0);
        }
        return filename;
    }

    public String regexImagehosterFilename(Browser br) {
        return br.getRegex("class=\"pic\"[^>]*alt=\"([^<>\"]*?)\"").getMatch(0);
    }

    protected boolean getFilesizeViaAvailablecheckAlt(Browser br, DownloadLink link) throws PluginException, IOException {
        this.logger.info("Trying getFilesizeViaAvailablecheckAlt");
        this.requestFileInformationWebsiteMassLinkcheckerSingle(link);
        if (link.isAvailabilityStatusChecked()) {
            this.logger.info("Successfully checked URL via website massLinkcheck | filesize: " + link.getView().getBytesTotal());
            return true;
        }
        this.logger.info("Failed to find filesize via website massLinkcheck");
        return false;
    }

    protected String getEmbedDllink(Browser br, String embedURL, DownloadLink link, Account account) throws Exception, PluginException {
        Browser brc = br.cloneBrowser();
        this.getPage(brc, embedURL);
        return this.getDllink(link, account, brc, brc.getRequest().getHtmlCode());
    }

    @Override
    public void handleFree(DownloadLink link) throws Exception, PluginException {
        this.resolveShortURL(this.br.cloneBrowser(), link, null);
        this.doFree(link, null);
    }

    public void doFree(DownloadLink link, Account account) throws Exception, PluginException {
        String embedURL;
        if (this.attemptStoredDownloadurlDownload(link, account)) {
            return;
        }
        this.requestFileInformationWebsite(link, account);
        if (!this.hasCheckedEmbedHandling && this.videoStreamDownloadurl == null && (embedURL = this.findEmbedURL(this.br, link, account)) != null) {
            this.logger.info("Looks like this is a videohost which is using self-embedding");
            this.hasCheckedEmbedHandling = true;
            this.videoStreamDownloadurl = this.getEmbedDllink(this.br, embedURL, link, account);
        }
        String dllink = null;
        String officialDownloadURL = null;
        XFSConfigVideo.DownloadMode mode = this.getPreferredDownloadModeFromConfig();
        boolean preferOfficialVideoDownload = mode == XFSConfigVideo.DownloadMode.ORIGINAL && Boolean.TRUE.equals(this.requiresCaptchaForOfficialVideoDownload()) ? true : mode == XFSConfigVideo.DownloadMode.AUTO && Boolean.FALSE.equals(this.requiresCaptchaForOfficialVideoDownload());
        if (this.videoStreamDownloadurl != null && !preferOfficialVideoDownload) {
            this.logger.info("Do not enter download1 loop because: Found stream downloadurl");
            dllink = this.videoStreamDownloadurl;
        } else {
            int download1counter = 0;
            boolean download1max = true;
            block0: do {
                block26: {
                    this.logger.info(String.format(Locale.ROOT, "Handling download1 loop %d / %d", download1counter + 1, 2));
                    dllink = this.getDllink(link, account, this.br, this.getCorrectBR(this.br));
                    if (!StringUtils.isEmpty((String)dllink) && !preferOfficialVideoDownload) {
                        this.logger.info("Stepping out of download1 loop because: Found directurl");
                        break;
                    }
                    officialDownloadURL = this.getDllinkViaOfficialVideoDownload(this.br.cloneBrowser(), link, account, false);
                    if (!StringUtils.isEmpty((String)officialDownloadURL)) {
                        this.logger.info("Stepping out of download1 loop because: User wants original download && we found original download");
                        break;
                    }
                    if (StringUtils.isEmpty((String)dllink) && this.isImagehoster()) {
                        this.checkErrors(this.br, this.getCorrectBR(this.br), link, account);
                        Form imghost_next_form = this.findImageForm(this.br);
                        if (imghost_next_form != null) {
                            int counter = -1;
                            int countermax = 3;
                            do {
                                this.logger.info(String.format(Locale.ROOT, "imghost_next_form loop %d / %d", ++counter + 1, 3));
                                this.submitForm(imghost_next_form);
                                this.checkErrors(this.br, this.getCorrectBR(this.br), link, account);
                                dllink = this.getDllink(link, account, this.br, this.getCorrectBR(this.br));
                                String imageFilename = this.regexImagehosterFilename(this.br);
                                if (imageFilename != null) {
                                    link.setName(Encoding.htmlOnlyDecode((String)imageFilename));
                                }
                                if (this.isAbort()) {
                                    throw new InterruptedException();
                                }
                                if (!StringUtils.isEmpty((String)dllink)) {
                                    this.logger.info("Found image directurl: " + dllink);
                                    break block0;
                                }
                                if (counter < 3) continue;
                                this.logger.warning("Imagehost handling exceeded max tries");
                                break block26;
                            } while ((imghost_next_form = this.findImageForm(this.br)) != null);
                            this.logger.warning("Failed to find next imghost_next_form and no directurl present -> Stepping out of imagehost handling");
                        }
                    }
                }
                if (!StringUtils.isEmpty((String)dllink) || !StringUtils.isEmpty((String)officialDownloadURL)) {
                    this.logger.info("Stepping out of download1 loop because: Found directurl");
                    break;
                }
                if (download1counter > 0) break;
                this.checkErrors(this.br, this.getCorrectBR(this.br), link, account);
                Form download1 = this.findFormDownload1Free(this.br);
                if (download1 == null) {
                    this.logger.info("Failed to find download1 Form");
                    break;
                }
                this.logger.info("Found download1 Form");
                this.waitTime(link, Time.systemIndependentCurrentJVMTimeMillis());
                this.submitForm(download1);
                this.checkErrors(this.br, this.getCorrectBR(this.br), link, account);
            } while (++download1counter <= 1 && StringUtils.isEmpty((String)dllink));
        }
        if (!StringUtils.isEmpty((String)dllink) && !preferOfficialVideoDownload) {
            this.logger.info("Do not enter download2 loop because: Found stream downloadurl");
        } else if (StringUtils.isEmpty((String)dllink) && StringUtils.isEmpty(officialDownloadURL) || StringUtils.isEmpty(officialDownloadURL) && preferOfficialVideoDownload) {
            this.logger.info("Jumping into download2 handling");
            Form download2 = this.findFormDownload2Free(this.br);
            if (download2 == null) {
                this.logger.warning("Failed to find download2 Form");
            } else {
                this.logger.info("Found download2 Form");
                this.checkErrors(this.br, this.getCorrectBR(this.br), link, account);
                boolean download2start = false;
                int download2max = 2;
                for (int download2counter = 0; download2counter <= 2; ++download2counter) {
                    this.logger.info(String.format(Locale.ROOT, "Download2 loop %d / %d", download2counter + 1, 3));
                    long timeBefore = Time.systemIndependentCurrentJVMTimeMillis();
                    this.handlePassword(download2, link);
                    this.handleCaptcha(link, this.br, download2);
                    this.waitTime(link, timeBefore);
                    if (this.tryDownload(this.br, link, account, this.br.createFormRequest(download2), DOWNLOAD_ATTEMPT_FLAGS.CONNECT_OR_EXCEPTION)) {
                        return;
                    }
                    this.logger.info("Submitted Form download2");
                    this.checkErrors(this.br, this.getCorrectBR(this.br), link, account);
                    if (StringUtils.isEmpty((String)dllink) && !StringUtils.isEmpty((String)(dllink = this.getDllink(link, account, this.br, this.getCorrectBR(this.br)))) && !preferOfficialVideoDownload) break;
                    if (StringUtils.isEmpty((String)officialDownloadURL)) {
                        officialDownloadURL = this.getDllinkViaOfficialVideoDownload(this.br.cloneBrowser(), link, account, false);
                    }
                    if (!StringUtils.isEmpty((String)officialDownloadURL) || !StringUtils.isEmpty((String)dllink)) {
                        this.validateLastChallengeResponse();
                        this.logger.info("Stepping out of download2 loop because: Found downloadlink");
                        break;
                    }
                    download2 = this.findFormDownload2Free(this.br);
                    if (download2 == null) {
                        this.logger.info("Stepping out of download2 loop because: download2 form is null");
                        break;
                    }
                    this.invalidateLastChallengeResponse();
                }
            }
        }
        if (StringUtils.isEmpty(officialDownloadURL) && StringUtils.isEmpty((String)dllink)) {
            this.logger.warning("Failed to find final downloadurl");
            this.checkErrors(this.br, this.getCorrectBR(this.br), link, account);
            this.checkServerErrors(this.br, link, account);
            this.checkErrorsLastResort(this.br, link, account);
            throw new PluginException(0x400000);
        }
        this.handleDownload(link, account, officialDownloadURL, dllink);
    }

    protected String findEmbedURL(Browser br, DownloadLink link, Account Account2) {
        String fid = this.getFUIDFromURL(link);
        URL_TYPE urltype = this.getURLType(link);
        if (fid == null || urltype == null) {
            return null;
        }
        String expectedurl = this.isXFSOld(urltype) ? this.buildURLPath(link, fid, URL_TYPE.EMBED_VIDEO) : this.buildURLPath(link, fid, URL_TYPE.EMBED_VIDEO_2);
        if (br.containsHTML(Pattern.quote(expectedurl))) {
            return expectedurl;
        }
        return null;
    }

    protected String getDllinkViaOfficialVideoDownload(Browser br, DownloadLink link, Account account, boolean returnFilesize) throws Exception {
        String string;
        String[] filesizeCandidates;
        if (returnFilesize) {
            this.logger.info("[FilesizeMode] Trying to find official video downloads");
        } else {
            this.logger.info("[DownloadMode] Trying to find official video downloads");
        }
        String[] videoQualityHTMLs = br.getRegex("<tr><td>[^\r\t\n]+download_video\\(.*?</td></tr>").getColumn(-1);
        if (videoQualityHTMLs == null || videoQualityHTMLs.length == 0) {
            videoQualityHTMLs = br.getRegex("download_video\\([^\r\t\n]+").getColumn(-1);
        }
        if (videoQualityHTMLs == null || videoQualityHTMLs.length == 0) {
            return this.getDllinkViaOfficialVideoDownloadNew(br, link, account, returnFilesize);
        }
        HashMap<String, Integer> qualityMap = new HashMap<String, Integer>();
        qualityMap.put("l", 20);
        qualityMap.put("n", 40);
        qualityMap.put("h", 60);
        qualityMap.put("o", 80);
        qualityMap.put("x", 100);
        ArrayList parsedQualities = new ArrayList();
        for (int currentQualityIndex = 0; currentQualityIndex < videoQualityHTMLs.length; ++currentQualityIndex) {
            String videoQualityHTML = videoQualityHTMLs[currentQualityIndex];
            String filesizeStrTmp = this.scanGenericFileSize(videoQualityHTML);
            org.appwork.utils.Regex videoinfo = new org.appwork.utils.Regex(videoQualityHTML, "download_video\\('([a-z0-9]+)','([^<>\"\\']*)','([^<>\"\\']*)'");
            String videoQualityStr = videoinfo.getMatch(1);
            String videoHashTmp = videoinfo.getMatch(2);
            if (StringUtils.isEmpty((String)videoQualityStr) || StringUtils.isEmpty((String)videoHashTmp)) {
                this.logger.warning("Found unidentifyable video quality");
                continue;
            }
            if (!qualityMap.containsKey(videoQualityStr)) {
                this.logger.info("Skipping unknown quality: " + videoQualityStr);
                continue;
            }
            int internalQualityValue = (Integer)qualityMap.get(videoQualityStr);
            HashMap<String, Object> qualityData = new HashMap<String, Object>();
            qualityData.put("qualityStr", videoQualityStr);
            qualityData.put("videoHash", videoHashTmp);
            qualityData.put("filesizeStr", filesizeStrTmp);
            qualityData.put("targetHTML", videoQualityHTML);
            qualityData.put("qualityIndex", currentQualityIndex);
            qualityData.put("internalQualityValue", internalQualityValue);
            parsedQualities.add(qualityData);
        }
        if (parsedQualities.isEmpty()) {
            this.logger.warning("No valid video qualities found");
            return null;
        }
        String filesizeStr = null;
        String chosenVideoQualityStr = null;
        String videoHash = null;
        String targetHTML = null;
        String userSelectedQualityStr = this.getPreferredDownloadQualityStr();
        boolean foundUserSelectedQuality = false;
        if (userSelectedQualityStr == null) {
            this.logger.info("Trying to find highest quality for official video download");
        } else {
            this.logger.info(String.format("Trying to find user selected quality %s for official video download", userSelectedQualityStr));
        }
        int selectedQualityIndex = 0;
        Map selectedQuality = null;
        if (userSelectedQualityStr != null) {
            for (Map map : parsedQualities) {
                String string2 = (String)map.get("qualityStr");
                if (!string2.equalsIgnoreCase(userSelectedQualityStr)) continue;
                this.logger.info("Found user selected quality: " + userSelectedQualityStr);
                foundUserSelectedQuality = true;
                selectedQuality = map;
                break;
            }
            if (!foundUserSelectedQuality) {
                this.logger.info("Failed to find user selected quality --> Finding next best quality");
                int userSelectedQualityValue = (Integer)qualityMap.get(userSelectedQualityStr.toLowerCase());
                int n = Integer.MAX_VALUE;
                for (Map map : parsedQualities) {
                    int n2;
                    int internalQualityValue = (Integer)map.get("internalQualityValue");
                    if (internalQualityValue <= userSelectedQualityValue || internalQualityValue >= n2) continue;
                    n2 = internalQualityValue;
                    selectedQuality = map;
                }
                if (selectedQuality != null) {
                    this.logger.info("Selected next best quality: " + selectedQuality.get("qualityStr") + " (higher than target " + userSelectedQualityStr + ")");
                }
            }
        }
        if (selectedQuality == null) {
            int maxInternalQualityValue = 0;
            for (Map map : parsedQualities) {
                int n = (Integer)map.get("internalQualityValue");
                if (n <= maxInternalQualityValue) continue;
                maxInternalQualityValue = n;
                selectedQuality = map;
            }
            if (userSelectedQualityStr != null && !foundUserSelectedQuality) {
                this.logger.info("No higher quality found, returning highest available: " + selectedQuality.get("qualityStr"));
            }
        }
        if (selectedQuality != null) {
            chosenVideoQualityStr = (String)selectedQuality.get("qualityStr");
            videoHash = (String)selectedQuality.get("videoHash");
            filesizeStr = (String)selectedQuality.get("filesizeStr");
            targetHTML = (String)selectedQuality.get("targetHTML");
            selectedQualityIndex = (Integer)selectedQuality.get("qualityIndex");
        }
        if (targetHTML == null || chosenVideoQualityStr == null || videoHash == null) {
            this.logger.info(String.format(Locale.ROOT, "Failed to find officially downloadable video quality although there are %d qualities available", videoQualityHTMLs.length));
            return null;
        }
        if (filesizeStr == null && (filesizeCandidates = br.getRegex("(\\d+(?:\\.\\d{1,2})? *(MB|GB))").getColumn(0)).length == videoQualityHTMLs.length) {
            filesizeStr = filesizeCandidates[selectedQualityIndex];
        }
        if (foundUserSelectedQuality) {
            this.logger.info("Found user selected quality: " + userSelectedQualityStr);
        } else {
            this.logger.info("Picked BEST quality: " + chosenVideoQualityStr);
        }
        if (filesizeStr == null) {
            this.logger.info("Failed to find filesize");
        } else {
            this.logger.info("Found filesize of official video download: " + filesizeStr);
        }
        if (returnFilesize) {
            return filesizeStr;
        }
        this.waitTime(link, Time.systemIndependentCurrentJVMTimeMillis());
        this.logger.info("Waiting extra wait seconds: " + this.getDllinkViaOfficialVideoDownloadExtraWaittimeSeconds());
        this.sleep((long)this.getDllinkViaOfficialVideoDownloadExtraWaittimeSeconds() * 1000L, link);
        this.getPage(br, "/dl?op=download_orig&id=" + this.getFUIDFromURL(link) + "&mode=" + chosenVideoQualityStr + "&hash=" + videoHash);
        Form download1 = br.getFormByInputFieldKeyValue("op", "download1");
        if (download1 != null) {
            this.submitForm(br, download1);
            this.checkErrors(br, br.getRequest().getHtmlCode(), link, account);
        }
        if (StringUtils.isEmpty((String)(string = this.getDllink(link, account, br, br.getRequest().getHtmlCode())))) {
            this.logger.warning("Failed to find dllink via official video download");
            return null;
        }
        this.logger.info("Successfully found dllink via official video download:" + string);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    protected String getDllinkViaOfficialVideoDownloadNew(Browser br, DownloadLink link, Account account, boolean returnFilesize) throws Exception {
        String dllink;
        void var12_23;
        void var12_21;
        String videoQualityStr;
        if (returnFilesize) {
            this.logger.info("[FilesizeMode] Trying to find official video downloads");
        } else {
            this.logger.info("[DownloadMode] Trying to find official video downloads");
        }
        boolean isDownload = Plugin.PluginEnvironment.DOWNLOAD.equals((Object)this.getPluginEnvironment());
        if (isDownload) {
            String fuid = this.getFUIDFromURL(link);
            String download_button_url = br.getRegex("(/d/" + fuid + ")").getMatch(0);
            if (download_button_url != null && !br.getURL().contains(download_button_url)) {
                this.logger.info("Accessing download page: " + download_button_url);
                this.getPage(br, download_button_url);
            }
        }
        String[] videourls = br.getRegex("(/d/[a-z0-9]{12}_[a-z]{1})").getColumn(0);
        String[][] videoresolutionsAndFilesizes = br.getRegex(">\\s*(\\d+x\\d+), (\\d+(\\.\\d{1,2})?,? [A-Za-z]{1,5})").getMatches();
        if (videourls == null || videourls.length == 0) {
            this.logger.info("Failed to find any official video downloads");
            return null;
        }
        ArrayList parsedVideos = new ArrayList();
        for (int i = 0; i < videourls.length; ++i) {
            void var12_13;
            String videoURL = videourls[i];
            Object resolution = null;
            Object var12_14 = null;
            if (videoresolutionsAndFilesizes != null && videoresolutionsAndFilesizes.length == videourls.length) {
                String[] thisVideoResolutionAndFilesize = videoresolutionsAndFilesizes[i];
                resolution = thisVideoResolutionAndFilesize[0];
                String string = thisVideoResolutionAndFilesize[1];
            }
            if (StringUtils.isEmpty((String)(videoQualityStr = new org.appwork.utils.Regex(videoURL, "_([a-z]{1})$").getMatch(0)))) {
                this.logger.warning("Found unidentifyable video quality");
                continue;
            }
            HashMap<String, Object> videoData = new HashMap<String, Object>();
            videoData.put("videoURL", videoURL);
            videoData.put("resolution", resolution);
            videoData.put("filesizeStr", var12_13);
            videoData.put("videoQualityStr", videoQualityStr);
            parsedVideos.add(videoData);
        }
        if (parsedVideos.isEmpty()) {
            this.logger.info("No valid video qualities found");
            return null;
        }
        HashMap<String, Integer> qualityMap = new HashMap<String, Integer>();
        qualityMap.put("l", 20);
        qualityMap.put("n", 40);
        qualityMap.put("h", 60);
        qualityMap.put("o", 80);
        qualityMap.put("x", 100);
        ArrayList<Map> validVideos = new ArrayList<Map>();
        for (Map map : parsedVideos) {
            videoQualityStr = (String)map.get("videoQualityStr");
            if (!qualityMap.containsKey(videoQualityStr)) {
                this.logger.info("Skipping unknown quality: " + videoQualityStr);
                continue;
            }
            map.put("internalQualityValue", qualityMap.get(videoQualityStr));
            validVideos.add(map);
        }
        if (validVideos.isEmpty()) {
            this.logger.warning("No valid video qualities found after filtering");
            return null;
        }
        String userSelectedQualityValue = this.getPreferredDownloadQualityStr();
        if (userSelectedQualityValue == null) {
            this.logger.info("Trying to find highest quality for official video download");
        } else {
            this.logger.info(String.format("Trying to find user selected quality %s for official video download", userSelectedQualityValue));
        }
        Object var12_18 = null;
        boolean foundUserSelectedQuality = false;
        if (userSelectedQualityValue != null) {
            for (Map videoData : validVideos) {
                String videoQualityStr2 = (String)videoData.get("videoQualityStr");
                if (!videoQualityStr2.equalsIgnoreCase(userSelectedQualityValue)) continue;
                this.logger.info("Found user selected quality: " + userSelectedQualityValue);
                foundUserSelectedQuality = true;
                Map map = videoData;
                break;
            }
            if (!foundUserSelectedQuality) {
                this.logger.info("Failed to find user selected quality --> Finding next best quality");
                int userSelectedQualityValueInt = (Integer)qualityMap.get(userSelectedQualityValue.toLowerCase());
                int nextBestQualityValue = Integer.MAX_VALUE;
                for (Map videoData : validVideos) {
                    int internalQualityValue = (Integer)videoData.get("internalQualityValue");
                    if (internalQualityValue <= userSelectedQualityValueInt || internalQualityValue >= nextBestQualityValue) continue;
                    nextBestQualityValue = internalQualityValue;
                    Map map = videoData;
                }
                if (var12_21 != null) {
                    this.logger.info("Selected next best quality: " + var12_21.get("videoQualityStr") + " (higher than target " + userSelectedQualityValue + ")");
                }
            }
        }
        if (var12_21 == null) {
            int maxInternalQualityValue = 0;
            for (Map videoData : validVideos) {
                int internalQualityValue = (Integer)videoData.get("internalQualityValue");
                if (internalQualityValue <= maxInternalQualityValue) continue;
                maxInternalQualityValue = internalQualityValue;
                Map map = videoData;
            }
            if (userSelectedQualityValue != null && !foundUserSelectedQuality) {
                this.logger.info("No higher quality found, returning highest available: " + var12_23.get("videoQualityStr"));
            } else {
                this.logger.info("Returning BEST quality according to user preference");
            }
        }
        if (var12_23 == null) {
            this.logger.warning("Video selection handling failed");
            return null;
        }
        String filesizeStrChosen = (String)var12_23.get("filesizeStr");
        String continueURL = (String)var12_23.get("videoURL");
        if (foundUserSelectedQuality) {
            this.logger.info("Returning user selected quality: " + userSelectedQualityValue);
        } else if (userSelectedQualityValue != null) {
            this.logger.info("Returning next best or highest quality as fallback");
        } else {
            this.logger.info("Returning BEST quality according to user preference");
        }
        if (returnFilesize) {
            return filesizeStrChosen;
        }
        this.getPage(br, continueURL);
        this.checkErrors(br, continueURL, link, account);
        Form download1 = br.getFormByInputFieldKeyValue("op", "download_orig");
        if (download1 != null) {
            long timeBefore = Time.systemIndependentCurrentJVMTimeMillis();
            this.handleCaptcha(link, br, download1);
            int extraWaitSeconds = this.getDllinkViaOfficialVideoDownloadExtraWaittimeSeconds();
            if (extraWaitSeconds > 0) {
                this.logger.info("Waiting extra wait seconds: " + extraWaitSeconds);
                this.waitTime(link, timeBefore, extraWaitSeconds);
            }
            this.submitForm(br, download1);
            this.checkErrors(br, br.getRequest().getHtmlCode(), link, account);
        }
        if (StringUtils.isEmpty((String)(dllink = this.getDllink(link, account, br, br.getRequest().getHtmlCode())))) {
            this.logger.warning("Failed to find dllink via official video download");
            return null;
        }
        this.logger.info("Successfully found dllink via official video download");
        return dllink;
    }

    protected int getDllinkViaOfficialVideoDownloadExtraWaittimeSeconds() {
        return 5;
    }

    protected String getPreferredDownloadQualityStr() {
        Class<? extends XFSConfigVideo> cfgO = this.getVideoConfigInterface();
        if (cfgO == null) {
            return null;
        }
        XFSConfigVideo cfg = PluginJsonConfig.get(cfgO);
        XFSConfigVideo.PreferredDownloadQuality quality = cfg.getPreferredDownloadQuality();
        switch (quality) {
            case HIGH: {
                return "h";
            }
            case NORMAL: {
                return "n";
            }
            case LOW: {
                return "l";
            }
        }
        return null;
    }

    protected void setCaptchaResponse(Browser br, CaptchaHosterHelperInterface captchaHosterHelper, Form form, String response) {
        if (captchaHosterHelper instanceof CaptchaHelperHostPluginHCaptcha) {
            form.put("h-captcha-response", Encoding.urlEncode((String)response));
            if (this.containsRecaptchaV2Class(br)) {
                form.put("g-recaptcha-response", Encoding.urlEncode((String)response));
            }
        } else {
            form.put("g-recaptcha-response", Encoding.urlEncode((String)response));
        }
    }

    protected void waitBeforeInteractiveCaptcha(DownloadLink link, int captchaTimeoutMillis) throws PluginException {
        if (this.preDownloadWaittimeSkippable()) {
            return;
        }
        String waitStr = this.regexWaittime(this.br);
        if (waitStr == null) {
            return;
        }
        if (!waitStr.matches("\\d+")) {
            return;
        }
        int preDownloadWaittimeMillis = Integer.parseInt(waitStr) * 1000;
        if (preDownloadWaittimeMillis > captchaTimeoutMillis) {
            int prePrePreDownloadWait = preDownloadWaittimeMillis - captchaTimeoutMillis;
            this.logger.info("Waittime is higher than interactive captcha timeout --> Waiting a part of it before solving captcha to avoid captcha-token-timeout");
            this.logger.info("Pre-pre download waittime seconds: " + prePrePreDownloadWait / 1000);
            this.sleep(prePrePreDownloadWait, link);
        }
    }

    protected boolean handleCloudflareTurnstileCaptcha(DownloadLink link, Browser br, Form captchaForm) throws Exception {
        CaptchaHelperHostPluginCloudflareTurnstile ts = new CaptchaHelperHostPluginCloudflareTurnstile(this, br);
        this.logger.info("Detected captcha method \"CloudflareTurnstileCaptcha\" for this host");
        this.waitBeforeInteractiveCaptcha(link, ts.getSolutionTimeout());
        String cfTurnstileResponse = ts.getToken();
        captchaForm.put("cf-turnstile-response", Encoding.urlEncode((String)cfTurnstileResponse));
        captchaForm.put("g-recaptcha-response", Encoding.urlEncode((String)cfTurnstileResponse));
        return true;
    }

    protected boolean handleHCaptcha(DownloadLink link, Browser br, Form captchaForm) throws Exception {
        CaptchaHelperHostPluginHCaptcha hCaptcha = this.getCaptchaHelperHostPluginHCaptcha(this, br);
        this.logger.info("Detected captcha method \"hcaptcha\" type '" + (Object)((Object)hCaptcha.getType()) + "' for this host");
        this.waitBeforeInteractiveCaptcha(link, hCaptcha.getSolutionTimeout());
        String response = hCaptcha.getToken();
        this.setCaptchaResponse(br, hCaptcha, captchaForm, response);
        return true;
    }

    protected boolean handleRecaptchaV2(DownloadLink link, Browser br, Form captchaForm) throws Exception {
        CaptchaHelperHostPluginRecaptchaV2 rc2 = this.getCaptchaHelperHostPluginRecaptchaV2(this, br);
        this.logger.info("Detected captcha method \"RecaptchaV2\" normal-type '" + (Object)((Object)rc2.getType()) + "' for this host");
        this.waitBeforeInteractiveCaptcha(link, rc2.getSolutionTimeout());
        String recaptchaV2Response = rc2.getToken();
        this.setCaptchaResponse(br, rc2, captchaForm, recaptchaV2Response);
        return true;
    }

    protected CaptchaHelperHostPluginHCaptcha getCaptchaHelperHostPluginHCaptcha(PluginForHost plugin, Browser br) throws PluginException {
        return new CaptchaHelperHostPluginHCaptcha(this, br);
    }

    protected CaptchaHelperHostPluginRecaptchaV2 getCaptchaHelperHostPluginRecaptchaV2(PluginForHost plugin, Browser br) throws PluginException {
        return new CaptchaHelperHostPluginRecaptchaV2(this, br);
    }

    public void handleCaptcha(DownloadLink link, Browser br, Form captchaForm) throws Exception {
        String reCaptchaKey = captchaForm.getRegex("data-sitekey=\"([^\"]+)").getMatch(0);
        if (new org.appwork.utils.Regex(this.getCorrectBR(br), Pattern.compile("\\$\\.post\\(\\s*\"/ddl\"", 2)).patternFind()) {
            String captchaResponse;
            CaptchaHosterHelperInterface captchaHelper;
            if (this.containsHCaptcha(this.getCorrectBR(br))) {
                CaptchaHelperHostPluginHCaptcha captchaHelperHostPluginHCaptcha = this.getCaptchaHelperHostPluginHCaptcha(this, br);
                this.logger.info("Detected captcha method \"hCaptcha\" type '" + (Object)((Object)captchaHelperHostPluginHCaptcha.getType()) + "' for this host");
                captchaHelper = captchaHelperHostPluginHCaptcha;
                this.waitBeforeInteractiveCaptcha(link, captchaHelperHostPluginHCaptcha.getSolutionTimeout());
                captchaResponse = captchaHelperHostPluginHCaptcha.getToken();
            } else {
                CaptchaHelperHostPluginRecaptchaV2 captchaHelperHostPluginRecaptchaV2 = this.getCaptchaHelperHostPluginRecaptchaV2(this, br);
                this.logger.info("Detected captcha method \"RecaptchaV2\" type '" + (Object)((Object)captchaHelperHostPluginRecaptchaV2.getType()) + "' for this host");
                captchaHelper = captchaHelperHostPluginRecaptchaV2;
                this.waitBeforeInteractiveCaptcha(link, captchaHelperHostPluginRecaptchaV2.getSolutionTimeout());
                captchaResponse = captchaHelper.getToken();
            }
            captchaForm.put("g-recaptcha-response", "");
            Form form = new Form();
            form.setMethod(Form.MethodType.POST);
            form.setAction("/ddl");
            InputField inputField_Rand = captchaForm.getInputFieldByName("rand");
            String file_id = PluginJSonUtils.getJson(br, "file_id");
            if (inputField_Rand != null) {
                form.put("rand", inputField_Rand.getValue());
            }
            if (!StringUtils.isEmpty((String)file_id)) {
                form.put("file_id", file_id);
            }
            form.put("op", "captcha1");
            Browser brc = br.cloneBrowser();
            this.setCaptchaResponse(brc, captchaHelper, form, captchaResponse);
            brc.getHeaders().put("X-Requested-With", "XMLHttpRequest");
            this.submitForm(brc, form);
            if (brc.getRequest().getHtmlCode().equalsIgnoreCase("ERROR: Wrong captcha")) {
                throw new PluginException(8);
            }
            if (!brc.getRequest().getHtmlCode().equalsIgnoreCase("OK")) {
                this.logger.warning("Fatal " + captchaHelper + " ajax handling failure");
                this.checkErrorsLastResort(brc, link, null);
                throw new PluginException(0x400000);
            }
        } else if (AbstractCloudflareTurnstileCaptcha.containsCloudflareTurnstileClass(br)) {
            if (this.handleCloudflareTurnstileCaptcha(link, br, captchaForm)) {
                // empty if block
            }
        } else if (this.containsHCaptcha(this.getCorrectBR(br))) {
            if (this.handleHCaptcha(link, br, captchaForm)) {
                // empty if block
            }
        } else if (this.containsRecaptchaV2Class(this.getCorrectBR(br))) {
            if (this.handleRecaptchaV2(link, br, captchaForm)) {
                // empty if block
            }
        } else if (reCaptchaKey != null) {
            if (this.handleRecaptchaV2(link, br, captchaForm)) {
                // empty if block
            }
        } else if (this.containsPlainTextCaptcha(this.getCorrectBR(br))) {
            this.logger.info("Detected captcha method \"plaintext captchas\" for this host");
            String[][] letters = new org.appwork.utils.Regex((Object)br, "<span style=.position:absolute;padding-left:(\\d+)px;padding-top:\\d+px;.>(&#\\d+;)</span>").getMatches();
            if (!(letters != null && letters.length != 0 || (letters = new org.appwork.utils.Regex(br.getRequest().getHtmlCode(), "<span style=.position:absolute;padding-left:(\\d+)px;padding-top:\\d+px;.>(&#\\d+;)</span>").getMatches()) != null && letters.length != 0)) {
                this.logger.warning("plaintext captchahandling broken!");
                this.checkErrorsLastResort(br, link, null);
                throw new PluginException(0x400000);
            }
            TreeMap<Integer, String> capMap = new TreeMap<Integer, String>();
            for (String[] letter : letters) {
                capMap.put(Integer.parseInt(letter[0]), Encoding.htmlDecode((String)letter[1]));
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String value : capMap.values()) {
                stringBuilder.append(value);
            }
            captchaForm.put("code", stringBuilder.toString());
            this.logger.info("Put captchacode " + stringBuilder.toString() + " obtained by captcha metod \"plaintext captchas\" in captchaForm");
        } else if (StringUtils.containsIgnoreCase((String)this.getCorrectBR(br), (String)"/captchas/")) {
            this.logger.info("Detected captcha method \"Standard captcha\" for this host");
            String[] sitelinks = HTMLParser.getHttpLinks(br.getRequest().getHtmlCode(), "");
            if (sitelinks == null || sitelinks.length == 0) {
                this.logger.warning("Standard captcha captchahandling broken!");
                this.checkErrorsLastResort(br, link, null);
                throw new PluginException(0x400000);
            }
            String captchaurl = null;
            for (String linkTmp : sitelinks) {
                if (!StringUtils.containsIgnoreCase((String)linkTmp, (String)"/captchas/")) continue;
                captchaurl = linkTmp;
                break;
            }
            if (StringUtils.isEmpty(captchaurl)) {
                captchaurl = new org.appwork.utils.Regex(this.getCorrectBR(br), Pattern.compile("(/captchas/[a-z0-9]+\\.jpe?g)", 2)).getMatch(0);
            }
            if (captchaurl == null) {
                this.logger.warning("Standard captcha captchahandling broken2!");
                this.checkErrorsLastResort(br, link, null);
                throw new PluginException(0x400000);
            }
            String string = this.getCaptchaCode(CAPTCHA_METHOD_ID_XFS_DEFAULT, captchaurl, link);
            captchaForm.put("code", string);
            this.logger.info("Put captchacode " + string + " obtained by captcha metod \"Standard captcha\" in the form.");
        } else {
            if (new org.appwork.utils.Regex(this.getCorrectBR(br), "(api\\.recaptcha\\.net|google\\.com/recaptcha/api/)").patternFind()) {
                this.logger.info("Detected captcha method \"reCaptchaV1\" for this host");
                throw new PluginException(131072, "Website uses reCaptchaV1 which has been shut down by Google. Contact website owner!");
            }
            if (AbstractCloudflareTurnstileCaptcha.containsCloudflareTurnstileClass(br)) {
                throw new PluginException(131072, "Unsupported captcha type 'Cloudflare Turnstile'");
            }
        }
    }

    protected boolean containsPlainTextCaptcha(String correctBR) {
        return StringUtils.containsIgnoreCase((String)correctBR, (String)";background:#ccc;text-align");
    }

    public Form findFormDownload1Free(Browser br) throws Exception {
        if (br == null) {
            return null;
        }
        Form ret = br.getFormByInputFieldKeyValue("op", "download1");
        if (ret == null) {
            return null;
        }
        ret.remove("method_premium");
        String method_free_key = "method_free";
        if (!ret.hasInputFieldByName("method_free") || ret.getInputFieldByName("method_free").getValue() == null) {
            String method_free_value = ret.getRegex("\"method_free\" value=\"([^<>\"]+)\"").getMatch(0);
            if (method_free_value == null || method_free_value.equals("")) {
                method_free_value = "Free Download";
            }
            ret.put("method_free", Encoding.urlEncode((String)method_free_value));
        }
        return ret;
    }

    protected Form findFormDownload2Free(Browser br) {
        Form[] forms;
        Form ret = null;
        for (Form form : forms = br.getForms()) {
            InputField op_field = form.getInputFieldByName("op");
            if (!form.containsHTML("method_") || op_field == null || !op_field.getValue().contains("download")) continue;
            ret = form;
            break;
        }
        if (ret == null && (ret = br.getFormbyProperty("name", "F1")) == null) {
            ret = br.getFormByInputFieldKeyValue("op", "download2");
        }
        if (ret == null) {
            return null;
        }
        InputField adblock_detected = ret.getInputField("adblock_detected");
        if (adblock_detected != null && StringUtils.isEmpty((String)adblock_detected.getValue())) {
            adblock_detected.setValue("0");
        }
        return ret;
    }

    public Form findFormDownload2Premium(DownloadLink downloadLink, Account account, Browser br) throws Exception {
        return br.getFormbyProperty("name", "F1");
    }

    protected String getStoredDirectUrl(DownloadLink link, Account account) {
        String directurlproperty = this.getDownloadModeDirectlinkProperty(account);
        String ret = link.getStringProperty(directurlproperty);
        return ret;
    }

    protected final String checkDirectLink(DownloadLink link, Account account) throws Exception {
        String dllink = this.getStoredDirectUrl(link, account);
        if (dllink == null) {
            return null;
        }
        String validDirecturl = this.checkDirectLinkAndSetFilesize(link, dllink, false);
        if (validDirecturl != null) {
            return validDirecturl;
        }
        this.removeStoredDirectUrl(link, account);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String checkDirectLinkAndSetFilesize(DownloadLink link, String directurl, boolean setFilesize) throws Exception {
        Browser br2;
        boolean throwException;
        URLConnectionAdapter con;
        block28: {
            String string;
            block29: {
                block26: {
                    String string2;
                    block27: {
                        block24: {
                            String string3;
                            block25: {
                                if (StringUtils.isEmpty((String)directurl) || !directurl.startsWith("http")) {
                                    return null;
                                }
                                con = null;
                                throwException = false;
                                br2 = this.br.cloneBrowser();
                                Object request = this.supportsHEADRequestForDirecturlCheck() ? br2.createHeadRequest(directurl) : br2.createGetRequest(directurl);
                                request.getHeaders().put("Accept-Encoding", "identity");
                                con = this.openAntiDDoSRequestConnection(br2, (Request)request);
                                if (con.getResponseCode() != 503) break block24;
                                throwException = true;
                                this.exception503ConnectionLimitReached();
                                string3 = directurl;
                                if (con == null) break block25;
                                try {
                                    con.disconnect();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            return string3;
                        }
                        if (!this.looksLikeDownloadableContent(con)) break block26;
                        long completeContentLength = con.getCompleteContentLength();
                        if (setFilesize && completeContentLength > 0L) {
                            if (con.isContentDecoded()) {
                                link.setDownloadSize(completeContentLength);
                            } else {
                                link.setVerifiedFileSize(completeContentLength);
                            }
                        }
                        string2 = directurl;
                        if (con == null) break block27;
                        try {
                            con.disconnect();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return string2;
                }
                if (!LinkCrawlerDeepInspector.looksLikeMpegURL(con)) break block28;
                string = directurl;
                if (con == null) break block29;
                try {
                    con.disconnect();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return string;
        }
        try {
            try {
                br2.followConnection(true);
                throw new Exception("no downloadable content?" + con.getResponseCode() + "|" + con.getContentType() + "|" + con.isContentDisposition());
            }
            catch (Exception e) {
                if (throwException) {
                    throw e;
                }
                this.logger.log((Throwable)e);
                String string = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (con != null) {
                try {
                    con.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected final boolean attemptStoredDownloadurlDownload(DownloadLink link, Account account) throws Exception {
        String url = this.getStoredDirectUrl(link, account);
        if (StringUtils.isEmpty((String)url)) {
            return false;
        }
        this.logger.info("Attempting to re-use stored directurl: " + url);
        Browser br = this.createNewBrowserInstance();
        if (!this.tryDownload(br, link, account, (Request)br.createGetRequest(url), new DOWNLOAD_ATTEMPT_FLAGS[0])) {
            this.removeStoredDirectUrl(link, account);
            return false;
        }
        return true;
    }

    protected boolean removeStoredDirectUrl(DownloadLink link, Account account) {
        return false;
    }

    protected boolean verifyURLFormat(String url) {
        try {
            if (StringUtils.startsWithCaseInsensitive((String)url, (String)"http")) {
                URLHelper.verifyURL((URL)new URL(url));
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    protected String getReferer(DownloadLink link) {
        String custom_referer_from_settings;
        String downloadPassword = link.getDownloadPassword();
        if (!StringUtils.isEmpty((String)downloadPassword) && !this.canHandle(downloadPassword) && this.verifyURLFormat(downloadPassword)) {
            this.logger.info("Using download password as referer: " + downloadPassword);
            return downloadPassword;
        }
        String containerURL = link.getContainerUrl();
        if (!StringUtils.isEmpty((String)containerURL) && !this.canHandle(containerURL) && this.verifyURLFormat(containerURL)) {
            this.logger.info("Using containerURL as referer: " + containerURL);
            return containerURL;
        }
        Class<? extends XFSConfig> cfg = this.getConfigInterface();
        if (cfg != null && !StringUtils.isEmpty((String)(custom_referer_from_settings = PluginJsonConfig.get(cfg).getCustomReferer())) && !this.canHandle(custom_referer_from_settings) && this.verifyURLFormat(custom_referer_from_settings)) {
            this.logger.info("Using custom config as referer: " + custom_referer_from_settings);
            return custom_referer_from_settings;
        }
        return null;
    }

    @Override
    public boolean hasAutoCaptcha() {
        return false;
    }

    @Override
    public boolean hasCaptcha(DownloadLink link, Account acc) {
        if (this.isPremium(acc)) {
            return false;
        }
        return !this.isImagehoster();
    }

    protected Boolean requiresCaptchaForOfficialVideoDownload() {
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean() {
        try {
            this.correctBrowserMap.set(null);
            super.clean();
        }
        finally {
            WeakHashMap<Request, String[]> weakHashMap = this.correctedBrowserRequestMap;
            synchronized (weakHashMap) {
                this.correctedBrowserRequestMap.clear();
            }
        }
    }

    public ArrayList<String> getCleanupHTMLRegexes() {
        ArrayList<String> regexStuff = new ArrayList<String>();
        regexStuff.add("<\\!(\\-\\-.*?\\-\\-)>");
        regexStuff.add("(<div[^>]*style\\s*=\\s*\"[^\"]*display: ?none;\"[^>]*>.*?</div>)");
        regexStuff.add("(visibility:hidden>.*?<)");
        return regexStuff;
    }

    protected String replaceCorrectBR(Browser br, String pattern, String target) {
        if (StringUtils.containsIgnoreCase((String)pattern, (String)"none") && (this.containsHCaptcha(target) || this.containsRecaptchaV2Class(target) || this.containsPlainTextCaptcha(target))) {
            return null;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String correctBR(Browser br) {
        WeakHashMap<Request, String[]> weakHashMap = this.correctedBrowserRequestMap;
        synchronized (weakHashMap) {
            Request request = br.getRequest();
            String[] html = this.correctedBrowserRequestMap.get(request);
            if (html == null) {
                html = new String[2];
                try {
                    html[1] = br.getRequest().getHtmlCode();
                }
                catch (Throwable e) {
                    this.logger.log(e);
                    html[1] = "";
                }
                html[0] = html[1];
                ArrayList<String> regexStuff = this.getCleanupHTMLRegexes();
                boolean modified = false;
                if (regexStuff != null) {
                    Iterator<String> iterator = regexStuff.iterator();
                    while (iterator.hasNext()) {
                        String before = html[0];
                        String aRegex = iterator.next();
                        String after = this.applyCorrectBR(br, before, aRegex);
                        if (StringUtils.equals((String)before, (String)after)) continue;
                        html[0] = after;
                        modified = true;
                    }
                }
                if (modified && request != null && request.isRequested()) {
                    this.correctedBrowserRequestMap.put(request, html);
                } else {
                    this.correctedBrowserRequestMap.remove(request);
                }
            }
            br.getRequest().setHtmlCode(html[0]);
            return html[0];
        }
    }

    protected String applyCorrectBR(Browser br, String correctedBR, String pattern) {
        String[] matches = new org.appwork.utils.Regex(correctedBR, pattern).getColumn(0);
        if (matches != null && matches.length > 0) {
            for (String match : matches) {
                String replace = this.replaceCorrectBR(br, pattern, match);
                if (replace == null) continue;
                correctedBR = correctedBR.replace(match, replace);
            }
        }
        return correctedBR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCorrectBR(Browser br) {
        WeakHashMap<Request, String[]> weakHashMap = this.correctedBrowserRequestMap;
        synchronized (weakHashMap) {
            String[] html = this.correctedBrowserRequestMap.get(br.getRequest());
            if (html != null) {
                return html[0];
            }
            return br.getRequest().getHtmlCode();
        }
    }

    protected String getDllink(DownloadLink link, Account account, Browser br, String src) {
        String[] cryptedScripts;
        String dllink = null;
        String current_url = br.getURL();
        for (Pattern pattern : this.getDownloadurlRegexes()) {
            String this_dllink = new org.appwork.utils.Regex(src, pattern).getMatch(0);
            if (this_dllink == null || this_dllink.equals(current_url)) continue;
            dllink = this_dllink;
            break;
        }
        if (StringUtils.isEmpty(dllink) && (cryptedScripts = new org.appwork.utils.Regex(src, "p\\}\\((.*?)\\.split\\('\\|'\\)").getColumn(0)) != null && cryptedScripts.length != 0) {
            String crypted;
            String[] stringArray = cryptedScripts;
            int n = stringArray.length;
            for (int i = 0; i < n && (dllink = this.decodeDownloadLink(link, account, br, crypted = stringArray[i])) == null; ++i) {
            }
        }
        if (StringUtils.isEmpty(dllink)) {
            dllink = this.getDllinkVideohost(link, account, br, src);
        }
        if (dllink == null && this.isImagehoster()) {
            dllink = this.getDllinkImagehost(link, account, br, src);
        }
        if (dllink != null) {
            dllink = Encoding.htmlOnlyDecode(dllink);
        }
        return dllink;
    }

    protected String getDllinkImagehost(DownloadLink link, Account account, Browser br, String src) {
        HashMap<String, Integer> possibleDllinks = new HashMap<String, Integer>();
        for (Pattern pattern : this.getImageDownloadurlRegexes()) {
            String[] stringArray;
            for (String url : stringArray = new org.appwork.utils.Regex(src, pattern).getColumn(0)) {
                Integer count = (Integer)possibleDllinks.get(url);
                if (count == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                possibleDllinks.put(url, count);
            }
        }
        Map.Entry best = null;
        for (Map.Entry entry : possibleDllinks.entrySet()) {
            if (((String)entry.getKey()).matches(".+_t\\.[A-Za-z]{3,4}$") || ((String)entry.getKey()).matches(".+/th/\\d+.*$")) continue;
            if (best == null) {
                best = entry;
                continue;
            }
            if ((Integer)entry.getValue() <= (Integer)best.getValue()) continue;
            best = entry;
        }
        if (best == null && possibleDllinks.size() > 0) {
            this.logger.info("All possible image directurls have been filtered (all thumbnails?)");
        }
        if (best != null) {
            String string = (String)best.getKey();
            return string;
        }
        return null;
    }

    protected String getDllinkVideohost(DownloadLink link, Account account, Browser br, String src) {
        String check;
        String[] jssources;
        String dllink = null;
        String jssource = new org.appwork.utils.Regex(src, "\"?sources\"?\\s*:\\s*(\\[[^\\]]+\\])").getMatch(0);
        if (StringUtils.isEmpty((String)jssource) && (jssources = new org.appwork.utils.Regex(src, ":\\s*(\\[[^\\]]+\\])").getColumn(0)) != null && jssources.length > 0) {
            for (String thisjssource : jssources) {
                if (!new org.appwork.utils.Regex(thisjssource, "[a-z0-9]{60}/v\\.mp4").patternFind()) continue;
                jssource = thisjssource;
                break;
            }
        }
        if (!StringUtils.isEmpty((String)jssource)) {
            this.logger.info("Found video json source");
            String[] possibleQualityObjectNames = new String[]{"label", "res"};
            String[] possibleStreamURLObjectNames = new String[]{"file", "src"};
            try {
                long quality_picked = -1L;
                String dllink_temp = null;
                List ressourcelist = null;
                HashMap<String, String> references = new HashMap<String, String>();
                while (true) {
                    try {
                        if (references.size() > 0) {
                            ScriptEngineManager mgr = JavaScriptEngineFactory.getScriptEngineManager(this);
                            ScriptEngine engine = mgr.getEngineByName("JavaScript");
                            for (Map.Entry reference : references.entrySet()) {
                                engine.eval("var " + (String)reference.getKey() + "=" + (String)reference.getValue() + ";");
                            }
                            engine.eval("var response=" + jssource + ";");
                            ressourcelist = (List)JavaScriptEngineFactory.convertJavaScriptToJava(engine.get("response"));
                            break;
                        }
                        ressourcelist = (List)JavaScriptEngineFactory.jsonToJavaObject(jssource);
                    }
                    catch (Exception e) {
                        String undefined;
                        EcmaError ee = (EcmaError)Exceptions.getInstanceof((Throwable)e, EcmaError.class);
                        String string = undefined = ee == null ? null : new org.appwork.utils.Regex(ee.getMessage(), "ReferenceError\\s*:\\s*\"(.*?)\"\\s*(is not defined|n'est pas d\u00e9fini|\u672a\u5b9a\u4e49)?").getMatch(0);
                        if (undefined == null || references.containsKey(undefined)) {
                            throw e;
                        }
                        String value = new org.appwork.utils.Regex(src, "var\\s*" + Pattern.quote(undefined) + "\\s*=\\s*(\\{.*?\\})\\s*;").getMatch(0);
                        if (value == null) {
                            throw e;
                        }
                        references.put(undefined, value);
                        this.getLogger().log((Throwable)e);
                        continue;
                    }
                    break;
                }
                boolean onlyOneQualityAvailable = ressourcelist.size() == 1;
                int userSelectedQuality = this.getPreferredStreamQuality();
                if (userSelectedQuality == -1) {
                    this.logger.info("Looking for BEST video stream");
                } else {
                    this.logger.info("Looking for user selected video stream quality: " + userSelectedQuality);
                }
                boolean foundUserSelectedQuality = false;
                for (Object videoo : ressourcelist) {
                    Map entries;
                    if (videoo instanceof String && onlyOneQualityAvailable) {
                        this.logger.info("Only one quality available --> Returning that");
                        dllink_temp = (String)videoo;
                        if (dllink_temp.startsWith("http")) {
                            dllink = dllink_temp;
                            break;
                        }
                    }
                    if (videoo instanceof Map) {
                        entries = (Map)videoo;
                        for (String possibleStreamURLObjectName : possibleStreamURLObjectNames) {
                            if (!entries.containsKey(possibleStreamURLObjectName)) continue;
                            dllink_temp = (String)entries.get(possibleStreamURLObjectName);
                            break;
                        }
                    } else {
                        entries = null;
                    }
                    if (StringUtils.isEmpty(dllink_temp)) continue;
                    if (dllink_temp.contains(".mpd")) {
                        this.logger.info("Skipping DASH stream: " + dllink_temp);
                        continue;
                    }
                    long quality_temp = 0L;
                    for (String possibleQualityObjectName : possibleQualityObjectNames) {
                        try {
                            String res;
                            Object quality_temp_o = entries.get(possibleQualityObjectName);
                            if (quality_temp_o != null && quality_temp_o instanceof Number) {
                                quality_temp = ((Number)quality_temp_o).intValue();
                            } else if (quality_temp_o != null && quality_temp_o instanceof String && (res = new org.appwork.utils.Regex((String)quality_temp_o, "(\\d+)p?$").getMatch(0)) != null) {
                                quality_temp = (int)Long.parseLong(res);
                            }
                            if (quality_temp <= 0L) continue;
                            break;
                        }
                        catch (Throwable e) {
                            this.logger.log(e);
                            this.logger.info("Failed to find quality via key '" + possibleQualityObjectName + "' for current downloadurl candidate: " + dllink_temp);
                            if (onlyOneQualityAvailable) continue;
                        }
                    }
                    if (StringUtils.isEmpty((String)dllink_temp)) continue;
                    if (quality_temp == (long)userSelectedQuality) {
                        this.logger.info("Found user selected quality: " + userSelectedQuality);
                        foundUserSelectedQuality = true;
                        quality_picked = quality_temp;
                        dllink = dllink_temp;
                        break;
                    }
                    if (quality_temp <= quality_picked) continue;
                    quality_picked = quality_temp;
                    dllink = dllink_temp;
                }
                if (!StringUtils.isEmpty((String)dllink)) {
                    this.logger.info("Quality handling for multiple video stream sources succeeded - picked quality is: " + quality_picked);
                    if (foundUserSelectedQuality) {
                        this.logger.info("Successfully found user selected quality: " + userSelectedQuality);
                    } else {
                        this.logger.info("Successfully found BEST quality: " + quality_picked);
                    }
                } else {
                    this.logger.info("Failed to find any stream downloadurl");
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
                this.logger.info("BEST handling for multiple video source failed");
            }
        }
        if (StringUtils.isEmpty(dllink)) {
            dllink = this.regexVideoStreamDownloadURL(src);
        }
        if (StringUtils.isEmpty(dllink) && StringUtils.isNotEmpty((String)(check = new org.appwork.utils.Regex(src, "file\\s*:\\s*\"(https?[^<>\"]*?\\.(?:mp4|flv))\"").getMatch(0))) && !StringUtils.containsIgnoreCase((String)check, (String)"/images/")) {
            dllink = check;
        }
        if (StringUtils.isEmpty((String)dllink)) {
            dllink = br.getRegex("href\\s*=\\s*\"(https?://[^\"]+)\"[^>]*>\\s*Direct Download Link").getMatch(0);
        }
        return dllink;
    }

    private final String regexVideoStreamDownloadURL(String src) {
        String dllink = new org.appwork.utils.Regex(src, Pattern.compile("(https?://[^/]+[^\"]+[a-z0-9]{60}/v\\.mp4)", 2)).getMatch(0);
        if (StringUtils.isEmpty((String)dllink)) {
            dllink = new org.appwork.utils.Regex(src, Pattern.compile("\"(https?://[^/]+/[a-z0-9]{60}/[^\"]+)\"", 2)).getMatch(0);
        }
        return dllink;
    }

    protected Class<? extends XFSConfigVideo> getVideoConfigInterface() {
        Class<? extends XFSConfig> configInterface = this.getConfigInterface();
        if (configInterface != null && XFSConfigVideo.class.isAssignableFrom(configInterface)) {
            return configInterface;
        }
        return null;
    }

    protected final int getPreferredStreamQuality() {
        Class<? extends XFSConfigVideo> cfgO = this.getVideoConfigInterface();
        if (cfgO == null) {
            return -1;
        }
        XFSConfigVideo cfg = PluginJsonConfig.get(cfgO);
        XFSConfigVideo.PreferredStreamQuality quality = cfg.getPreferredStreamQuality();
        switch (quality) {
            case Q2160P: {
                return 2160;
            }
            case Q1080P: {
                return 1080;
            }
            case Q720P: {
                return 720;
            }
            case Q480P: {
                return 480;
            }
            case Q360P: {
                return 360;
            }
        }
        return -1;
    }

    public String decodeDownloadLink(DownloadLink link, Account account, Browser br, String s) {
        String decoded = null;
        try {
            org.appwork.utils.Regex params = new org.appwork.utils.Regex(s, "'(.*?[^\\\\])',(\\d+),(\\d+),'(.*?)'");
            String p = params.getMatch(0).replaceAll("\\\\", "");
            int a = Integer.parseInt(params.getMatch(1));
            int c = Integer.parseInt(params.getMatch(2));
            String[] k = params.getMatch(3).split("\\|");
            while (c != 0) {
                if (k[--c].length() == 0) continue;
                p = p.replaceAll("\\b" + Integer.toString(c, a) + "\\b", k[c]);
            }
            decoded = p;
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            this.logger.info("js unpack failed");
        }
        String dllink = null;
        if (decoded != null && StringUtils.isEmpty((String)(dllink = this.getDllinkVideohost(link, account, br, decoded)))) {
            dllink = new org.appwork.utils.Regex(decoded, "(?:\"|')(https?://[^<>\"']*?\\.(avi|flv|mkv|mp4|m3u8))(?:\"|')").getMatch(0);
        }
        return dllink;
    }

    protected boolean isDllinkFile(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return false;
        }
        for (Pattern pattern : this.getDownloadurlRegexes()) {
            String urlMatch = new org.appwork.utils.Regex(url, pattern).getMatch(0);
            if (urlMatch == null) continue;
            return true;
        }
        return false;
    }

    protected final String getDllinkHostPattern() {
        return "[A-Za-z0-9\\-\\.]*";
    }

    protected String regexWaittime(Browser br) {
        return this.regexWaittime(br.getRequest().getHtmlCode());
    }

    protected String regexWaittime(String html) {
        String waitStr = new org.appwork.utils.Regex(html, "id=(?:\"|\\')countdown_str(?:\"|\\')[^>]*>[^<>]*<span id=[^>]*>\\s*(\\d+)\\s*</span>").getMatch(0);
        if (waitStr == null && (waitStr = new org.appwork.utils.Regex(html, "class=\"seconds\"[^>]*>\\s*(\\d+)\\s*</span>").getMatch(0)) == null && (waitStr = new org.appwork.utils.Regex(html, "class=\"seconds\"[^>]*>\\s*(\\d+)\\s*<").getMatch(0)) == null) {
            waitStr = new org.appwork.utils.Regex(html, "id=\"seconds\"[^>]*>\\s*(\\d+)\\s*<").getMatch(0);
        }
        return waitStr;
    }

    protected List<Pattern> getDownloadurlRegexes() {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        patterns.add(Pattern.compile("\"" + String.format("(https?://(?:\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|%s)(?::\\d+)?/(?:files|d|cgi\\-bin/dl\\.cgi|dl)/(?:\\d+/)?[a-z0-9]+/[^<>\"/]*)", this.getDllinkHostPattern()) + "\""));
        patterns.add(Pattern.compile(String.format("(https?://(?:\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|%s)(?::\\d+)?/(?:files|d|cgi\\-bin/dl\\.cgi|dl)/(?:\\d+/)?[a-z0-9]+/[^<>\"/']*)", this.getDllinkHostPattern()) + "'\\s*\\)\\s*;"));
        patterns.add(Pattern.compile(String.format("(https?://(?:\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|%s)(?::\\d+)?/(?:files|d|cgi\\-bin/dl\\.cgi|dl)/(?:\\d+/)?[a-z0-9]+/[^<>\"'/]*)", this.getDllinkHostPattern())));
        return patterns;
    }

    protected List<Pattern> getImageDownloadurlRegexes() {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        String protocol = "https?://";
        String ipAddress = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
        String hostPattern = String.format("(?:%s|%s)", ipAddress, this.getDllinkHostPattern());
        String port = "(?:\\d+)?";
        String fileNamePattern = "[^<>\"'\\[\\]]+";
        String optionalProtocolAndHost = String.format("(?:%s%s%s)?", protocol, hostPattern, port);
        String imgWithDigits = String.format("(%s/img/\\d+/%s)", optionalProtocolAndHost, fileNamePattern);
        patterns.add(Pattern.compile(imgWithDigits));
        String imgWithAlphaNum = String.format("(%s/img/[a-z0-9]+/%s)", optionalProtocolAndHost, fileNamePattern);
        patterns.add(Pattern.compile(imgWithAlphaNum));
        String imgDirect = String.format("(%s/img/%s)", optionalProtocolAndHost, fileNamePattern);
        patterns.add(Pattern.compile(imgDirect));
        String iWithDigits = String.format("(%s/i/\\d+/%s)", optionalProtocolAndHost, fileNamePattern);
        patterns.add(Pattern.compile(iWithDigits));
        String iWithDigitsNoThumbnails = String.format("(%s/i/\\d+/%s(?!_t\\.[A-Za-z]{3,4}))", optionalProtocolAndHost, fileNamePattern);
        patterns.add(Pattern.compile(iWithDigitsNoThumbnails));
        return patterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void controlMaxFreeDownloads(Account account, DownloadLink link, int num) {
        if (account == null) {
            AtomicInteger freeRunning;
            AtomicInteger atomicInteger = freeRunning = this.getFreeRunning();
            synchronized (atomicInteger) {
                int before = freeRunning.get();
                int after = before + num;
                freeRunning.set(after);
                this.logger.info("freeRunning(" + link.getName() + ")|max:" + this.getMaxSimultanFreeDownloadNum() + "|before:" + before + "|after:" + after + "|num:" + num);
            }
        }
    }

    protected void getPage(Browser br, String page, boolean correctBr) throws Exception {
        this.setCorrectBrowserFlag(br, correctBr);
        this.getPage(br, page);
    }

    @Override
    protected void sendRequest(Browser br, Request request) throws Exception {
        super.sendRequest(br, request);
        if (this.wasCorrectBrowserFlagSet(br)) {
            this.correctBR(br);
        }
    }

    protected void setCorrectBrowserFlag(Browser br, boolean flag) {
        WeakHashMap<Object, Boolean> map = this.correctBrowserMap.get();
        if (flag && map == null) {
            return;
        }
        if (map != null) {
            map.put(br, flag);
        } else if (!flag) {
            if (map == null) {
                map = new WeakHashMap();
                this.correctBrowserMap.set(map);
            }
            map.put(br, Boolean.FALSE);
        }
    }

    protected boolean wasCorrectBrowserFlagSet(Browser br) {
        WeakHashMap<Browser, Boolean> map = this.correctBrowserMap.get();
        return map == null || Boolean.TRUE.equals(map.remove(br));
    }

    protected void waitTime(DownloadLink link, long timeBefore) throws PluginException {
        String waitStr = this.regexWaittime(this.br);
        if (this.preDownloadWaittimeSkippable()) {
            this.logger.info("Skipping pre-download waittime: " + waitStr);
            return;
        }
        if (waitStr == null) {
            this.logger.info("Found no waittime");
            return;
        }
        if (!waitStr.matches("\\d+")) {
            this.logger.info("Got invalid wait time string: " + waitStr);
            return;
        }
        this.logger.info("Found waittime, parsing waittime: " + waitStr);
        int waitSeconds = Integer.parseInt(waitStr);
        this.waitTime(link, timeBefore, waitSeconds);
    }

    protected void waitTime(DownloadLink link, long timeBefore, int waitSeconds) throws PluginException {
        if (waitSeconds <= 0) {
            this.logger.info("Strange: Got 0 wait seconds");
            return;
        }
        int passedTime = (int)((Time.systemIndependentCurrentJVMTimeMillis() - timeBefore) / 1000L);
        waitSeconds -= passedTime;
        if (passedTime > 0) {
            this.logger.info("Total passed time during captcha: " + passedTime);
        }
        if (waitSeconds > 0) {
            this.logger.info("Waiting final waittime: " + waitSeconds);
            this.sleep((long)waitSeconds * 1000L, link);
        } else if (waitSeconds < waitSeconds) {
            this.logger.info("Congratulations: Time to solve captcha was higher than waittime --> No waittime left");
        } else {
            this.logger.info("Found no waittime");
        }
    }

    protected void fixFilenameHLSDownload(DownloadLink link) {
        String orgNameWithExt = link.getName();
        if (orgNameWithExt != null) {
            link.setFinalFileName(this.applyFilenameExtension(orgNameWithExt, ".mp4"));
        }
    }

    protected String getFileNameFromConnection(URLConnectionAdapter connection, DownloadLink link) {
        String fileName = XFileSharingProBasic.getFileNameFromDispositionHeader(connection);
        if (StringUtils.isEmpty((String)fileName)) {
            fileName = Plugin.getFileNameFromURL(connection.getURL());
            if ((fileName = URLEncode.decodeURIComponent((String)fileName)) != null && fileName.matches("(?i)video\\.(mp4|mkv)$")) {
                fileName = null;
            }
        }
        return fileName;
    }

    protected void fixFilename(URLConnectionAdapter connection, DownloadLink link) {
        String finalFileName;
        String servNameExt;
        String servName = null;
        String servExt = null;
        String orgNameExt = link.getName();
        String orgExt = !StringUtils.isEmpty((String)orgNameExt) && StringUtils.contains((String)orgNameExt, (String)".") ? orgNameExt.substring(orgNameExt.lastIndexOf(".")) : null;
        String orgName = !StringUtils.isEmpty(orgExt) ? new org.appwork.utils.Regex(orgNameExt, "^(.+)" + Pattern.quote(orgExt) + "$").getMatch(0) : orgNameExt;
        String string = servNameExt = connection != null ? this.getFileNameFromConnection(connection, link) : null;
        if (!StringUtils.isEmpty((String)servNameExt) && !StringUtils.contains((String)servNameExt, (String)".")) {
            String mimeExt;
            String string2 = mimeExt = connection != null ? this.getExtensionFromMimeType(connection) : null;
            if (mimeExt != null) {
                servNameExt = servNameExt + "." + mimeExt;
            }
        }
        if (!StringUtils.isEmpty((String)servNameExt) && StringUtils.contains((String)servNameExt, (String)".")) {
            servExt = servNameExt.substring(servNameExt.lastIndexOf("."));
            servName = new org.appwork.utils.Regex(servNameExt, "(.+)" + Pattern.quote(servExt)).getMatch(0);
        } else {
            servName = servNameExt;
        }
        if (StringUtils.equalsIgnoreCase((String)orgName, (String)this.getFUIDFromURL(link))) {
            finalFileName = servNameExt;
            this.logger.info("fixFileName case 1: prefer servNameExt: Use servNameExt");
        } else if (StringUtils.isEmpty((String)orgExt) && !StringUtils.isEmpty((String)servExt) && StringUtils.containsIgnoreCase((String)servName, (String)orgName) && !StringUtils.equalsIgnoreCase((String)servName, (String)orgName)) {
            finalFileName = servNameExt;
            this.logger.info("fixFileName case 2: prefer servNameExt: Use servNameExt");
        } else if (!StringUtils.isEmpty((String)servExt) && !StringUtils.equalsIgnoreCase((String)orgExt, (String)servExt)) {
            finalFileName = orgName + servExt;
            this.logger.info(String.format("fixFileName case 3: Use orgName + servExt | Old ext: %s | New ext: %s", orgExt, servExt));
        } else {
            finalFileName = orgNameExt;
            this.logger.info("fixFileName case 4: prefer orgNameExt");
        }
        this.logger.info("fixFileName: link=" + orgNameExt + "|server=" + servNameExt + "|final=" + finalFileName);
        link.setFinalFileName(finalFileName);
    }

    public String getFUIDFromURL(DownloadLink link) {
        URL_TYPE type = this.getURLType(link);
        return this.getFUID(link, type);
    }

    public String getFilenameFromURL(DownloadLink link) {
        try {
            String result = null;
            String url_name_RegEx = "/[a-z0-9]{12}/(.*?)(?:\\.html|\\?|$)";
            String contentURL = this.getPluginContentURL(link);
            if (contentURL != null) {
                result = new org.appwork.utils.Regex(new URL(contentURL).getPath(), "/[a-z0-9]{12}/(.*?)(?:\\.html|\\?|$)").getMatch(0);
            }
            if (result == null) {
                result = new org.appwork.utils.Regex(new URL(link.getPluginPatternMatcher()).getPath(), "/[a-z0-9]{12}/(.*?)(?:\\.html|\\?|$)").getMatch(0);
            }
            return result;
        }
        catch (MalformedURLException e) {
            this.logger.log((Throwable)e);
            return null;
        }
    }

    protected String getFallbackFilename(DownloadLink link, Browser br) {
        String filenameURL = this.getFilenameFromURL(link);
        if (filenameURL != null) {
            if (XFileSharingProBasic.getFileNameExtensionFromString(filenameURL = URLEncode.decodeURIComponent((String)filenameURL), null) == null) {
                if (this.internal_isVideohoster_enforce_video_filename(link, br)) {
                    return filenameURL + ".mp4";
                }
                if (this.isImagehoster()) {
                    return filenameURL + ".jpg";
                }
            }
            return filenameURL;
        }
        if (this.internal_isVideohoster_enforce_video_filename(link, br)) {
            return this.getFUIDFromURL(link) + ".mp4";
        }
        if (this.isImagehoster()) {
            return this.getFUIDFromURL(link) + ".jpg";
        }
        return this.getFUIDFromURL(link);
    }

    protected void handlePassword(Form form, DownloadLink link) throws PluginException {
        if (this.isPasswordProtectedHTML(this.br, form)) {
            link.setPasswordProtected(true);
            if (form == null) {
                throw new PluginException(0x400000);
            }
            this.logger.info("URL is password protected");
            String passCode = link.getDownloadPassword();
            if (passCode == null && StringUtils.isEmpty((String)(passCode = this.getUserInput("Password?", link)))) {
                this.logger.info("User has entered blank password, exiting handlePassword");
                link.setDownloadPassword(null);
                throw new PluginException(131072, "Pre-Download Password not provided");
            }
            this.logger.info("Put password \"" + passCode + "\" entered by user in the DLForm.");
            form.put("password", Encoding.urlEncode((String)passCode));
            link.setDownloadPassword(passCode);
        } else {
            link.setPasswordProtected(false);
        }
    }

    protected void checkErrors(Browser br, String html, DownloadLink link, Account account) throws NumberFormatException, PluginException {
        if (new org.appwork.utils.Regex(html, "(?i)>\\s*Wrong password").patternFind()) {
            if (link.isPasswordProtected()) {
                String userEnteredPassword = link.getDownloadPassword();
                this.logger.warning("Wrong password, the entered password \"" + userEnteredPassword + "\" is wrong, retrying...");
                link.setDownloadPassword(null);
                throw new PluginException(4, "Wrong password entered");
            }
            throw new PluginException(2048, "Got error 'wrong password' but website never prompted for one");
        }
        if (new org.appwork.utils.Regex(html, "(?i)>\\s*Wrong captcha").patternFind()) {
            this.logger.warning("Wrong captcha (or wrong password as well)!");
            if (this.getChallengeRound() >= 1) {
                throw new PluginException(8);
            }
            throw new PluginException(2048, "Server says 'wrong captcha' but never prompted for one");
        }
        if (new org.appwork.utils.Regex(html, "(?i)>\\s*Skipped countdown\\s*<").patternFind()) {
            throw new PluginException(131072, "Fatal countdown error (countdown skipped)");
        }
        String limitBasedOnNumberofFilesAndTime = new org.appwork.utils.Regex(html, "(?i)>\\s*(You have reached the maximum limit \\d+ files in \\d+ hours)").getMatch(0);
        String preciseWaittime = new org.appwork.utils.Regex(html, "(?i)((You have reached the download(\\-| )limit|You have to wait)[^<>]+)").getMatch(0);
        if (preciseWaittime != null) {
            int waittime;
            String tmphrs = new org.appwork.utils.Regex(preciseWaittime, "(?i)\\s*(\\d+)\\s*hours?").getMatch(0);
            String tmpmin = new org.appwork.utils.Regex(preciseWaittime, "(?i)\\s*(\\d+)\\s*minutes?").getMatch(0);
            String tmpsec = new org.appwork.utils.Regex(preciseWaittime, "(?i)\\s*(\\d+)\\s*seconds?").getMatch(0);
            String tmpdays = new org.appwork.utils.Regex(preciseWaittime, "(?i)\\s*(\\d+)\\s*days?").getMatch(0);
            if (tmphrs == null && tmpmin == null && tmpsec == null && tmpdays == null) {
                this.logger.info("Waittime RegExes seem to be broken - using default waittime");
                waittime = 3600000;
            } else {
                int minutes = 0;
                int seconds = 0;
                int hours = 0;
                int days = 0;
                if (tmphrs != null) {
                    hours = Integer.parseInt(tmphrs);
                }
                if (tmpmin != null) {
                    minutes = Integer.parseInt(tmpmin);
                }
                if (tmpsec != null) {
                    seconds = Integer.parseInt(tmpsec);
                }
                if (tmpdays != null) {
                    days = Integer.parseInt(tmpdays);
                }
                waittime = (days * 24 * 3600 + 3600 * hours + 60 * minutes + seconds + 1) * 1000;
            }
            this.logger.info("Detected reconnect waittime (milliseconds): " + waittime);
            String errMsg = "Download limit reached or wait until next download can be started";
            if (account != null) {
                throw new AccountUnavailableException("Download limit reached or wait until next download can be started", (long)waittime);
            }
            throw new PluginException(16, "Download limit reached or wait until next download can be started", waittime);
        }
        if (limitBasedOnNumberofFilesAndTime != null) {
            this.ipBlockedOrAccountLimit(link, account, limitBasedOnNumberofFilesAndTime, 900000L);
        } else if (StringUtils.containsIgnoreCase((String)html, (String)"You're using all download slots for IP")) {
            this.ipBlockedOrAccountLimit(link, account, "You're using all download slots for IP...", 300000L);
        } else if (StringUtils.containsIgnoreCase((String)html, (String)"Error happened when generating Download Link")) {
            throw new PluginException(2048, "Server error 'Error happened when generating Download Link'", 600000L);
        }
        String premiumOnlyMessage = this.getPremiumOnlyErrorMessage(br);
        if (premiumOnlyMessage != null) {
            throw new AccountRequiredException(premiumOnlyMessage);
        }
        if (this.isPremiumOnly(br)) {
            throw new AccountRequiredException();
        }
        if (new org.appwork.utils.Regex(html, "(?i)>\\s*Expired download session").patternFind()) {
            throw new PluginException(2048, "Server error 'Expired download session'", 600000L);
        }
        if (this.isServerUnderMaintenance(br)) {
            throw new PluginException(2048, "Server is under maintenance", 1800000L);
        }
        if (new org.appwork.utils.Regex(html, "(?i)>\\s*Video is processing now").patternFind()) {
            throw new PluginException(2048, "Not (yet) downloadable: Video is still being encoded or broken", 600000L);
        }
        if (br.containsHTML(">\\s*Downloads disabled for this file")) {
            throw new PluginException(131072, "Uploader has disabled downloads for this file");
        }
        if (br.containsHTML(">\\s*Downloads are disabled for your country")) {
            throw new PluginException(131072, "Downloads are disabled for your country", 3600000L);
        }
        if (br.containsHTML(">\\s*File was locked by administrator")) {
            throw new PluginException(131072, "File was locked by administrator");
        }
        if (new org.appwork.utils.Regex(html, ">\\s*Couldn't generate direct link").patternFind()) {
            throw new PluginException(2048, "Couldn't generate direct link");
        }
        if (account != null && (StringUtils.containsIgnoreCase((String)br.getURL(), (String)"op=my_account") || StringUtils.containsIgnoreCase((String)br.getRedirectLocation(), (String)"op=my_account"))) {
            String accountErrorMsg = "de".equalsIgnoreCase(System.getProperty("user.language")) ? String.format("Erg\u00e4nze deine E-Mail Adresse unter %s/?op=my_account um diesen Account verwenden zu k\u00f6nnen!", this.getHost()) : String.format("Go to %s/?op=my_account and enter your e-mail in order to be able to use this account!", this.getHost());
            throw new AccountUnavailableException(accountErrorMsg, 600000L);
        }
        this.checkResponseCodeErrors(br.getHttpConnection());
    }

    protected void checkErrorsLoginWebsite(Browser br, Account account) throws Exception {
    }

    private void ipBlockedOrAccountLimit(DownloadLink link, Account account, String errorMsg, long waitMillis) throws PluginException {
        if (account != null) {
            throw new AccountUnavailableException(errorMsg, waitMillis);
        }
        throw new PluginException(16, errorMsg, waitMillis);
    }

    protected void checkErrorsLastResort(Browser br, DownloadLink link, Account account) throws PluginException {
        this.logger.info("Last resort errorhandling");
        boolean isHTML = br.isHtml();
        if (account != null && br.getHttpConnection().getResponseCode() == 200 && isHTML && !this.isLoggedin(br)) {
            throw new AccountUnavailableException("Session expired?", 300000L);
        }
        long waitMillis = 300000L;
        String website_error = br.getRegex("class=\"[^\"]*(?:err|alert-danger)[^\"]*\"[^>]*>([^<]+)<").getMatch(0);
        if (!StringUtils.isEmpty((String)website_error)) {
            website_error = Encoding.htmlDecode((String)website_error).trim();
            this.logger.info("Found website error: " + website_error);
            if (link == null) {
                throw new AccountUnavailableException(website_error, 300000L);
            }
            throw new PluginException(131072, website_error);
        }
        String website_error_videoplayer = br.getRegex("id=\"over_player_msg\"[^>]*?>([^<>\"]+)<").getMatch(0);
        if (website_error_videoplayer != null) {
            website_error = Encoding.htmlDecode((String)website_error_videoplayer).trim();
            this.logger.info("Found website videoplayer error: " + website_error_videoplayer);
            throw new PluginException(131072, website_error_videoplayer);
        }
        if (StringUtils.isEmpty((String)br.getRequest().getHtmlCode())) {
            String errormessage = "Got blank page";
            if (link == null) {
                throw new AccountUnavailableException("Got blank page", 300000L);
            }
            throw new PluginException(131072, "Got blank page");
        }
        if (br.getRequest().getHtmlCode().length() <= 100 && !isHTML) {
            String plaintextError = br.getRequest().getHtmlCode().trim();
            if (link == null) {
                throw new AccountUnavailableException(plaintextError, 300000L);
            }
            throw new PluginException(131072, plaintextError);
        }
        this.logger.warning("Unknown error happened");
        throw new PluginException(0x400000);
    }

    public void checkResponseCodeErrors(URLConnectionAdapter con) throws PluginException {
        if (con == null) {
            return;
        }
        long responsecode = con.getResponseCode();
        if (responsecode == 403L) {
            throw new PluginException(2048, "Server error 403", 300000L);
        }
        if (responsecode == 404L) {
            throw new PluginException(2048, "Server error 404", 300000L);
        }
        if (responsecode == 416L) {
            throw new PluginException(2048, "Server error 416", 300000L);
        }
        if (responsecode == 500L) {
            throw new PluginException(2048, "Server error 500", 300000L);
        }
        if (responsecode == 503L) {
            this.exception503ConnectionLimitReached();
        }
    }

    private void exception503ConnectionLimitReached() throws PluginException {
        throw new PluginException(4096, "Server error 503 connection limit reached", 900000L);
    }

    public void checkServerErrors(Browser br, DownloadLink link, Account account) throws PluginException {
        String html = this.getCorrectBR(br);
        if (new org.appwork.utils.Regex(html, "^(No file|error_nofile|Not Found)$").patternFind()) {
            throw new PluginException(2048, "Server error 'No file'", 1800000L);
        }
        if (new org.appwork.utils.Regex(html, "^Wrong IP$").patternFind()) {
            throw new PluginException(2048, "Server error: 'Wrong IP'", 0x6DDD00L);
        }
        if (new org.appwork.utils.Regex(html, "^Expired$").patternFind()) {
            throw new PluginException(2048, "Server error: 'Expired'", 0x6DDD00L);
        }
        if (new org.appwork.utils.Regex(html, "(^File Not Found$|<h1>404 Not Found</h1>)").patternFind()) {
            throw new PluginException(2048, "Server error 404", 1800000L);
        }
    }

    protected boolean supports_lifetime_account() {
        return false;
    }

    @Deprecated
    protected boolean is_lifetime_account(Browser br) {
        return br.getRegex("(?i)>\\s*Premium\\s*(Pro)?\\s*account expire\\s*</TD>\\s*<TD>\\s*<b>\\s*Lifetime\\s*</b>").matches();
    }

    @Override
    public AccountInfo fetchAccountInfo(Account account) throws Exception {
        if (this.enableAccountApiOnlyMode()) {
            return this.fetchAccountInfoAPI(this.br, account);
        }
        return this.fetchAccountInfoWebsite(account);
    }

    protected void fetchAccountInfoWebsiteStorage(Browser br, Account account, AccountInfo ai) throws Exception {
        String[] space = new org.appwork.utils.Regex(this.getCorrectBR(br), ">\\s*Used space:\\s*</td>.*?<td.*?b>([0-9\\.]+) ?(KB|MB|GB|TB)?</b>").getRow(0);
        if (space != null && space.length != 0 && space[0] != null && space[1] != null) {
            ai.setUsedSpace(space[0] + " " + space[1]);
        } else if (space != null && space.length != 0 && space[0] != null) {
            ai.setUsedSpace(space[0] + "Mb");
        }
    }

    protected void fetchAccountInfoWebsiteTraffic(Browser br, Account account, AccountInfo ai) throws Exception {
        String usableBandwidth;
        boolean userHasUnlimitedTraffic;
        String trafficLeftStr = this.regExTrafficLeft(br);
        boolean bl = userHasUnlimitedTraffic = trafficLeftStr != null && trafficLeftStr.matches(".*?(nlimited|Ilimitado).*?");
        if (trafficLeftStr == null || userHasUnlimitedTraffic || trafficLeftStr.equalsIgnoreCase("Mb")) {
            ai.setUnlimitedTraffic();
            return;
        }
        trafficLeftStr = Encoding.htmlDecode((String)trafficLeftStr).trim();
        long trafficLeft = 0L;
        if (!trafficLeftStr.startsWith("-")) {
            trafficLeft = SizeFormatter.getSize((String)trafficLeftStr);
        }
        if ((usableBandwidth = br.getRegex("Usable Bandwidth\\s*<span[^>]*>\\s*([0-9\\.]+\\s*[TGMKB]+)\\s*/\\s*[0-9\\.]+\\s*[TGMKB]+\\s*<").getMatch(0)) != null) {
            trafficLeft = Math.max(trafficLeft, SizeFormatter.getSize((String)usableBandwidth));
        }
        ai.setTrafficLeft(trafficLeft);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AccountInfo fetchAccountInfoWebsite(Account account) throws Exception {
        Account.AccountType apiAccountType;
        AccountInfo ai;
        block32: {
            this.loginWebsite(null, account, true);
            if (this.br.getURL() == null || !this.br.getURL().contains(this.getRelativeAccountInfoURL())) {
                this.getPage(this.getMainPage() + this.getRelativeAccountInfoURL());
            }
            ai = new AccountInfo();
            apiAccountType = null;
            String apikey = this.findAPIKey(this.br.cloneBrowser());
            if (apikey == null) {
                this.logger.info("No apikey found");
            } else {
                this.logger.info("Found apikey --> Trying to get AccountInfo via account API: " + apikey);
                Account account2 = account;
                synchronized (account2) {
                    account.setProperty(PROPERTY_ACCOUNT_apikey, apikey);
                    if (Boolean.FALSE.equals(this.trustAccountInfoAPI(account))) {
                        this.logger.info("--> Not trying to get AccountInfo via untrusted account API");
                        break block32;
                    }
                    try {
                        ai = this.fetchAccountInfoAPI(this.br.cloneBrowser(), account);
                        apiAccountType = account.getType();
                        this.logger.info("Found AccountInfo via API but trying to obtain trafficleft value from website as it is usually not given via API");
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        this.logger.warning("Failed to find accountinfo via API even though apikey is given; probably serverside API failure --> Fallback to website handling");
                        account.removeProperty(PROPERTY_ACCOUNT_apikey);
                    }
                }
            }
        }
        this.fetchAccountInfoWebsiteTraffic(this.br, account, ai);
        if (apiAccountType != null && Boolean.TRUE.equals(this.trustAccountInfoAPI(account))) {
            this.logger.info("Successfully found AccountInfo without trafficleft via API (fetched trafficleft via website)");
            if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                String statusText = ai.getStatus() != null && !StringUtils.startsWithCaseInsensitive((String)ai.getStatus(), (String)"[API] ") ? ai.getStatus() : account.getType().toString();
                ai.setStatus("[API] | DLs: " + account.hasProperty(PROPERTY_ACCOUNT_ALLOW_API_DOWNLOAD_ATTEMPT_IN_WEBSITE_MODE) + " | " + statusText);
            }
            return ai;
        }
        this.fetchAccountInfoWebsiteStorage(this.br, account, ai);
        if (this.supports_lifetime_account() && this.is_lifetime_account(this.br)) {
            ai.setValidUntil(-1L);
            this.setAccountLimitsByType(account, Account.AccountType.LIFETIME);
        } else {
            Long expire_milliseconds = this.fetchAccountInfoWebsiteExpireDate(this.br, account, ai);
            if (expire_milliseconds == null) {
                this.logger.info("Account is a FREE account as no expiredate has been found");
                ai.setValidUntil(-1L);
                this.setAccountLimitsByType(account, Account.AccountType.FREE);
            } else if (expire_milliseconds < 0L) {
                this.logger.info("Premium expired --> Free account");
                ai.setValidUntil(-1L);
                this.setAccountLimitsByType(account, Account.AccountType.FREE);
            } else if (expire_milliseconds == Long.MAX_VALUE) {
                this.logger.info("Lifetime Premium account");
                ai.setValidUntil(-1L);
                this.setAccountLimitsByType(account, Account.AccountType.LIFETIME);
            } else {
                long apiValidUntil = ai.getValidUntil();
                if (apiValidUntil >= expire_milliseconds && apiValidUntil <= expire_milliseconds + TimeUnit.DAYS.toMillis(1L)) {
                    ai.setValidUntil(apiValidUntil);
                } else if (apiValidUntil <= expire_milliseconds && apiValidUntil >= expire_milliseconds - TimeUnit.DAYS.toMillis(1L)) {
                    ai.setValidUntil(apiValidUntil);
                } else {
                    ai.setValidUntil(expire_milliseconds);
                }
                this.logger.info("Premium account");
                this.setAccountLimitsByType(account, Account.AccountType.PREMIUM);
            }
        }
        if (apiAccountType != null) {
            WeakHashMap<Account, Boolean> weakHashMap = TRUST_ACCOUNT_API;
            synchronized (weakHashMap) {
                if (!Account.AccountType.FREE.equals((Object)apiAccountType) && !Account.AccountType.FREE.equals((Object)account.getType())) {
                    this.logger.info("Trust AccountInfo via account API!");
                    TRUST_ACCOUNT_API.put(account, Boolean.TRUE);
                } else if (Account.AccountType.FREE.equals((Object)apiAccountType) && !Account.AccountType.FREE.equals((Object)account.getType())) {
                    this.logger.info("Don't trust AccountInfo via account API!");
                    TRUST_ACCOUNT_API.put(account, Boolean.FALSE);
                } else if (Account.AccountType.FREE.equals((Object)apiAccountType) && Account.AccountType.FREE.equals((Object)account.getType())) {
                    TRUST_ACCOUNT_API.remove(account);
                }
            }
        }
        return ai;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean trustAccountInfoAPI(Account account) {
        WeakHashMap<Account, Boolean> weakHashMap = TRUST_ACCOUNT_API;
        synchronized (weakHashMap) {
            return TRUST_ACCOUNT_API.get(account);
        }
    }

    protected Long fetchAccountInfoWebsiteExpireDate(Browser br, Account account, AccountInfo ai) throws Exception {
        long expire_milliseconds;
        AtomicBoolean isPreciseTimestampFlag = new AtomicBoolean(false);
        Long expire_milliseconds_from_expiredate = this.findExpireTimestamp(account, br, isPreciseTimestampFlag);
        String[] supports_precise_expire_date = isPreciseTimestampFlag.get() && expire_milliseconds_from_expiredate != null ? null : this.supportsPreciseExpireDate();
        long expire_milliseconds_precise_to_the_second = -1L;
        if (supports_precise_expire_date != null && supports_precise_expire_date.length != 0) {
            LinkedHashSet<String> paymentURLs = new LinkedHashSet<String>();
            String last_working_payment_url = this.getPluginConfig().getStringProperty(PROPERTY_PLUGIN_LAST_WORKING_PAYMENT_URL);
            if (StringUtils.isNotEmpty((String)last_working_payment_url)) {
                this.logger.info("Found stored last_working_payment_url --> Trying this first in an attempt to save http requests: " + last_working_payment_url);
                paymentURLs.add(last_working_payment_url);
            } else {
                this.logger.info("last_working_payment_url is not available --> Going through all possible paymentURLs in default order");
            }
            for (String paymentURL : supports_precise_expire_date) {
                paymentURLs.add(paymentURL);
            }
            int i = -1;
            for (String paymentURL : paymentURLs) {
                ++i;
                if (StringUtils.isEmpty((String)paymentURL)) continue;
                try {
                    this.getPage(paymentURL);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (i == paymentURLs.size() - 1) {
                        throw e;
                    }
                    this.logger.log((Throwable)e);
                    continue;
                }
                String expireSecond = this.findExpireDate(br);
                if (StringUtils.isEmpty((String)expireSecond)) continue;
                String tmpYears = new org.appwork.utils.Regex(expireSecond, "(\\d+)\\s+years?").getMatch(0);
                String tmpdays = new org.appwork.utils.Regex(expireSecond, "(\\d+)\\s+days?").getMatch(0);
                String tmphrs = new org.appwork.utils.Regex(expireSecond, "(\\d+)\\s+hours?").getMatch(0);
                String tmpmin = new org.appwork.utils.Regex(expireSecond, "(\\d+)\\s+minutes?").getMatch(0);
                String tmpsec = new org.appwork.utils.Regex(expireSecond, "(\\d+)\\s+seconds?").getMatch(0);
                long years = 0L;
                long days = 0L;
                long hours = 0L;
                long minutes = 0L;
                long seconds = 0L;
                if (!StringUtils.isEmpty((String)tmpYears)) {
                    years = Integer.parseInt(tmpYears);
                }
                if (!StringUtils.isEmpty((String)tmpdays)) {
                    days = Integer.parseInt(tmpdays);
                }
                if (!StringUtils.isEmpty((String)tmphrs)) {
                    hours = Integer.parseInt(tmphrs);
                }
                if (!StringUtils.isEmpty((String)tmpmin)) {
                    minutes = Integer.parseInt(tmpmin);
                }
                if (!StringUtils.isEmpty((String)tmpsec)) {
                    seconds = Integer.parseInt(tmpsec);
                }
                if ((expire_milliseconds_precise_to_the_second = years * 86400000L * 365L + days * 86400000L + hours * 3600000L + minutes * 60000L + seconds * 1000L) <= 0L) {
                    this.logger.info("Failed to find precise expire-date via paymentURL: \"" + paymentURL + "\"");
                    continue;
                }
                this.logger.info("Successfully found precise expire-date via paymentURL: \"" + paymentURL + "\" : " + expireSecond);
                this.getPluginConfig().setProperty(PROPERTY_PLUGIN_LAST_WORKING_PAYMENT_URL, paymentURL);
                break;
            }
        }
        long currentTime = br.getCurrentServerTime(System.currentTimeMillis());
        if (expire_milliseconds_precise_to_the_second > 0L) {
            expire_milliseconds_precise_to_the_second += currentTime;
        }
        if (isPreciseTimestampFlag.get() && expire_milliseconds_from_expiredate != null) {
            this.logger.info("Using precise expire-date");
            expire_milliseconds = expire_milliseconds_from_expiredate;
        } else if (expire_milliseconds_precise_to_the_second > 0L) {
            this.logger.info("Using precise expire-date");
            expire_milliseconds = expire_milliseconds_precise_to_the_second;
        } else if (expire_milliseconds_from_expiredate != null) {
            this.logger.info("Using expire-date which is up to 24 hours precise");
            expire_milliseconds = expire_milliseconds_from_expiredate;
        } else {
            this.logger.info("Failed to find any useful expire-date at all");
            expire_milliseconds = -1L;
        }
        if (expire_milliseconds < 0L || expire_milliseconds - currentTime <= 0L) {
            if (expire_milliseconds > 0L) {
                return -expire_milliseconds;
            }
            return null;
        }
        return expire_milliseconds;
    }

    protected Long findExpireTimestamp(Account account, Browser br, AtomicBoolean isPreciseTimestampFlag) throws Exception {
        long ret;
        String expireStr = new org.appwork.utils.Regex(this.getCorrectBR(br), "(\\d{1,2} (January|February|March|April|May|June|July|August|September|October|November|December) \\d{4})").getMatch(0);
        if (expireStr != null) {
            expireStr = expireStr + " 23:59:59";
            return TimeFormatter.getMilliSeconds((String)expireStr, (String)"dd MMMM yyyy HH:mm:ss", (Locale)Locale.ENGLISH);
        }
        expireStr = new org.appwork.utils.Regex(this.getCorrectBR(br), "(?:>\\s*|<span[^>]*)Premium\\s*(?:account expire|until|expiration):?\\s*</(?:span|td)>\\s*[^>]*>([\\d]+-[\\w{2}]+-[\\d]+\\s[\\d:]+)</").getMatch(0);
        if (expireStr != null && (ret = TimeFormatter.getMilliSeconds((String)expireStr, (String)"yyyy-MM-dd HH:mm:ss", (Locale)Locale.ENGLISH)) > 0L) {
            isPreciseTimestampFlag.set(true);
            return ret;
        }
        return -1L;
    }

    protected String findExpireDate(Browser br) throws Exception {
        String expireSecond;
        boolean allHTML = false;
        String preciseExpireHTML = new org.appwork.utils.Regex(this.getCorrectBR(br), "<div[^>]*class=\"[^\"]*accexpire[^\"]*\"[^>]*>.*?</div>").getMatch(-1);
        if (preciseExpireHTML == null) {
            preciseExpireHTML = new org.appwork.utils.Regex(this.getCorrectBR(br), "<div[^>]*class=((?!</div>).)*expires_in((?!</div>).)*>.*?</div>").getMatch(-1);
        }
        if (preciseExpireHTML == null) {
            allHTML = true;
            preciseExpireHTML = this.getCorrectBR(br);
        }
        if (StringUtils.isEmpty((String)(expireSecond = new org.appwork.utils.Regex(preciseExpireHTML, "(?:Premium(-| )Account expires?(?: in)?|Twoje premium wyga\u015bnie za)\\s*:\\s*(?:</span>)?\\s*(?:</span>)?\\s*(?:<span>)?\\s*([a-zA-Z0-9, ]+)\\s*</").getMatch(-1)))) {
            expireSecond = new org.appwork.utils.Regex(preciseExpireHTML, Pattern.compile(">\\s*Your premium expires?\\s*:\\s*(\\d+ years?, )?(\\d+ days?, )?(\\d+ hours?, )?(\\d+ minutes?, )?\\d+ seconds\\s*<", 2)).getMatch(-1);
        }
        if (StringUtils.isEmpty((String)expireSecond)) {
            expireSecond = new org.appwork.utils.Regex(preciseExpireHTML, Pattern.compile(">\\s*Premium Account expires in\\s*(\\d+ years?,?\\s*)?(\\d+ days?,?\\s*)?(\\d+ hours?,?\\s*)?(\\d+ minutes?,?\\s*)?(\\d+ seconds)?\\s*<", 2)).getMatch(-1);
        }
        if (StringUtils.isEmpty((String)expireSecond) && !allHTML) {
            expireSecond = new org.appwork.utils.Regex(preciseExpireHTML, Pattern.compile(">\\s*(\\d+ years?, )?(\\d+ days?, )?(\\d+ hours?, )?(\\d+ minutes?, )?\\d+ seconds\\s*<", 2)).getMatch(-1);
        }
        if (StringUtils.isEmpty((String)expireSecond) && !StringUtils.isEmpty((String)preciseExpireHTML)) {
            this.logger.info("html contains 'accexpire' class but we failed to find a precise expiredate --> Either we have a free account or failed to find precise expiredate although it is given");
        }
        return expireSecond;
    }

    protected String findAPIKey(Browser brc) {
        String generateApikeyUrl;
        String apikey = this.regexAPIKey(brc);
        if (StringUtils.isEmpty((String)apikey) && this.allowToGenerateAPIKeyInWebsiteMode() && (generateApikeyUrl = this.regexGenerateAPIKeyURL(brc)) != null) {
            generateApikeyUrl = Encoding.htmlOnlyDecode((String)generateApikeyUrl);
            this.logger.info("Failed to find apikey but host has api-mod enabled --> Trying to generate first apikey for this account via: " + generateApikeyUrl);
            try {
                this.getPage(brc, generateApikeyUrl);
                apikey = this.regexAPIKey(brc);
                if (apikey == null) {
                    throw new PluginException(0x400000, "Failed to find generated apikey - possible plugin failure");
                }
                this.logger.info("Successfully found newly generated apikey: " + apikey);
            }
            catch (Throwable e) {
                this.logger.exception("Exception occured during accessing generateApikeyUrl", e);
            }
        }
        if (apikey != null) {
            this.findAPIHost(brc, apikey);
        }
        return apikey;
    }

    protected void findAPIHost(Browser brc, String apikey) {
        if (apikey == null) {
            return;
        }
        this.logger.info("Found apikey! Trying to find api domain with protocol");
        String url_with_apikey = brc.getRegex("(https?://[^/]+/api/account/info[^<>\"\\']*key=" + apikey + "[^<>\"\\']*)").getMatch(0);
        boolean api_uses_special_domain = false;
        if (url_with_apikey == null) {
            this.logger.info("Unable to find API domain - assuming it is the same as this plugins' domain");
        } else {
            try {
                url_with_apikey = Encoding.htmlOnlyDecode((String)url_with_apikey);
                URL apiurl = new URL(url_with_apikey);
                String apihost = Browser.getHost((URL)apiurl, (boolean)true);
                if (!apihost.equalsIgnoreCase(this.getHost())) {
                    this.logger.info(String.format("API domain is %s while main domain of plugin is %s", apihost, this.getHost()));
                    api_uses_special_domain = true;
                    String test = apiurl.getProtocol() + "://" + apiurl.getHost() + "/api";
                    this.getPluginConfig().setProperty(PROPERTY_PLUGIN_api_domain_with_protocol, test);
                } else {
                    this.logger.info("API domain and main domain are the same: " + this.getHost());
                }
            }
            catch (Throwable e) {
                this.logger.exception("Error while trying to find API domain", e);
            }
        }
        if (!api_uses_special_domain) {
            this.getPluginConfig().removeProperty(PROPERTY_PLUGIN_api_domain_with_protocol);
        }
    }

    protected String regexAPIKey(Browser br) {
        String[][] rets;
        String ret = br.getRegex("/api/account/info\\?key=([a-z0-9]+)").getMatch(0);
        if (ret == null && (rets = br.getRegex("<input[^>]*value\\s*=\\s*\"([a-z0-9]{16,})\"[^>]readonly").getMatches()).length == 1 && rets[0].length == 1) {
            ret = rets[0][0];
        }
        return ret;
    }

    protected String regexGenerateAPIKeyURL(Browser br) {
        return br.getRegex("\"([^\"]*?generate_api_key=1[^\"]*?token=[a-f0-9]{32}[^\"]*?)\"").getMatch(0);
    }

    protected void setAccountLimitsByType(Account account, Account.AccountType type) {
        account.setType(type);
        switch (type) {
            case LIFETIME: 
            case PREMIUM: {
                account.setConcurrentUsePossible(true);
                account.setMaxSimultanDownloads(this.getMaxSimultanPremiumDownloadNum());
                break;
            }
            case FREE: {
                account.setConcurrentUsePossible(false);
                account.setMaxSimultanDownloads(this.getMaxSimultaneousFreeAccountDownloads());
                break;
            }
            default: {
                account.setConcurrentUsePossible(false);
                account.setMaxSimultanDownloads(1);
            }
        }
    }

    public Form findLoginform(Browser br) {
        Form loginform = br.getFormbyProperty("name", "FL");
        if (loginform == null) {
            Form[] allForms;
            for (Form aForm : allForms = br.getForms()) {
                InputField inputFieldOP = aForm.getInputFieldByName("op");
                if (inputFieldOP == null || !"login".equalsIgnoreCase(inputFieldOP.getValue())) continue;
                loginform = aForm;
                break;
            }
        }
        if (loginform == null) {
            return null;
        }
        InputField redirect = loginform.getInputFieldByName("redirect");
        if (redirect != null && StringUtils.isNotEmpty((String)redirect.getValue())) {
            try {
                String value = URLDecoder.decode(redirect.getValue(), "UTF-8");
                if (value != null && this.canHandle(value)) {
                    this.logger.info("clear login redirect to download:" + value);
                    redirect.setValue("");
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
        }
        return loginform;
    }

    public Form findImageForm(Browser br) {
        Form imghost_next_form = br.getFormbyKey("next");
        if (imghost_next_form != null && imghost_next_form.hasInputFieldByName("method_premium")) {
            imghost_next_form.remove("method_premium");
        }
        return imghost_next_form;
    }

    protected String regExTrafficLeft(Browser br) {
        String src = this.getCorrectBR(br);
        String availabletraffic = new org.appwork.utils.Regex(src, "Traffic available(?:\\s*today)?\\s*[^<>]*:?(?:<[^>]*>)?</TD>\\s*<TD[^>]*>\\s*<div[^>]*title\\s*=\\s*\"\\s*([^<>\"']+)\\s*available").getMatch(0);
        if (StringUtils.isEmpty((String)availabletraffic)) {
            availabletraffic = new org.appwork.utils.Regex(src, "Traffic available(?:\\s*today)?\\s*[^<>]*:?(?:<[^>]*>)?</TD>\\s*<TD[^>]*>\\s*(?:<b[^>]*>)?\\s*([^<>\"']+)").getMatch(0);
            if (StringUtils.isEmpty((String)availabletraffic)) {
                availabletraffic = new org.appwork.utils.Regex(src, ">\\s*Traffic available(?:\\s*today)?\\s*</div>\\s*<div class=\"txt\\d+\">\\s*([^<>\"]+)\\s*<").getMatch(0);
            }
            if (StringUtils.isEmpty((String)availabletraffic)) {
                String trafficLeft = new org.appwork.utils.Regex(src, ">\\s*Traffic available(?:\\s*today)?\\s*</[^>]*>\\s*<div class=\"(?:txt\\d+|price)\">\\s*(.*?)\\s*</div").getMatch(0);
                String unit = new org.appwork.utils.Regex(trafficLeft, "<sup>\\s*([TGMKB]+)\\s*</sup>").getMatch(0);
                String left = new org.appwork.utils.Regex(trafficLeft, "</sup>\\s*([\\-\\s*]*[0-9\\.]+)").getMatch(0);
                if (unit != null && left != null) {
                    availabletraffic = left + " " + unit;
                }
            }
        }
        if (StringUtils.isEmpty((String)availabletraffic)) {
            String formGroup = new org.appwork.utils.Regex(src, ">\\s*Traffic available(?:\\s*today)?\\s*:?\\s*</[^>]*>(.*?)<div\\s*class\\s*=\\s*\"form-group").getMatch(0);
            String[] trafficDetails = new org.appwork.utils.Regex(formGroup, "title\\s*=\\s*\"\\s*([0-9\\.]+\\s*[TGMB]+\\s*)/\\s*([0-9\\.]+\\s*[TGMB]+\\s*)\"").getRow(0);
            if (trafficDetails != null) {
                long used = SizeFormatter.getSize((String)trafficDetails[0]);
                long max = SizeFormatter.getSize((String)trafficDetails[1]);
                if (used > 0L && max > 0L) {
                    return max - used + "b";
                }
            }
            availabletraffic = new org.appwork.utils.Regex(formGroup, "title\\s*=\\s*\"\\s*([\\-\\s*]*[0-9\\.]+\\s*[TGMB]+\\s*)(?:available)?\"").getMatch(0);
        }
        if (StringUtils.isNotEmpty((String)availabletraffic)) {
            return availabletraffic;
        }
        return null;
    }

    public boolean isLoggedin(Browser brc) {
        boolean ret;
        String mainpage = this.getMainPage(brc);
        this.logger.info("Doing login-cookiecheck for: " + mainpage);
        String cookieXFSS = brc.getCookie(mainpage, "xfss", Cookies.NOTDELETEDPATTERN);
        String cookieXFSTS = brc.getCookie(mainpage, "xfsts", Cookies.NOTDELETEDPATTERN);
        boolean login_xfss_CookieOkay = StringUtils.isAllNotEmpty((String[])new String[]{brc.getCookie(mainpage, "login", Cookies.NOTDELETEDPATTERN), cookieXFSS});
        boolean login_xfsts_CookieOkay = StringUtils.isAllNotEmpty((String[])new String[]{brc.getCookie(mainpage, "login", Cookies.NOTDELETEDPATTERN), cookieXFSTS});
        boolean email_xfss_CookieOkay = StringUtils.isAllNotEmpty((String[])new String[]{brc.getCookie(mainpage, "email", Cookies.NOTDELETEDPATTERN), cookieXFSS});
        boolean email_xfsts_CookieOkay = StringUtils.isAllNotEmpty((String[])new String[]{brc.getCookie(mainpage, "email", Cookies.NOTDELETEDPATTERN), cookieXFSTS});
        String htmlWithoutScriptTagsAndComments = brc.getRequest() == null || brc.getRequest().getHtmlCode() == null ? "" : brc.getRequest().getHtmlCode().replaceAll("(?s)(<script.*?</script>)", "").replaceAll("(?s)(<!--.*?-->)", "");
        String ahrefPattern = "<a[^<]*href\\s*=\\s*\"[^\"]*";
        boolean logout = new org.appwork.utils.Regex(htmlWithoutScriptTagsAndComments, "<a[^<]*href\\s*=\\s*\"[^\"]*(&|\\?)op=logout").matches() || new org.appwork.utils.Regex(htmlWithoutScriptTagsAndComments, "<a[^<]*href\\s*=\\s*\"[^\"]*/(user_)?logout/?\"").matches() || new org.appwork.utils.Regex(htmlWithoutScriptTagsAndComments, "<a[^<]*href\\s*=\\s*\"[^\"]*/logout\\.html\"").matches();
        boolean login = new org.appwork.utils.Regex(htmlWithoutScriptTagsAndComments, "<a[^<]*href\\s*=\\s*\"[^\"]*(&|\\?)op=login").matches() || new org.appwork.utils.Regex(htmlWithoutScriptTagsAndComments, "<a[^<]*href\\s*=\\s*\"[^\"]*/(user_)?login/?\"").matches() || new org.appwork.utils.Regex(htmlWithoutScriptTagsAndComments, "<a[^<]*href\\s*=\\s*\"[^\"]*/login\\.html\"").matches();
        boolean loginURLFailed = brc.getURL().contains("op=") && brc.getURL().contains("op=login");
        boolean isRedirect = brc.getRedirectLocation() != null;
        boolean myAccountOkay = new org.appwork.utils.Regex(htmlWithoutScriptTagsAndComments, "<a[^<]*href\\s*=\\s*\"[^\"]*(&|\\?)op=my_account").matches() || new org.appwork.utils.Regex(htmlWithoutScriptTagsAndComments, "<a[^<]*href\\s*=\\s*\"[^\"]*/my(-|_)account\"").matches() || new org.appwork.utils.Regex(htmlWithoutScriptTagsAndComments, "<a[^<]*href\\s*=\\s*\"[^\"]*/account/?\"").matches();
        this.logger.info("xfss_Cookie:" + cookieXFSS);
        this.logger.info("xfsts_Cookie:" + cookieXFSTS);
        this.logger.info("login_xfss_CookieOkay:" + login_xfss_CookieOkay);
        this.logger.info("login_xfsts_CookieOkay:" + login_xfsts_CookieOkay);
        this.logger.info("email_xfss_CookieOkay:" + email_xfss_CookieOkay);
        this.logger.info("email_xfsts_CookieOkay:" + email_xfsts_CookieOkay);
        this.logger.info("logout_exists:" + logout);
        this.logger.info("login_exists:" + login);
        this.logger.info("myaccount_exists:" + myAccountOkay);
        this.logger.info("redirect:" + isRedirect);
        this.logger.info("loginURLFailed:" + loginURLFailed);
        boolean bl = ret = (login_xfss_CookieOkay || email_xfss_CookieOkay || login_xfsts_CookieOkay || email_xfsts_CookieOkay) && (logout || myAccountOkay && !login || isRedirect) && !loginURLFailed;
        if (!ret) {
            ret = (cookieXFSS != null || cookieXFSTS != null) && (logout || myAccountOkay && !login) && !loginURLFailed;
        }
        this.logger.info("loggedin:" + ret);
        return ret;
    }

    public String getLoginURL() {
        return this.getMainPage() + "/login.html";
    }

    protected String getRelativeAccountInfoURL() {
        return "/?op=my_account";
    }

    protected boolean containsInvalidLoginsMessage(Browser br) {
        return br != null && br.containsHTML(">\\s*Incorrect (Login|Username) or Password\\s*<");
    }

    protected boolean containsBlockedIPLoginMessage(Browser br) {
        return br != null && (br.containsHTML(">\\s*You can't login from this IP") || br.containsHTML(">\\s*Your IP (is|was) banned\\s*<") || br.containsHTML(">\\s*Your IP (is|was) banned by administrator[^<]*<"));
    }

    protected void fillWebsiteLoginForm(Browser br, Form loginform, Account account) {
        String passwordFieldName;
        String userFieldName;
        int n;
        String[] userFieldNames;
        String user = Encoding.urlEncode((String)account.getUser());
        InputField userField = null;
        String[] stringArray = userFieldNames = new String[]{"login", "email"};
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (userField = loginform.getInputFieldByName(userFieldName = stringArray[n])) == null; ++n) {
        }
        if (userField != null) {
            userField.setValue(user);
        } else {
            loginform.put(userFieldNames[0], user);
        }
        String password = Encoding.urlEncode((String)account.getPass());
        InputField passwordField = null;
        String[] passwordFieldNames = new String[]{"password", "pass"};
        stringArray = passwordFieldNames;
        n2 = stringArray.length;
        for (n = 0; n < n2 && (passwordField = loginform.getInputFieldByName(passwordFieldName = stringArray[n])) == null; ++n) {
        }
        if (passwordField != null) {
            passwordField.setValue(password);
        } else {
            loginform.put(passwordFieldNames[0], password);
        }
    }

    public boolean loginWebsite(DownloadLink link, Account account, boolean validateCookies) throws Exception {
        Account account2 = account;
        synchronized (account2) {
            try {
                this.br.setCookiesExclusive(true);
                Cookies cookies = account.loadCookies("");
                Cookies userCookies = account.loadUserCookies();
                if (userCookies == null && this.requiresCookieLogin()) {
                    this.showCookieLoginInfo();
                    throw new AccountInvalidException(_GUI.T.accountdialog_check_cookies_required());
                }
                if (userCookies != null) {
                    this.br.setCookies(this.getMainPage(), userCookies);
                    if (!validateCookies) {
                        return false;
                    }
                    if (!this.verifyCookies(account, userCookies)) {
                        if (account.hasEverBeenValid()) {
                            throw new AccountInvalidException(_GUI.T.accountdialog_check_cookies_expired());
                        }
                        throw new AccountInvalidException(_GUI.T.accountdialog_check_cookies_invalid());
                    }
                    String cookiesUsername = this.br.getCookie(this.br.getHost(), "login", Cookies.NOTDELETEDPATTERN);
                    if (StringUtils.isEmpty((String)cookiesUsername)) {
                        cookiesUsername = this.br.getCookie(this.br.getHost(), "email", Cookies.NOTDELETEDPATTERN);
                    }
                    if (!StringUtils.isEmpty((String)cookiesUsername)) {
                        cookiesUsername = Encoding.htmlDecode((String)cookiesUsername).trim();
                    }
                    if (StringUtils.isEmpty((String)cookiesUsername)) {
                        this.logger.warning("Failed to find username via cookie");
                    } else {
                        this.logger.info("Found username by cookie: " + cookiesUsername);
                        if (!account.getUser().equals(cookiesUsername)) {
                            this.logger.info("Setting new username by cookie | New: " + cookiesUsername + " | Old: " + account.getUser());
                            account.setUser(cookiesUsername);
                        }
                    }
                    return true;
                }
                if (cookies != null) {
                    this.br.setCookies(this.getMainPage(), cookies);
                    if (!validateCookies) {
                        return false;
                    }
                    if (this.verifyCookies(account, cookies)) {
                        account.saveCookies(this.br.getCookies(this.getMainPage()), "");
                        return true;
                    }
                }
                this.logger.info("Full login required");
                int login_counter = 1;
                int maxLoginAttempts = 3;
                this.br.clearCookies(this.getMainPage());
                boolean userSolvedAtLeastOneLoginCaptcha = false;
                do {
                    boolean captchaRequiredInThisRun;
                    this.logger.info("Performing full website login attempt: " + login_counter + "/" + 3 + " | Multiple attempts will only happen if a captcha is required");
                    Form loginForm = this.findLoginform(this.br);
                    if (loginForm == null) {
                        this.getPage(this.getLoginURL());
                        if (this.br.getHttpConnection().getResponseCode() == 404) {
                            this.getPage(this.getMainPage() + "/login");
                        }
                        if ((loginForm = this.findLoginform(this.br)) == null) {
                            this.logger.warning("Failed to find loginform");
                            this.checkErrorsLoginWebsite(this.br, account);
                            this.checkResponseCodeErrors(this.br.getHttpConnection());
                            if (this.containsBlockedIPLoginMessage(this.br)) {
                                throw new AccountInvalidException("\r\nYou can't login from this IP!\r\n");
                            }
                            throw new PluginException(0x400000);
                        }
                    }
                    this.fillWebsiteLoginForm(this.br, loginForm, account);
                    int captchasBefore = this.getChallenges().size();
                    this.handleCaptcha(new DownloadLink(this, "Account", this.getHost(), "https://" + account.getHoster(), true), this.br, loginForm);
                    int captchasAfter = this.getChallenges().size();
                    boolean bl = captchaRequiredInThisRun = captchasAfter > captchasBefore;
                    if (captchaRequiredInThisRun) {
                        userSolvedAtLeastOneLoginCaptcha = true;
                    } else if (login_counter > 1) {
                        this.logger.info("Logins seem to be invalid because no login captcha required on login attempt: " + login_counter);
                        break;
                    }
                    this.submitForm(loginForm);
                    boolean captchaRequiredInNextRun = this.containsCaptcha(this.findLoginform(this.br));
                    if (!captchaRequiredInNextRun) {
                        this.logger.info("Ending login loop because: No captcha required in next run --> No more attempts needed");
                        break;
                    }
                    if (!userSolvedAtLeastOneLoginCaptcha || !this.containsInvalidLoginsMessage(this.br) && !this.containsBlockedIPLoginMessage(this.br)) continue;
                    this.logger.info("Logins seem to be invalid because: There has been a login captcha but server response indicates invalid logins on login attempt: " + login_counter);
                    break;
                } while (!this.isLoggedin(this.br) && ++login_counter <= 3);
                if (!this.isLoggedin(this.br)) {
                    this.logger.info("Login failed after attempts: " + login_counter);
                    if (this.getCorrectBR(this.br).contains("op=resend_activation")) {
                        throw new AccountUnavailableException("\r\nYour account has not yet been activated!\r\nActivate it via the URL you received via E-Mail and try again!", 300000L);
                    }
                    if (this.containsInvalidLoginsMessage(this.br)) {
                        if ("de".equalsIgnoreCase(System.getProperty("user.language"))) {
                            throw new AccountInvalidException("\r\nUng\u00fcltiger Benutzername/Passwort!\r\nDu bist dir sicher, dass dein eingegebener Benutzername und Passwort stimmen? Versuche folgendes:\r\n1. Falls dein Passwort Sonderzeichen enth\u00e4lt, \u00e4ndere es (entferne diese) und versuche es erneut!\r\n2. Gib deine Zugangsdaten per Hand (ohne kopieren/einf\u00fcgen) ein.");
                        }
                        if ("pl".equalsIgnoreCase(System.getProperty("user.language"))) {
                            throw new AccountInvalidException("\r\nNieprawid\u0142owa nazwa u\u017cytkownika / has\u0142o!\r\nUpewnij si\u0119, \u017ce prawid\u0142owo wprowadzi\u0142es has\u0142o i nazw\u0119 u\u017cytkownika. Dodatkowo:\r\n1. Je\u015bli twoje has\u0142o zawiera znaki specjalne, zmie\u0144 je (usu\u0144) i spr\u00f3buj ponownie!\r\n2. Wprowad\u017a has\u0142o i nazw\u0119 u\u017cytkownika r\u0119cznie bez u\u017cycia opcji Kopiuj i Wklej.");
                        }
                        throw new AccountInvalidException("\r\nInvalid username/password!\r\nYou're sure that the username and password you entered are correct? Some hints:\r\n1. If your password contains special characters, change it (remove them) and try again!\r\n2. Type in your username/password by hand without copy & paste.");
                    }
                    if (this.containsBlockedIPLoginMessage(this.br)) {
                        throw new AccountInvalidException("\r\nYou can't login from this IP!\r\n");
                    }
                    if (this.containsCaptcha(this.findLoginform(this.br))) {
                        if ("de".equalsIgnoreCase(System.getProperty("user.language"))) {
                            throw new AccountInvalidException("\r\nUng\u00fcltiges Login captcha!\r\nVersuche es erneut.");
                        }
                        throw new AccountInvalidException("\r\nInvalid login captcha answer!\r\nTry again.");
                    }
                    throw new AccountInvalidException();
                }
                account.saveCookies(this.br.getCookies(this.getMainPage()), "");
                return true;
            }
            catch (PluginException e) {
                try {
                    return this.handleLoginWebsite2FA(e, link, account, validateCookies);
                }
                catch (Exception e2) {
                    if (e.getLinkStatus() == 256) {
                        account.clearCookies("");
                    } else if (e2 instanceof PluginException && ((PluginException)e2).getLinkStatus() == 256) {
                        account.clearCookies("");
                    }
                    throw e2;
                }
            }
        }
    }

    protected boolean handleLoginWebsite2FA(PluginException e, DownloadLink link, Account account, boolean validateCookies) throws Exception {
        Form twoFAForm = this.find2FALoginform(this.br);
        if (twoFAForm == null) {
            throw e;
        }
        this.logger.info("2FA code required");
        InputField twoFAField = this.get2FALoginField(this.br, twoFAForm);
        if (twoFAField == null) {
            this.logger.warning("Failed to find 2FA fieldKey");
            throw e;
        }
        String twoFACode = this.getTwoFACode(account, "\\d{6}");
        this.logger.info("Submitting 2FA code");
        twoFAForm.put(twoFAField.getKey(), twoFACode);
        this.submitForm(twoFAForm);
        if (!this.isLoggedin(this.br) || this.find2FALoginform(this.br) != null) {
            throw new AccountInvalidException(e, _GUI.T.jd_gui_swing_components_AccountDialog_2FA_login_invalid());
        }
        Cookies cookies = this.br.getCookies(this.br.getHost());
        account.saveCookies(cookies, "");
        if (!this.verifyCookies(account, cookies)) {
            throw e;
        }
        return this.loginWebsite(link, account, validateCookies);
    }

    protected InputField get2FALoginField(Browser br, Form form) {
        List<InputField> fields = form.getInputFields();
        for (InputField field : fields) {
            if (field.getKey() == null || !field.getKey().matches("^code\\d*$")) continue;
            return field;
        }
        return null;
    }

    protected Form find2FALoginform(Browser br) {
        Form[] forms;
        for (Form form : forms = br.getForms()) {
            if (form.containsHTML("g2fa_check")) {
                return form;
            }
            InputField field = this.get2FALoginField(br, form);
            if (field == null) continue;
            return form;
        }
        return null;
    }

    protected boolean verifyCookies(Account account, Cookies cookies) throws Exception {
        this.br.setCookies(this.getMainPage(), cookies);
        this.br.setCookies(cookies);
        this.getPage(this.getMainPage() + this.getRelativeAccountInfoURL());
        if (this.isLoggedin(this.br)) {
            this.logger.info("Cookie login successful");
            return true;
        }
        this.logger.info("Cookie login failed");
        this.br.clearCookies(this.br.getHost());
        return false;
    }

    protected boolean containsCaptcha(Form form) {
        if (form == null) {
            return false;
        }
        return this.containsCaptcha(form.getHtmlCode());
    }

    protected boolean containsCaptcha(Browser br) {
        return br != null && this.containsCaptcha(br.getRequest().getHtmlCode());
    }

    protected boolean containsCaptcha(String str) {
        if (str == null) {
            return false;
        }
        return this.containsHCaptcha(str) || this.containsRecaptchaV2Class(str) || this.containsPlainTextCaptcha(str);
    }

    @Override
    protected void throwFinalConnectionException(Browser br, URLConnectionAdapter con) throws PluginException, IOException {
        throw new PluginException(0x400000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryDownload(Browser br, DownloadLink link, Account account, Request req, DOWNLOAD_ATTEMPT_FLAGS ... flags) throws Exception {
        String url_original;
        if (req == null) {
            throw new IllegalArgumentException();
        }
        ArrayList flagList = flags != null ? Arrays.asList(flags) : new ArrayList(0);
        boolean throwConnectException = flagList.contains((Object)DOWNLOAD_ATTEMPT_FLAGS.DOWNLOAD_OR_EXCEPTION) || flagList.contains((Object)DOWNLOAD_ATTEMPT_FLAGS.CONNECT_OR_EXCEPTION);
        String url = url_original = req.getUrl();
        if (!(url = this.fixProtocol(link, account, br, url)).equals(req.getUrl())) {
            this.logger.info("Final downloadlink was changed to: " + url);
            req.setURL(new URL(url));
        }
        String hlsURL = null;
        if (req.getRequestMethod() == HTTPConnection.RequestMethod.GET && StringUtils.containsIgnoreCase((String)url, (String)".m3u8")) {
            hlsURL = url;
        } else {
            req.getHeaders().put("Accept-Encoding", "identity");
            boolean resume = this.isResumeable(link, account);
            int maxChunks = this.getMaxChunks(account);
            if (maxChunks > 1) {
                this.logger.info("@Developer: fixme! maxChunks may not be fixed positive:" + maxChunks);
                maxChunks = -maxChunks;
            }
            if (!resume && maxChunks != 1) {
                this.logger.info("@Developer: fixme! no resume allowed but maxChunks is not 1:" + maxChunks);
                maxChunks = 1;
            }
            try {
                new BrowserAdapter();
                this.dl = BrowserAdapter.openDownload(br, link, req, resume, maxChunks);
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception e) {
                if (!throwConnectException && Exceptions.containsInstanceOf((Throwable)e, (Class[])new Class[]{SocketException.class, UnknownHostException.class})) {
                    this.logger.log((Throwable)e);
                    return false;
                }
                throw e;
            }
            if (LinkCrawlerDeepInspector.looksLikeMpegURL(this.dl.getConnection())) {
                hlsURL = this.dl.getConnection().getURL().toExternalForm();
                br.followConnection(true);
            } else {
                if (!this.looksLikeDownloadableContent(this.dl.getConnection())) {
                    br.followConnection(true);
                    this.runPostRequestTask(br);
                    this.correctBR(br);
                    if (this.dl.getConnection().getResponseCode() == 503) {
                        this.exception503ConnectionLimitReached();
                        throw new PluginException(0x400000);
                    }
                    if (flagList.contains((Object)DOWNLOAD_ATTEMPT_FLAGS.DOWNLOAD_OR_EXCEPTION)) {
                        this.handleDownloadErrors(this.dl.getConnection(), link, account);
                        this.throwFinalConnectionException(br, this.dl.getConnection());
                        throw new PluginException(0x400000);
                    }
                    this.dl.close();
                    this.dl = null;
                    if (br.getHttpConnection().getResponseCode() == 416) {
                        Request withoutRange = req.cloneRequest();
                        withoutRange.getHeaders().remove("Range");
                        br.getPage(withoutRange);
                        this.runPostRequestTask(br);
                        this.correctBR(br);
                        URLConnectionAdapter con = br.getHttpConnection();
                        if (con.getResponseCode() == 503) {
                            this.exception503ConnectionLimitReached();
                            throw new PluginException(0x400000);
                        }
                        if (flagList.contains((Object)DOWNLOAD_ATTEMPT_FLAGS.DOWNLOAD_OR_EXCEPTION)) {
                            this.handleDownloadErrors(con, link, account);
                            this.throwFinalConnectionException(br, con);
                            throw new PluginException(0x400000);
                        }
                    }
                    return false;
                }
                try {
                    this.handleDownloadErrors(this.dl.getConnection(), link, account);
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (Exception e) {
                    if (flagList.contains((Object)DOWNLOAD_ATTEMPT_FLAGS.DOWNLOAD_OR_EXCEPTION)) {
                        throw e;
                    }
                    return false;
                }
            }
        }
        if (hlsURL != null) {
            String finalDownloadlink;
            try {
                finalDownloadlink = this.handleQualitySelectionHLS(this.br.cloneBrowser(), hlsURL);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                if (flagList.contains((Object)DOWNLOAD_ATTEMPT_FLAGS.DOWNLOAD_OR_EXCEPTION)) {
                    throw e;
                }
                this.logger.log((Throwable)e);
                return false;
            }
            this.checkFFmpeg(link, "Download a HLS Stream");
            this.dl = new HLSDownloader(link, br, finalDownloadlink);
            try {
                this.fixFilenameHLSDownload(link);
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
        } else {
            try {
                this.fixFilename(this.dl.getConnection(), link);
            }
            catch (Exception ignore) {
                this.logger.log((Throwable)ignore);
            }
        }
        this.storeDirecturl(link, account, this.dl.getConnection().getURL().toExternalForm());
        this.controlMaxFreeDownloads(account, link, 1);
        try {
            this.dl.startDownload();
        }
        finally {
            this.controlMaxFreeDownloads(account, link, -1);
        }
        return true;
    }

    @Override
    public void handlePremium(DownloadLink link, Account account) throws Exception {
        Form dlform;
        String contentURL;
        block15: {
            if (this.attemptStoredDownloadurlDownload(link, account)) {
                return;
            }
            this.resolveShortURL(this.br.cloneBrowser(), link, account);
            if (this.enableAccountApiOnlyMode()) {
                this.handleDownload(link, account, null, this.getDllinkAPI(link, account));
                return;
            }
            contentURL = this.getNormalizedDownloadURL(link);
            if (this.allowAPIDownloadIfApikeyIsAvailable(link, account)) {
                String directlinkFromAPI = null;
                try {
                    directlinkFromAPI = this.getDllinkAPI(link, account);
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (Throwable e) {
                    this.logger.log(e);
                    this.logger.warning("Error in API download handling in website mode");
                    break block15;
                }
                this.logger.info("Found directurl via API mode: " + directlinkFromAPI);
                this.handleDownload(link, account, null, directlinkFromAPI);
                return;
            }
        }
        this.requestFileInformationWebsite(link, account);
        boolean verifiedLogin = this.loginWebsite(link, account, false);
        if (this.tryDownload(this.br, link, account, (Request)this.br.createGetRequest(contentURL), DOWNLOAD_ATTEMPT_FLAGS.CONNECT_OR_EXCEPTION)) {
            return;
        }
        if (!verifiedLogin && !this.isLoggedin(this.br)) {
            this.loginWebsite(link, account, true);
            if (this.tryDownload(this.br, link, account, (Request)this.br.createGetRequest(contentURL), DOWNLOAD_ATTEMPT_FLAGS.CONNECT_OR_EXCEPTION)) {
                return;
            }
        }
        if (this.isFree(account)) {
            this.doFree(link, account);
            return;
        }
        String officialVideoDownloadURL = null;
        officialVideoDownloadURL = this.getDllinkViaOfficialVideoDownload(this.br.cloneBrowser(), link, account, false);
        String dllink = this.getDllink(link, account, this.br, this.getCorrectBR(this.br));
        if ((StringUtils.isEmpty((String)dllink) || StringUtils.isEmpty((String)officialVideoDownloadURL)) && (dlform = this.findFormDownload2Premium(link, account, this.br)) != null) {
            this.handlePassword(dlform, link);
            if (this.tryDownload(this.br, link, account, this.br.createFormRequest(dlform), DOWNLOAD_ATTEMPT_FLAGS.CONNECT_OR_EXCEPTION)) {
                return;
            }
            if (StringUtils.isEmpty((String)officialVideoDownloadURL)) {
                officialVideoDownloadURL = this.getDllinkViaOfficialVideoDownload(this.br.cloneBrowser(), link, account, false);
            }
            if (dllink == null) {
                dllink = this.getDllink(link, account, this.br, this.getCorrectBR(this.br));
            }
        }
        if (StringUtils.isEmpty((String)dllink) && StringUtils.isEmpty((String)officialVideoDownloadURL)) {
            this.checkErrors(this.br, this.getCorrectBR(this.br), link, account);
            this.logger.warning("Failed to find Form download2");
            this.checkServerErrors(this.br, link, account);
            this.checkErrorsLastResort(this.br, link, account);
            throw new PluginException(0x400000);
        }
        this.handleDownload(link, account, officialVideoDownloadURL, dllink);
    }

    protected String fixProtocol(DownloadLink link, Account account, Browser br, String dllink) throws Exception {
        if (dllink == null) {
            return null;
        }
        URL url = br.getURL(dllink);
        if (url.getPort() != -1 && StringUtils.equalsIgnoreCase((String)url.getProtocol(), (String)"http")) {
            try {
                Browser brc = br.cloneBrowser();
                brc.setAllowedResponseCodes(new int[]{400});
                brc.getPage(url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + "/");
                if (brc.getHttpConnection().getResponseCode() == 400 && brc.containsHTML("The plain HTTP request was sent to HTTPS port")) {
                    String ret = url.toExternalForm().replaceFirst("(?i)^(http://)", "https://");
                    this.logger.info("fixProtocol downloadlink = " + dllink + "->" + ret);
                    return ret;
                }
            }
            catch (IOException e) {
                this.logger.log((Throwable)e);
            }
        }
        return dllink;
    }

    protected void handleDownload(DownloadLink link, Account account, String officialVideoDownloadURL, String directurl) throws Exception {
        XFSConfigVideo.DownloadMode mode = this.getPreferredDownloadModeFromConfig();
        String finalDownloadlink = !StringUtils.isEmpty((String)officialVideoDownloadURL) && (mode == null || mode == XFSConfigVideo.DownloadMode.ORIGINAL || mode == XFSConfigVideo.DownloadMode.AUTO || StringUtils.isEmpty((String)directurl)) ? officialVideoDownloadURL : directurl;
        if (Encoding.isHtmlEntityCoded((String)finalDownloadlink)) {
            finalDownloadlink = Encoding.htmlOnlyDecode((String)finalDownloadlink);
        }
        this.tryDownload(this.br, link, account, (Request)this.br.createGetRequest(finalDownloadlink), DOWNLOAD_ATTEMPT_FLAGS.DOWNLOAD_OR_EXCEPTION);
    }

    protected String handleQualitySelectionHLS(Browser br, String hlsUrl) throws Exception {
        List<HlsContainer> hlsQualities;
        if (hlsUrl == null) {
            throw new IllegalArgumentException();
        }
        if (!StringUtils.equals((String)br.getURL(), (String)hlsUrl)) {
            this.getPage(br, hlsUrl);
        }
        if ((hlsQualities = HlsContainer.getHlsQualities(br)) == null || hlsQualities.isEmpty()) {
            if (br.containsHTML("#EXT-X-PLAYLIST-TYPE")) {
                this.logger.info("Looks like single HLS quality");
                return br.getURL();
            }
            throw new PluginException(2048, "HLS stream broken?");
        }
        HlsContainer hlsSelected = null;
        int userSelectedQuality = this.getPreferredStreamQuality();
        if (userSelectedQuality == -1) {
            this.logger.info("Looking for BEST video stream");
            hlsSelected = HlsContainer.findBestVideoByBandwidth(hlsQualities);
        } else {
            this.logger.info("Looking for user selected video stream quality: " + userSelectedQuality);
            for (HlsContainer hlsQualityTmp : hlsQualities) {
                int height = hlsQualityTmp.getHeight();
                if (height != userSelectedQuality) continue;
                this.logger.info("Successfully found selected quality: " + userSelectedQuality);
                hlsSelected = hlsQualityTmp;
                break;
            }
            if (hlsSelected == null) {
                this.logger.info("Failed to find user selected quality --> Finding next best quality");
                hlsSelected = HlsContainer.findBestTargetHeight(hlsQualities, userSelectedQuality);
            }
        }
        this.logger.info(String.format("Picked stream quality = %sp", hlsSelected.getHeight()));
        return hlsSelected.getDownloadurl();
    }

    protected void storeDirecturl(DownloadLink link, Account account, String directurl) {
        String directlinkproperty = this.getDownloadModeDirectlinkProperty(account);
        link.setProperty(directlinkproperty, directurl);
    }

    protected void handleDownloadErrors(URLConnectionAdapter con, DownloadLink link, Account account) throws Exception {
        if (this.looksLikeDownloadableContent(con)) {
            return;
        }
        this.logger.warning("The final dllink seems not to be a file!");
        this.br.followConnection(true);
        this.correctBR(this.br);
        this.runPostRequestTask(this.br);
        this.checkServerErrors(this.br, link, account);
        this.checkErrors(this.br, this.getCorrectBR(this.br), link, account);
        this.checkResponseCodeErrors(con);
        throw new PluginException(2048, "Final downloadlink did not lead to downloadable content");
    }

    protected String getAPIBase() {
        String custom_apidomain = this.getPluginConfig().getStringProperty(PROPERTY_PLUGIN_api_domain_with_protocol);
        if (custom_apidomain != null) {
            return custom_apidomain;
        }
        return this.getMainPage() + "/api";
    }

    protected boolean allowToGenerateAPIKeyInWebsiteMode() {
        return true;
    }

    protected String getDllinkAPI(DownloadLink link, Account account) throws Exception {
        String quality;
        Map quality_tmp;
        String[] qualities;
        String fileid_to_download;
        this.logger.info("Trying to get dllink via API");
        String apikey = this.getAPIKeyFromAccount(account);
        if (StringUtils.isEmpty((String)apikey)) {
            throw new IllegalArgumentException("apikey is null");
        }
        if (this.requiresAPIGetdllinkCloneWorkaround(account)) {
            this.logger.info("Trying to download file via clone workaround");
            this.getPage(this.getAPIBase() + "/file/clone?key=" + apikey + "&file_code=" + this.getFUIDFromURL(link));
            this.checkErrorsAPI(this.br, link, account);
            fileid_to_download = PluginJSonUtils.getJson(this.br, "filecode");
            if (StringUtils.isEmpty((String)fileid_to_download)) {
                this.logger.warning("Failed to find new fileid in clone handling");
                throw new PluginException(0x400000);
            }
        } else {
            this.logger.info("Trying to download file via api without workaround");
            fileid_to_download = this.getFUIDFromURL(link);
        }
        this.getPage(this.getAPIBase() + "/file/direct_link?key=" + apikey + "&file_code=" + fileid_to_download);
        Map<String, Object> entries = this.checkErrorsAPI(this.br, link, account);
        Map result = (Map)entries.get("result");
        String dllink = null;
        String[] stringArray = qualities = new String[]{"o", "h", "n", "l"};
        int n = stringArray.length;
        for (int i = 0; i < n && ((quality_tmp = (Map)result.get(quality = stringArray[i])) == null || StringUtils.isEmpty((String)(dllink = (String)quality_tmp.get("url")))); ++i) {
        }
        if (StringUtils.isEmpty(dllink)) {
            this.logger.info("Failed to find any quality - downloading original file");
            dllink = (String)result.get("url");
        }
        if (StringUtils.isEmpty(dllink)) {
            throw new PluginException(0x400000, "Failed to find final downloadurl via API");
        }
        this.logger.info("Successfully found dllink via API: " + dllink);
        return dllink;
    }

    protected AccountInfo fetchAccountInfoAPI(Browser br, Account account) throws Exception {
        Object files_totalO;
        Object storage_usedO;
        String balanceStr;
        Map<String, Object> entries = this.loginAPI(br, account);
        String server_timeStr = (String)entries.get("server_time");
        Map result = (Map)entries.get("result");
        long expire_milliseconds_precise_to_the_second = 0L;
        long currentTime = server_timeStr != null && server_timeStr.matches("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}:\\d{2}:\\d{2}") ? TimeFormatter.getMilliSeconds((String)server_timeStr, (String)"yyyy-MM-dd HH:mm:ss", (Locale)Locale.ENGLISH) : br.getCurrentServerTime(System.currentTimeMillis());
        String expireStr = (String)result.get("premium_expire");
        if (StringUtils.isEmpty((String)expireStr)) {
            expireStr = (String)result.get("premim_expire");
        }
        if (expireStr != null && expireStr.matches("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
            expire_milliseconds_precise_to_the_second = TimeFormatter.getMilliSeconds((String)expireStr, (String)"yyyy-MM-dd HH:mm:ss", (Locale)Locale.ENGLISH);
        }
        AccountInfo ai = new AccountInfo();
        ai.setUnlimitedTraffic();
        long premiumDurationMilliseconds = expire_milliseconds_precise_to_the_second - currentTime;
        if (premiumDurationMilliseconds <= 0L) {
            this.setAccountLimitsByType(account, Account.AccountType.FREE);
        } else {
            ai.setValidUntil(System.currentTimeMillis() + premiumDurationMilliseconds);
            if (premiumDurationMilliseconds > TimeUnit.DAYS.toMillis(2190L)) {
                this.setAccountLimitsByType(account, Account.AccountType.LIFETIME);
            } else {
                this.setAccountLimitsByType(account, Account.AccountType.PREMIUM);
            }
        }
        String premium_bandwidthBytesStr = (String)result.get("premium_bandwidth");
        String traffic_leftBytesStr = (String)result.get("traffic_left");
        if (premium_bandwidthBytesStr != null) {
            ai.setTrafficLeft(SizeFormatter.getSize((String)premium_bandwidthBytesStr));
        } else if (traffic_leftBytesStr != null) {
            ai.setTrafficLeft(SizeFormatter.getSize((String)traffic_leftBytesStr));
        }
        Object balanceO = result.get("balance");
        if (balanceO != null && (balanceStr = balanceO.toString()).matches("[0-9.]+")) {
            ai.setAccountBalance(Double.parseDouble(balanceStr), Currency.getInstance("USD"));
        }
        if ((storage_usedO = result.get("storage_used")) != null) {
            ai.setUsedSpace(SizeFormatter.getSize((String)storage_usedO.toString()));
        }
        if ((files_totalO = result.get("files_total")) instanceof Number) {
            ai.setFilesNum(((Number)files_totalO).intValue());
        }
        String email = (String)result.get("email");
        if (this.enableAccountApiOnlyMode() && !StringUtils.isEmpty((String)email)) {
            account.setUser(email);
        } else if (StringUtils.equals((String)account.getUser(), (String)this.getAPIKeyFromAccount(account))) {
            this.logger.info("User has entered API key as username & password -> Set email as username: " + email);
            account.setUser(email);
        }
        return ai;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<String, Object> loginAPI(Browser br, Account account) throws Exception {
        Account account2 = account;
        synchronized (account2) {
            br.setCookiesExclusive(true);
            String apikey = this.getAPIKeyFromAccount(account);
            if (!this.looksLikeValidAPIKey(apikey)) {
                throw new AccountInvalidException("Invalid API Key format!\r\nFind your API Key here: " + this.getAPILoginHelpURL());
            }
            this.getPage(br, this.getAPIBase() + "/account/info?key=" + apikey);
            Map<String, Object> entries = this.checkErrorsAPI(br, null, account);
            boolean loginAPICheckIfDownloadsAreAllowed = true;
            boolean apiDownloadsPossible = false;
            try {
                Browser brc = br.cloneBrowser();
                this.getPage(brc, this.getAPIBase() + "/file/direct_link?key=" + apikey + "&file_code=");
                Map<String, Object> result = this.checkErrorsAPI(brc, null, account);
                String msg = (String)result.get("msg");
                if (StringUtils.equalsIgnoreCase((String)msg, (String)"uploading") && "200".equals(StringUtils.valueOfOrNull((Object)result.get("status")))) {
                    apiDownloadsPossible = true;
                }
            }
            catch (PluginException ple) {
                if (ple.getLinkStatus() == 32) {
                    apiDownloadsPossible = true;
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
                this.logger.info("Exception occured API download check");
            }
            finally {
                this.logger.info("API download status: " + apiDownloadsPossible);
                if (apiDownloadsPossible) {
                    account.setProperty(PROPERTY_ACCOUNT_ALLOW_API_DOWNLOAD_ATTEMPT_IN_WEBSITE_MODE, true);
                } else {
                    account.removeProperty(PROPERTY_ACCOUNT_ALLOW_API_DOWNLOAD_ATTEMPT_IN_WEBSITE_MODE);
                }
            }
            return entries;
        }
    }

    protected final DownloadLink.AvailableStatus requestFileInformationAPI(DownloadLink link, String apikey) throws Exception {
        this.massLinkcheckerAPI(new DownloadLink[]{link}, apikey);
        if (link.getAvailableStatus() == DownloadLink.AvailableStatus.FALSE) {
            throw new PluginException(32);
        }
        return link.getAvailableStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean massLinkcheckerAPI(DownloadLink[] urls, String apikey) {
        if (urls == null || urls.length == 0) {
            return false;
        }
        if (!this.looksLikeValidAPIKey(apikey)) {
            throw new IllegalArgumentException("apikey cannot be null");
        }
        boolean linkcheckerHasFailed = false;
        try {
            Browser br = this.createNewBrowserInstance();
            this.prepBrowser(br, this.getMainPage());
            br.setCookiesExclusive(true);
            StringBuilder sb = new StringBuilder();
            ArrayList<DownloadLink> links = new ArrayList<DownloadLink>();
            int index = 0;
            do {
                links.clear();
                while (index != urls.length && links.size() != 50) {
                    links.add(urls[index]);
                    ++index;
                }
                ArrayList<DownloadLink> apiLinkcheckLinks = new ArrayList<DownloadLink>();
                sb.delete(0, sb.capacity());
                for (DownloadLink link : links) {
                    try {
                        this.resolveShortURL(br.cloneBrowser(), link, null);
                    }
                    catch (PluginException e) {
                        this.logger.log((Throwable)e);
                        if (e.getLinkStatus() == 32) {
                            link.setAvailableStatus(DownloadLink.AvailableStatus.FALSE);
                            continue;
                        }
                        if (e.getLinkStatus() == 16) {
                            link.setAvailableStatus(DownloadLink.AvailableStatus.TRUE);
                            continue;
                        }
                        link.setAvailableStatus(DownloadLink.AvailableStatus.UNCHECKABLE);
                        continue;
                    }
                    sb.append(this.getFUIDFromURL(link));
                    sb.append("%2C");
                    apiLinkcheckLinks.add(link);
                }
                if (apiLinkcheckLinks.isEmpty()) {
                    this.logger.info("Seems like we got only shortURLs -> Nothing left to be checked via API");
                    break;
                }
                this.getPage(br, this.getAPIBase() + "/file/info?key=" + apikey + "&file_code=" + sb.toString());
                Map<String, Object> entries = null;
                try {
                    entries = this.checkErrorsAPI(br, (DownloadLink)links.get(0), null);
                }
                catch (Throwable e) {
                    this.logger.log(e);
                    this.logger.info("Fatal failure");
                    boolean bl = false;
                    if (linkcheckerHasFailed) {
                        this.logger.info("Seems like massLinkcheckerAPI availablecheck is not supported by this host or currently broken");
                    }
                    return bl;
                }
                List ressourcelist = (List)entries.get("result");
                for (DownloadLink link : apiLinkcheckLinks) {
                    Map fileinfo = null;
                    String thisFUID = this.getFUIDFromURL(link);
                    for (Map fileInfoTmp : ressourcelist) {
                        String fuid_temp = (String)fileInfoTmp.get("filecode");
                        if (StringUtils.isEmpty((String)fuid_temp)) {
                            fuid_temp = (String)fileInfoTmp.get("file_code");
                        }
                        if (!StringUtils.equals((String)fuid_temp, (String)thisFUID)) continue;
                        fileinfo = fileInfoTmp;
                        break;
                    }
                    if (fileinfo == null) {
                        this.logger.warning("WTF failed to find information for fuid: " + this.getFUIDFromURL(link));
                        linkcheckerHasFailed = true;
                        continue;
                    }
                    int status = ((Number)fileinfo.get("status")).intValue();
                    String filename = null;
                    boolean isVideohost = false;
                    if (status != 200) {
                        link.setAvailable(false);
                    } else {
                        link.setAvailable(true);
                        filename = (String)fileinfo.get("name");
                        if (StringUtils.isEmpty((String)filename)) {
                            filename = (String)fileinfo.get("file_title");
                        }
                        long filesize = JavaScriptEngineFactory.toLong(fileinfo.get("size"), 0L);
                        Object canplay = fileinfo.get("canplay");
                        Object views_started = fileinfo.get("views_started");
                        Object views = fileinfo.get("views");
                        Object length = fileinfo.get("length");
                        boolean bl = isVideohost = canplay != null || views_started != null || views != null || length != null;
                        if (filesize > 0L) {
                            link.setDownloadSize(filesize);
                        }
                    }
                    if (!isVideohost) {
                        isVideohost = this.internal_isVideohoster_enforce_video_filename(link, null);
                    }
                    if (!StringUtils.isEmpty(filename)) {
                        if (Encoding.isHtmlEntityCoded((String)filename)) {
                            filename = Encoding.htmlDecode((String)filename).trim();
                        }
                        if (isVideohost) {
                            filename = this.applyFilenameExtension(filename, ".mp4");
                        }
                        link.setFinalFileName(filename);
                        continue;
                    }
                    String name = link.getName();
                    if (name == null || !isVideohost) continue;
                    link.setName(this.applyFilenameExtension(filename, ".mp4"));
                }
            } while (index != urls.length);
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (linkcheckerHasFailed) {
                this.logger.info("Seems like massLinkcheckerAPI availablecheck is not supported by this host or currently broken");
            }
        }
        return !linkcheckerHasFailed;
    }

    protected Map<String, Object> checkErrorsAPI(Browser br, DownloadLink link, Account account) throws NumberFormatException, PluginException {
        long defaultWaitAccount = 180000L;
        long defaultWaitMillis = 180000L;
        Map entries = null;
        try {
            entries = (Map)this.restoreFromString(br.getRequest().getHtmlCode(), TypeRef.MAP);
        }
        catch (JSonMapperException e) {
            this.logger.log((Throwable)e);
            String errormessage = "Invalid API response";
            if (link == null) {
                throw new AccountUnavailableException("Invalid API response", 180000L);
            }
            throw new PluginException(2048, "Invalid API response", 180000L);
        }
        int status = ((Number)entries.get("status")).intValue();
        if (status == 200) {
            return entries;
        }
        String errormsg = (String)entries.get("msg");
        if (errormsg != null) {
            if (errormsg.equalsIgnoreCase("This function not allowed in API")) {
                throw new AccountUnavailableException("API does not allow download | Contact support of this website", 300000L);
            }
            if (errormsg.equalsIgnoreCase("Wrong auth")) {
                throw new AccountInvalidException(errormsg);
            }
            if (errormsg.equalsIgnoreCase("no file")) {
                throw new PluginException(32);
            }
            if (link == null) {
                throw new AccountInvalidException(errormsg);
            }
        }
        if (status == 403) {
            throw new AccountInvalidException(errormsg);
        }
        if (status == 404) {
            throw new PluginException(32);
        }
        String msg = "Unknown API error with status " + status;
        if (link == null) {
            throw new AccountUnavailableException(msg, 180000L);
        }
        throw new PluginException(2048, msg, 180000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAPIKeyFromAccount(Account account) {
        Account account2 = account;
        synchronized (account2) {
            String apikey;
            if (this.enableAccountApiOnlyMode()) {
                apikey = account.getPass();
                if (apikey != null) {
                    apikey = apikey.trim();
                }
            } else {
                apikey = account.getStringProperty(PROPERTY_ACCOUNT_apikey);
            }
            if (this.looksLikeValidAPIKey(apikey)) {
                return apikey;
            }
            return null;
        }
    }

    protected final String getAPIKeyFromConfig() {
        Class<? extends XFSConfig> cfgO = this.getConfigInterface();
        if (cfgO == null) {
            return null;
        }
        String apikey = PluginJsonConfig.get(cfgO).getApikey();
        if (this.looksLikeValidAPIKey(apikey)) {
            return apikey;
        }
        return null;
    }

    protected final XFSConfigVideo.DownloadMode getPreferredDownloadModeFromConfig() {
        Class<? extends XFSConfigVideo> cfgO = this.getVideoConfigInterface();
        if (cfgO == null) {
            return XFSConfigVideo.DownloadMode.AUTO;
        }
        return PluginJsonConfig.get(cfgO).getPreferredDownloadMode();
    }

    protected final String getAPIKey() {
        Account acc = AccountController.getInstance().getValidAccount(this.getHost());
        if (acc != null && this.getAPIKeyFromAccount(acc) != null) {
            return this.getAPIKeyFromAccount(acc);
        }
        return this.getAPIKeyFromConfig();
    }

    @Override
    protected String getAPILoginHelpURL() {
        return this.getMainPage() + "/?op=my_account";
    }

    @Override
    protected boolean looksLikeValidAPIKey(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("^[a-z0-9]{16,}$");
    }

    public final String[] internal_getFileInfoArray() {
        return new String[3];
    }

    protected final boolean internal_isVideohosterEmbed(Browser br) {
        return this.isVideohosterEmbed() || this.isVideohosterEmbedHTML(br);
    }

    protected final boolean internal_isVideohoster_enforce_video_filename(DownloadLink link, Browser br) {
        URL_TYPE urltype2;
        URL_TYPE urltype = this.getURLType(link);
        URL_TYPE uRL_TYPE = urltype2 = br != null ? this.getURLType(br.getURL()) : null;
        if (this.isVideohoster_enforce_video_filename()) {
            return true;
        }
        if (this.internal_isVideohosterEmbed(br)) {
            return true;
        }
        if (urltype == URL_TYPE.EMBED_VIDEO || urltype == URL_TYPE.EMBED_VIDEO_2 || urltype == URL_TYPE.OFFICIAL_VIDEO_DOWNLOAD) {
            return true;
        }
        return urltype2 == URL_TYPE.EMBED_VIDEO || urltype2 == URL_TYPE.EMBED_VIDEO_2 || urltype2 == URL_TYPE.OFFICIAL_VIDEO_DOWNLOAD;
    }

    @Override
    public boolean internal_supportsMassLinkcheck() {
        return this.supportsAPIMassLinkcheck() || this.supportsMassLinkcheckOverWebsite() || this.enableAccountApiOnlyMode();
    }

    protected boolean supportsAPISingleLinkcheck() {
        return false;
    }

    protected boolean supportsAPIMassLinkcheck() {
        return false;
    }

    protected final boolean internal_supports_availablecheck_filename_abuse() {
        long timestampCooldown;
        boolean supportedByIndicatingHtmlCode = new org.appwork.utils.Regex(this.getCorrectBR(this.br), "op=report_file&(?:amp;)?id=" + this.getFUIDFromURL(this.getDownloadLink())).matches();
        boolean allowedByAutoHandling = true;
        SubConfiguration config = this.getPluginConfig();
        long timestampLastFailure = config.getLongProperty(PROPERTY_PLUGIN_REPORT_FILE_AVAILABLECHECK_LAST_FAILURE_TIMESTAMP, 0L);
        String last_version = config.getStringProperty(PROPERTY_PLUGIN_REPORT_FILE_AVAILABLECHECK_LAST_FAILURE_VERSION, null);
        if (timestampLastFailure > 0L && StringUtils.equalsIgnoreCase((String)this.getPluginVersionHash(), (String)last_version) && (timestampCooldown = timestampLastFailure + this.internal_waittime_on_alternative_availablecheck_failures()) > System.currentTimeMillis()) {
            this.logger.info("internal_supports_availablecheck_filename_abuse is still deactivated as it did not work on the last attempt");
            this.logger.info("Time until retry: " + TimeFormatter.formatMilliSeconds((long)(timestampCooldown - System.currentTimeMillis()), (int)0));
            allowedByAutoHandling = false;
        }
        return (this.supports_availablecheck_filename_abuse() || supportedByIndicatingHtmlCode) && allowedByAutoHandling;
    }

    protected final boolean internal_supports_availablecheck_alt() {
        long timestampCooldown;
        boolean allowedByAutoHandling = true;
        SubConfiguration config = this.getPluginConfig();
        long timestampLastFailure = config.getLongProperty(PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_FAILURE_TIMESTAMP, 0L);
        String last_version = config.getStringProperty(PROPERTY_PLUGIN_ALT_AVAILABLECHECK_LAST_FAILURE_VERSION, null);
        if (timestampLastFailure > 0L && StringUtils.equalsIgnoreCase((String)this.getPluginVersionHash(), (String)last_version) && (timestampCooldown = timestampLastFailure + this.internal_waittime_on_alternative_availablecheck_failures()) > System.currentTimeMillis()) {
            this.logger.info("internal_supports_availablecheck_alt is still deactivated as it did not work on the last attempt");
            this.logger.info("Time until retry: " + TimeFormatter.formatMilliSeconds((long)(timestampCooldown - System.currentTimeMillis()), (int)0));
            allowedByAutoHandling = false;
        }
        return this.supports_availablecheck_alt() && allowedByAutoHandling;
    }

    protected long internal_waittime_on_alternative_availablecheck_failures() {
        return 604800000L;
    }

    private boolean test_looks_like_supports_api() throws IOException {
        this.br.getPage(this.getAPIBase() + "/account/info");
        try {
            Map entries = (Map)this.restoreFromString(this.br.getRequest().getHtmlCode(), TypeRef.MAP);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public Class<? extends XFSConfig> getConfigInterface() {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public Boolean verifyDownloadableContent(Set<LazyHostPlugin> plugins, URLConnectionAdapter urlConnection) {
        if (plugins != null) {
            plugins.add(this.getLazyP());
        }
        if (urlConnection.getCompleteContentLength() == 7L && urlConnection.getContentType().matches("(?i)^.*application/octet-stream.*")) {
            return Boolean.FALSE;
        }
        if (urlConnection.getCompleteContentLength() == 7L && urlConnection.getContentType().matches("(?i)^.*text/html.*")) {
            return Boolean.FALSE;
        }
        if (urlConnection.isContentDisposition()) {
            String contentDispositionHeader = urlConnection.getHeaderField("Content-Disposition");
            String contentDispositionFileName = HTTPConnectionUtils.getFileNameFromDispositionHeader((String)contentDispositionHeader);
            boolean inlineFlag = contentDispositionHeader.matches("(?i)^\\s*inline\\s*;?.*");
            if (inlineFlag && contentDispositionFileName != null && contentDispositionFileName.matches("(?i)^.*\\.html?$")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public void resetDownloadlink(DownloadLink link) {
        if (link == null) {
            return;
        }
        link.removeProperty(PROPERTY_REFERER_REQUIRED);
    }

    @Override
    public SiteType.SiteTemplate siteTemplateType() {
        return SiteType.SiteTemplate.SibSoft_XFileShare;
    }

    protected static enum DOWNLOAD_ATTEMPT_FLAGS {
        DOWNLOAD_OR_EXCEPTION,
        CONNECT_OR_EXCEPTION;

    }

    public static enum URL_TYPE {
        EMBED_VIDEO,
        EMBED_VIDEO_2,
        FILE,
        IMAGE,
        NORMAL,
        SHORT,
        OFFICIAL_VIDEO_DOWNLOAD;

    }
}

