/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.archiveorg;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.defaults.AbstractDefaultFactory;
import org.appwork.storage.config.handler.KeyHandler;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="archive.org", type=Type.CRAWLER)
public interface ArchiveOrgConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();
    public static final SingleFilePathNotFoundMode default_SingleFilePathNotFoundMode = SingleFilePathNotFoundMode.ADD_ALL;
    public static final SingleFileAdoptFolderStructureMode default_SingleFileAdoptFolderStructureMode = SingleFileAdoptFolderStructureMode.ENABLE;
    public static final PlaylistCrawlMode default_PlaylistCrawlMode = PlaylistCrawlMode.AUTO;

    @AboutConfig
    @DefaultOnNull
    @DefaultFactory(value=DefaultFileCrawlerTypesToCrawl.class)
    @Order(value=10)
    public Set<ArchiveOrgType> getFileCrawlerTypesToCrawl();

    public void setFileCrawlerTypesToCrawl(Set<ArchiveOrgType> var1);

    @AboutConfig
    @DefaultEnumValue(value="ADD_DISABLED")
    @Order(value=11)
    public DeselectedTypesMode getDeselectedTypesLinksMode();

    public void setDeselectedTypesLinksMode(DeselectedTypesMode var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @Order(value=27)
    public SingleFilePathNotFoundMode getSingleFilePathNotFoundMode();

    public void setSingleFilePathNotFoundMode(SingleFilePathNotFoundMode var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @Order(value=28)
    public SingleFileAdoptFolderStructureMode getSingleFileAdoptFolderStructureMode();

    public void setSingleFileAdoptFolderStructureMode(SingleFileAdoptFolderStructureMode var1);

    @AboutConfig
    @DefaultEnumValue(value="PLAYLIST_TITLE_WITH_TRACK_NUMBER")
    @Order(value=29)
    public PlaylistFilenameScheme getPlaylistFilenameScheme();

    public void setPlaylistFilenameScheme(PlaylistFilenameScheme var1);

    @AboutConfig
    @SpinnerValidator(min=0L, max=10L, step=1L)
    @DefaultIntValue(value=0)
    @Order(value=30)
    public int getBookImageQuality();

    public void setBookImageQuality(int var1);

    @AboutConfig
    @DefaultEnumValue(value="PREFER_ORIGINAL")
    @Order(value=40)
    public BookCrawlMode getBookCrawlMode();

    public void setBookCrawlMode(BookCrawlMode var1);

    @AboutConfig
    @DefaultEnumValue(value="SET_AVAILABLE_STATUS_OFFLINE")
    @Order(value=41)
    public NonDownloadableBookPagesMode getNonDownloadableBookPagesMode();

    public void setNonDownloadableBookPagesMode(NonDownloadableBookPagesMode var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @Order(value=50)
    @DescriptionForConfigEntry(value="Handling for audio/video playlists.")
    public PlaylistCrawlMode getPlaylistCrawlMode202404();

    public void setPlaylistCrawlMode202404(PlaylistCrawlMode var1);

    @AboutConfig
    @SpinnerValidator(min=0L, max=100000L, step=100L)
    @DefaultIntValue(value=100)
    @Order(value=60)
    public int getSearchTermCrawlerMaxResultsLimit();

    public void setSearchTermCrawlerMaxResultsLimit(int var1);

    public static enum PlaylistCrawlMode implements LabelInterface
    {
        PLAYLIST_ONLY{

            public String getLabel() {
                return "Playlist only";
            }
        }
        ,
        PLAYLIST_AND_FILES{

            public String getLabel() {
                return "Playlist and selected files";
            }
        }
        ,
        FILES_ONLY{

            public String getLabel() {
                return "Selected files only";
            }
        }
        ,
        AUTO{

            public String getLabel() {
                return "Auto";
            }
        }
        ,
        DEFAULT{

            public String getLabel() {
                return "Default: " + default_PlaylistCrawlMode.getLabel();
            }
        };

    }

    public static enum NonDownloadableBookPagesMode implements LabelInterface
    {
        SET_AVAILABLE_STATUS_OFFLINE{

            public String getLabel() {
                return "Display as offline";
            }
        }
        ,
        SET_AVAILABLE_STATUS_ONLINE{

            public String getLabel() {
                return "Display as online (download will fail with error status)";
            }
        };

    }

    public static enum BookCrawlMode implements LabelInterface
    {
        PREFER_ORIGINAL{

            public String getLabel() {
                return "Selected files if possible else loose book pages";
            }
        }
        ,
        ORIGINAL_AND_LOOSE_PAGES{

            public String getLabel() {
                return "Selected files if possible and loose book pages";
            }
        }
        ,
        LOOSE_PAGES{

            public String getLabel() {
                return "Only loose book pages";
            }
        };

    }

    public static enum PlaylistFilenameScheme implements LabelInterface
    {
        PLAYLIST_TITLE_WITH_TRACK_NUMBER{

            public String getLabel() {
                return "Same as website: <TrackNumber>.<title> - <artist>.<fileExt>";
            }
        }
        ,
        ORIGINAL_FILENAME{

            public String getLabel() {
                return "Original / serverside filenames";
            }
        };

    }

    public static enum SingleFileAdoptFolderStructureMode implements LabelInterface
    {
        DEFAULT{

            public String getLabel() {
                return "Default: " + default_SingleFileAdoptFolderStructureMode.getLabel();
            }
        }
        ,
        ENABLE{

            public String getLabel() {
                return "Allow adopt folder structure";
            }
        }
        ,
        DISABLE{

            public String getLabel() {
                return "Do not allow adopt folder structure";
            }
        };

    }

    public static enum SingleFilePathNotFoundMode implements LabelInterface
    {
        ADD_ALL{

            public String getLabel() {
                return "Add all (selected) items";
            }
        }
        ,
        ADD_NOTHING_AND_DISPLAY_ADDED_URL_AS_OFFLINE{

            public String getLabel() {
                return "Display added URL as offline";
            }
        }
        ,
        DEFAULT{

            public String getLabel() {
                return "Default: " + default_SingleFilePathNotFoundMode.getLabel();
            }
        };

    }

    public static enum DeselectedTypesMode implements LabelInterface
    {
        ADD_DISABLED{

            public String getLabel() {
                return "Add links disabled";
            }
        }
        ,
        DO_NOT_ADD_SKIP{

            public String getLabel() {
                return "Do not add links (skip)";
            }
        };

    }

    @StorableValidatorIgnoresMissingSetter
    public static enum ArchiveOrgType implements LabelInterface
    {
        ORIGINAL{

            public String getLabel() {
                return "Original files";
            }
        }
        ,
        DERIVATIVE{

            public String getLabel() {
                return "Derivatives | Transcoded audio/video files";
            }
        }
        ,
        METADATA{

            public String getLabel() {
                return "Metadata | .xml/.xqlite files";
            }
        }
        ,
        METADATA_TORRENT{

            public String getLabel() {
                return "Metadata | .torrent files";
            }
        }
        ,
        THUMBNAIL{

            public String getLabel() {
                return "Thumbnails";
            }
        }
        ,
        DERIVATIVE_COVER{

            public String getLabel() {
                return "Decorative covers";
            }
        }
        ,
        DERIVATIVE_SPECTROGRAM{

            public String getLabel() {
                return "Spectogram";
            }
        }
        ,
        DERIVATIVE_PEAKS{

            public String getLabel() {
                return "Columbia Peaks | .afpk audio fingerprint files";
            }
        };

    }

    public static class DefaultFileCrawlerTypesToCrawl
    extends AbstractDefaultFactory<Set<ArchiveOrgType>> {
        public Set<ArchiveOrgType> getDefaultValue(KeyHandler<Set<ArchiveOrgType>> keyHandler) {
            return new HashSet<ArchiveOrgType>(Arrays.asList(ArchiveOrgType.values()));
        }
    }

    public static class TRANSLATION {
        public String getFileCrawlerTypesToCrawl_label() {
            return "File crawler: Select types to crawl";
        }

        public String getDeselectedTypesLinksMode_label() {
            return "File crawler: How to treat links of deselected types?";
        }

        public String getSingleFilePathNotFoundMode_label() {
            return "File crawler: What to do when single file/folder-path is not found?";
        }

        public String getSingleFileAdoptFolderStructureMode_label() {
            return "File crawler: Single files: Adopt folder structure mode";
        }

        public String getPlaylistFilenameScheme_label() {
            return "Playlist filename scheme";
        }

        public String getBookImageQuality_label() {
            return "Book image quality (0 = highest, 10 = lowest)";
        }

        public String getBookCrawlMode_label() {
            return "Book crawl mode: Which items to return if the added link is a book?";
        }

        public String getNonDownloadableBookPagesMode_label() {
            return "How to display non downloadable book pages in linkgrabber?";
        }

        public String getPlaylistCrawlMode202404_label() {
            return "Playlist crawl mode: Which files to add if the added link is a audio/video playlist?";
        }

        public String getSearchTermCrawlerMaxResultsLimit_label() {
            return "Search term and profile crawler: Limit max results [0 = disable this crawler]";
        }
    }
}

