/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.captchasolver;

import java.util.List;
import jd.PluginWrapper;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.CaptchaType;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.DebugMode;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.PluginChallengeSolver;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.plugins.controller.LazyPlugin;

public abstract class abstractPluginForCaptchaSolver
extends PluginForHost {
    protected boolean enoughBalanceFor(Challenge<?> c, Account account) throws Exception {
        return true;
    }

    public final boolean canHandle(Challenge<?> c) {
        if (!this.validateBlackWhite(c)) {
            return false;
        }
        List<CaptchaType.CAPTCHA_TYPE> supportedTypes = this.getSupportedCaptchaTypes();
        for (CaptchaType.CAPTCHA_TYPE supportedType : supportedTypes) {
            if (!supportedType.canHandle(c)) continue;
            return true;
        }
        return false;
    }

    public <T> PluginChallengeSolver<T> getPluginChallengeSolver(Challenge<T> c, Account account) throws Exception {
        abstractPluginForCaptchaSolver plugin = (abstractPluginForCaptchaSolver)this.getNewPluginInstance(this.getLazyP());
        plugin.setBrowser(plugin.createNewBrowserInstance());
        return new PluginChallengeSolver(plugin, account);
    }

    public abstractPluginForCaptchaSolver(PluginWrapper wrapper) {
        super(wrapper);
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            this.enablePremium(this.getBuyPremiumUrl());
        }
    }

    @Override
    public LazyPlugin.FEATURE[] getFeatures() {
        return new LazyPlugin.FEATURE[]{LazyPlugin.FEATURE.CAPTCHA_SOLVER, LazyPlugin.FEATURE.BUBBLE_NOTIFICATION};
    }

    @Override
    public abstract String getBuyPremiumUrl();

    public abstract boolean setInvalid(AbstractResponse<?> var1, Account var2) throws Exception;

    public abstract boolean setValid(AbstractResponse<?> var1, Account var2) throws Exception;

    public boolean setUnused(AbstractResponse<?> response, Account account) throws Exception {
        return false;
    }

    public abstract List<CaptchaType.CAPTCHA_TYPE> getSupportedCaptchaTypes();

    protected boolean notifyOnLowBalance(Account account) {
        return true;
    }

    public int getPollingIntervalMillis(Account account) {
        return 5000;
    }

    protected int getMaxSimultaneousCaptchas(Account account) {
        return Integer.MAX_VALUE;
    }

    protected List<String> getBlacklistedDomains(Account account) {
        return null;
    }

    protected List<String> getWhitelistedDomains(Account account) {
        return null;
    }

    @Override
    public abstract AccountInfo fetchAccountInfo(Account var1) throws Exception;

    public abstract void solve(CESSolverJob<?> var1, Account var2) throws Exception;

    public boolean validateBlackWhite(Challenge<?> c) {
        return true;
    }

    protected static void checkInterruption() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public DownloadLink.AvailableStatus requestFileInformation(DownloadLink parameter) throws Exception {
        throw new WTFException();
    }

    @Override
    public void handleFree(DownloadLink link) throws Exception {
        throw new WTFException();
    }
}

