/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.captchasolver;

import java.io.IOException;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jd.PluginWrapper;
import jd.controlling.captcha.SkipException;
import jd.http.Browser;
import jd.http.Request;
import jd.http.requests.PostRequest;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountInvalidException;
import jd.plugins.AccountUnavailableException;
import jd.plugins.HostPlugin;
import jd.plugins.PluginException;
import org.appwork.storage.JSonMapperException;
import org.appwork.storage.TypeRef;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.SolverStatus;
import org.jdownloader.captcha.v2.challenge.clickcaptcha.ClickCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.clickcaptcha.ClickedPoint;
import org.jdownloader.captcha.v2.challenge.cloudflareturnstile.CloudflareTurnstileChallenge;
import org.jdownloader.captcha.v2.challenge.cutcaptcha.CutCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.hcaptcha.AbstractHCaptcha;
import org.jdownloader.captcha.v2.challenge.hcaptcha.HCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.multiclickcaptcha.MultiClickCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.multiclickcaptcha.MultiClickedPoint;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.AbstractRecaptchaV2;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.CaptchaResponse;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ClickCaptchaResponse;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ImageCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.MultiClickCaptchaResponse;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.TokenCaptchaResponse;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaResponse;
import org.jdownloader.plugins.components.captchasolver.abstractPluginForCaptchaSolver;
import org.jdownloader.plugins.controller.LazyPlugin;

@HostPlugin(revision="$Revision: 50799 $", interfaceVersion=3, names={"2captcha.com"}, urls={""})
public abstract class abstractPluginForCaptchaSolverTwoCaptchaAPIV2
extends abstractPluginForCaptchaSolver {
    @Override
    public LazyPlugin.FEATURE[] getFeatures() {
        return new LazyPlugin.FEATURE[]{LazyPlugin.FEATURE.CAPTCHA_SOLVER, LazyPlugin.FEATURE.BUBBLE_NOTIFICATION, LazyPlugin.FEATURE.API_KEY_LOGIN};
    }

    public abstractPluginForCaptchaSolverTwoCaptchaAPIV2(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Override
    public abstract String getBuyPremiumUrl();

    @Override
    public AccountInfo fetchAccountInfo(Account account) throws Exception {
        HashMap<String, String> postdata = new HashMap<String, String>();
        postdata.put("clientKey", account.getPass());
        PostRequest req = this.br.createJSonPostRequest(this.getApiBase() + "/getBalance", postdata);
        this.br.getPage((Request)req);
        Map<String, Object> entries = this.handleAPIErrors(this.br, account);
        double balance = ((Number)ReflectionUtils.cast((Object)entries.get("balance"), Double.class)).doubleValue();
        AccountInfo ai = new AccountInfo();
        ai.setAccountBalance(balance, Currency.getInstance("USD"));
        return ai;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void solve(CESSolverJob<?> job, Account account) throws InterruptedException, SolverException, SkipException {
        Challenge<String> captchachallenge = job.getChallenge();
        job.setStatus(SolverStatus.UPLOADING);
        try {
            Challenge challenge;
            HashMap<String, Object> postdata = new HashMap<String, Object>();
            String apikey = account.getPass();
            postdata.put("clientKey", apikey);
            HashMap<String, Object> task = new HashMap<String, Object>();
            if (captchachallenge instanceof RecaptchaV2Challenge) {
                challenge = (RecaptchaV2Challenge)job.getChallenge();
                task.put("type", "RecaptchaV2TaskProxyless");
                task.put("websiteKey", ((RecaptchaV2Challenge)challenge).getSiteKey());
                task.put("websiteURL", ((RecaptchaV2Challenge)challenge).getSiteUrl());
                Map<String, Object> action = ((RecaptchaV2Challenge)challenge).getV3Action();
                if (((RecaptchaV2Challenge)challenge).isV3() || action != null) {
                    task.put("type", "RecaptchaV3TaskProxyless");
                    task.put("isEnterprise", ((RecaptchaV2Challenge)challenge).isEnterprise());
                } else if (((RecaptchaV2Challenge)challenge).isEnterprise()) {
                    task.put("type", "RecaptchaV2EnterpriseTaskProxyless");
                }
                if (action != null) {
                    task.put("pageAction", action.get("action"));
                }
                task.put("isInvisible", AbstractRecaptchaV2.TYPE.INVISIBLE.equals(((RecaptchaV2Challenge)challenge).getType()));
                Double minScore = ((RecaptchaV2Challenge)challenge).getMinScore();
                if (minScore != null) {
                    task.put("minScore", minScore);
                }
                if (account.getHoster().equals("2captcha.com") && ((RecaptchaV2Challenge)challenge).isEnterprise() && StringUtils.containsIgnoreCase((String)((RecaptchaV2Challenge)challenge).getSiteUrl(), (String)"filer.net")) {
                    task.put("type", "RecaptchaV2EnterpriseTaskProxyless");
                }
            } else if (captchachallenge instanceof HCaptchaChallenge) {
                challenge = (HCaptchaChallenge)captchachallenge;
                task.put("type", "HCaptchaTaskProxyless");
                task.put("websiteURL", ((HCaptchaChallenge)challenge).getSiteUrl());
                task.put("websiteKey", ((HCaptchaChallenge)challenge).getSiteKey());
                AbstractHCaptcha<?> hCaptcha = ((HCaptchaChallenge)challenge).getAbstractCaptchaHelperHCaptcha();
                if (hCaptcha != null && AbstractHCaptcha.TYPE.INVISIBLE.equals((Object)hCaptcha.getType())) {
                    task.put("isInvisible", true);
                }
            } else if (captchachallenge instanceof CutCaptchaChallenge) {
                challenge = (CutCaptchaChallenge)captchachallenge;
                task.put("type", "CutCaptchaTaskProxyless");
                task.put("miseryKey", ((CutCaptchaChallenge)challenge).getSiteKey());
                task.put("apiKey", ((CutCaptchaChallenge)challenge).getApiKey());
                task.put("websiteURL", ((CutCaptchaChallenge)challenge).getSiteUrl());
            } else if (captchachallenge instanceof CloudflareTurnstileChallenge) {
                challenge = (CloudflareTurnstileChallenge)captchachallenge;
                task.put("type", "TurnstileTaskProxyless");
                task.put("websiteURL", ((CloudflareTurnstileChallenge)challenge).getSiteUrl());
                task.put("websiteKey", ((CloudflareTurnstileChallenge)challenge).getSiteKey());
            } else if (captchachallenge instanceof ClickCaptchaChallenge) {
                challenge = (ClickCaptchaChallenge)captchachallenge;
                task.put("type", "CoordinatesTask");
                task.put("body", ((ImageCaptchaChallenge)challenge).getBase64ImageFile());
                task.put("minClicks", 1);
                task.put("maxClicks", 1);
            } else if (captchachallenge instanceof MultiClickCaptchaChallenge) {
                challenge = (MultiClickCaptchaChallenge)captchachallenge;
                task.put("type", "CoordinatesTask");
                task.put("body", ((ImageCaptchaChallenge)challenge).getBase64ImageFile());
                task.put("minClicks", 1);
                if (((MultiClickCaptchaChallenge)challenge).getMaxClicks() != -1) {
                    task.put("maxClicks", ((MultiClickCaptchaChallenge)challenge).getMaxClicks());
                }
            } else if (captchachallenge instanceof ImageCaptchaChallenge) {
                challenge = (ImageCaptchaChallenge)job.getChallenge();
                task.put("type", "ImageToTextTask");
                task.put("body", ((ImageCaptchaChallenge)challenge).getBase64ImageFile());
            } else {
                throw new IllegalArgumentException("Unexpected captcha challenge type");
            }
            if (captchachallenge.getExplain() != null) {
                task.put("comment", captchachallenge.getExplain());
            }
            postdata.put("task", task);
            PostRequest req_createTask = this.br.createJSonPostRequest(this.getApiBase() + "/createTask", postdata);
            this.br.getPage((Request)req_createTask);
            Map<String, Object> entries = this.handleAPIErrors(this.br, this.getCurrentAccount());
            String id = entries.get("taskId").toString();
            HashMap<String, String> postdata_getTaskResult = new HashMap<String, String>();
            postdata_getTaskResult.put("clientKey", apikey);
            postdata_getTaskResult.put("taskId", id);
            job.setStatus(SolverStatus.SOLVING);
            while (job.getJob().isAlive() && !job.getJob().isSolved()) {
                abstractPluginForCaptchaSolverTwoCaptchaAPIV2.checkInterruption();
                PostRequest req_getTaskResult = this.br.createJSonPostRequest(this.getApiBase() + "/getTaskResult", postdata_getTaskResult);
                this.br.getPage((Request)req_getTaskResult);
                entries = this.handleAPIErrors(this.br, this.getCurrentAccount());
                this.logger.info(this.br.getRequest().getHtmlCode());
                String status = entries.get("status").toString();
                if (status.equalsIgnoreCase("processing")) {
                    Thread.sleep(this.getPollingIntervalMillis(account));
                    continue;
                }
                if (!status.equalsIgnoreCase("ready")) {
                    throw new PluginException(0x400000);
                }
                Map solutionmap = (Map)entries.get("solution");
                List clicklist = (List)solutionmap.get("coordinates");
                String token = (String)solutionmap.get("token");
                AbstractResponse resp = null;
                if (captchachallenge instanceof RecaptchaV2Challenge || captchachallenge instanceof HCaptchaChallenge || captchachallenge instanceof CloudflareTurnstileChallenge || captchachallenge instanceof CutCaptchaChallenge) {
                    resp = new TokenCaptchaResponse(captchachallenge, (Object)this, token, 0);
                } else if (captchachallenge instanceof MultiClickCaptchaChallenge || captchachallenge instanceof ClickCaptchaChallenge) {
                    int[] x = new int[clicklist.size()];
                    int[] y = new int[clicklist.size()];
                    int i = 0;
                    for (Map clicks : clicklist) {
                        x[i] = ((Number)clicks.get("x")).intValue();
                        y[i] = ((Number)clicks.get("y")).intValue();
                        ++i;
                    }
                    if (captchachallenge instanceof MultiClickCaptchaChallenge) {
                        MultiClickedPoint mcp = new MultiClickedPoint(x, y);
                        MultiClickCaptchaChallenge challenge2 = (MultiClickCaptchaChallenge)captchachallenge;
                        resp = new MultiClickCaptchaResponse(challenge2, (Object)this, mcp, 0);
                    } else {
                        ClickCaptchaChallenge challenge3 = (ClickCaptchaChallenge)captchachallenge;
                        ClickedPoint cp = new ClickedPoint(x[0], y[0]);
                        resp = new ClickCaptchaResponse(challenge3, (Object)this, cp, 0);
                    }
                } else {
                    resp = new CaptchaResponse(captchachallenge, (Object)this, solutionmap.get("text").toString(), 0);
                }
                if (resp == null) {
                    throw new IllegalArgumentException();
                }
                resp.setCaptchaSolverTaskID(id);
                job.setAnswer(resp);
                return;
            }
        }
        catch (IOException e) {
            job.getLogger().log((Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.out.println(1);
        }
    }

    @Override
    public boolean setInvalid(AbstractResponse<?> response, Account account) {
        return this.sendCaptchaFeedback(response, account, false);
    }

    @Override
    public boolean setValid(AbstractResponse<?> response, Account account) {
        return this.sendCaptchaFeedback(response, account, true);
    }

    private final boolean sendCaptchaFeedback(AbstractResponse<?> response, Account account, boolean positiveFeedback) {
        TwoCaptchaResponse twocaptcharesponse = (TwoCaptchaResponse)response;
        String captchaID = twocaptcharesponse.getCaptchaID();
        try {
            String url = positiveFeedback ? "/reportCorrect" : "/reportIncorrect";
            HashMap<String, String> postdata = new HashMap<String, String>();
            postdata.put("clientKey", account.getPass());
            postdata.put("taskId", captchaID);
            PostRequest req = this.br.createJSonPostRequest(this.getApiBase() + url, postdata);
            this.br.getPage((Request)req);
            Map<String, Object> entries = this.handleAPIErrors(this.br, account);
            String status = entries.get("status").toString();
            return status.equalsIgnoreCase("success");
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private Map<String, Object> handleAPIErrors(Browser br, Account account) throws Exception {
        Map entries = null;
        try {
            entries = (Map)this.restoreFromString(br.getRequest().getHtmlCode(), TypeRef.MAP);
        }
        catch (JSonMapperException ignore) {
            String msg = "Invalid API response";
            long wait = 60000L;
            throw new AccountUnavailableException("Invalid API response", 60000L);
        }
        HashSet<String> accountErrorsPermament = new HashSet<String>();
        accountErrorsPermament.add("ERROR_KEY_DOES_NOT_EXIST");
        accountErrorsPermament.add("ERROR_ZERO_BALANCE");
        accountErrorsPermament.add("ERROR_NO_SUCH_METHOD");
        accountErrorsPermament.add("ERROR_ACCOUNT_SUSPENDED");
        HashSet<String> accountErrorsTemp = new HashSet<String>();
        accountErrorsTemp.add("ERROR_NO_SLOT_AVAILABLE");
        accountErrorsTemp.add("ERROR_IP_NOT_ALLOWED");
        accountErrorsTemp.add("ERROR_IP_BLOCKED");
        HashSet<String> captchaErrors = new HashSet<String>();
        captchaErrors.add("ERROR_ZERO_CAPTCHA_FILESIZE");
        captchaErrors.add("ERROR_TOO_BIG_CAPTCHA_FILESIZE");
        captchaErrors.add("ERROR_CAPTCHA_UNSOLVABLE");
        captchaErrors.add("ERROR_BAD_DUPLICATES");
        captchaErrors.add("ERROR_IMAGE_TYPE_NOT_SUPPORTED");
        captchaErrors.add("ERROR_NO_SUCH_CAPCHA_ID");
        captchaErrors.add("ERROR_TASK_ABSENT");
        captchaErrors.add("ERROR_TASK_NOT_SUPPORTED");
        captchaErrors.add("ERROR_RECAPTCHA_INVALID_SITEKEY");
        captchaErrors.add("ERROR_BAD_PROXY");
        captchaErrors.add("ERROR_BAD_PARAMETERS");
        captchaErrors.add("ERROR_BAD_IMGINSTRUCTIONS");
        int errorId = ((Number)entries.get("errorId")).intValue();
        if (errorId == 0) {
            return entries;
        }
        String errorCode = entries.get("errorCode").toString();
        String errorDescription = entries.get("errorDescription").toString();
        if (accountErrorsPermament.contains(errorCode)) {
            throw new AccountInvalidException(errorDescription);
        }
        if (accountErrorsTemp.contains(errorCode)) {
            throw new AccountUnavailableException(errorDescription, 300000L);
        }
        throw new PluginException(8);
    }

    protected String getApiBase() {
        return "https://api." + this.getHost();
    }

    @Override
    public abstract String getAGBLink();

    @Override
    protected boolean looksLikeValidAPIKey(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("[a-f0-9]{32}");
    }

    @Override
    protected abstract String getAPILoginHelpURL();
}

