/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultDoubleValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.DoubleSpinnerValidator;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="2captcha.com", type=Type.HOSTER)
public interface CaptchaSolverPluginConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @DescriptionForConfigEntry(value="Polling interval in seconds for captcha status checks")
    @SpinnerValidator(min=2L, max=300L, step=1L)
    @DefaultIntValue(value=5)
    @Order(value=10)
    public int getPollingIntervalSeconds();

    public void setPollingIntervalSeconds(int var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Send correct/incorrect captcha feedback to 2captcha service to improve recognition accuracy")
    @DefaultBooleanValue(value=true)
    @Order(value=20)
    public boolean isEnableCaptchaFeedback();

    public void setEnableCaptchaFeedback(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Display a warning when account credits fall below the specified threshold")
    @DefaultBooleanValue(value=true)
    @Order(value=30)
    public boolean isWarnOnLowCredits();

    public void setWarnOnLowCredits(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Minimum credit balance before warning is displayed (in currency of captcha solver service)")
    @DoubleSpinnerValidator(min=0.1, max=10.0, step=0.1)
    @DefaultDoubleValue(value=0.5)
    @Order(value=35)
    public double getLowCreditsWarningThreshold();

    public void setLowCreditsWarningThreshold(double var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Maximum number of captchas to solve in parallel")
    @SpinnerValidator(min=1L, max=100L, step=1L)
    @DefaultIntValue(value=1)
    @Order(value=40)
    public int getMaxParallelCaptchas();

    public void setMaxParallelCaptchas(int var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Comma-separated list of domains where captcha solving is enabled (leave empty to allow all domains)")
    @DefaultStringValue(value="")
    @Order(value=50)
    public String getDomainWhitelist();

    public void setDomainWhitelist(String var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Comma-separated list of domains where captcha solving is disabled")
    @DefaultStringValue(value="")
    @Order(value=60)
    public String getDomainBlacklist();

    public void setDomainBlacklist(String var1);

    public static class TRANSLATION {
        public String getPollingIntervalSeconds_label() {
            return "Polling interval in seconds";
        }

        public String getEnableCaptchaFeedback_label() {
            return "Report correct/incorrect captcha feedback to captcha service";
        }

        public String getWarnOnLowCredits_label() {
            return "Warn on low credits";
        }

        public String getLowCreditsWarningThreshold_label() {
            return "Low credits warning threshold (in currency of captcha solver service)";
        }

        public String getMaxParallelCaptchas_label() {
            return "Max parallel captchas";
        }

        public String getDomainWhitelist_label() {
            return "Domain whitelist";
        }

        public String getDomainBlacklist_label() {
            return "Domain blacklist";
        }
    }
}

