/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="eporner.com", type=Type.HOSTER)
public interface EpornerComConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();
    public static final PreferredVideoCodec defaultPreferredVideoCodec = PreferredVideoCodec.H264;

    @AboutConfig
    @DefaultEnumValue(value="BEST")
    @DescriptionForConfigEntry(value="If your preferred stream quality is not found, best quality will be downloaded instead.")
    @Order(value=100)
    public PreferredStreamQuality getPreferredStreamQuality();

    public void setPreferredStreamQuality(PreferredStreamQuality var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @DescriptionForConfigEntry(value="If your video codec is not found, first/random codec will be used.")
    @Order(value=110)
    public PreferredVideoCodec getPreferredVideoCodec();

    public void setPreferredVideoCodec(PreferredVideoCodec var1);

    public static enum PreferredVideoCodec implements LabelInterface
    {
        AV1{

            public String getLabel() {
                return "AV1";
            }
        }
        ,
        H264{

            public String getLabel() {
                return "H.264";
            }
        }
        ,
        DEFAULT{

            public String getLabel() {
                return "Default: " + defaultPreferredVideoCodec.getLabel();
            }
        };

    }

    public static enum PreferredStreamQuality implements LabelInterface
    {
        BEST{

            public String getLabel() {
                return "Best";
            }
        }
        ,
        Q240P{

            public String getLabel() {
                return "240p";
            }
        }
        ,
        Q360P{

            public String getLabel() {
                return "360p";
            }
        }
        ,
        Q480P{

            public String getLabel() {
                return "480p";
            }
        }
        ,
        Q720P{

            public String getLabel() {
                return "720p";
            }
        }
        ,
        Q1080P{

            public String getLabel() {
                return "1080p";
            }
        }
        ,
        Q1440P{

            public String getLabel() {
                return "1440p";
            }
        }
        ,
        Q2160P{

            public String getLabel() {
                return "2160p (4k)";
            }
        };

    }

    public static class TRANSLATION {
        public String getPreferredStreamQuality_label() {
            return "Preferred quality";
        }

        public String getPreferredVideoCodec_label() {
            return "Preferred video codec";
        }
    }
}

