/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="pluralsight.com", type=Type.CRAWLER)
public interface PluralsightComConfig
extends PluginConfigInterface {
    public static final String text_CrawlSubtitles = "Crawl subtitles?";
    public static final String text_UserAgent = "User-Agent which will be used for all website http requests:";
    public static final String text_WaittimeBetweenDownloadsSeconds = "Wait time in seconds between downloads";
    public static final String text_WaitMode = "Wait between downloads mode";
    public static final String text_AddRandomDelaySecondsBetweenDownloads = "Add random delay in seconds to wait time between downloads?";
    public static final String text_AdditionalWaittimeBetweenDownloadsMaxSeconds = "Max additional random wait seconds between downloads";
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Crawl subtitles?")
    @Order(value=5)
    public boolean isCrawlSubtitles();

    public void setCrawlSubtitles(boolean var1);

    @AboutConfig
    @DefaultStringValue(value="JDDEFAULT")
    @DescriptionForConfigEntry(value="User-Agent which will be used for all website http requests:")
    @Order(value=10)
    public String getUserAgent();

    public void setUserAgent(String var1);

    @AboutConfig
    @DefaultEnumValue(value="LENGTH_OF_PREVIOUSLY_DOWNLOADED_VIDEO")
    @Order(value=15)
    @DescriptionForConfigEntry(value="Wait between downloads mode")
    public WaitMode getWaitMode();

    public void setWaitMode(WaitMode var1);

    @AboutConfig
    @DefaultIntValue(value=120)
    @SpinnerValidator(min=90L, max=900L, step=1L)
    @Order(value=20)
    @DescriptionForConfigEntry(value="Wait time in seconds between downloads")
    public int getWaittimeBetweenDownloadsSeconds();

    public void setWaittimeBetweenDownloadsSeconds(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @Order(value=40)
    @DescriptionForConfigEntry(value="Add random delay in seconds to wait time between downloads?")
    public boolean isAddRandomDelaySecondsBetweenDownloads();

    public void setAddRandomDelaySecondsBetweenDownloads(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=30)
    @SpinnerValidator(min=0L, max=120L, step=1L)
    @Order(value=50)
    @DescriptionForConfigEntry(value="Max additional random wait seconds between downloads")
    public int getAdditionalWaittimeBetweenDownloadsMaxSeconds();

    public void setAdditionalWaittimeBetweenDownloadsMaxSeconds(int var1);

    public static enum WaitMode implements LabelInterface
    {
        LENGTH_OF_PREVIOUSLY_DOWNLOADED_VIDEO{

            public String getLabel() {
                return "Length of previously downloaded video";
            }
        }
        ,
        CUSTOM_WAIT{

            public String getLabel() {
                return "Custom wait time";
            }
        }
        ,
        LENGTH_OF_PREVIOUSLY_DOWNLOADED_VIDEO_AND_CUSTOM_WAIT{

            public String getLabel() {
                return "Length of previously downloaded video and custom wait";
            }
        };

    }

    public static class TRANSLATION {
        public String getCrawlSubtitles_label() {
            return PluralsightComConfig.text_CrawlSubtitles;
        }

        public String getUserAgent_label() {
            return PluralsightComConfig.text_UserAgent;
        }

        public String getWaitMode_label() {
            return PluralsightComConfig.text_WaitMode;
        }

        public String getWaittimeBetweenDownloadsSeconds_label() {
            return PluralsightComConfig.text_WaittimeBetweenDownloadsSeconds;
        }

        public String getAddRandomDelaySecondsBetweenDownloads_label() {
            return PluralsightComConfig.text_AddRandomDelaySecondsBetweenDownloads;
        }

        public String getAdditionalWaittimeBetweenDownloadsMaxSeconds_label() {
            return PluralsightComConfig.text_AdditionalWaittimeBetweenDownloadsMaxSeconds;
        }
    }
}

