/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="tiktok.com", type=Type.HOSTER)
public interface TiktokConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();
    public static final String text_EnableFastLinkcheck = "Enable fast linkcheck? If enabled, filenames may contain less information in website mode and filesize might be missing until download is started.";
    public static final String text_MaxSimultaneousDownloads = "Set max. simultaneous downloads. The higher the value the higher is the chance that your IP gets blocked by tiktok!";
    public static final String text_MediaCrawlMode = "Media crawl mode";
    public static final String text_ProfileCrawlMode = "Profile crawl mode";
    public static final String text_AddDummyURLProfileCrawlerWebsiteModeMissingPagination = "Profile crawler website mode: Add dummy URL when user profile is crawled and crawler fails to find all items due to missing pagination support?";
    public static final String text_ProfileCrawlerMaxItemsLimit = "Profile crawler: Define max number of items to be fetched: 0 = disable profile crawler, -1 = fetch all items";
    public static final String text_TagCrawlerMaxItemsLimit = "Tag crawler: Define max number of items to be fetched: 0 = disable tag crawler, -1 = fetch all items";
    public static final String text_VideoCrawlerCrawlAudioSeparately = "Video crawler: Crawl soundtrack separately?";
    public static final String text_ImageCrawlerCrawlImagesWithoutWatermark = "Image crawler: Crawl images without watermark?";
    public static final String text_PreferredImageFormat = "Image crawler: Choose preferred image format";
    public static final MediaCrawlMode defaultMediaCrawlMode = MediaCrawlMode.AUTO;

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Enable fast linkcheck? If enabled, filenames may contain less information in website mode and filesize might be missing until download is started.")
    @Order(value=10)
    public boolean isEnableFastLinkcheck();

    public void setEnableFastLinkcheck(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=1)
    @SpinnerValidator(min=1L, max=20L, step=1L)
    @Order(value=20)
    @DescriptionForConfigEntry(value="Set max. simultaneous downloads. The higher the value the higher is the chance that your IP gets blocked by tiktok!")
    public int getMaxSimultaneousDownloads();

    public void setMaxSimultaneousDownloads(int var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @Order(value=40)
    @DescriptionForConfigEntry(value="Media crawl mode")
    public MediaCrawlMode getMediaCrawlModeV2();

    public void setMediaCrawlModeV2(MediaCrawlMode var1);

    @AboutConfig
    @DefaultEnumValue(value="API")
    @Order(value=50)
    @DescriptionForConfigEntry(value="Profile crawl mode")
    public ProfileCrawlMode getProfileCrawlMode();

    public void setProfileCrawlMode(ProfileCrawlMode var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Profile crawler website mode: Add dummy URL when user profile is crawled and crawler fails to find all items due to missing pagination support?")
    @Order(value=55)
    public boolean isAddDummyURLProfileCrawlerWebsiteModeMissingPagination();

    public void setAddDummyURLProfileCrawlerWebsiteModeMissingPagination(boolean var1);

    @AboutConfig
    @SpinnerValidator(min=-1L, max=10000L, step=25L)
    @DefaultIntValue(value=-1)
    @DescriptionForConfigEntry(value="Profile crawler: Define max number of items to be fetched: 0 = disable profile crawler, -1 = fetch all items")
    @Order(value=60)
    public int getProfileCrawlerMaxItemsLimit();

    public void setProfileCrawlerMaxItemsLimit(int var1);

    @AboutConfig
    @SpinnerValidator(min=-1L, max=10000L, step=20L)
    @DefaultIntValue(value=20)
    @DescriptionForConfigEntry(value="Tag crawler: Define max number of items to be fetched: 0 = disable tag crawler, -1 = fetch all items")
    @Order(value=70)
    public int getTagCrawlerMaxItemsLimit();

    public void setTagCrawlerMaxItemsLimit(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Video crawler: Crawl soundtrack separately?")
    @Order(value=80)
    public boolean isVideoCrawlerCrawlAudioSeparately();

    public void setVideoCrawlerCrawlAudioSeparately(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Image crawler: Crawl images without watermark?")
    @Order(value=90)
    public boolean isImageCrawlerCrawlImagesWithoutWatermark();

    public void setImageCrawlerCrawlImagesWithoutWatermark(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="JPEG")
    @Order(value=91)
    @DescriptionForConfigEntry(value="Image crawler: Choose preferred image format")
    public ImageFormat getPreferredImageFormat();

    public void setPreferredImageFormat(ImageFormat var1);

    public static enum ImageFormat implements LabelInterface
    {
        JPEG{

            public String getLabel() {
                return "jpeg";
            }
        }
        ,
        WEBP{

            public String getLabel() {
                return "webp";
            }
        };

    }

    public static enum ProfileCrawlMode implements LabelInterface
    {
        WEBSITE{

            public String getLabel() {
                return "[!BROKEN!] Website [Max first ~30 items, also private profiles]";
            }
        }
        ,
        API{

            public String getLabel() {
                return "[!BROKEN!] API [All items, only public profiles]";
            }
        };

    }

    public static enum MediaCrawlMode implements LabelInterface
    {
        DEFAULT{

            public String getLabel() {
                return "Default: " + defaultMediaCrawlMode.getLabel();
            }
        }
        ,
        AUTO{

            public String getLabel() {
                return "Auto";
            }
        }
        ,
        WEBSITE{

            public String getLabel() {
                return "Website [Usually without watermark, also private videos if account is given]";
            }
        }
        ,
        WEBSITE_EMBED{

            public String getLabel() {
                return "Website embed [Usually with watermark, also private videos if account is given]";
            }
        }
        ,
        API{

            public String getLabel() {
                return "[!BROKEN!] API [Without watermark, only public videos]";
            }
        };

    }

    public static class TRANSLATION {
        public String getEnableFastLinkcheck_label() {
            return TiktokConfig.text_EnableFastLinkcheck;
        }

        public String getMaxSimultaneousDownloads_label() {
            return TiktokConfig.text_MaxSimultaneousDownloads;
        }

        public String getMediaCrawlModeV2_label() {
            return TiktokConfig.text_MediaCrawlMode;
        }

        public String getProfileCrawlMode_label() {
            return TiktokConfig.text_ProfileCrawlMode;
        }

        public String getAddDummyURLProfileCrawlerWebsiteModeMissingPagination_label() {
            return TiktokConfig.text_AddDummyURLProfileCrawlerWebsiteModeMissingPagination;
        }

        public String getProfileCrawlerMaxItemsLimit_label() {
            return TiktokConfig.text_ProfileCrawlerMaxItemsLimit;
        }

        public String getTagCrawlerMaxItemsLimit_label() {
            return TiktokConfig.text_TagCrawlerMaxItemsLimit;
        }

        public String getVideoCrawlerCrawlAudioSeparately_label() {
            return TiktokConfig.text_VideoCrawlerCrawlAudioSeparately;
        }

        public String getImageCrawlerCrawlImagesWithoutWatermark_label() {
            return TiktokConfig.text_ImageCrawlerCrawlImagesWithoutWatermark;
        }

        public String getPreferredImageFormat_label() {
            return TiktokConfig.text_PreferredImageFormat;
        }
    }
}

