/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="uptobox.com", type=Type.HOSTER)
public interface UpToBoxComConfig
extends PluginConfigInterface {
    public static final String text_PreferredQuality = "If your preferred quality is not found, original/best will be downloaded instead. Only works for content also available on uptostream! Only works if you own a premium account!";
    public static final String text_GrabSubtitle = "[Premium only] Crawl subtitle?";
    public static final String text_UseHTTPSForDownloads = "Use https for final downloadurls?";
    public static final String text_PreferredDomain = "Preferred domain";
    public static final String text_CustomDomain = "Define custom preferred domain. If given this will be preferred over the above selection";
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @DescriptionForConfigEntry(value="If your preferred quality is not found, original/best will be downloaded instead. Only works for content also available on uptostream! Only works if you own a premium account!")
    @Order(value=40)
    public PreferredQuality getPreferredQuality();

    public void setPreferredQuality(PreferredQuality var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="[Premium only] Crawl subtitle?")
    @Order(value=50)
    public boolean isGrabSubtitle();

    public void setGrabSubtitle(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Use https for final downloadurls?")
    @Order(value=60)
    public boolean isUseHTTPSForDownloads();

    public void setUseHTTPSForDownloads(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @DefaultOnNull
    @DescriptionForConfigEntry(value="Preferred domain")
    @Order(value=70)
    public PreferredDomain getPreferredDomain();

    public void setPreferredDomain(PreferredDomain var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Define custom preferred domain. If given this will be preferred over the above selection")
    @Order(value=80)
    public String getCustomDomain();

    public void setCustomDomain(String var1);

    public static enum PreferredDomain implements LabelInterface
    {
        DEFAULT{

            public String getLabel() {
                return "default (= " + this.getDomain() + ")";
            }

            @Override
            public String getDomain() {
                return UPTOBOXEU.getDomain();
            }
        }
        ,
        CUSTOM{

            public String getLabel() {
                return "custom";
            }

            @Override
            public String getDomain() {
                return null;
            }
        }
        ,
        UPTOBOXEU{

            public String getLabel() {
                return this.getDomain();
            }

            @Override
            public String getDomain() {
                return "uptobox.eu";
            }
        }
        ,
        UPTOBOXCOM{

            public String getLabel() {
                return this.getDomain();
            }

            @Override
            public String getDomain() {
                return "uptobox.com";
            }
        }
        ,
        UPTOBOXFR{

            public String getLabel() {
                return this.getDomain();
            }

            @Override
            public String getDomain() {
                return "uptobox.fr";
            }
        }
        ,
        UPTOBOXLINK{

            public String getLabel() {
                return this.getDomain();
            }

            @Override
            public String getDomain() {
                return "uptobox.link";
            }
        }
        ,
        UPTOSTREAMCOM{

            public String getLabel() {
                return this.getDomain();
            }

            @Override
            public String getDomain() {
                return "uptostream.com";
            }
        }
        ,
        UPTOSTREAMFR{

            public String getLabel() {
                return this.getDomain();
            }

            @Override
            public String getDomain() {
                return "uptostream.fr";
            }
        }
        ,
        UPTOSTREAMEU{

            public String getLabel() {
                return this.getDomain();
            }

            @Override
            public String getDomain() {
                return "uptostream.eu";
            }
        };


        public abstract String getDomain();
    }

    public static enum PreferredQuality implements LabelInterface
    {
        DEFAULT{

            public String getLabel() {
                return "Source/Original/Best";
            }
        }
        ,
        QUALITY1{

            public String getLabel() {
                return "360p";
            }
        }
        ,
        QUALITY2{

            public String getLabel() {
                return "480p";
            }
        }
        ,
        QUALITY3{

            public String getLabel() {
                return "720p";
            }
        }
        ,
        QUALITY4{

            public String getLabel() {
                return "1080p";
            }
        }
        ,
        QUALITY5{

            public String getLabel() {
                return "2160p (4k)";
            }
        };

    }

    public static class TRANSLATION {
        public String getPreferredQuality_label() {
            return UpToBoxComConfig.text_PreferredQuality;
        }

        public String getGrabSubtitle_label() {
            return UpToBoxComConfig.text_GrabSubtitle;
        }

        public String getUseHTTPSForDownloads_label() {
            return UpToBoxComConfig.text_UseHTTPSForDownloads;
        }

        public String getPreferredDomain_label() {
            return UpToBoxComConfig.text_PreferredDomain;
        }

        public String getCustomDomain_label() {
            return UpToBoxComConfig.text_CustomDomain;
        }
    }
}

