/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.containers;

import org.appwork.storage.TypeRef;
import org.jdownloader.plugins.components.containers.VideoContainer;
import org.jdownloader.plugins.components.hls.HlsContainer;

public class VimeoContainer
extends VideoContainer {
    public static final TypeRef<VimeoContainer> TYPE_REF = new TypeRef<VimeoContainer>(){};
    private Quality quality;
    private String rawQuality;
    private String lang;
    private Source source;
    private String codec;
    private Long estimatedSize = null;

    public String getRawQuality() {
        return this.rawQuality;
    }

    public void setRawQuality(String rawQuality) {
        this.rawQuality = rawQuality;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Long getEstimatedSize() {
        return this.estimatedSize;
    }

    public void setEstimatedSize(Long estimatedSize) {
        this.estimatedSize = estimatedSize;
    }

    public final Quality getQuality() {
        return this.quality;
    }

    public final String getCodec() {
        return this.codec;
    }

    public final void setQuality(Quality quality) {
        this.quality = quality;
    }

    public final void updateQualityByHeight() {
        this.setQuality(VimeoContainer.getQuality(this.getHeight()));
    }

    public final void setCodec(String codec) {
        this.codec = codec;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public static Quality getQuality(int height) {
        if (height == -1) {
            return null;
        }
        if (height >= 2160) {
            return Quality.UHD_4K;
        }
        if (height >= 1440) {
            return Quality.UHD;
        }
        if (height >= 1080) {
            return Quality.FHD;
        }
        if (height >= 720) {
            return Quality.HD;
        }
        return Quality.SD;
    }

    public static VimeoContainer createVimeoVideoContainer(HlsContainer container) {
        VimeoContainer vvm = new VimeoContainer();
        vvm.setCodec(container.getCodecs());
        vvm.setWidth(container.getWidth());
        vvm.setHeight(container.getHeight());
        vvm.setBitrate(container.getBandwidth());
        vvm.setFramerate(container.getFramerate());
        vvm.setSource(Source.HLS);
        vvm.setQuality(VimeoContainer.getQuality(container.getHeight()));
        vvm._setDownloadurlAndExtension(container.getDownloadurl(), ".mp4");
        return vvm;
    }

    public String createLinkID(String id) {
        String linkid = Source.SUBTITLE.equals((Object)this.getSource()) ? id.concat("_").concat(this.toString((Object)this.getSource())).concat(this.toString(this.getLang())) : id.concat("_").concat(this.getQuality().toString()).concat("_").concat(String.valueOf(this.getWidth())).concat("x").concat(String.valueOf(this.getHeight())).concat(this.toString((Object)this.getSource()).concat(this.toString(this.getLang())));
        return linkid;
    }

    private String toString(Object object) {
        if (object == null) {
            return "";
        }
        return "_".concat(object.toString());
    }

    @Override
    public String toString() {
        return super.toString().concat(this.getQuality() != null ? "|" + this.getQuality().toString() : "").concat(this.getSource() != null ? "|" + this.getSource().toString() : "");
    }

    public String bestString() {
        if (Source.SUBTITLE.equals((Object)this.getSource())) {
            return this.getLang();
        }
        if (this.getQuality() == Quality.ORIGINAL || this.getQuality() == Quality.SOURCE) {
            return String.valueOf(this.getWidth()).concat("x").concat(String.valueOf(this.getHeight())).concat(this.getQuality().toString()).concat(this.getSource().toString());
        }
        return String.valueOf(this.getWidth()).concat("x").concat(String.valueOf(this.getHeight()));
    }

    public static enum Source {
        HLS,
        DASH,
        WEB,
        DOWNLOAD,
        SUBTITLE;

    }

    public static enum Quality {
        MOBILE,
        SD,
        HD,
        FHD,
        UHD,
        UHD_4K,
        ORIGINAL,
        SOURCE;

    }
}

