/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.firefile;

import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;

public class FirefileLink {
    private final DownloadLink link;
    private final String hash;
    private final String key;

    public static FirefileLink get(DownloadLink downloadLink) throws PluginException {
        Regex matches = new Regex(downloadLink.getDownloadURL(), "https?://firefile\\.cc/drive/s/([a-zA-Z0-9]+)!([a-zA-Z0-9]+)");
        if (matches.getMatch(0) == null) {
            throw new PluginException(0x400000);
        }
        if (matches.getMatch(1) == null) {
            throw new PluginException(0x400000);
        }
        return new FirefileLink(downloadLink, matches.getMatch(0), matches.getMatch(1));
    }

    private FirefileLink(DownloadLink link, String hash, String key) {
        this.link = link;
        this.hash = hash;
        this.key = key;
    }

    public String getHash() {
        return this.hash;
    }

    public DownloadLink getLink() {
        return this.link;
    }

    public String getKey() {
        return this.key;
    }
}

