/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.google;

import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import jd.controlling.accountchecker.AccountCheckerThread;
import jd.http.Browser;
import jd.http.Cookie;
import jd.http.Cookies;
import jd.nutils.JDHash;
import jd.nutils.encoding.Encoding;
import jd.parser.html.Form;
import jd.parser.html.InputField;
import jd.plugins.Account;
import jd.plugins.AccountInvalidException;
import jd.plugins.PluginException;
import jd.plugins.components.GoogleService;
import org.appwork.swing.components.ExtTextField;
import org.appwork.swing.components.TextComponentInterface;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.InputDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.parser.UrlQuery;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.InputDialog;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.components.config.GoogleConfig;
import org.jdownloader.plugins.config.PluginJsonConfig;
import org.jdownloader.translate._JDT;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GoogleHelper {
    private static final String META_HTTP_EQUIV_REFRESH_CONTENT_D_S_URL_39_39 = "<meta\\s+http-equiv=\"refresh\"\\s+content\\s*=\\s*\"(\\d+)\\s*;\\s*url\\s*=\\s*([^\"]+)";
    private static final String PROPERTY_ACCOUNT_user_agent = "user_agent";
    private Browser br;
    private boolean cacheEnabled = true;
    LogInterface logger = null;
    private final String PROPERTY_HAS_SHOWN_ADDITIONAL_COOKIE_LOGIN_INFORMATION = "has_shown_additional_cookie_login_information";
    private GoogleService service = GoogleService.YOUTUBE;

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    public void setLogger(LogInterface logger) {
        this.logger = logger;
    }

    private void log(String str) {
        LogInterface logger = this.getLogger();
        if (logger != null) {
            logger.info(str);
        }
    }

    public GoogleHelper(Browser browser) {
        this.init(browser, null);
    }

    public GoogleHelper(Browser browser, LogInterface logger) {
        this.init(browser, logger);
    }

    private void init(Browser browser, LogInterface logger) {
        this.br = browser;
        Thread thread = Thread.currentThread();
        boolean forceUpdateAndBypassCache = thread instanceof AccountCheckerThread && ((AccountCheckerThread)((Object)thread)).getJob().isForce();
        this.cacheEnabled = !forceUpdateAndBypassCache;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postPageFollowRedirects(Browser br, String url, UrlQuery post) throws IOException, InterruptedException {
        boolean before = br.isFollowingRedirects();
        br.setFollowRedirects(false);
        int wait = 0;
        try {
            String[] redirect;
            this.log("Google Login: POST " + url + " Data: " + post);
            br.postPage(url, post);
            url = null;
            if (br.getRedirectLocation() != null) {
                url = br.getRedirectLocation();
            }
            if ((redirect = br.getRegex(META_HTTP_EQUIV_REFRESH_CONTENT_D_S_URL_39_39).getRow(0)) != null) {
                url = Encoding.htmlDecode((String)redirect[1]);
                wait = Integer.parseInt(redirect[0]) * 1000;
            }
        }
        finally {
            br.setFollowRedirects(before);
        }
        if (url != null) {
            if (wait > 0) {
                Thread.sleep(wait);
            }
            this.getPageFollowRedirects(br, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPageFollowRedirects(Browser br, String url) throws IOException, InterruptedException {
        boolean before = br.isFollowingRedirects();
        br.setFollowRedirects(false);
        try {
            int max = 20;
            int wait = 0;
            while (max-- > 0) {
                if ((url = this.breakRedirects(url)) == null) {
                    break;
                }
                if (wait > 0) {
                    Thread.sleep(wait);
                }
                this.log("Google Login: GET " + url);
                br.getPage(url);
                url = null;
                if (br.getRedirectLocation() != null) {
                    url = br.getRedirectLocation();
                    continue;
                }
                String[] redirect = br.getRegex(META_HTTP_EQUIV_REFRESH_CONTENT_D_S_URL_39_39).getRow(0);
                if (redirect == null) continue;
                url = Encoding.htmlDecode((String)redirect[1]);
                wait = Integer.parseInt(redirect[0]) * 1000;
            }
        }
        finally {
            br.setFollowRedirects(before);
        }
    }

    protected String breakRedirects(String url) throws MalformedURLException, IOException {
        if (StringUtils.isEmpty((String)url) || new URL(url).getHost().toLowerCase(Locale.ENGLISH).contains(this.getService().serviceName)) {
            return null;
        }
        return url;
    }

    private Browser prepBR(Browser br) {
        br.setCookie("https://google.com", "PREF", "hl=en-GB");
        return br;
    }

    public static String getUserAgent() {
        String cfgUserAgent = PluginJsonConfig.get(GoogleConfig.class).getUserAgent();
        if (StringUtils.isEmpty((String)cfgUserAgent) || cfgUserAgent.equalsIgnoreCase("JDDEFAULT")) {
            return "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.106 Safari/537.36";
        }
        return cfgUserAgent;
    }

    private Thread showCookieLoginInformation(String host) {
        String serviceNameForUser;
        String realhost;
        if (host.equals("youtube.com")) {
            realhost = "youtube.com";
            serviceNameForUser = "YouTube";
        } else if (host.equals("drive.google.com")) {
            realhost = "drive.google.com";
            serviceNameForUser = "Google Drive";
        } else {
            realhost = "google.com";
            serviceNameForUser = "Google";
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String title;
                    String help_article_url = "https://support.jdownloader.org/Knowledgebase/Article/View/account-cookie-login-instructions";
                    String message = "";
                    if ("de".equalsIgnoreCase(System.getProperty("user.language"))) {
                        title = serviceNameForUser + " - Login";
                        message = message + "Hallo liebe(r) " + serviceNameForUser + " NutzerIn\r\n";
                        message = message + "Um deinen " + serviceNameForUser + " Account in JDownloader verwenden zu k\u00f6nnen, musst du folgende Schritte beachten:\r\n";
                        message = message + "\u00d6ffne " + realhost + " in deinem Browser und folge dieser Anleitung:\r\n";
                        message = message + "https://support.jdownloader.org/Knowledgebase/Article/View/account-cookie-login-instructions";
                    } else {
                        title = serviceNameForUser + " - Login";
                        message = message + "Hello dear " + serviceNameForUser + " user\r\n";
                        message = message + "Open " + realhost + " in your browser and follow these instructions:\r\n";
                        message = message + "https://support.jdownloader.org/Knowledgebase/Article/View/account-cookie-login-instructions";
                    }
                    ConfirmDialog dialog = new ConfirmDialog(4, title, message);
                    dialog.setTimeout(180000);
                    if (CrossSystem.isOpenBrowserSupported() && !Application.isHeadless()) {
                        CrossSystem.openURL((String)"https://support.jdownloader.org/Knowledgebase/Article/View/account-cookie-login-instructions");
                    }
                    ConfirmDialogInterface ret = (ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)dialog);
                    ret.throwCloseExceptions();
                }
                catch (Throwable e) {
                    GoogleHelper.this.getLogger().log(e);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cookies loadUserCookies(Account account) {
        Account account2 = account;
        synchronized (account2) {
            Cookies ret = account.loadUserCookies();
            if (ret == null || ret.isEmpty()) {
                return ret;
            }
            ArrayList cookies = new ArrayList(ret.getCookies());
            for (Cookie cookie : cookies) {
                if (!cookie.getKey().matches("^ST-.+")) continue;
                ret.remove(cookie);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(Account account, boolean forceLoginValidation) throws Exception {
        Account account2 = account;
        synchronized (account2) {
            String userDefinedUserAgent = GoogleHelper.getUserAgent();
            this.br.setDebug(true);
            this.br.setCookiesExclusive(true);
            this.br.setCookie("https://google.com", "PREF", "hl=en-GB");
            Cookies userCookies = GoogleHelper.loadUserCookies(account);
            if (userCookies == null) {
                this.showCookieLoginInformation(account.getHoster());
                throw new AccountInvalidException(_GUI.T.accountdialog_check_cookies_required());
            }
            this.logger.info("Attempting to perform login with user cookies");
            this.br.setCookies(userCookies);
            if (!StringUtils.isEmpty((String)userCookies.getUserAgent())) {
                this.logger.info("Using User-Agent given in user cookies: " + userCookies.getUserAgent());
                account.setProperty(PROPERTY_ACCOUNT_user_agent, userCookies.getUserAgent());
            } else {
                this.logger.info("Using user defined User-Agent: " + userDefinedUserAgent);
                this.br.getHeaders().put("User-Agent", userDefinedUserAgent);
            }
            if (this.isCacheEnabled() && this.hasBeenValidatedRecently(account) && !forceLoginValidation) {
                this.logger.info("Trust cookies without check");
                return;
            }
            this.br.setAllowedResponseCodes(new int[]{400});
            if (!this.validateCookies(account)) {
                this.logger.info("Login with stored cookies failed");
                this.logger.info("Login failed --> No password available but only cookies --> Give up");
                account.removeProperty(PROPERTY_ACCOUNT_user_agent);
                GoogleHelper.errorAccountInvalid(account);
            }
            this.logger.info("Login with cookies successful");
            try {
                GoogleHelper.getSAPISidHash(this.br, this.br.getURL());
            }
            catch (PluginException e) {
                this.errorIncompleteLogin(account);
                throw new PluginException(0x400000);
            }
            this.validate(account);
            this.displayAdditionalCookieLoginInformation(account);
            return;
        }
    }

    private void errorIncompleteLogin(Account account) throws PluginException {
        StringBuilder sb = new StringBuilder();
        String language = System.getProperty("user.language").toLowerCase();
        if ("de".equals(language)) {
            sb.append("Login unvollst\u00e4ndig \u2013 'SAPISID'-Cookie fehlt! Versuch Folgendes:");
            sb.append("\r\n1. \u00d6ffne oben rechts das Kontomen\u00fc und w\u00e4hle \u201eGoogle-Konto\u201c. Es sollte sich in einem neuen Tab \u00f6ffnen.");
            sb.append("\r\n2. Sobald die Seite geladen ist, geh zur\u00fcck zum vorherigen GDrive-/YouTube-Tab und aktualisiere ihn \u2013 der Cookie sollte nun vorhanden sein. Hinweis: Das ist der Tab, den du zum \u00d6ffnen des Kontomen\u00fcs verwendet hast. Geh nicht \u00fcber das App-Men\u00fc (neun Punkte) oben rechts zur\u00fcck zu YouTube oder GDrive, da sonst der Cookie erneut verloren gehen kann.");
            sb.append("\r\n3. Exportiere jetzt deine Cookies erneut und versuche den Login-Vorgang in JDownloader erneut.");
            sb.append("\r\nZus\u00e4tzlicher Hinweis: Wenn du deine Cookies mit dem Chrome-Browser exportiert hast, probiere es erneut mit Firefox.");
        } else if ("es".equals(language)) {
            sb.append("Inicio de sesi\u00f3n incompleto: \u00a1falta la cookie 'SAPISID'! Prueba esto:");
            sb.append("\r\n1. En la esquina superior derecha, abre el men\u00fa de cuenta y selecciona \"Cuenta de Google\". Deber\u00eda cargarse en una nueva pesta\u00f1a.");
            sb.append("\r\n2. Cuando se cargue, vuelve a la pesta\u00f1a anterior de GDrive/YouTube y actual\u00edzala; la cookie deber\u00eda estar all\u00ed. Nota: esa es la pesta\u00f1a que usaste para abrir el men\u00fa de cuenta. No vuelvas a YouTube/GDrive usando el men\u00fa de aplicaciones (nueve puntos) en la parte superior derecha, ya que esto podr\u00eda hacer que se pierda la cookie nuevamente.");
            sb.append("\r\n3. Ahora exporta tus cookies otra vez e intenta el proceso de inicio de sesi\u00f3n en JDownloader de nuevo.");
            sb.append("\r\nSugerencia adicional: si exportaste tus cookies usando el navegador Chrome, int\u00e9ntalo nuevamente con Firefox.");
        } else if ("fr".equals(language)) {
            sb.append("Connexion incompl\u00e8te \u2013 le cookie 'SAPISID' est manquant ! Essaie ceci :");
            sb.append("\r\n1. En haut \u00e0 droite, ouvre le menu de compte et s\u00e9lectionne \u00ab Compte Google \u00bb. Cela devrait s\u2019ouvrir dans un nouvel onglet.");
            sb.append("\r\n2. Une fois la page charg\u00e9e, retourne \u00e0 l\u2019onglet GDrive/YouTube pr\u00e9c\u00e9dent et actualise-le ; le cookie devrait maintenant \u00eatre pr\u00e9sent. Remarque : c\u2019est l\u2019onglet que tu as utilis\u00e9 pour ouvrir le menu de compte. N\u2019utilise pas le menu des applications (neuf points) en haut \u00e0 droite pour revenir \u00e0 YouTube/GDrive, car cela pourrait faire perdre \u00e0 nouveau le cookie.");
            sb.append("\r\n3. Exporte maintenant \u00e0 nouveau tes cookies et r\u00e9essaie la connexion dans JDownloader.");
            sb.append("\r\nAstuce suppl\u00e9mentaire : si tu as export\u00e9 tes cookies avec le navigateur Chrome, essaie \u00e0 nouveau avec Firefox.");
        } else {
            sb.append("Login incomplete \u2013 'SAPISID' cookie missing! Try this:");
            sb.append("\r\n1. In the top-right corner, open the account menu and select \"Google account\". It should load in a new tab.");
            sb.append("\r\n2. When it loads, go back to the previous GDrive/YouTube tab and refresh it \u2013 the cookie should now be there. Note: that's the tab you used to open the account menu. Do not go back to YouTube/GDrive using the app menu (nine dots) at the top right, as this may cause the cookie to be lost again.");
            sb.append("\r\n3. Now export your cookies again and retry the login process in JDownloader.");
            sb.append("\r\nExtra hint: If you exported your cookies using the Chrome browser, try again using Firefox.");
        }
        throw new AccountInvalidException(sb.toString());
    }

    private void displayAdditionalCookieLoginInformation(Account account) {
        if (account.getBooleanProperty("has_shown_additional_cookie_login_information", false).booleanValue()) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String title;
                    String message = "";
                    String language = System.getProperty("user.language").toLowerCase();
                    if ("de".equals(language)) {
                        title = "Google Login - wichtige Information zum Login";
                        message = message + "<html><b>! ! ! WICHTIGE INFORMATION ZUM GOOGLE LOGIN ! ! !</b><br><br>";
                        message = message + "<ol>";
                        message = message + "<li>F\u00fcr die Nutzung von Google-Diensten raten wir davon ab, den Haupt-Account zu verwenden.</li>";
                        message = message + "<li>Login Information: Wir empfehlen, die Session/Cookies, die du gerade in JDownloader eingegeben hast, nicht weiter im Browser zu verwenden.</li>";
                        message = message + "</ol>";
                        message = message + "Solltest du diesen Hinweis missachten, werden deine Google-Cookies in JDownloader h\u00f6chstwahrscheinlich nach sehr kurzer Zeit ung\u00fcltig.<br><br>";
                        message = message + "Wir empfehlen, <b>vor dem Export der Cookies eine neue Session zu er\u00f6ffnen</b>, die danach nicht mehr im Browser verwendet wird,<br>z.&nbsp;B. durch Login in einem Inkognitofenster oder in einem separaten Browserprofil.</html>";
                    } else if ("es".equals(language)) {
                        title = "Google Login - informaci\u00f3n importante sobre el inicio de sesi\u00f3n";
                        message = message + "<html><b>! ! ! INFORMACI\u00d3N IMPORTANTE SOBRE EL INICIO DE SESI\u00d3N DE GOOGLE ! ! !</b><br><br>";
                        message = message + "<ol>";
                        message = message + "<li>Para evitar bloqueos de cuenta, recomendamos no usar la cuenta principal de Google para servicios de Google en JDownloader.</li>";
                        message = message + "<li>Informaci\u00f3n de inicio de sesi\u00f3n: Recomendamos no usar la misma sesi\u00f3n/cookies de Google que acaba de ingresar en JDownloader tambi\u00e9n en su navegador.</li>";
                        message = message + "</ol>";
                        message = message + "Si ignora esta advertencia, las cookies de Google en JDownloader probablemente caducar\u00e1n en muy poco tiempo.<br><br>";
                        message = message + "Recomendamos <b>crear una nueva sesi\u00f3n antes de exportar las cookies</b>, que despu\u00e9s no vuelva a usar en el navegador,<br>por ejemplo, iniciando sesi\u00f3n en una ventana de inc\u00f3gnito o en un perfil de navegador separado.</html>";
                    } else if ("fr".equals(language)) {
                        title = "Google Login - informations importantes concernant la connexion";
                        message = message + "<html><b>! ! ! INFORMATIONS IMPORTANTES SUR LA CONNEXION GOOGLE ! ! !</b><br><br>";
                        message = message + "<ol>";
                        message = message + "<li>Pour l\u2019utilisation des services Google, nous recommandons de ne pas utiliser votre compte principal.</li>";
                        message = message + "<li>Informations de connexion : nous recommandons de ne pas utiliser dans votre navigateur la m\u00eame session/cookies Google que vous venez d\u2019entrer dans JDownloader.</li>";
                        message = message + "</ol>";
                        message = message + "Si vous ignorez cet avertissement, vos cookies Google dans JDownloader deviendront probablement invalides tr\u00e8s rapidement.<br><br>";
                        message = message + "Nous recommandons de <b>cr\u00e9er une nouvelle session avant d\u2019exporter les cookies</b>, qui ne sera ensuite plus utilis\u00e9e dans le navigateur,<br>par exemple via une fen\u00eatre de navigation priv\u00e9e ou un profil de navigateur s\u00e9par\u00e9.</html>";
                    } else {
                        title = "Google Login - important login information";
                        message = message + "<html><b>! ! ! IMPORTANT INFORMATION ABOUT GOOGLE LOGIN ! ! !</b><br><br>";
                        message = message + "<ol>";
                        message = message + "<li>For using Google services, we strongly advise not to use your main account.</li>";
                        message = message + "<li>Login information: We recommend not to use the same Google session/cookies you just entered in JDownloader in your browser.</li>";
                        message = message + "</ol>";
                        message = message + "If you ignore this warning, your Google cookies in JDownloader will most likely become invalid after a very short time.<br><br>";
                        message = message + "We recommend <b>creating a new session before exporting cookies</b>, which should not be used in the browser afterwards,<br>e.g. by logging in via an incognito window or a separate browser profile.</html>";
                    }
                    ConfirmDialog dialog = new ConfirmDialog(148, title, message);
                    dialog.setTimeout(300000);
                    ConfirmDialogInterface ret = (ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)dialog);
                    ret.throwCloseExceptions();
                }
                catch (Throwable e) {
                    GoogleHelper.this.getLogger().log(e);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        account.setProperty("has_shown_additional_cookie_login_information", true);
    }

    public static void errorAccountInvalid(Account account) throws AccountInvalidException {
        Cookies userCookies = GoogleHelper.loadUserCookies(account);
        if (userCookies != null && !userCookies.isEmpty()) {
            account.removeProperty(PROPERTY_ACCOUNT_user_agent);
            if (account.hasEverBeenValid()) {
                throw new AccountInvalidException(_GUI.T.accountdialog_check_cookies_expired());
            }
            throw new AccountInvalidException(_GUI.T.accountdialog_check_cookies_invalid());
        }
        throw new AccountInvalidException();
    }

    public boolean validateCookies(Account account) throws IOException, InterruptedException, AccountInvalidException {
        this.logger.info("Validating cookies");
        if (account.getHoster().equals("youtube.com")) {
            this.br.getPage("https://www.youtube.com/");
            this.br.followRedirect(true);
            boolean ret = this.br.containsHTML("\"key\"\\s*:\\s*\"logged_in\"\\s*,\\s*\"value\"\\s*:\\s*\"1\"");
            return ret |= this.br.containsHTML("\"LOGGED_IN\"\\s*:\\s*true");
        }
        if (account.getHoster().equals("drive.google.com")) {
            this.validateCookiesGoogleDrive(this.br, account);
            return true;
        }
        boolean useTwoLoginValidations = false;
        this.getPageFollowRedirects(this.br, "https://www.google.com/?gws_rd=ssl");
        return this.br.containsHTML("accounts\\.google\\.com/logout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCookiesGoogleDrive(Browser br, Account account) throws AccountInvalidException, IOException {
        boolean oldFollowRedirects = br.isFollowingRedirects();
        try {
            br.setFollowRedirects(true);
            br.getPage("https://drive.google.com/drive/my-drive");
            if (br.getURL().contains("accounts.google.com")) {
                this.logger.warning("Looks like GDrive login failed");
                GoogleHelper.errorAccountInvalid(account);
            } else {
                this.logger.info("Looks like GDrive login was successful");
            }
        }
        finally {
            br.setFollowRedirects(oldFollowRedirects);
        }
    }

    protected boolean validateSuccessOLD() {
        return this.br.containsHTML("accounts/SetSID");
    }

    protected void validate(Account account) {
        account.setProperty("LAST_VALIDATE_" + this.getService().name(), System.currentTimeMillis());
    }

    protected boolean hasBeenValidatedRecently(Account account) {
        long lastValidated = account.getLongProperty("LAST_VALIDATE_" + this.getService().name(), -1L);
        return lastValidated > 0L && System.currentTimeMillis() - lastValidated < this.getValidatedCacheTimeout();
    }

    protected long getValidatedCacheTimeout() {
        return 3600000L;
    }

    private void handle2FactorAuthSmsDeprecated(Form form) throws Exception {
        if (this.br.containsHTML("idv-delivery-error-container")) {
            throw new PluginException(256, "You seem to be having trouble getting your sms verification code.  Please try again later.");
        }
        String number = this.br.getRegex("<span\\s+class\\s*=\\s*\"twostepphone\".*?>(.*?)</span>").getMatch(0);
        if (number != null) {
            InputDialog d = new InputDialog(0, _JDT.T.Google_helper_2factor_sms_dialog_title(), _JDT.T.Google_helper_2factor_sms_dialog_msg(number.trim()), null, (Icon)new AbstractIcon("text", 32), null, null);
            InputDialogInterface handler = (InputDialogInterface)UIOManager.I().show(InputDialogInterface.class, (UserIODefinition)d);
            handler.throwCloseExceptions();
            InputField smsUserPin = form.getInputFieldByName("smsUserPin");
            smsUserPin.setValue(Encoding.urlEncode((String)handler.getText()));
            InputField persistentCookie = form.getInputFieldByName("PersistentCookie");
            persistentCookie.setValue(Encoding.urlEncode((String)"on"));
            form.remove("smsSend");
            form.remove("retry");
            this.submitForm(this.br, form);
        } else {
            number = this.br.getRegex("<span\\s+class\\s*=\\s*\"twostepphone\".*?>(.*?)</span>").getMatch(0);
            InputDialog d = new InputDialog(0, _JDT.T.Google_helper_2factor_sms_dialog_title(), _JDT.T.Google_helper_2factor_sms_dialog_msg(number.trim()), null, (Icon)new AbstractIcon("text", 32), null, null);
            InputDialogInterface handler = (InputDialogInterface)UIOManager.I().show(InputDialogInterface.class, (UserIODefinition)d);
            handler.throwCloseExceptions();
            InputField smsUserPin = form.getInputFieldByName("smsUserPin");
            smsUserPin.setValue(Encoding.urlEncode((String)handler.getText()));
            InputField persistentCookie = form.getInputFieldByName("PersistentCookie");
            persistentCookie.setValue(Encoding.urlEncode((String)"on"));
            form.remove("smsSend");
            form.remove("retry");
            this.submitForm(this.br, form);
        }
        this.handleIntersitial();
    }

    private void handle2FactorAuthSmsNew2(Form form) throws Exception {
        if (this.br.containsHTML("idv-delivery-error-container")) {
            throw new PluginException(256, "You seem to be having trouble getting your sms verification code.  Please try again later.");
        }
        String number = this.getPhonenumberCensored();
        InputDialog d = new InputDialog(0, _JDT.T.Google_helper_2factor_sms_dialog_title(), _JDT.T.Google_helper_2factor_sms_dialog_msg(number), null, new AbstractIcon("text", 32), null, null){

            protected void initFocus(JComponent focus) {
            }

            protected TextComponentInterface getSmallInputComponent() {
                ExtTextField ttx = new ExtTextField();
                String TEXT_NOT_TO_TOUCH = "G-";
                ttx.addKeyListener((KeyListener)((Object)this));
                ttx.addMouseListener((MouseListener)((Object)this));
                ttx.setText("G-");
                ((AbstractDocument)ttx.getDocument()).setDocumentFilter(new DocumentFilter(){

                    @Override
                    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                        if (offset < "G-".length()) {
                            return;
                        }
                        super.insertString(fb, offset, string, attr);
                    }

                    @Override
                    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                        if (offset < "G-".length()) {
                            length = Math.max(0, length - "G-".length());
                            offset = "G-".length();
                        }
                        super.replace(fb, offset, length, text, attrs);
                    }

                    @Override
                    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                        if (offset < "G-".length()) {
                            length = Math.max(0, length + offset - "G-".length());
                            offset = "G-".length();
                        }
                        if (length > 0) {
                            super.remove(fb, offset, length);
                        }
                    }
                });
                return ttx;
            }
        };
        InputDialogInterface handler = (InputDialogInterface)UIOManager.I().show(InputDialogInterface.class, (UserIODefinition)d);
        handler.throwCloseExceptions();
        InputField smsUserPin = form.getInputFieldByName("Pin");
        String txt = handler.getText();
        if (txt.startsWith("G-")) {
            txt = txt.substring(2);
        }
        smsUserPin.setValue(Encoding.urlEncode((String)txt));
        InputField persistentCookie = form.getInputFieldByName("TrustDevice");
        persistentCookie.setValue(Encoding.urlEncode((String)"on"));
        form.remove("smsSend");
        form.remove("retry");
        this.submitForm(this.br, form);
        this.handleIntersitial();
    }

    private void handle2FactorAuthSmsNew(Form form) throws Exception {
        if (this.br.containsHTML("idv-delivery-error-container")) {
            throw new PluginException(256, "You seem to be having trouble getting your sms verification code.  Please try again later.");
        }
        String number = this.getPhonenumberCensored();
        InputDialog d = new InputDialog(0, _JDT.T.Google_helper_2factor_sms_dialog_title(), _JDT.T.Google_helper_2factor_sms_dialog_msg(number), null, new AbstractIcon("text", 32), null, null){

            protected void initFocus(JComponent focus) {
            }

            protected TextComponentInterface getSmallInputComponent() {
                ExtTextField ttx = new ExtTextField();
                String TEXT_NOT_TO_TOUCH = "G-";
                ttx.addKeyListener((KeyListener)((Object)this));
                ttx.addMouseListener((MouseListener)((Object)this));
                ttx.setText("G-");
                ((AbstractDocument)ttx.getDocument()).setDocumentFilter(new DocumentFilter(){

                    @Override
                    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                        if (offset < "G-".length()) {
                            return;
                        }
                        super.insertString(fb, offset, string, attr);
                    }

                    @Override
                    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                        if (offset < "G-".length()) {
                            length = Math.max(0, length - "G-".length());
                            offset = "G-".length();
                        }
                        super.replace(fb, offset, length, text, attrs);
                    }

                    @Override
                    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                        if (offset < "G-".length()) {
                            length = Math.max(0, length + offset - "G-".length());
                            offset = "G-".length();
                        }
                        if (length > 0) {
                            super.remove(fb, offset, length);
                        }
                    }
                });
                return ttx;
            }
        };
        InputDialogInterface handler = (InputDialogInterface)UIOManager.I().show(InputDialogInterface.class, (UserIODefinition)d);
        handler.throwCloseExceptions();
        String txt = handler.getText();
        if (txt.startsWith("G-")) {
            txt = txt.substring(2);
        }
        form.remove("pin");
        form.put("pin", Encoding.urlEncode((String)txt));
        InputField persistentCookie = form.getInputFieldByName("TrustDevice");
        if (persistentCookie != null) {
            persistentCookie.setValue(Encoding.urlEncode((String)"on"));
        } else {
            form.put("TrustDevice", "on");
        }
        form.remove("smsSend");
        form.remove("retry");
        this.submitForm(this.br, form);
        this.handleIntersitial();
    }

    private String getPhonenumberCensored() {
        String number = this.br.getRegex("<b dir=\"ltr\">(.*?)</b>").getMatch(0);
        if (number == null) {
            number = this.br.getRegex("<b dir=\"ltr\" class=\"[^<>\"]+\">([^<>\"]*?)</b>").getMatch(0);
        }
        if (number != null) {
            number = number.trim();
        }
        return number;
    }

    protected void handleIntersitial() throws Exception {
        Form remind = this.br.getFormBySubmitvalue("Remind+me+later");
        if (remind != null && "SmsAuthInterstitial".equals(remind.getAction())) {
            remind.remove("addBackupPhone");
            this.submitForm(this.br, remind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitForm(Browser br, Form form) throws Exception {
        boolean before = br.isFollowingRedirects();
        br.setFollowRedirects(false);
        int wait = 0;
        String url = null;
        try {
            String[] redirect;
            br.submitForm(form);
            if (br.getRedirectLocation() != null) {
                url = br.getRedirectLocation();
            }
            if ((redirect = br.getRegex(META_HTTP_EQUIV_REFRESH_CONTENT_D_S_URL_39_39).getRow(0)) != null) {
                url = Encoding.htmlDecode((String)redirect[1]);
                wait = Integer.parseInt(redirect[0]) * 1000;
            }
        }
        finally {
            br.setFollowRedirects(before);
        }
        if (url != null) {
            if (wait > 0) {
                Thread.sleep(wait);
            }
            this.getPageFollowRedirects(br, url);
        }
    }

    private String getText(Document doc, XPath xPath, String string) throws XPathExpressionException {
        Node n = (Node)xPath.evaluate(string, doc, XPathConstants.NODE);
        return n != null ? n.getFirstChild().getTextContent().trim() : null;
    }

    public GoogleService getService() {
        return this.service;
    }

    public void setService(GoogleService service) {
        this.service = service;
    }

    private boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public static String getSAPISidHash(Browser br, String url) throws PluginException {
        String sapisid = null;
        HashMap cookiemap = br.getCookies();
        block0: for (Map.Entry entry : cookiemap.entrySet()) {
            Cookies cookies = (Cookies)entry.getValue();
            for (Cookie cookie : cookies.getCookies()) {
                if (!cookie.getKey().equalsIgnoreCase("SAPISID")) continue;
                sapisid = cookie.getValue();
                break block0;
            }
        }
        if (sapisid == null) {
            throw new PluginException(0x400000);
        }
        long timeMillis = System.currentTimeMillis() / 1000L;
        return timeMillis + "_" + JDHash.getSHA1((String)(timeMillis + " " + sapisid + " " + url));
    }

    public static Browser prepBrowserWebAPI(Browser br, Account account, String domain) throws PluginException {
        String domainWithProtocol = "https://" + domain;
        br.getHeaders().put("Accept", "*/*");
        br.getHeaders().put("Origin", domainWithProtocol);
        br.getHeaders().put("Referer", domainWithProtocol + "/");
        br.getHeaders().put("X-Requested-With", "XMLHttpRequest");
        br.getHeaders().put("X-Javascript-User-Agent", "google-api-javascript-client/1.1.0");
        if (account != null) {
            String sapisidhash = GoogleHelper.getSAPISidHash(br, domainWithProtocol);
            if (sapisidhash != null) {
                br.getHeaders().put("Authorization", "SAPISIDHASH " + sapisidhash);
            }
            br.getHeaders().put("X-Goog-Authuser", "0");
        }
        return br;
    }
}

