/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.hls;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import jd.http.Browser;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.jdownloader.downloader.hls.M3U8Playlist;
import org.jdownloader.plugins.components.hls.HlsContainerMediaStorable;
import org.jdownloader.plugins.components.hls.HlsContainerStorable;

public class HlsContainer {
    private String codecs;
    private String streamURL;
    private String m3u8URL;
    private List<M3U8Playlist> m3u8List = null;
    private int width = -1;
    private List<MEDIA> media = null;
    private int height = -1;
    private int bandwidth = -1;
    private int average_bandwidth = -1;
    private int programID = -1;
    private int framerate = -1;
    private String audioGroupID = null;
    private String name = null;

    public static List<HlsContainer> findBestVideosByBandwidth(List<HlsContainer> media) {
        if (media == null || media.size() == 0) {
            return null;
        }
        HashMap<String, ArrayList<HlsContainer>> hlsContainer = new HashMap<String, ArrayList<HlsContainer>>();
        ArrayList<HlsContainer> ret = null;
        long bandwidth_highest = 0L;
        for (HlsContainer item : media) {
            String id = item.buildExtXStreamInfLine();
            ArrayList<HlsContainer> list = (ArrayList<HlsContainer>)hlsContainer.get(id);
            if (list == null) {
                list = new ArrayList<HlsContainer>();
                hlsContainer.put(id, list);
            }
            list.add(item);
            long bandwidth_temp = item.getBandwidth();
            if (bandwidth_temp == -1L) {
                bandwidth_temp = item.getAverageBandwidth();
            }
            if (bandwidth_temp <= bandwidth_highest) continue;
            bandwidth_highest = bandwidth_temp;
            ret = list;
        }
        return ret;
    }

    public static HlsContainer findBestTargetHeight(List<HlsContainer> media, int targetHeight) {
        if (media == null || media.size() == 0) {
            return null;
        }
        HlsContainer best = null;
        for (HlsContainer next : media) {
            int bestBW;
            int nextBW;
            if (next.getHeight() < targetHeight) continue;
            if (best == null) {
                best = next;
                continue;
            }
            if (Math.abs(next.getHeight() - targetHeight) < Math.abs(best.getHeight() - targetHeight)) {
                best = next;
                continue;
            }
            if (Math.abs(next.getHeight() - targetHeight) != Math.abs(best.getHeight() - targetHeight) || (nextBW = Math.max(next.getBandwidth(), next.getAverageBandwidth())) <= (bestBW = Math.max(best.getBandwidth(), best.getAverageBandwidth()))) continue;
            best = next;
        }
        if (best != null) {
            return best;
        }
        return HlsContainer.findBestVideoByBandwidth(media);
    }

    public static HlsContainer findBestVideoByBandwidth(List<HlsContainer> media) {
        List<HlsContainer> ret = HlsContainer.findBestVideosByBandwidth(media);
        if (ret != null && ret.size() > 0) {
            return ret.get(0);
        }
        return null;
    }

    public static HlsContainer find(Browser br, List<HlsContainer> hlsContainer, DownloadLink link) throws IOException, PluginException {
        ArrayList<HlsContainer> search = new ArrayList<HlsContainer>(hlsContainer);
        Iterator it = search.iterator();
        block0: while (it.hasNext()) {
            HlsContainer next = (HlsContainer)it.next();
            int width = link.getIntegerProperty("width", -1);
            if (width > 0 && next.getWidth() != width) {
                it.remove();
                continue;
            }
            int height = link.getIntegerProperty("height", -1);
            if (height > 0 && next.getHeight() != height) {
                it.remove();
                continue;
            }
            int frameRate = link.getIntegerProperty("framerate", -1);
            if (frameRate > 0 && next.getFramerate() != frameRate) {
                it.remove();
                continue;
            }
            int bandWidth = link.getIntegerProperty("hlsBandwidth", -1);
            if (bandWidth > 0 && next.getBandwidth() != bandWidth) {
                it.remove();
                continue;
            }
            String audioGroup = link.getStringProperty("m3u8_audio_group");
            if (audioGroup != null && !StringUtils.equals((String)audioGroup, (String)next.getAudioGroupID())) {
                it.remove();
                continue;
            }
            String audioLng = link.getStringProperty("m3u8_audio_lng");
            String audioName = link.getStringProperty("m3u8_audio_name");
            for (MEDIA media : next.getMedia(MEDIA.TYPE.AUDIO, audioGroup)) {
                if (StringUtils.equals((String)audioLng, (String)media.getLanguage()) && StringUtils.equals((String)audioName, (String)media.getName())) continue block0;
            }
            it.remove();
        }
        if (search.size() == 0) {
            return null;
        }
        if (search.size() == 1) {
            return (HlsContainer)search.get(0);
        }
        throw new PluginException(0x400000);
    }

    public static List<HlsContainer> getHlsQualities(Browser br, String m3u8) throws Exception {
        br.getHeaders().put("Accept", "*/*");
        br.getPage(m3u8);
        return HlsContainer.getHlsQualities(br);
    }

    public static List<HlsContainer> getHlsQualities(Browser br) throws Exception {
        return HlsContainer.parseHlsQualities(br.toString(), br);
    }

    private static List<MEDIA> parseMedia(String m3u8, Browser br) throws Exception {
        String[] extXMedia;
        ArrayList<MEDIA> ret = new ArrayList<MEDIA>();
        for (String entry : extXMedia = new Regex(m3u8, "#EXT-X-MEDIA:([^\r\n]+)").getColumn(0)) {
            try {
                String type = new Regex(entry, "(?:,|^)\\s*TYPE\\s*=\\s*(AUDIO|SUBTITLES)").getMatch(0);
                MEDIA.TYPE mediaType = MEDIA.TYPE.parse(type);
                if (mediaType == null || MEDIA.TYPE.CLOSEDCAPTIONS.equals((Object)mediaType)) continue;
                String groupID = new Regex(entry, "(?:,|^)\\s*GROUP-ID\\s*=\\s*\"([^<>\"]+)\"").getMatch(0);
                if (groupID == null) {
                    throw new Exception("No GROUP-ID?:" + entry);
                }
                String uri = new Regex(entry, "(?:,|^)\\s*URI\\s*=\\s*\"([^<>\"]+)\"").getMatch(0);
                if (uri == null) {
                    throw new Exception("No URI?:" + entry);
                }
                String language = new Regex(entry, "(?:,|^)\\s*LANGUAGE\\s*=\\s*\"([^<>\"]+)\"").getMatch(0);
                String name = new Regex(entry, "(?:,|^)\\s*NAME\\s*=\\s*\"([^<>\"]+)\"").getMatch(0);
                String autoSelect = new Regex(entry, "(?:,|^)\\s*AUTOSELECT\\s*=\\s*(YES|NO)").getMatch(0);
                String defaultSelect = new Regex(entry, "(?:,|^)\\s*DEFAULT\\s*=\\s*(YES|NO)").getMatch(0);
                String forced = new Regex(entry, "(?:,|^)\\s*FORCED\\s*=\\s*(YES|NO)").getMatch(0);
                ret.add(new MEDIA(mediaType, groupID, language, name, autoSelect == null ? null : Boolean.valueOf("YES".equals(autoSelect)), defaultSelect == null ? null : Boolean.valueOf("YES".equals(defaultSelect)), forced == null ? null : Boolean.valueOf("YES".equals(forced)), uri));
            }
            catch (Exception e) {
                br.getLogger().log((Throwable)e);
            }
        }
        return ret;
    }

    private static List<MEDIA> filterMedia(List<MEDIA> media, MEDIA.TYPE type, String groupID) {
        ArrayList<MEDIA> ret = new ArrayList<MEDIA>();
        if (media == null || media.size() == 0) {
            return ret;
        }
        for (MEDIA entry : media) {
            if (type != null && !type.equals((Object)entry.getType()) || groupID != null && !groupID.equals(entry.getGroupID())) continue;
            ret.add(entry);
        }
        return ret;
    }

    public static List<HlsContainer> parseHlsQualities(String m3u8, Browser br) throws Exception {
        ArrayList<HlsContainer> hlsqualities = new ArrayList<HlsContainer>();
        List<MEDIA> media = HlsContainer.parseMedia(m3u8, br);
        String[][] streams = new Regex(m3u8, "#EXT-X-STREAM-INF:?([^\r\n]+)[\r\n]+([^\r\n]+)").getMatches();
        if (streams != null) {
            for (String[] stream : streams) {
                if (!StringUtils.isNotEmpty((String)stream[1])) continue;
                String streamInfo = stream[0];
                String programID = new Regex(streamInfo, "(?:,|^)\\s*PROGRAM-ID\\s*=\\s*(\\d+)").getMatch(0);
                String bandwidth = new Regex(streamInfo, "(?:,|^)\\s*BANDWIDTH\\s*=\\s*(\\d+)").getMatch(0);
                String average_bandwidth = new Regex(streamInfo, "(?:,|^)\\s*AVERAGE-BANDWIDTH\\s*=\\s*(\\d+)").getMatch(0);
                String resolution = new Regex(streamInfo, "(?:,|^)\\s*RESOLUTION\\s*=\\s*(\\d+x\\d+)").getMatch(0);
                String framerate = new Regex(streamInfo, "(?:,|^)\\s*FRAME-RATE\\s*=\\s*(\\d+)").getMatch(0);
                String codecs = new Regex(streamInfo, "(?:,|^)\\s*CODECS\\s*=\\s*\"([^<>\"]+)\"").getMatch(0);
                String name = new Regex(streamInfo, "(?:,|^)\\s*NAME\\s*=\\s*\"([^<>\"]+)\"").getMatch(0);
                String url = br.getURL(stream[1]).toString();
                HlsContainer hls = new HlsContainer();
                hls.programID = programID != null ? Integer.parseInt(programID) : -1;
                hls.bandwidth = bandwidth != null ? Integer.parseInt(bandwidth) : -1;
                if (name != null) {
                    hls.name = name.trim();
                }
                hls.average_bandwidth = average_bandwidth != null ? Integer.parseInt(average_bandwidth) : -1;
                if (codecs != null) {
                    hls.codecs = codecs.trim();
                }
                hls.streamURL = url;
                hls.m3u8URL = br.getURL();
                if (resolution != null) {
                    String[] resolution_info = resolution.split("x");
                    String width = resolution_info[0];
                    String height = resolution_info[1];
                    hls.width = Integer.parseInt(width);
                    hls.height = Integer.parseInt(height);
                }
                if (framerate != null) {
                    hls.framerate = Integer.parseInt(framerate);
                }
                ArrayList<MEDIA> containerMedia = new ArrayList<MEDIA>();
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                    String audioID;
                    hls.audioGroupID = audioID = new Regex(streamInfo, "(?:,|^)\\s*AUDIO\\s*=\\s*\"([^<>\"]+)\"").getMatch(0);
                    containerMedia.addAll(HlsContainer.filterMedia(media, MEDIA.TYPE.AUDIO, audioID));
                }
                if (containerMedia.size() > 0) {
                    hls.setMedia(containerMedia);
                }
                hlsqualities.add(hls);
            }
        }
        return hlsqualities;
    }

    public String getM3U8URL() {
        return this.m3u8URL;
    }

    public List<MEDIA> getMedia() {
        return this.media;
    }

    public List<MEDIA> getMedia(MEDIA.TYPE type, String groupID) {
        return HlsContainer.filterMedia(this.getMedia(), type, groupID);
    }

    public void setMedia(List<MEDIA> media) {
        this.media = media;
    }

    public void setAverageBandwidth(int average_bandwidth) {
        this.average_bandwidth = average_bandwidth;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setBandwidth(int bandwidth) {
        this.bandwidth = bandwidth;
    }

    public String getAudioGroupID() {
        return this.audioGroupID;
    }

    public void setAudioGroupID(String audioGroupID) {
        this.audioGroupID = audioGroupID;
    }

    public void setFramerate(int framerate) {
        this.framerate = framerate;
    }

    public String getName() {
        return this.name;
    }

    protected List<M3U8Playlist> loadM3U8(Browser br) throws IOException {
        Browser br2 = br.cloneBrowser();
        return M3U8Playlist.loadM3U8(this.getStreamURL(), br2);
    }

    public void setM3U8(List<M3U8Playlist> m3u8List) {
        this.m3u8List = m3u8List;
    }

    public String buildExtXStreamInfLine() {
        StringBuilder sb = new StringBuilder();
        sb.append("#EXT-X-STREAM-INF:");
        boolean sep = false;
        if (this.getProgramID() != -1) {
            sb.append("PROGRAM-ID=" + this.getProgramID());
            sep = true;
        }
        if (this.getBandwidth() != -1) {
            if (sep) {
                sb.append(",");
            }
            sb.append("BANDWIDTH=" + this.getBandwidth());
            sep = true;
        }
        if (this.getAverageBandwidth() != -1) {
            if (sep) {
                sb.append(",");
            }
            sb.append("AVERAGE-BANDWIDTH=" + this.getAverageBandwidth());
            sep = true;
        }
        if (this.getCodecs() != null) {
            if (sep) {
                sb.append(",");
            }
            sb.append("CODECS=\"" + this.getCodecs() + "\"");
            sep = true;
        }
        if (this.getResolution() != null) {
            if (sep) {
                sb.append(",");
            }
            sb.append("RESOLUTION=" + this.getResolution());
            sep = true;
        }
        if (this.getFramerate() != -1) {
            if (sep) {
                sb.append(",");
            }
            sb.append("FRAME-RATE=" + this.getFramerate());
            sep = true;
        }
        if (this.getName() != null) {
            if (sep) {
                sb.append(",");
            }
            sb.append("NAME=\"" + this.getName() + "\"");
            sep = true;
        }
        return sb.toString();
    }

    public List<M3U8Playlist> getM3U8(Browser br) throws IOException {
        if (this.m3u8List == null) {
            this.setM3U8(this.loadM3U8(br));
            int bandwidth = this.getAverageBandwidth();
            if (bandwidth < 0) {
                bandwidth = this.getBandwidth();
            }
            if (this.m3u8List != null && bandwidth > 0) {
                for (M3U8Playlist m3u8 : this.m3u8List) {
                    m3u8.setAverageBandwidth(bandwidth);
                }
            }
        }
        return this.m3u8List;
    }

    public int getProgramID() {
        return this.programID;
    }

    public List<StreamCodec> getStreamCodecs() {
        return StreamCodec.parse(this.getCodecs());
    }

    public StreamCodec getCodecType(CODEC_TYPE type) {
        List<StreamCodec> ret = this.getStreamCodecs();
        if (ret != null) {
            for (StreamCodec streamCodec : ret) {
                if (!streamCodec.getCodec().getType().equals((Object)type)) continue;
                return streamCodec;
            }
        }
        return null;
    }

    public StreamCodec getCodec(CODEC codec) {
        List<StreamCodec> ret = this.getStreamCodecs();
        if (ret != null) {
            for (StreamCodec streamCodec : ret) {
                if (!streamCodec.getCodec().equals((Object)codec)) continue;
                return streamCodec;
            }
        }
        return null;
    }

    public String getCodecs() {
        return this.codecs;
    }

    public void setStreamURL(String url) {
        this.streamURL = url;
    }

    @Deprecated
    public String getDownloadurl() {
        return this.getStreamURL();
    }

    public String getStreamURL() {
        return this.streamURL;
    }

    public boolean isVideo() {
        if (this.getCodecType(CODEC_TYPE.VIDEO) != null) {
            return true;
        }
        return this.width != -1 || this.height != -1;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFramerate() {
        return this.framerate;
    }

    public int getFramerate(int fallback) {
        if (this.framerate == -1) {
            return fallback;
        }
        return this.framerate;
    }

    public String getResolution() {
        return this.getWidth() + "x" + this.getHeight();
    }

    public int getBandwidth() {
        return this.bandwidth;
    }

    public int getAverageBandwidth() {
        return this.average_bandwidth;
    }

    public String toString() {
        return this.buildExtXStreamInfLine();
    }

    public String getStandardFilename() {
        String filename = "";
        if (this.width != -1 && this.height != -1) {
            filename = filename + this.getResolution();
        }
        if (this.codecs != null) {
            filename = filename + "_" + this.codecs;
        }
        filename = filename + this.getFileExtension();
        return filename;
    }

    public String getFileExtension(String fallback) {
        StreamCodec video = this.getCodecType(CODEC_TYPE.VIDEO);
        StreamCodec audio = this.getCodecType(CODEC_TYPE.AUDIO);
        if (video != null) {
            return "." + video.getCodec().getDefaultExtension();
        }
        if (audio != null) {
            return "." + audio.getCodec().getDefaultExtension();
        }
        return fallback;
    }

    @Deprecated
    public String getFileExtension() {
        return this.getFileExtension(".mp4");
    }

    public void setPropertiesOnDownloadLink(DownloadLink link) {
        this.setPropertiesOnDownloadLink(link, new MEDIA[0]);
    }

    public void setPropertiesOnDownloadLink(DownloadLink link, MEDIA ... medias) {
        if (this.getWidth() > 0) {
            link.setProperty("width", this.getWidth());
        }
        if (this.getHeight() > 0) {
            link.setProperty("height", this.getHeight());
        }
        if (this.getFramerate() > 0) {
            link.setProperty("framerate", this.getFramerate());
        }
        if (this.getBandwidth() > 0) {
            link.setProperty("hlsBandwidth", this.getBandwidth());
        }
        if (this.getAverageBandwidth() > 0) {
            link.setProperty("hlsBandwidthAverage", this.getAverageBandwidth());
        }
        link.setProperty("m3u8_name", this.getName());
        link.setProperty("m3u8_codecs", this.getCodecs());
        HlsContainerStorable containerStorable = new HlsContainerStorable(this);
        for (MEDIA media : medias) {
            if (media == null) continue;
            containerStorable.getMedia().add(new HlsContainerMediaStorable(media));
        }
        link.setCompressedProperty("hlsContainerStorable", containerStorable);
    }

    public static class StreamCodec {
        private final CODEC codec;
        private final String raw;

        public CODEC getCodec() {
            return this.codec;
        }

        public String getRaw() {
            return this.raw;
        }

        private StreamCodec(String raw) {
            this.raw = raw;
            this.codec = CODEC.parse(raw);
        }

        public static List<StreamCodec> parse(String raw) {
            String[] codecs;
            String[] stringArray = codecs = raw != null ? raw.split(",") : null;
            if (codecs != null) {
                ArrayList<StreamCodec> ret = new ArrayList<StreamCodec>();
                for (String codec : codecs) {
                    ret.add(new StreamCodec(codec));
                }
                return ret;
            }
            return null;
        }
    }

    public static enum CODEC {
        MP3(CODEC_TYPE.AUDIO, "mp3,", "mp3", "(mp4a\\.40\\.34|mp3)"),
        MP2(CODEC_TYPE.AUDIO, "mp2", "mp2", "mp2"),
        AAC(CODEC_TYPE.AUDIO, "aac", "m4a", "(mp4a\\.40|aac)"),
        AC3(CODEC_TYPE.AUDIO, "ac3", "ac3", "(ac-3|ac3)"),
        EC3(CODEC_TYPE.AUDIO, "ec3", "ec3", "(ec-3|ec3)"),
        FLAC(CODEC_TYPE.VIDEO, "flac", "flac", "fLaC"),
        AVC(CODEC_TYPE.VIDEO, "avc", "mp4", "(avc1|avc3|h264)"),
        HEVC(CODEC_TYPE.VIDEO, "hevc", "mp4", "(hev1|hvc1|h265)"),
        AV1(CODEC_TYPE.VIDEO, "av1", "mp4", "(av1|av01)"),
        UNKNOWN(CODEC_TYPE.UNKNOWN, null, null, null);

        private final CODEC_TYPE type;
        private final String defaultExtension;
        private final Pattern pattern;
        private final String codecName;

        public CODEC_TYPE getType() {
            return this.type;
        }

        public String getDefaultExtension() {
            return this.defaultExtension;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String getCodecName() {
            return this.codecName;
        }

        private CODEC(CODEC_TYPE type, String codecName, String defaultExtension, String pattern) {
            this.type = type;
            this.codecName = codecName;
            this.defaultExtension = defaultExtension;
            this.pattern = pattern != null ? Pattern.compile(pattern) : null;
        }

        public static CODEC parse(String raw) {
            if (StringUtils.isNotEmpty((String)raw)) {
                for (CODEC codec : CODEC.values()) {
                    if (codec.getPattern() == null || !new Regex(raw, codec.getPattern()).matches()) continue;
                    return codec;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum CODEC_TYPE {
        VIDEO,
        AUDIO,
        UNKNOWN;

    }

    public static class MEDIA {
        protected final TYPE type;
        protected final String groupID;
        protected final String language;
        protected final String name;
        protected final Boolean autoSelect;
        protected final Boolean defaultSelect;
        protected final Boolean forced;
        protected final String uri;

        public TYPE getType() {
            return this.type;
        }

        public String getGroupID() {
            return this.groupID;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getName() {
            return this.name;
        }

        public Boolean getAutoSelect() {
            return this.autoSelect;
        }

        public Boolean getDefaultSelect() {
            return this.defaultSelect;
        }

        public Boolean getForced() {
            return this.forced;
        }

        public String getUri() {
            return this.uri;
        }

        public MEDIA(TYPE type, String groupID, String language, String name, Boolean autoSelect, Boolean defaultSelect, Boolean forced, String uri) {
            this.type = type;
            this.groupID = groupID;
            this.language = language;
            this.name = name;
            this.autoSelect = autoSelect;
            this.defaultSelect = defaultSelect;
            this.forced = forced;
            this.uri = uri;
        }

        public String buildExtXMediaLine() {
            String name;
            StringBuilder sb = new StringBuilder();
            sb.append("#EXT-X-MEDIA:");
            switch (this.getType()) {
                case AUDIO: 
                case SUBTITLES: {
                    sb.append("TYPE=").append(this.getType().name());
                    break;
                }
                default: {
                    sb.append("TYPE=FIXME");
                }
            }
            sb.append(",GROUP-ID=\"").append(this.getGroupID()).append("\"");
            String language = this.getLanguage();
            if (language != null) {
                sb.append(",LANGUAGE=\"").append(language).append("\"");
            }
            if ((name = this.getName()) != null) {
                sb.append(",NAME=\"").append(name).append("\"");
            }
            sb.append(",AUTOSELECT=").append(Boolean.TRUE.equals(this.getAutoSelect()) ? "YES" : "NO");
            sb.append(",DEFAULT=").append(Boolean.TRUE.equals(this.getDefaultSelect()) ? "YES" : "NO");
            Boolean forced = this.getForced();
            if (forced != null) {
                sb.append(",FORCED=").append(Boolean.TRUE.equals(forced) ? "YES" : "NO");
            }
            sb.append(",URI=\"").append(this.getUri()).append("\"");
            return sb.toString();
        }

        public String toString() {
            return this.buildExtXMediaLine();
        }

        public static enum TYPE {
            VIDEO,
            AUDIO,
            SUBTITLES,
            CLOSEDCAPTIONS;


            public static TYPE parse(String type) {
                if ("VIDEO".equals(type)) {
                    return VIDEO;
                }
                if ("AUDIO".equals(type)) {
                    return AUDIO;
                }
                if ("SUBTITLES".equals(type)) {
                    return SUBTITLES;
                }
                if ("CLOSED-CAPTIONS".equals(type)) {
                    return CLOSEDCAPTIONS;
                }
                return null;
            }
        }
    }
}

