/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.usenet;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import jd.gui.swing.jdgui.views.settings.components.Checkbox;
import jd.gui.swing.jdgui.views.settings.components.ComboBox;
import jd.plugins.Plugin;
import jd.plugins.PluginConfigPanelNG;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.components.usenet.UsenetAccountConfigInterface;
import org.jdownloader.plugins.components.usenet.UsenetServer;
import org.jdownloader.plugins.config.PluginConfigPanelEventSenderListener;

public class UsenetConfigPanel
extends PluginConfigPanelNG {
    @Override
    protected boolean useCustomUI(KeyHandler<?> h) {
        return true;
    }

    public static void extend(PluginConfigPanelNG panel, String host, final List<UsenetServer> availableServers, final UsenetAccountConfigInterface cf) {
        panel.addHeader(_GUI.T.lit_usenet_settings(), new AbstractIcon("logo/nzb", 20));
        final ArrayList<String> hosts = new ArrayList<String>();
        for (UsenetServer us : availableServers) {
            if (hosts.contains(us.getHost())) continue;
            hosts.add(us.getHost());
        }
        ComboBox<String> cmbServer = new ComboBox<String>(hosts.toArray(new String[0])){

            protected String getLabel(int index, String value) {
                boolean sslSupported = false;
                boolean nonsslSupported = false;
                for (UsenetServer us : availableServers) {
                    if (!value.equals(us.getHost())) continue;
                    if (us.isSSL()) {
                        sslSupported = true;
                        continue;
                    }
                    nonsslSupported = true;
                }
                StringBuilder supportedProtocols = new StringBuilder();
                supportedProtocols.append(" (");
                if (sslSupported) {
                    supportedProtocols.append("SSL");
                }
                if (nonsslSupported) {
                    if (supportedProtocols.length() > 2) {
                        supportedProtocols.append(", ");
                    }
                    supportedProtocols.append("PLAIN");
                }
                supportedProtocols.append(")");
                return value + supportedProtocols.toString();
            }

            public void setSelectedItem(Object anObject) {
                if (anObject == null || !hosts.contains(anObject)) {
                    super.setSelectedItem((Object)((UsenetServer)availableServers.get(0)).getHost());
                } else {
                    super.setSelectedItem(anObject);
                }
            }
        };
        panel.addPair(_GUI.T.UsenetConfigPanel_Server(), (BooleanKeyHandler)null, cmbServer);
        cmbServer.setEnabled(hosts.size() > 1);
        ComboBox<Integer> cmbPort = new ComboBox<Integer>(new Integer[0]){

            protected String getLabel(int index, Integer port) {
                String host = UsenetConfigPanel.getHost(cf, availableServers);
                boolean sslSupported = false;
                boolean nonsslSupported = false;
                for (UsenetServer us : availableServers) {
                    if (!host.equals(us.getHost()) || port.intValue() != us.getPort()) continue;
                    if (us.isSSL()) {
                        sslSupported = true;
                        continue;
                    }
                    nonsslSupported = true;
                }
                StringBuilder supportedProtocols = new StringBuilder();
                supportedProtocols.append(" (");
                if (sslSupported) {
                    supportedProtocols.append("SSL");
                }
                if (nonsslSupported) {
                    if (supportedProtocols.length() > 2) {
                        supportedProtocols.append(", ");
                    }
                    supportedProtocols.append("PLAIN");
                }
                supportedProtocols.append(")");
                return port + supportedProtocols.toString();
            }

            public void setSelectedItem(Object anObject) {
                if (anObject == null) {
                    super.setSelectedItem((Object)((UsenetServer)availableServers.get(0)).getPort());
                } else {
                    super.setSelectedItem(anObject);
                }
            }
        };
        panel.addPair(_GUI.T.UsenetConfigPanel_port(), (BooleanKeyHandler)null, cmbPort);
        Checkbox cbSSL = new Checkbox();
        panel.addPair(_GUI.T.UsenetConfigPanel_ssl(), null, cbSSL);
        ActionListener al = new ActionListener((ComboBox)cmbServer, cf, (ComboBox)cmbPort, cbSSL, availableServers){
            final /* synthetic */ ComboBox val$cmbServer;
            final /* synthetic */ UsenetAccountConfigInterface val$cf;
            final /* synthetic */ ComboBox val$cmbPort;
            final /* synthetic */ Checkbox val$cbSSL;
            final /* synthetic */ List val$availableServers;
            {
                this.val$cmbServer = comboBox;
                this.val$cf = usenetAccountConfigInterface;
                this.val$cmbPort = comboBox2;
                this.val$cbSSL = checkbox;
                this.val$availableServers = list;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == this.val$cmbServer) {
                    this.val$cf.setHost((String)this.val$cmbServer.getSelectedItem());
                } else if (e.getSource() == this.val$cmbPort) {
                    this.val$cf.setPort((Integer)this.val$cmbPort.getSelectedItem());
                } else if (e.getSource() == this.val$cbSSL) {
                    this.val$cf.setSSLEnabled(this.val$cbSSL.isSelected());
                    return;
                }
                UsenetConfigPanel.updateModels(this.val$cf, this.val$availableServers, (ComboBox<String>)this.val$cmbServer, (ComboBox<Integer>)this.val$cmbPort, this.val$cbSSL);
            }
        };
        cmbPort.addActionListener(al);
        cmbServer.addActionListener(al);
        cbSSL.addActionListener(al);
        cmbServer.setSelectedItem((Object)cf.getHost());
        panel.getEventSender().addListener(new PluginConfigPanelEventSenderListener((ComboBox)cmbPort, al, (ComboBox)cmbServer, cbSSL, cf, availableServers){
            final /* synthetic */ ComboBox val$cmbPort;
            final /* synthetic */ ActionListener val$al;
            final /* synthetic */ ComboBox val$cmbServer;
            final /* synthetic */ Checkbox val$cbSSL;
            final /* synthetic */ UsenetAccountConfigInterface val$cf;
            final /* synthetic */ List val$availableServers;
            {
                this.val$cmbPort = comboBox;
                this.val$al = actionListener;
                this.val$cmbServer = comboBox2;
                this.val$cbSSL = checkbox;
                this.val$cf = usenetAccountConfigInterface;
                this.val$availableServers = list;
            }

            @Override
            public void onConfigPanelReset(Plugin plugin, PluginConfigPanelNG pluginConfigPanelNG, Set<ConfigInterface> interfaces) {
                new EDTRunner(){

                    protected void runInEDT() {
                        try {
                            val$cmbPort.removeActionListener(val$al);
                            val$cmbServer.removeActionListener(val$al);
                            val$cbSSL.removeActionListener(val$al);
                            val$cf.setHost(((UsenetServer)val$availableServers.get(0)).getHost());
                            val$cf.setSSLEnabled(((UsenetServer)val$availableServers.get(0)).isSSL());
                            val$cf.setPort(((UsenetServer)val$availableServers.get(0)).getPort());
                            UsenetConfigPanel.updateModels(val$cf, val$availableServers, (ComboBox<String>)val$cmbServer, (ComboBox<Integer>)val$cmbPort, val$cbSSL);
                        }
                        finally {
                            val$cmbPort.addActionListener(val$al);
                            val$cmbServer.addActionListener(val$al);
                            val$cbSSL.addActionListener(val$al);
                        }
                    }
                };
            }
        });
        panel.add(Box.createGlue(), "gapbottom 5,pushx,growx,spanx" + panel.getRightGap());
    }

    private static String getHost(UsenetAccountConfigInterface cf, List<UsenetServer> availableServers) {
        String accHost = cf.getHost();
        for (UsenetServer availableServer : availableServers) {
            if (!StringUtils.equals((String)availableServer.getHost(), (String)accHost)) continue;
            return accHost;
        }
        return availableServers.get(0).getHost();
    }

    protected static void updateModels(UsenetAccountConfigInterface cf, List<UsenetServer> availableServers, ComboBox<String> cmbServer, ComboBox<Integer> cmbPort, Checkbox cbSSL) {
        String host = UsenetConfigPanel.getHost(cf, availableServers);
        int port = cf.getPort();
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (UsenetServer us : availableServers) {
            if (!host.equals(us.getHost()) || ports.contains(us.getPort())) continue;
            ports.add(us.getPort());
        }
        if (!ports.contains(port)) {
            port = (Integer)ports.get(0);
        }
        cmbPort.setModel((Object[])ports.toArray(new Integer[0]));
        boolean sslSupported = false;
        boolean nonsslSupported = false;
        for (UsenetServer us : availableServers) {
            if (!host.equals(us.getHost()) || port != us.getPort()) continue;
            if (us.isSSL()) {
                sslSupported = true;
                continue;
            }
            nonsslSupported = true;
        }
        cbSSL.setEnabled(sslSupported && nonsslSupported);
        if (!sslSupported) {
            cf.setSSLEnabled(false);
        } else if (!nonsslSupported) {
            cf.setSSLEnabled(true);
        }
        cbSSL.setSelected(cf.isSSLEnabled());
        cmbPort.setSelectedItem((Object)cf.getPort());
    }

    @Override
    public void save() {
    }

    @Override
    public void updateContents() {
    }
}

