/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.usenet;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.appwork.storage.Storable;
import org.appwork.utils.StringUtils;

public class UsenetServer
implements Storable {
    private String host = null;
    private int port = -1;
    private int connections = -1;
    private boolean ssl = false;

    public UsenetServer() {
    }

    public UsenetServer(String host, int port) {
        this(host, port, false);
    }

    public UsenetServer(String host, int port, boolean ssl) {
        this.host = host;
        this.port = port;
        this.ssl = ssl;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port > 0 ? this.port : (this.isSSL() ? 563 : 119);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public void setSSL(boolean ssl) {
        this.ssl = ssl;
    }

    public int getConnections() {
        return this.connections;
    }

    public void setConnections(int connections) {
        this.connections = connections;
    }

    public boolean validate() {
        return this.getPort() > 0 && StringUtils.isNotEmpty((String)this.getHost());
    }

    public int hashCode() {
        return (this.getHost() + ":" + this.getPort() + ":" + this.isSSL()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof UsenetServer)) {
            return false;
        }
        UsenetServer other = (UsenetServer)obj;
        return this.isSSL() == other.isSSL() && this.getPort() == other.getPort() && StringUtils.equalsIgnoreCase((String)this.getHost(), (String)other.getHost());
    }

    public String toString() {
        return String.format(Locale.ROOT, "Host:%s|Port:%d|Connections:%d|SSL:%b", this.getHost(), this.getPort(), this.getConnections(), this.isSSL());
    }

    public static List<UsenetServer> createServerList(String host, boolean ssl, int ... ports) {
        if (ssl) {
            return UsenetServer.createServerList(host, new int[0], ports);
        }
        return UsenetServer.createServerList(host, ports, new int[0]);
    }

    public static List<UsenetServer> createServerList(String host, int[] nonSSLPorts, int[] SSLPorts) {
        ArrayList<UsenetServer> servers = new ArrayList<UsenetServer>();
        for (int port : nonSSLPorts) {
            servers.add(new UsenetServer(host, port, false));
        }
        for (int port : SSLPorts) {
            servers.add(new UsenetServer(host, port, true));
        }
        return servers;
    }
}

