/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import jd.plugins.AccountRequiredException;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.jdownloader.plugins.components.youtube.YoutubeClipData;
import org.jdownloader.plugins.components.youtube.YoutubeHelper;
import org.jdownloader.translate._JDT;

public class ClipDataCache {
    public static final String THE_DOWNLOAD_IS_NOT_AVAILABLE_IN_YOUR_COUNTRY = "The Download is not available in your country";
    private static final WeakHashMap<CachedClipData, String> CACHE = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YoutubeClipData get(YoutubeHelper helper, DownloadLink downloadLink) throws Exception {
        CachedClipData ret;
        String videoID = downloadLink.getStringProperty("YT_ID");
        String playListID = downloadLink.getStringProperty("YT_PLAYLIST_ID");
        String previousPlayListID = helper.getPlaylistID();
        try {
            helper.setPlaylistID(playListID);
            ret = ClipDataCache.get(helper, new YoutubeClipData(videoID));
            ret.clipData.copyToDownloadLink(downloadLink);
        }
        finally {
            helper.setPlaylistID(previousPlayListID);
        }
        downloadLink.getTempProperties().setProperty("CLIP_DATA_REFERENCE", ret);
        return ret.clipData;
    }

    public static YoutubeClipData load(YoutubeHelper helper, YoutubeClipData vid) throws Exception {
        return ClipDataCache.get(helper, vid).clipData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CachedClipData get(YoutubeHelper helper, YoutubeClipData vid) throws Exception {
        String cachedID = vid.videoID;
        if (StringUtils.isEmpty((String)cachedID)) {
            throw new PluginException(0x400000);
        }
        List proxyListNew = helper.getBr().selectProxies(new URL("https://youtube.com"));
        while (true) {
            CachedClipData cachedData;
            if ((cachedData = ClipDataCache.get(cachedID)) != null) {
                CachedClipData cachedClipData = cachedData;
                synchronized (cachedClipData) {
                    if (cachedData.isExpired()) {
                        helper.getLogger().info("invalidate CachedClipData:" + cachedID + "|reason:expired");
                    } else if (!cachedData.hasValidProxyList(proxyListNew)) {
                        helper.getLogger().info("invalidate CachedClipData:" + cachedID + "|reason:no valid proxyList");
                    } else if (StringUtils.isEmpty((String)((CachedClipData)cachedData).clipData.title)) {
                        helper.getLogger().info("invalidate CachedClipData:" + cachedID + "|reason:missing title");
                    } else if (((CachedClipData)cachedData).clipData.datePublished == 0L) {
                        helper.getLogger().info("invalidate CachedClipData:" + cachedID + "|reason:missing date");
                    } else if (cachedData.clipData == null) {
                        helper.getLogger().info("invalidate CachedClipData:" + cachedID + "|reason:missing data");
                    } else {
                        helper.getLogger().info("valid CachedClipData found:" + cachedID);
                        cachedData.clipData.copyTo(vid);
                        ClipDataCache.check(helper, cachedData);
                        return cachedData;
                    }
                }
            }
            CachedClipData newCachedData = null;
            Object object = CACHE;
            synchronized (object) {
                if (ClipDataCache.get(cachedID) == cachedData) {
                    newCachedData = new CachedClipData(proxyListNew, vid);
                    ClipDataCache.put(cachedID, newCachedData);
                }
                cachedData = ClipDataCache.get(cachedID);
            }
            object = cachedData;
            synchronized (object) {
                if (cachedData == newCachedData) {
                    try {
                        helper.getLogger().info("refresh CachedClipData:" + cachedID);
                        helper.loadVideo(cachedData.clipData);
                    }
                    finally {
                        cachedData.notifyAll();
                    }
                } else {
                    cachedData.wait(500L);
                }
            }
        }
    }

    private static void check(YoutubeHelper helper, CachedClipData cachedData) throws PluginException {
        if (((CachedClipData)cachedData).clipData.streams == null || StringUtils.isNotEmpty((String)((CachedClipData)cachedData).clipData.error)) {
            if (StringUtils.equalsIgnoreCase((String)((CachedClipData)cachedData).clipData.error, (String)"This video is unavailable.") || StringUtils.equalsIgnoreCase((String)((CachedClipData)cachedData).clipData.error, (String)"This video is not available.")) {
                throw new PluginException(32, ((CachedClipData)cachedData).clipData.error);
            }
            if (StringUtils.containsIgnoreCase((String)((CachedClipData)cachedData).clipData.error, (String)"This video has been removed")) {
                throw new PluginException(32, ((CachedClipData)cachedData).clipData.error);
            }
            if (StringUtils.containsIgnoreCase((String)((CachedClipData)cachedData).clipData.error, (String)"This Video is Private")) {
                if (helper.getAccountLoggedIn() != null) {
                    // empty if block
                }
                throw new AccountRequiredException(((CachedClipData)cachedData).clipData.error);
            }
            if (((CachedClipData)cachedData).clipData.error != null) {
                String lc = ((CachedClipData)cachedData).clipData.error.toLowerCase(Locale.ENGLISH);
                if (lc.contains("is not available in your country") || lc.contains("geo blocked due to copyright grounds")) {
                    throw new PluginException(2048, THE_DOWNLOAD_IS_NOT_AVAILABLE_IN_YOUR_COUNTRY).localizedMessage(_JDT.T.CountryIPBlockException_createCandidateResult());
                }
                if (lc.contains("content is not available in")) {
                    throw new PluginException(2048, THE_DOWNLOAD_IS_NOT_AVAILABLE_IN_YOUR_COUNTRY).localizedMessage(_JDT.T.CountryIPBlockException_createCandidateResult());
                }
            }
            throw new PluginException(2048, ((CachedClipData)cachedData).clipData.error);
        }
    }

    public static void clearCache(DownloadLink downloadLink) {
        String videoID = downloadLink.getStringProperty("YT_ID");
        ClipDataCache.clearCache(videoID);
    }

    public static void clearCache(String videoID) {
        ClipDataCache.put(videoID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void referenceLink(YoutubeHelper helper, DownloadLink link, YoutubeClipData vid) {
        String cachedID = vid.videoID;
        List proxyListNew = null;
        try {
            proxyListNew = helper.getBr().selectProxies(new URL("https://youtube.com"));
        }
        catch (IOException e) {
            helper.getLogger().log((Throwable)e);
        }
        while (true) {
            Object object;
            CachedClipData data;
            if ((data = ClipDataCache.get(cachedID)) != null) {
                object = data;
                synchronized (object) {
                    if (!data.isExpired() && data.hasValidProxyList(proxyListNew)) {
                        data.clipData = vid;
                        link.getTempProperties().setProperty("CLIP_DATA_REFERENCE", data);
                        break;
                    }
                }
            }
            object = CACHE;
            synchronized (object) {
                if (ClipDataCache.get(cachedID) == data) {
                    data = new CachedClipData(proxyListNew, vid);
                    link.getTempProperties().setProperty("CLIP_DATA_REFERENCE", data);
                    ClipDataCache.put(cachedID, data);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CachedClipData get(String videoID) {
        WeakHashMap<CachedClipData, String> weakHashMap = CACHE;
        synchronized (weakHashMap) {
            Iterator<Map.Entry<CachedClipData, String>> it = CACHE.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<CachedClipData, String> next = it.next();
                CachedClipData ret = next.getKey();
                if (ret == null || ret.clipData == null) {
                    it.remove();
                    continue;
                }
                if (!StringUtils.equals((String)videoID, (String)next.getValue())) continue;
                return ret;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void put(String videoID, CachedClipData data) {
        WeakHashMap<CachedClipData, String> weakHashMap = CACHE;
        synchronized (weakHashMap) {
            Iterator<Map.Entry<CachedClipData, String>> it = CACHE.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<CachedClipData, String> next = it.next();
                CachedClipData ret = next.getKey();
                if (ret == null || ret.clipData == null) {
                    it.remove();
                    continue;
                }
                if (!StringUtils.equals((String)videoID, (String)next.getValue())) continue;
                it.remove();
            }
            if (data != null) {
                CACHE.put(data, videoID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasCache(YoutubeHelper helper, String videoID) {
        CachedClipData cachedData = ClipDataCache.get(videoID);
        if (cachedData != null) {
            CachedClipData cachedClipData = cachedData;
            synchronized (cachedClipData) {
                try {
                    List proxyListNew = helper.getBr().selectProxies(new URL("https://youtube.com"));
                    return !cachedData.isExpired() && cachedData.hasValidProxyList(proxyListNew);
                }
                catch (IOException e) {
                    helper.getLogger().log((Throwable)e);
                }
            }
        }
        return false;
    }

    public static boolean hasCache(YoutubeHelper helper, DownloadLink downloadLink) {
        String videoID = downloadLink.getStringProperty("YT_ID");
        return ClipDataCache.hasCache(helper, videoID);
    }

    private static class CachedClipData {
        private volatile YoutubeClipData clipData = null;
        private final long timeStamp = Time.systemIndependentCurrentJVMTimeMillis();
        private final List<HTTPProxy> proxyList;

        private CachedClipData(List<HTTPProxy> proxyListNew, YoutubeClipData youtubeClipData) {
            this.clipData = youtubeClipData;
            this.proxyList = proxyListNew;
        }

        private boolean hasValidProxyList(List<HTTPProxy> validateList) {
            if (this.proxyList != null && validateList != null) {
                for (HTTPProxy proxy : this.proxyList) {
                    if (validateList.contains(proxy)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean isExpired() {
            return Time.systemIndependentCurrentJVMTimeMillis() - this.timeStamp > 1800000L;
        }
    }
}

