/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.parser.Regex;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.ide.IDEUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.parser.UrlQuery;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.controlling.ffmpeg.FFprobe;
import org.jdownloader.controlling.ffmpeg.json.Stream;
import org.jdownloader.controlling.ffmpeg.json.StreamInfo;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.components.youtube.YoutubeClipData;
import org.jdownloader.plugins.components.youtube.itag.AudioBitrate;
import org.jdownloader.plugins.components.youtube.itag.AudioCodec;
import org.jdownloader.plugins.components.youtube.itag.VideoCodec;
import org.jdownloader.plugins.components.youtube.itag.VideoFrameRate;
import org.jdownloader.plugins.components.youtube.itag.VideoResolution;
import org.jdownloader.plugins.components.youtube.itag.YoutubeITAG;
import org.jdownloader.plugins.components.youtube.keepForCompatibility.YoutubeVariantOld;
import org.jdownloader.plugins.components.youtube.variants.DownloadType;
import org.jdownloader.plugins.components.youtube.variants.FileContainer;
import org.jdownloader.plugins.components.youtube.variants.VariantBase;
import org.jdownloader.plugins.components.youtube.variants.VariantGroup;

public class ItagHelper {
    private static HashSet<String> dupes;
    private static HashSet<String> EXCLUDES;
    private static Class<?> caller;
    private UrlQuery query;
    private String url;
    private String itag;
    private Browser br;
    private StreamInfo streamInfo;
    private YoutubeClipData vid;
    private File file;

    public static int fillCompatibility() throws IOException {
        Application.setApplication((String)".jd_home");
        if (dupes == null) {
            dupes = new HashSet();
        }
        int i = 0;
        for (YoutubeVariantOld vo : YoutubeVariantOld.values()) {
            if (VariantBase.COMPATIBILITY_MAP.containsKey(vo.name())) continue;
            System.out.println((Object)vo);
            i = ItagHelper.handleCompatibility(i, vo);
        }
        return i;
    }

    private static int handleCompatibility(int i, YoutubeVariantOld vo) throws IOException {
        boolean b = false;
        for (VariantBase v : VariantBase.values()) {
            if (vo.getiTagAudio() != v.getiTagAudio() || vo.getiTagData() != v.getiTagData() || vo.getiTagVideo() != v.getiTagVideo() || vo.getGroup() != v.getGroup() || !StringUtils.equalsIgnoreCase((String)vo.getFileExtension(), (String)v.getContainer().getExtension())) continue;
            System.out.println("Match" + (Object)((Object)vo) + " - " + (Object)((Object)v));
            if (!StringUtils.equals((String)vo.name(), (String)v.name())) {
                ItagHelper.appendToSrc("COMPATIBILITY_MAP.put(\"" + vo.name() + "\"," + v.name() + ");", "// ###APPEND_COMPATIBILITY_MAP###");
            }
            ++i;
            b = true;
        }
        if (!b) {
            System.out.println("Not Found");
        }
        return i;
    }

    public static void main(String[] args) throws DialogClosedException, DialogCanceledException, IOException {
        Application.setApplication((String)".jd_home");
        EXCLUDES = new HashSet();
        EXCLUDES.add("DEMUX_AMRNB_.*");
        EXCLUDES.add("DEMUX_.*_THREEGP.*");
        EXCLUDES.add("DEMUX_VORBIS_.*");
        ArrayList<YoutubeITAG> dashVideos = new ArrayList<YoutubeITAG>();
        ArrayList<YoutubeITAG> dashAudios = new ArrayList<YoutubeITAG>();
        ArrayList<YoutubeITAG> nonDash = new ArrayList<YoutubeITAG>();
        block3: for (YoutubeITAG youtubeITAG : YoutubeITAG.values()) {
            switch (youtubeITAG) {
                case SUBTITLE: 
                case DESCRIPTION: 
                case COVER_HQ: 
                case IMAGE_HQ: 
                case COVER_LQ: 
                case IMAGE_LQ: 
                case COVER_MAX: 
                case IMAGE_MAX: 
                case COVER_MQ: 
                case IMAGE_MQ: {
                    continue block3;
                }
                default: {
                    if (youtubeITAG.getAudioCodec() == null) {
                        dashVideos.add(youtubeITAG);
                        continue block3;
                    }
                    if (youtubeITAG.getVideoCodec() == null) {
                        dashAudios.add(youtubeITAG);
                        continue block3;
                    }
                    nonDash.add(youtubeITAG);
                }
            }
        }
        dupes = new HashSet();
        for (Enum enum_ : VariantBase.values()) {
            dupes.add(enum_.name());
        }
        for (YoutubeITAG itag : nonDash) {
            ItagHelper.handleItag(itag);
        }
        for (YoutubeITAG dashAudio : dashAudios) {
            for (YoutubeITAG youtubeITAG : dashVideos) {
                AudioCodec audioCodec;
                VideoCodec videoCodec = youtubeITAG.getVideoCodec();
                if (!ItagHelper.validCombination(videoCodec, audioCodec = dashAudio.getAudioCodec())) continue;
                ItagHelper.handleDashCombination(youtubeITAG, dashAudio);
            }
        }
    }

    private static void handleDashCombination(YoutubeITAG dashVideo, YoutubeITAG dashAudio) throws IOException {
        if (dashVideo.name().contains("HLS")) {
            throw new WTFException("DASH HLS");
        }
        if (dashAudio.name().contains("HLS")) {
            throw new WTFException("DASH HLS");
        }
        VideoResolution resolution = dashVideo.getVideoResolution();
        AudioBitrate bitrate = dashAudio.getAudioBitrate();
        FileContainer videoContainer = FileContainer.getVideoContainer(dashVideo, dashAudio);
        FileContainer audioContainer2 = FileContainer.getAudioContainer(dashVideo, dashAudio);
        boolean is3DItag = dashVideo.name().contains("3D");
        VideoFrameRate fps = dashVideo.getVideoFrameRate();
        VideoCodec videoCodec = dashVideo.getVideoCodec();
        AudioCodec audioCodec = dashAudio.getAudioCodec();
        String baseName = videoContainer.name() + "_" + videoCodec.name() + "_" + resolution.getHeight() + "P_" + (int)Math.ceil(fps.getFps()) + "FPS_" + audioCodec.name() + "_" + bitrate.getKbit() + "KBIT_DASH";
        baseName = baseName.toUpperCase(Locale.ENGLISH);
        VariantInfo vi = new VariantInfo(baseName);
        vi.fps = fps;
        vi.group = VariantGroup.VIDEO;
        vi.downloadType = DownloadType.DASH_VIDEO;
        vi.container = videoContainer;
        vi.videoItag = dashVideo;
        vi.audioItag = dashAudio;
        vi.dataItag = null;
        if (!is3DItag) {
            ItagHelper.addVi(vi);
        } else {
            vi.baseName = baseName + "_3D";
            if (is3DItag) {
                ItagHelper.addVi(vi);
            }
        }
        if (!dupes.add(dashAudio.name())) {
            return;
        }
        String audioName = StringUtils.equalsIgnoreCase((String)audioContainer2.name(), (String)audioCodec.name()) ? audioContainer2.name() + "_" + bitrate.getKbit() + "KBIT_DASH" : audioContainer2.name() + "_" + audioCodec.name() + "_" + bitrate.getKbit() + "KBIT_DASH";
        audioName = audioName.toUpperCase(Locale.ENGLISH);
        vi.baseName = audioName;
        vi.group = VariantGroup.AUDIO;
        vi.downloadType = DownloadType.DASH_AUDIO;
        vi.container = audioContainer2;
        vi.videoItag = null;
        ItagHelper.addVi(vi);
        switch (audioContainer2) {
            case AAC: {
                vi.container = audioContainer2 = FileContainer.M4A;
                audioName = audioContainer2.name() + "_" + audioCodec.name() + "_" + bitrate.getKbit() + "KBIT_DASH";
                vi.baseName = audioName.toUpperCase(Locale.ENGLISH);
                vi.extender = null;
                ItagHelper.addVi(vi);
            }
        }
    }

    private static void handleItag(YoutubeITAG itag) throws IOException {
        VideoFrameRate fps = itag.getVideoFrameRate();
        VideoResolution resolution = itag.getVideoResolution();
        AudioBitrate bitrate = itag.getAudioBitrate();
        VideoCodec videoCodec = itag.getVideoCodec();
        FileContainer container = FileContainer.getVideoContainer(itag, itag);
        AudioCodec audioCodec = itag.getAudioCodec();
        FileContainer audioContainer = FileContainer.getAudioContainer(itag, itag);
        boolean is3DItag = itag.name().contains("3D");
        String baseName = container.name() + "_" + videoCodec.name() + "_" + resolution.getHeight() + "P_" + (int)Math.ceil(fps.getFps()) + "FPS_" + audioCodec.name() + "_" + bitrate.getKbit() + "KBIT";
        baseName = baseName.toUpperCase(Locale.ENGLISH);
        if (itag.name().contains("HLS")) {
            baseName = "HLS_" + baseName;
        }
        VariantInfo vi = new VariantInfo(baseName);
        vi.fps = fps;
        vi.group = VariantGroup.VIDEO;
        vi.downloadType = DownloadType.VIDEO;
        vi.container = container;
        if (itag.name().contains("HLS")) {
            vi.downloadType = DownloadType.HLS_VIDEO;
        }
        vi.videoItag = itag;
        vi.audioItag = null;
        vi.dataItag = null;
        if (!is3DItag) {
            ItagHelper.addVi(vi);
        } else {
            vi.baseName = baseName + "_3D";
            ItagHelper.addVi(vi);
        }
        vi.container = audioContainer;
        vi.baseName = "DEMUX_" + audioCodec.name() + "_" + baseName;
        vi.group = VariantGroup.AUDIO;
        vi.converter = "YoutubeConverter" + (Object)((Object)container) + "To" + (Object)((Object)audioContainer) + "Audio.getInstance()";
        vi.extender = null;
        ItagHelper.addVi(vi);
        if (audioCodec == AudioCodec.AAC) {
            vi.converter = "YoutubeConverter" + (Object)((Object)container) + "ToM4AAudio.getInstance()";
            vi.extender = null;
            vi.container = FileContainer.M4A;
            vi.baseName = "DEMUX_M4A_" + baseName;
            ItagHelper.addVi(vi);
        }
    }

    private static String generateMethod(String annotation, String header, String extra, String ret) {
        StringBuilder sb = new StringBuilder();
        sb.append(annotation);
        sb.append("\r\n");
        sb.append("public " + header + " {\r\n");
        if (extra != null) {
            sb.append("\r\n").append(extra).append("\r\n");
        }
        sb.append(" return " + ret + ";\r\n");
        sb.append("}\r\n");
        return sb.toString();
    }

    private static void addVi(VariantInfo vi) throws IOException {
        for (String regex : EXCLUDES) {
            if (!vi.baseName.matches(regex)) continue;
            System.out.println("Ignore " + vi + "(" + regex + ")");
            return;
        }
        VariantBase existingVariant = ItagHelper.getExistingVariant(vi);
        if (existingVariant == null) {
            System.out.println("Write " + vi.baseName);
            ItagHelper.appendToSrc(vi.generateVariantSource(dupes), "// ###APPEND###");
        } else {
            String existingBaseName = existingVariant.name().replaceAll("_\\d+$", "");
            if (!StringUtils.equals((String)existingBaseName, (String)vi.baseName)) {
                System.out.println("Write " + vi.baseName + " replace " + (Object)((Object)existingVariant));
            }
        }
    }

    private static void removeFromSrc(String search, String replace) throws IOException {
        File project = IDEUtils.getProjectFolder(VariantBase.class);
        File variantSourceFile = new File(new File(project, "src"), VariantBase.class.getName().replace(".", "/") + ".java");
        String src = IO.readFileToString((File)variantSourceFile);
        src = Pattern.compile(search, 34).matcher(src).replaceAll(replace);
        variantSourceFile.delete();
        IO.writeStringToFile((File)variantSourceFile, (String)src, (boolean)false, (IO.SYNC)IO.SYNC.META_AND_DATA);
    }

    private static void appendToSrc(String newSrc, String tag) throws IOException {
        File project = IDEUtils.getProjectFolder(VariantBase.class);
        File variantSourceFile = new File(new File(project, "src"), VariantBase.class.getName().replace(".", "/") + ".java");
        String src = IO.readFileToString((File)variantSourceFile);
        src = src.replace(tag, newSrc + "\r\n" + tag);
        variantSourceFile.delete();
        IO.writeStringToFile((File)variantSourceFile, (String)src, (boolean)false, (IO.SYNC)IO.SYNC.META_AND_DATA);
    }

    private static VariantBase getExistingVariant(VariantInfo vi) {
        for (VariantBase v : VariantBase.values()) {
            String baseName;
            if (!StringUtils.equalsIgnoreCase((String)v.getContainer().getExtension(), (String)vi.container.getExtension()) || vi.group != v.getGroup() || vi.videoItag != v.getiTagVideo() || vi.audioItag != v.getiTagAudio() || vi.dataItag != v.getiTagData() || !StringUtils.equals((String)(baseName = v.name().replaceAll("_\\d+$", "")), (String)vi.baseName)) continue;
            return v;
        }
        for (VariantBase v : VariantBase.values()) {
            if (!StringUtils.equalsIgnoreCase((String)v.getContainer().getExtension(), (String)vi.container.getExtension()) || vi.group != v.getGroup() || vi.videoItag != v.getiTagVideo() || vi.audioItag != v.getiTagAudio() || vi.dataItag != v.getiTagData()) continue;
            System.out.println((Object)v.getiTagVideo());
            System.out.println((Object)v.getiTagAudio());
            System.out.println((Object)v.getiTagData());
            return v;
        }
        return null;
    }

    public static boolean validCombination(VideoCodec videoCodec, AudioCodec audioCodec) {
        switch (videoCodec) {
            case H263: 
            case H264: {
                switch (audioCodec) {
                    case AAC: 
                    case AAC_SPATIAL: {
                        return true;
                    }
                }
                return false;
            }
            case AV1: {
                switch (audioCodec) {
                    case AAC: 
                    case AAC_SPATIAL: {
                        return true;
                    }
                    case OPUS: {
                        return false;
                    }
                    case VORBIS: 
                    case VORBIS_SPATIAL: {
                        return true;
                    }
                }
                return false;
            }
            case VP8: 
            case VP9: 
            case VP9_HDR: 
            case VP9_BETTER_PROFILE_1: 
            case VP9_BETTER_PROFILE_2: 
            case VP9_WORSE_PROFILE_1: {
                switch (audioCodec) {
                    case AAC: {
                        return true;
                    }
                    case AAC_SPATIAL: 
                    case MP3: {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public ItagHelper(YoutubeClipData vid, Browser br, UrlQuery query, String url) {
        this.query = query;
        this.url = url;
        this.itag = query.get("itag");
        this.br = br;
        this.vid = vid;
    }

    public int getKBIT(Stream audio) {
        int bps = -1;
        try {
            bps = Integer.parseInt(audio.getBit_rate());
        }
        catch (Throwable e) {
            bps = (int)((double)this.file.length() / Double.parseDouble(this.streamInfo.getFormat().getDuration()) * 8.0);
        }
        return bps / 1000;
    }

    public int getFPS(Stream video) {
        String[] d = new Regex(video.getAvg_frame_rate(), "(\\d+)/(\\d+)").getRow(0);
        return (int)Math.ceil((double)Integer.parseInt(d[0]) / (double)Integer.parseInt(d[1]));
    }

    public String getVideoResolution(Stream video) {
        return video.getHeight() + "";
    }

    private String upper(Object string) {
        String str = string.toString();
        if (Character.isDigit(str.charAt(0))) {
            switch (str.charAt(0)) {
                case '0': {
                    str = "zero" + str.substring(1);
                    break;
                }
                case '1': {
                    str = "one" + str.substring(1);
                    break;
                }
                case '2': {
                    str = "two" + str.substring(1);
                    break;
                }
                case '3': {
                    str = "three" + str.substring(1);
                    break;
                }
                case '4': {
                    str = "fou_" + str.substring(1);
                    break;
                }
                case '5': {
                    str = "five" + str.substring(1);
                    break;
                }
                case '6': {
                    str = "six" + str.substring(1);
                    break;
                }
                case '7': {
                    str = "seven" + str.substring(1);
                    break;
                }
                case '8': {
                    str = "eight" + str.substring(1);
                    break;
                }
                case '\t': {
                    str = "nine" + str.substring(1);
                }
            }
        }
        return str.toUpperCase(Locale.ENGLISH).replaceAll("[\\s\\-]+", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStreamInfo() throws IOException {
        LogSource logger = LogController.CL(true);
        FFprobe ffprobe = new FFprobe(null, (LogInterface)logger){
            final /* synthetic */ LogInterface val$logger;
            {
                this.val$logger = logInterface;
                super(br);
            }

            @Override
            public LogInterface getLogger() {
                return this.val$logger;
            }
        };
        this.file = Application.getResource((String)("tmp/ytdev/stream_" + this.itag + "_" + this.vid.videoID + ".dat"));
        if (!this.file.exists()) {
            URLConnectionAdapter con = this.br.openGetConnection(this.url);
            FileOutputStream fos = null;
            try {
                this.file.getParentFile().mkdirs();
                fos = new FileOutputStream(this.file);
                IO.readStreamToOutputStream((int)-1, (InputStream)con.getInputStream(), (OutputStream)fos, (boolean)true);
            }
            finally {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
                try {
                    if (con != null) {
                        con.disconnect();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        this.streamInfo = ffprobe.getStreamInfo(this.file);
    }

    public void run() {
        Dialog.getInstance().showMessageDialog("Unknown ITag found: " + this.query + "\r\nAsk Coalado to Update the ItagHelper for Video ID: " + this.vid.videoID);
    }

    static {
        caller = ItagHelper.class;
    }

    private static class VariantInfo {
        public VideoFrameRate fps;
        private String baseName;
        public VariantGroup group;
        public DownloadType downloadType;
        public YoutubeITAG videoItag;
        public YoutubeITAG audioItag;
        public YoutubeITAG dataItag;
        public FileContainer container;
        public String converter;
        public String extender;

        public VariantInfo(String name) {
            this.baseName = name;
        }

        public String generateVariantSource(HashSet<String> dupes) {
            String name = this.createName();
            int i = 2;
            while (dupes.contains(name)) {
                name = this.createName() + "_" + i++;
            }
            dupes.add(name);
            StringBuilder sb = new StringBuilder();
            sb.append(",\r\n");
            sb.append(name).append("(");
            sb.append("VariantGroup." + this.group.name());
            sb.append(", ");
            sb.append("DownloadType." + this.downloadType.name());
            sb.append(", ");
            sb.append("FileContainer.").append((Object)this.container).append("");
            sb.append(", ");
            sb.append(this.videoItag == null ? "null" : "YoutubeITAG." + (Object)((Object)this.videoItag));
            sb.append(", ");
            sb.append(this.audioItag == null ? "null" : "YoutubeITAG." + (Object)((Object)this.audioItag));
            sb.append(", ");
            sb.append(this.dataItag == null ? "null" : "YoutubeITAG." + (Object)((Object)this.dataItag));
            sb.append(", ");
            sb.append(this.converter);
            sb.append(")");
            if (this.extender != null) {
                sb.append("{\r\n");
                sb.append(this.extender);
                sb.append("}");
            }
            System.out.println(sb);
            return sb.toString();
        }

        private String createName() {
            return this.baseName;
        }
    }
}

