/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube;

import org.appwork.storage.Storable;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.AudioVariant;
import org.jdownloader.plugins.components.youtube.variants.ImageVariant;
import org.jdownloader.plugins.components.youtube.variants.SubtitleVariant;
import org.jdownloader.plugins.components.youtube.variants.VariantGroup;
import org.jdownloader.plugins.components.youtube.variants.VideoVariant;

public class VariantIDStorable
implements Storable {
    private String group;
    private String container;
    private String projection;
    private int height;
    private int vheight;
    private int aBitrate;
    private int fps;
    private String vCodec;
    private String aCodec;
    private String base;

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getProjection() {
        return this.projection;
    }

    public void setProjection(String projection) {
        this.projection = projection;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getaBitrate() {
        return this.aBitrate;
    }

    public void setaBitrate(int aBitrate) {
        this.aBitrate = aBitrate;
    }

    public int getFps() {
        return this.fps;
    }

    public void setFps(int fps) {
        this.fps = fps;
    }

    public String getvCodec() {
        return this.vCodec;
    }

    public void setvCodec(String vCodec) {
        this.vCodec = vCodec;
    }

    public String getaCodec() {
        return this.aCodec;
    }

    public void setaCodec(String aCodec) {
        this.aCodec = aCodec;
    }

    public int getVheight() {
        if (this.vheight > 0) {
            return this.vheight;
        }
        return this.height;
    }

    public void setVheight(int vheight) {
        this.vheight = vheight;
    }

    public VariantIDStorable() {
    }

    public VariantIDStorable(AbstractVariant variant) {
        this.container = variant.getContainer().name();
        this.group = variant.getGroup().name();
        if (variant instanceof AudioVariant) {
            AudioVariant avar = (AudioVariant)variant;
            this.aBitrate = avar.getiTagAudioOrVideoItagEquivalent().getAudioBitrate().getKbit();
            this.aCodec = avar.getiTagAudioOrVideoItagEquivalent().getAudioCodec().name();
        } else if (variant instanceof VideoVariant) {
            VideoVariant vvar = (VideoVariant)variant;
            this.aBitrate = vvar.getiTagAudioOrVideoItagEquivalent().getAudioBitrate().getKbit();
            this.aCodec = vvar.getiTagAudioOrVideoItagEquivalent().getAudioCodec().name();
            this.vCodec = vvar.getiTagVideo().getVideoCodec().name();
            this.fps = vvar.getiTagVideo().getVideoFrameRate().getInt();
            this.height = vvar.getiTagVideo().getVideoResolution().getHeight();
            this.projection = vvar.getProjection().name();
            this.vheight = vvar.getVideoHeight();
        } else if (!(variant instanceof SubtitleVariant) && variant instanceof ImageVariant) {
            this.base = variant.getBaseVariant().name();
        }
    }

    public String createUniqueID() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.aBitrate).append("_");
        sb.append(this.aCodec).append("_");
        sb.append(this.container).append("_");
        sb.append(this.fps).append("_");
        sb.append(this.group).append("_");
        sb.append(this.height).append("_");
        sb.append(this.projection).append("_");
        sb.append(this.vCodec).append("_");
        sb.append(this.base).append("_");
        return sb.toString();
    }

    public String createGroupingID() {
        if (VariantGroup.VIDEO.name().equals(this.getGroup())) {
            return this.getGroup() + "_" + this.projection;
        }
        return this.getGroup();
    }
}

