/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.txtresource.TranslationFactory;
import org.jdownloader.plugins.components.youtube.YoutubeConfig;
import org.jdownloader.plugins.components.youtube.itag.AudioBitrate;
import org.jdownloader.plugins.components.youtube.itag.AudioCodec;
import org.jdownloader.plugins.components.youtube.itag.AudioType;
import org.jdownloader.plugins.components.youtube.itag.ImageQuality;
import org.jdownloader.plugins.components.youtube.itag.QualitySortIdentifier;
import org.jdownloader.plugins.components.youtube.itag.VideoCodec;
import org.jdownloader.plugins.components.youtube.itag.VideoFrameRate;
import org.jdownloader.plugins.components.youtube.itag.VideoResolution;
import org.jdownloader.plugins.components.youtube.variants.FileContainer;
import org.jdownloader.plugins.config.PluginJsonConfig;
import org.jdownloader.settings.staticreferences.CFG_YOUTUBE;

public class YT_STATICS {
    public static final YoutubeConfig CFG = PluginJsonConfig.get(YoutubeConfig.class);
    public static Map<VideoResolution, Integer> SORTIDS_VIDEO_RESOLUTION;
    public static Map<ImageQuality, Integer> SORTIDS_IMAGE_QUALITY;
    public static Map<VideoCodec, Integer> SORTIDS_VIDEO_CODEC;
    public static Map<VideoFrameRate, Integer> SORTIDS_VIDEO_FRAMERATE;
    public static Map<AudioBitrate, Integer> SORTIDS_AUDIO_BITRATE;
    public static List<QualitySortIdentifier> SORTIDS;
    public static Map<AudioCodec, Integer> SORTIDS_AUDIO_CODEC;
    public static Map<AudioType, Integer> SORTIDS_AUDIO_TYPE;
    public static Map<FileContainer, Integer> SORTIDS_FILE_CONTAINER;
    public static Map<String, Integer> SUBTITLE_PREFERRENCE_MAP;

    private static void updateSorterMaps() {
        SORTIDS_VIDEO_RESOLUTION = YT_STATICS.update(VideoResolution.class, CFG.getQualitySortIdentifierOrderResolution());
        SORTIDS_IMAGE_QUALITY = YT_STATICS.update(ImageQuality.class, CFG.getQualitySortIdentifierOrderImageQuality());
        SORTIDS_VIDEO_CODEC = YT_STATICS.update(VideoCodec.class, CFG.getQualitySortIdentifierOrderVideoCodec());
        SORTIDS_VIDEO_FRAMERATE = YT_STATICS.update(VideoFrameRate.class, CFG.getQualitySortIdentifierOrderVideoFramerate());
        SORTIDS_AUDIO_BITRATE = YT_STATICS.update(AudioBitrate.class, CFG.getQualitySortIdentifierOrderAudioBitrate());
        SORTIDS_AUDIO_CODEC = YT_STATICS.update(AudioCodec.class, CFG.getQualitySortIdentifierOrderAudioCodec());
        SORTIDS_AUDIO_TYPE = YT_STATICS.update(AudioType.class, CFG.getQualitySortIdentifierOrderAudioType());
        SORTIDS_FILE_CONTAINER = YT_STATICS.update(FileContainer.class, CFG.getQualitySortIdentifierOrderFiletype());
        ArrayList<QualitySortIdentifier> sortIds = new ArrayList<QualitySortIdentifier>();
        for (String s : CFG.getQualitySortIdentifierOrder()) {
            sortIds.add(QualitySortIdentifier.valueOf(s));
        }
        SORTIDS = sortIds;
        YT_STATICS.updateSubtitlesSorter();
    }

    protected static void updateSubtitlesSorter() {
        HashMap<String, Integer> prefSubtitles = new HashMap<String, Integer>();
        String[] prefs = CFG_YOUTUBE.CFG.getPreferedSubtitleLanguages();
        int prefID = 0;
        if (prefs != null && prefs.length > 0) {
            for (int i = 0; i < prefs.length; ++i) {
                if (prefs[i] == null) continue;
                prefSubtitles.put(prefs[i].toLowerCase(Locale.ENGLISH), prefID++);
            }
        }
        prefSubtitles.put(TranslationFactory.getDesiredLanguage().toLowerCase(Locale.ENGLISH), prefID++);
        prefSubtitles.put(Locale.getDefault().getLanguage().toLowerCase(Locale.ENGLISH), prefID++);
        prefSubtitles.put("en", prefID++);
        SUBTITLE_PREFERRENCE_MAP = prefSubtitles;
    }

    private static <T extends Enum> Map<T, Integer> update(Class<T> class1, String[] values) {
        LinkedHashMap<T, Integer> ret = new LinkedHashMap<T, Integer>();
        List<T> lst = YT_STATICS.defaultEnumList(class1, values);
        for (int i = 0; i < lst.size(); ++i) {
            ret.put(lst.get(i), lst.size() - i);
        }
        return ret;
    }

    public static <T extends Enum> List<T> defaultEnumList(Class<T> cls, String[] values) {
        if (values == null) {
            values = new String[]{};
        }
        LinkedHashSet<Object> ret = new LinkedHashSet<Object>();
        for (String value : values) {
            try {
                Field field = cls.getDeclaredField(value);
                Object enumValue = field.get(null);
                if (enumValue == null) continue;
                ret.add((Enum)enumValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (Enum enumConstant : (Enum[])cls.getEnumConstants()) {
            try {
                ret.add(enumConstant);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new ArrayList(ret);
    }

    static {
        YT_STATICS.updateSorterMaps();
        GenericConfigEventListener<String[]> listener = new GenericConfigEventListener<String[]>(){

            public void onConfigValidatorError(KeyHandler<String[]> keyHandler, String[] invalidValue, ValidationException validateException) {
            }

            public void onConfigValueModified(KeyHandler<String[]> keyHandler, String[] newValue) {
                YT_STATICS.updateSorterMaps();
            }
        };
        CFG_YOUTUBE.QUALITY_SORT_IDENTIFIER_ORDER.getEventSender().addListener((EventListener)listener);
        CFG_YOUTUBE.QUALITY_SORT_IDENTIFIER_ORDER_AUDIO_BITRATE.getEventSender().addListener((EventListener)listener);
        CFG_YOUTUBE.QUALITY_SORT_IDENTIFIER_ORDER_AUDIO_CODEC.getEventSender().addListener((EventListener)listener);
        CFG_YOUTUBE.QUALITY_SORT_IDENTIFIER_ORDER_AUDIO_TYPE.getEventSender().addListener((EventListener)listener);
        CFG_YOUTUBE.QUALITY_SORT_IDENTIFIER_ORDER_VIDEO_CODEC.getEventSender().addListener((EventListener)listener);
        CFG_YOUTUBE.QUALITY_SORT_IDENTIFIER_ORDER_VIDEO_FRAMERATE.getEventSender().addListener((EventListener)listener);
        CFG_YOUTUBE.QUALITY_SORT_IDENTIFIER_ORDER_RESOLUTION.getEventSender().addListener((EventListener)listener);
        CFG_YOUTUBE.QUALITY_SORT_IDENTIFIER_ORDER_FILETYPE.getEventSender().addListener((EventListener)listener);
        CFG_YOUTUBE.QUALITY_SORT_IDENTIFIER_ORDER_IMAGE_QUALITY.getEventSender().addListener((EventListener)listener);
    }
}

