/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube;

import java.util.ArrayList;
import java.util.List;
import org.appwork.storage.Storage;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.AbstractCustomValueGetter;
import org.appwork.storage.config.annotations.CustomStorageName;
import org.appwork.storage.config.annotations.CustomValueGetter;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultJsonObject;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.annotations.StorageHandlerFactoryAnnotation;
import org.appwork.storage.config.defaults.AbstractDefaultFactory;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.StringUtils;
import org.jdownloader.plugins.components.youtube.Projection;
import org.jdownloader.plugins.components.youtube.VariantIDStorable;
import org.jdownloader.plugins.components.youtube.YT_STATICS;
import org.jdownloader.plugins.components.youtube.YoutubeConfigStorageHandlerFactory;
import org.jdownloader.plugins.components.youtube.configpanel.YoutubeVariantCollection;
import org.jdownloader.plugins.components.youtube.itag.AudioBitrate;
import org.jdownloader.plugins.components.youtube.itag.AudioCodec;
import org.jdownloader.plugins.components.youtube.itag.AudioType;
import org.jdownloader.plugins.components.youtube.itag.ImageQuality;
import org.jdownloader.plugins.components.youtube.itag.QualitySortIdentifier;
import org.jdownloader.plugins.components.youtube.itag.VideoCodec;
import org.jdownloader.plugins.components.youtube.itag.VideoFrameRate;
import org.jdownloader.plugins.components.youtube.itag.VideoResolution;
import org.jdownloader.plugins.components.youtube.keepForCompatibilitye.YoutubeCompatibility;
import org.jdownloader.plugins.components.youtube.variants.FileContainer;
import org.jdownloader.plugins.components.youtube.variants.VariantGroup;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;
import org.jdownloader.translate._JDT;

@CustomStorageName(value="youtube/Youtube")
@StorageHandlerFactoryAnnotation(value=YoutubeConfigStorageHandlerFactory.class)
@PluginHost(host="youtube.com", type=Type.HOSTER)
public interface YoutubeConfig
extends PluginConfigInterface {
    public static final double AVOID_DOUBLE_MOD = 100000.0;
    public static final Object NOTHING = YoutubeCompatibility.moveJSonFiles("youtube/Youtube");

    @AboutConfig
    @DefaultFactory(value=DefaultAudioFilenamePattern.class)
    @DefaultOnNull
    public String getAudioFilenamePattern2();

    @AboutConfig
    @DefaultJsonObject(value="[]")
    public List<AudioBitrate> getBlacklistedAudioBitrates();

    @AboutConfig
    public List<AudioCodec> getBlacklistedAudioCodecs();

    @AboutConfig
    @DefaultJsonObject(value="[]")
    public List<FileContainer> getBlacklistedFileContainers();

    @AboutConfig
    @DefaultJsonObject(value="[]")
    public List<VariantGroup> getBlacklistedGroups();

    @AboutConfig
    @DefaultJsonObject(value="[]")
    public List<Projection> getBlacklistedProjections();

    @AboutConfig
    @DefaultJsonObject(value="[]")
    public List<VideoResolution> getBlacklistedResolutions();

    @AboutConfig
    @DefaultJsonObject(value="[]")
    public List<VideoCodec> getBlacklistedVideoCodecs();

    @AboutConfig
    @DefaultJsonObject(value="[]")
    public List<VideoFrameRate> getBlacklistedVideoFramerates();

    @DefaultJsonObject(value="[]")
    public List<AudioBitrate> getChooseVariantDialogBlacklistedAudioBitrates();

    @DefaultJsonObject(value="[]")
    public List<AudioCodec> getChooseVariantDialogBlacklistedAudioCodecs();

    @DefaultJsonObject(value="[]")
    public List<FileContainer> getChooseVariantDialogBlacklistedFileContainers();

    @DefaultJsonObject(value="[]")
    public List<VariantGroup> getChooseVariantDialogBlacklistedGroups();

    @DefaultJsonObject(value="[]")
    public List<Projection> getChooseVariantDialogBlacklistedProjections();

    @DefaultJsonObject(value="[]")
    public List<VideoResolution> getChooseVariantDialogBlacklistedResolutions();

    @DefaultJsonObject(value="[]")
    public List<VideoCodec> getChooseVariantDialogBlacklistedVideoCodecs();

    @DefaultJsonObject(value="[]")
    public List<VideoFrameRate> getChooseVariantDialogBlacklistedVideoFramerates();

    @AboutConfig
    @DefaultEnumValue(value="P_4320")
    @DefaultOnNull
    public VideoResolution getMaxVideoResolution();

    public void setMaxVideoResolution(VideoResolution var1);

    @AboutConfig
    @DefaultIntValue(value=15)
    public int getChunksCount();

    public List<YoutubeVariantCollection> getCollections();

    @AboutConfig
    @DefaultOnNull
    @DefaultStringValue(value="*VIDEO_NAME* (*QUALITY*).*EXT*")
    public String getDescriptionFilenamePattern();

    @AboutConfig
    public List<VariantIDStorable> getDisabledVariants();

    @AboutConfig
    @DescriptionForConfigEntry(value="Use this if you want to get more than 1 subtitle per video. [\"de\", \"ar\", \"zh-HK\"] or [\"*\"] for all")
    public List<String> getExtraSubtitles();

    @AboutConfig
    @DescriptionForConfigEntry(value="Use this if you want to get auto translated subtitles. [\"de\", \"en\", \"ar\", \"zh-HK\", \"ru\", \"tr\"]")
    public List<String> getAutoTranslatedSubtitles();

    @DefaultOnNull
    @AboutConfig
    @DefaultStringValue(value="*VIDEO_NAME* (*QUALITY*).*EXT*")
    public String getImageFilenamePattern();

    @AboutConfig
    @DefaultEnumValue(value="ASK")
    public IfUrlisAPlaylistAction getLinkIsPlaylistUrlAction();

    @AboutConfig
    @DefaultEnumValue(value="ASK")
    public IfUrlisAVideoAndPlaylistAction getLinkIsVideoAndPlaylistUrlAction();

    @AboutConfig
    @DescriptionForConfigEntry(value="Define how channels/profiles should be crawled. Channels can be crawled as their 'Uploaded by' playlist which can be found on the website under '/@channelname/featured' -> 'Play all' or just all videos you can see on the website under '/@channelname/videos' -> Tab called 'Videos'.")
    @DefaultEnumValue(value="PLAYLIST")
    public ProfileCrawlMode getProfileCrawlMode();

    public void setProfileCrawlMode(ProfileCrawlMode var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Define max items to be crawled when channel/playlist/profile is added. -1 = unlimited, 0 = disable channel/playlist/profile crawler")
    @SpinnerValidator(min=-1L, max=100000L, step=100L)
    @DefaultIntValue(value=-1)
    public int getPlaylistAndProfileCrawlerMaxItemsLimit();

    public void setPlaylistAndProfileCrawlerMaxItemsLimit(int var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Define in which order items of crawled channels should roughtly be added. This has no influence on the final sort order in the linkgrabber! It only has an influence on what is roughly crawled first.")
    @DefaultEnumValue(value="AUTO")
    public ChannelCrawlerSortMode getChannelCrawlerPreferredSortMode();

    public void setChannelCrawlerPreferredSortMode(ChannelCrawlerSortMode var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Channels/playlist crawler: Grouping mode")
    @DefaultEnumValue(value="AUTO")
    public ChannelPlaylistCrawlerPackagingMode getChannelPlaylistCrawlerPackagingMode();

    public void setChannelPlaylistCrawlerPackagingMode(ChannelPlaylistCrawlerPackagingMode var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="If enabled, list of crawled videoIDs will be reversed before processing. Important: This will also change the index numbers inside the YouTube URLs you get in JD later on! This setting is only applied if no crawl limit is set or if the playlist contains less items than the crawl limit.")
    @DefaultBooleanValue(value=false)
    public boolean isProcessPlaylistItemsInReverseOrder();

    public void setProcessPlaylistItemsInReverseOrder(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Controls duplicate detection behavior for videos added as part of a playlist")
    @DefaultEnumValue(value="AUTO")
    @DefaultOnNull
    @RequiresRestart(value="A JDownloader Restart is Required")
    public PlaylistDupeDetectionMode getPlaylistDupeDetectionMode();

    public void setPlaylistDupeDetectionMode(PlaylistDupeDetectionMode var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Subtitle Variant Mode - Controls how downloaded subtitle files are processed to match their corresponding video files.\r\n\r\nDISABLED: Subtitle files are left with their original filenames as downloaded, with no additional processing or renaming.\r\n\r\nCOPY_AND_KEEP: Subtitle files are copied and renamed to match their associated video files (e.g., \"Video Title.English.srt\"), while the original subtitle files are preserved. This creates both the original and the renamed versions.\r\n\r\nCOPY_AND_DELETE: Subtitle files are renamed to match their associated video files and the original subtitle files are deleted after successful processing. This results in only the renamed subtitle files that correspond to video filenames.\r\n\r\nThe renamed subtitle files use the video's base filename with the subtitle language appended (when available), making them compatible with media players that automatically load subtitles based on matching filenames.")
    @DefaultFactory(value=DefaultConvertSubtitleVariantMode.class)
    public SubtitleVariantMode getSubtitleVariantMode();

    public void setSubtitleVariantMode(SubtitleVariantMode var1);

    @AboutConfig
    @DefaultOnNull
    @DefaultStringValue(value="*VIDEO_NAME*")
    public String getPackagePattern();

    public void setPackagePattern(String var1);

    @AboutConfig
    @DefaultOnNull
    @DefaultStringValue(value="*CHANNEL_NAME*")
    public String getPackagePatternForChannelPackages();

    public void setPackagePatternForChannelPackages(String var1);

    @AboutConfig
    @DefaultOnNull
    @DefaultStringValue(value="*PLAYLIST_CREATOR* - *PLAYLIST_TITLE*")
    public String getPackagePatternForPlaylists();

    public void setPackagePatternForPlaylists(String var1);

    @AboutConfig
    public String[] getPreferedSubtitleLanguages();

    @AboutConfig
    @CustomValueGetter(value=QualitySortIdentifierOrderDefaultGetter.class)
    public String[] getQualitySortIdentifierOrder();

    @CustomValueGetter(value=QualitySortIdentifierOrderAudioBitrate.class)
    @AboutConfig
    public String[] getQualitySortIdentifierOrderAudioBitrate();

    @AboutConfig
    @CustomValueGetter(value=QualitySortIdentifierOrderAudioCodec.class)
    public String[] getQualitySortIdentifierOrderAudioCodec();

    @AboutConfig
    @CustomValueGetter(value=QualitySortIdentifierOrderAudioType.class)
    public String[] getQualitySortIdentifierOrderAudioType();

    @AboutConfig
    @CustomValueGetter(value=QualitySortIdentifierOrderFiletype.class)
    public String[] getQualitySortIdentifierOrderFiletype();

    @AboutConfig
    @CustomValueGetter(value=QualitySortIdentifierOrderResolution.class)
    public String[] getQualitySortIdentifierOrderResolution();

    @AboutConfig
    @CustomValueGetter(value=QualitySortIdentifierOrderImageQuality.class)
    public String[] getQualitySortIdentifierOrderImageQuality();

    @CustomValueGetter(value=QualitySortIdentifierOrderVideoCodec.class)
    @AboutConfig
    public String[] getQualitySortIdentifierOrderVideoCodec();

    @CustomValueGetter(value=QualitySortIdentifierOrderVideoFramerate.class)
    @AboutConfig
    public String[] getQualitySortIdentifierOrderVideoFramerate();

    @AboutConfig
    @DefaultOnNull
    @DefaultFactory(value=DefaultSubtitleFilenamePattern.class)
    public String getSubtitleFilenamePattern2();

    @AboutConfig
    public ArrayList<String> getSubtitleWhiteList();

    @AboutConfig
    @DescriptionForConfigEntry(value="ID Pattern for dupe filtering. Tags: *CONTAINER*,*AUDIO_BITRATE*,*AUDIO_CODEC*,*DEMUX*,*SPATIAL*,*LNG*")
    @DefaultOnNull
    @DefaultStringValue(value="*LNG* *AUDIO_BITRATE* *LNG* *SPATIAL* kbit/s.*CONTAINER*")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public String getVariantNamePatternAudio();

    @AboutConfig
    @DefaultStringValue(value="*LNG* *3D* *360* *HEIGHT*p *FPS*fps - *VIDEO_CODEC*-Video & *AUDIO_CODEC*-Audio.*CONTAINER*")
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="ID Pattern for dupe filtering. Tags: *CONTAINER*,*HEIGHT*,*FPS*,*AUDIO_CODEC*,*VIDEO_CODEC*,*3D*,*AUDIO_BITRATE*,*SPATIAL*,*LNG*")
    @DefaultOnNull
    public String getVariantNamePatternVideo();

    @AboutConfig
    @DefaultOnNull
    @DefaultFactory(value=DefaultVideoFilenamePattern.class)
    public String getVideoFilenamePattern2();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @RequiresRestart(value="A JDownloader Restart is Required")
    public boolean isAdvancedVariantNamesEnabled();

    @DefaultBooleanValue(value=false)
    @AboutConfig
    public boolean isAndroidSupportEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isChooseAlternativeForMassChangeOrAddDialog();

    @DefaultBooleanValue(value=false)
    @AboutConfig
    public boolean isCustomChunkValueEnabled();

    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Disable this if you do not want to use the new DASH Format. This will disable AUDIO only Downloads, and High Quality Video Downloads")
    @AboutConfig
    public boolean isExternMultimediaToolUsageEnabled();

    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Disable this if you do not want to mux new DASH Format. This will result in seperate audio/video streams.")
    @AboutConfig
    public boolean isDASHMuxingEnabled();

    public void setDASHMuxingEnabled(boolean var1);

    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Appends String representing internal variant information ('#variant=...') to URL the user gets when copying URL of added item.")
    @AboutConfig
    public boolean isEnableIncludeVariantStringInContentURLs();

    public void setAdvancedVariantNamesEnabled(boolean var1);

    public void setAndroidSupportEnabled(boolean var1);

    public void setAudioFilenamePattern2(String var1);

    public void setBlacklistedAudioBitrates(List<AudioBitrate> var1);

    public void setBlacklistedAudioCodecs(List<AudioCodec> var1);

    public void setBlacklistedFileContainers(List<FileContainer> var1);

    public void setBlacklistedGroups(List<VariantGroup> var1);

    public void setBlacklistedProjections(List<Projection> var1);

    public void setBlacklistedResolutions(List<VideoResolution> var1);

    public void setBlacklistedVideoCodecs(List<VideoCodec> var1);

    public void setBlacklistedVideoFramerates(List<VideoFrameRate> var1);

    public void setChooseAlternativeForMassChangeOrAddDialog(boolean var1);

    public void setChooseVariantDialogBlacklistedAudioBitrates(List<AudioBitrate> var1);

    public void setChooseVariantDialogBlacklistedAudioCodecs(List<AudioCodec> var1);

    public void setChooseVariantDialogBlacklistedFileContainers(List<FileContainer> var1);

    public void setChooseVariantDialogBlacklistedGroups(List<VariantGroup> var1);

    public void setChooseVariantDialogBlacklistedProjections(List<Projection> var1);

    public void setChooseVariantDialogBlacklistedResolutions(List<VideoResolution> var1);

    public void setChooseVariantDialogBlacklistedVideoCodecs(List<VideoCodec> var1);

    public void setChooseVariantDialogBlacklistedVideoFramerates(List<VideoFrameRate> var1);

    public void setChunksCount(int var1);

    @AboutConfig
    public void setCollections(List<YoutubeVariantCollection> var1);

    public void setCustomChunkValueEnabled(boolean var1);

    public void setDescriptionFilenamePattern(String var1);

    public void setDisabledVariants(List<VariantIDStorable> var1);

    public void setExternMultimediaToolUsageEnabled(boolean var1);

    public void setExtraSubtitles(List<String> var1);

    public void setAutoTranslatedSubtitles(List<String> var1);

    public void setImageFilenamePattern(String var1);

    public void setLinkIsPlaylistUrlAction(IfUrlisAPlaylistAction var1);

    public void setLinkIsVideoAndPlaylistUrlAction(IfUrlisAVideoAndPlaylistAction var1);

    public void setPreferedSubtitleLanguages(String[] var1);

    public void setQualitySortIdentifierOrder(String[] var1);

    public void setQualitySortIdentifierOrderAudioBitrate(String[] var1);

    public void setQualitySortIdentifierOrderAudioCodec(String[] var1);

    public void setQualitySortIdentifierOrderAudioType(String[] var1);

    public void setQualitySortIdentifierOrderFiletype(String[] var1);

    public void setQualitySortIdentifierOrderResolution(String[] var1);

    public void setQualitySortIdentifierOrderImageQuality(String[] var1);

    public void setQualitySortIdentifierOrderVideoCodec(String[] var1);

    public void setQualitySortIdentifierOrderVideoFramerate(String[] var1);

    public void setEnableIncludeVariantStringInContentURLs(boolean var1);

    public void setSubtitleFilenamePattern2(String var1);

    public void setSubtitleWhiteList(ArrayList<String> var1);

    public void setVariantNamePatternAudio(String var1);

    public void setVariantNamePatternVideo(String var1);

    public void setVideoFilenamePattern2(String var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="If enabled, playlist position will be added to the beginning of all filenames regardless of the customizes filename patterns.")
    @DefaultBooleanValue(value=false)
    public boolean isPlaylistItemsIncludePlaylistPositionAtBeginningOfFilenames();

    public void setPlaylistItemsIncludePlaylistPositionAtBeginningOfFilenames(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Preload 200kb and use FFProbe to detect the actual Audio Bitrate.")
    public boolean isDoExtendedAudioBitrateLookupEnabled();

    public void setDoExtendedAudioBitrateLookupEnabled(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=5)
    @DescriptionForConfigEntry(value="If a Variant is not available, JD will try up to * alternatives")
    public int getAutoAlternativeSearchDepths();

    public void setAutoAlternativeSearchDepths(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="If a Variant is not available, JD will try to find alternatives")
    public boolean isAutoAlternativeSearchEnabled();

    public void setAutoAlternativeSearchEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If disabled, JD will ignore the Youtube Collections, but create an extra link for every variant")
    public boolean isCollectionMergingEnabled();

    public void setCollectionMergingEnabled(boolean var1);

    @RequiresRestart(value="A JDownloader Restart is Required")
    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isSegmentLoadingEnabled();

    public void setSegmentLoadingEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isMetaDataEnabled();

    public void setMetaDataEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="If enabled, crawler will avoid video items that already exist in the linkgrabber at a very early stage. This can speed up processing of added YT video links.")
    public boolean isCrawlDupeCheckEnabled();

    public void setCrawlDupeCheckEnabled(boolean var1);

    public static enum PlaylistDupeDetectionMode implements LabelInterface
    {
        AUTO{

            public String getLabel() {
                return "Auto";
            }
        }
        ,
        ALLOW_PLAYLIST_AND_SINGLE_VIDEO{

            public String getLabel() {
                return "Allow single video and same video as part of playlist";
            }
        }
        ,
        AVOID_DUPLICATES{

            public String getLabel() {
                return "Use global duplicate detection: Avoid duplicates";
            }
        };

    }

    public static enum ChannelPlaylistCrawlerPackagingMode implements LabelInterface
    {
        AUTO{

            public String getLabel() {
                return "Auto";
            }
        }
        ,
        GROUP_ALL_VIDEOS_AS_SINGLE_PACKAGE{

            public String getLabel() {
                return _JDT.T.YoutubeDash_ChannelPlaylistCrawlerPackagingModeSingle();
            }
        }
        ,
        GROUP_EACH_VIDEO_INDIVIDUALLY{

            public String getLabel() {
                return _JDT.T.YoutubeDash_ChannelPlaylistCrawlerPackagingModePerVideo();
            }
        };

    }

    public static enum ChannelCrawlerSortMode implements LabelInterface
    {
        AUTO{

            public String getLabel() {
                return "Auto";
            }
        }
        ,
        LATEST{

            public String getLabel() {
                return _JDT.T.YoutubeDash_ChannelCrawlerSortModeLatest();
            }
        }
        ,
        POPULAR{

            public String getLabel() {
                return _JDT.T.YoutubeDash_ChannelCrawlerSortModePopular();
            }
        }
        ,
        OLDEST{

            public String getLabel() {
                return _JDT.T.YoutubeDash_ChannelCrawlerSortModeOldest();
            }
        };

    }

    public static class QualitySortIdentifierOrderVideoFramerate
    extends AbstractEnumOrderFixList {
        public QualitySortIdentifierOrderVideoFramerate() {
            super(VideoFrameRate.class);
        }
    }

    public static class QualitySortIdentifierOrderVideoCodec
    extends AbstractEnumOrderFixList {
        public QualitySortIdentifierOrderVideoCodec() {
            super(VideoCodec.class);
        }
    }

    public static class QualitySortIdentifierOrderImageQuality
    extends AbstractEnumOrderFixList {
        public QualitySortIdentifierOrderImageQuality() {
            super(ImageQuality.class);
        }
    }

    public static class QualitySortIdentifierOrderResolution
    extends AbstractEnumOrderFixList {
        public QualitySortIdentifierOrderResolution() {
            super(VideoResolution.class);
        }
    }

    public static class QualitySortIdentifierOrderFiletype
    extends AbstractEnumOrderFixList {
        public QualitySortIdentifierOrderFiletype() {
            super(FileContainer.class);
        }
    }

    public static class QualitySortIdentifierOrderDefaultGetter
    extends AbstractEnumOrderFixList {
        public QualitySortIdentifierOrderDefaultGetter() {
            super(QualitySortIdentifier.class);
        }
    }

    public static class QualitySortIdentifierOrderAudioType
    extends AbstractEnumOrderFixList {
        public QualitySortIdentifierOrderAudioType() {
            super(AudioType.class);
        }
    }

    public static class QualitySortIdentifierOrderAudioCodec
    extends AbstractEnumOrderFixList {
        public QualitySortIdentifierOrderAudioCodec() {
            super(AudioCodec.class);
        }
    }

    public static class QualitySortIdentifierOrderAudioBitrate
    extends AbstractEnumOrderFixList {
        public QualitySortIdentifierOrderAudioBitrate() {
            super(AudioBitrate.class);
        }
    }

    public static enum ProfileCrawlMode implements LabelInterface
    {
        PLAYLIST{

            public String getLabel() {
                return _JDT.T.YoutubeDash_ProfileCrawlModePlaylist();
            }
        }
        ,
        USER{

            public String getLabel() {
                return _JDT.T.YoutubeDash_ProfileCrawlModeVideosTab();
            }
        };

    }

    public static enum IfUrlisAVideoAndPlaylistAction implements LabelInterface
    {
        ASK{

            public String getLabel() {
                return _JDT.T.YoutubeDash_IfUrlisAVideoAndPlaylistAction_ASK();
            }
        }
        ,
        NOTHING{

            public String getLabel() {
                return _JDT.T.YoutubeDash_IfUrlisAVideoAndPlaylistAction_NOTHING();
            }
        }
        ,
        PLAYLIST_ONLY{

            public String getLabel() {
                return _JDT.T.YoutubeDash_IfUrlisAVideoAndPlaylistAction_PLAYLIST_ONLY();
            }
        }
        ,
        VIDEO_ONLY{

            public String getLabel() {
                return _JDT.T.YoutubeDash_IfUrlisAVideoAndPlaylistAction_VIDEO_ONLY();
            }
        };

    }

    public static enum IfUrlisAPlaylistAction implements LabelInterface
    {
        ASK{

            public String getLabel() {
                return _JDT.T.YoutubeDash_IfUrlisAPlaylistAction_ASK();
            }
        }
        ,
        NOTHING{

            public String getLabel() {
                return _JDT.T.YoutubeDash_IfUrlisAPlaylistAction_NOTHING();
            }
        }
        ,
        PROCESS{

            public String getLabel() {
                return _JDT.T.YoutubeDash_IfUrlisAPlaylistAction_PROCESS();
            }
        };

    }

    public static enum SubtitleVariantMode {
        DISABLED,
        COPY_AND_KEEP,
        COPY_AND_DELETE;

    }

    public static class DefaultSubtitleFilenamePattern
    extends AbstractDefaultFactory<String> {
        public String getDefaultValue(KeyHandler<String> keyHandler) {
            Storage storage;
            String currentDefault = "*VIDEO_NAME** (LNG[DISPLAY])*.*EXT*";
            if (keyHandler != null && (storage = keyHandler.getStorageHandler().getPrimitiveStorage(keyHandler)) != null) {
                String oldKey = "subtitlefilenamepattern";
                Object oldValue = storage.get("subtitlefilenamepattern", null);
                if (!(oldValue instanceof String)) {
                    return "*VIDEO_NAME** (LNG[DISPLAY])*.*EXT*";
                }
                storage.remove("subtitlefilenamepattern");
                if (StringUtils.equalsIgnoreCase((String)"*VIDEO_NAME* (*LNG[DISPLAY]*).*EXT*", (String)oldValue.toString())) {
                    return "*VIDEO_NAME** (LNG[DISPLAY])*.*EXT*";
                }
                return oldValue.toString();
            }
            return "*VIDEO_NAME** (LNG[DISPLAY])*.*EXT*";
        }
    }

    public static class DefaultVideoFilenamePattern
    extends AbstractDefaultFactory<String> {
        public String getDefaultValue(KeyHandler<String> keyHandler) {
            Storage storage;
            String currentDefault = "*3D* *360* *VIDEO_NAME* (*H*p_*FPS*fps_*VIDEO_CODEC*-*AUDIO_BITRATE*kbit_*AUDIO_CODEC**-LNG[DISPLAY]*).*EXT*";
            if (keyHandler != null && (storage = keyHandler.getStorageHandler().getPrimitiveStorage(keyHandler)) != null) {
                String oldKey = "videofilenamepattern";
                Object oldValue = storage.get("videofilenamepattern", null);
                if (!(oldValue instanceof String)) {
                    return "*3D* *360* *VIDEO_NAME* (*H*p_*FPS*fps_*VIDEO_CODEC*-*AUDIO_BITRATE*kbit_*AUDIO_CODEC**-LNG[DISPLAY]*).*EXT*";
                }
                storage.remove("videofilenamepattern");
                if (StringUtils.equalsIgnoreCase((String)"*3D* *360* *VIDEO_NAME* (*H*p_*FPS*fps_*VIDEO_CODEC*-*AUDIO_BITRATE*kbit_*AUDIO_CODEC*).*EXT*", (String)oldValue.toString())) {
                    return "*3D* *360* *VIDEO_NAME* (*H*p_*FPS*fps_*VIDEO_CODEC*-*AUDIO_BITRATE*kbit_*AUDIO_CODEC**-LNG[DISPLAY]*).*EXT*";
                }
                return oldValue.toString();
            }
            return "*3D* *360* *VIDEO_NAME* (*H*p_*FPS*fps_*VIDEO_CODEC*-*AUDIO_BITRATE*kbit_*AUDIO_CODEC**-LNG[DISPLAY]*).*EXT*";
        }
    }

    public static class DefaultAudioFilenamePattern
    extends AbstractDefaultFactory<String> {
        public String getDefaultValue(KeyHandler<String> keyHandler) {
            Storage storage;
            String currentDefault = "*VIDEO_NAME* (*AUDIO_BITRATE*kbit_*AUDIO_CODEC**-LNG[DISPLAY]*).*EXT*";
            if (keyHandler != null && (storage = keyHandler.getStorageHandler().getPrimitiveStorage(keyHandler)) != null) {
                String oldKey = "audiofilenamepattern";
                Object oldValue = storage.get("audiofilenamepattern", null);
                if (!(oldValue instanceof String)) {
                    return "*VIDEO_NAME* (*AUDIO_BITRATE*kbit_*AUDIO_CODEC**-LNG[DISPLAY]*).*EXT*";
                }
                storage.remove("audiofilenamepattern");
                if (StringUtils.equalsIgnoreCase((String)"*VIDEO_NAME* (*AUDIO_BITRATE*kbit_*AUDIO_CODEC*).*EXT*", (String)oldValue.toString())) {
                    return "*VIDEO_NAME* (*AUDIO_BITRATE*kbit_*AUDIO_CODEC**-LNG[DISPLAY]*).*EXT*";
                }
                return oldValue.toString();
            }
            return "*VIDEO_NAME* (*AUDIO_BITRATE*kbit_*AUDIO_CODEC**-LNG[DISPLAY]*).*EXT*";
        }
    }

    public static class DefaultConvertSubtitleVariantMode
    extends AbstractDefaultFactory<SubtitleVariantMode> {
        public SubtitleVariantMode getDefaultValue(KeyHandler<SubtitleVariantMode> keyHandler) {
            Storage storage;
            if (keyHandler != null && (storage = keyHandler.getStorageHandler().getPrimitiveStorage(keyHandler)) != null) {
                String oldKey = "subtitlecopyforeachvideovariant";
                Object oldValue = storage.get("subtitlecopyforeachvideovariant", null);
                if (oldValue != null && StringUtils.equalsIgnoreCase((String)"false", (String)oldValue.toString())) {
                    storage.remove("subtitlecopyforeachvideovariant");
                    return SubtitleVariantMode.DISABLED;
                }
            }
            return SubtitleVariantMode.COPY_AND_KEEP;
        }
    }

    public static abstract class AbstractEnumOrderFixList
    extends AbstractCustomValueGetter<String[]> {
        private Class<? extends Enum> cls;

        public AbstractEnumOrderFixList(Class<? extends Enum> cls) {
            this.cls = cls;
        }

        public String[] getValue(KeyHandler<String[]> keyHandler, String[] value) {
            List<? extends Enum> enums = YT_STATICS.defaultEnumList(this.cls, value);
            String[] ret = new String[enums.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = enums.get(i).name();
            }
            return ret;
        }
    }
}

