/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForHost;
import org.appwork.swing.action.BasicAction;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.CounterMap;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ProgressDialog;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.linkcrawler.LinkVariant;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.components.youtube.ClipDataCache;
import org.jdownloader.plugins.components.youtube.VariantIDStorable;
import org.jdownloader.plugins.components.youtube.YoutubeClipData;
import org.jdownloader.plugins.components.youtube.YoutubeHelper;
import org.jdownloader.plugins.components.youtube.YoutubeHostPluginInterface;
import org.jdownloader.plugins.components.youtube.choosevariantdialog.YoutubeVariantSelectionDialogAddMulti;
import org.jdownloader.plugins.components.youtube.choosevariantdialog.YoutubeVariantSelectionDialogSetMulti;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.AudioVariant;
import org.jdownloader.plugins.components.youtube.variants.SubtitleVariant;
import org.jdownloader.plugins.components.youtube.variants.VariantGroup;
import org.jdownloader.plugins.components.youtube.variants.VariantInfo;
import org.jdownloader.plugins.components.youtube.variants.VideoVariant;
import org.jdownloader.plugins.components.youtube.variants.YoutubeSubtitleStorable;

public class YoutubeLinkGrabberExtender {
    private SelectionInfo.PluginView<CrawledLink> pv;
    private final PluginForHost plg;
    private JMenuItem addVariants;
    private JMenu youtubeMenu;
    private HashMap<VariantGroup, JMenuItem> groupMenuItems;
    private CounterMap<VariantGroup> groupCount;
    private JMenu setVariantMenu;

    public YoutubeLinkGrabberExtender(PluginForHost plg, JComponent parent, SelectionInfo.PluginView<CrawledLink> pv, Collection<SelectionInfo.PluginView<CrawledLink>> allPvs) {
        this.plg = plg;
        this.pv = pv;
    }

    public List<JComponent> run() {
        ArrayList<JComponent> ret = new ArrayList<JComponent>();
        this.addVariants = new JMenuItem((Action)new BasicAction(){
            {
                this.setSmallIcon(new AbstractIcon("add", 18));
                this.setName(_GUI.T.youtube_add_variant());
            }

            public void actionPerformed(ActionEvent e) {
                YoutubeLinkGrabberExtender.this.addVariants();
            }
        });
        this.youtubeMenu = new JMenu("youtube.com");
        ret.add(this.youtubeMenu);
        Icon icon = DomainInfo.getInstance("youtube.com").getFavIcon();
        this.youtubeMenu.setIcon(icon);
        this.setVariantMenu = new JMenu(_GUI.T.youtube_choose_variant());
        this.youtubeMenu.add(this.setVariantMenu);
        this.setVariantMenu.setIcon(new AbstractIcon("refresh", 18));
        this.groupMenuItems = new HashMap();
        for (final VariantGroup g : VariantGroup.values()) {
            if (g == VariantGroup.DESCRIPTION) continue;
            JMenuItem menu = new JMenuItem((Action)new BasicAction(){
                {
                    this.setSmallIcon(g.getIcon(18));
                    this.setName(_GUI.T.youtube_choose_variant_group(g.getLabel()));
                }

                public void actionPerformed(ActionEvent e) {
                    YoutubeLinkGrabberExtender.this.setVariants(g);
                }
            });
            this.setVariantMenu.add(menu);
            this.groupMenuItems.put(g, menu);
        }
        this.youtubeMenu.add(this.addVariants);
        new Thread("Collect Variants"){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                YoutubeLinkGrabberExtender.this.groupCount = new CounterMap();
                for (CrawledLink cl : YoutubeLinkGrabberExtender.this.pv.getChildren()) {
                    if (!cl.getDownloadLink().getHost().equals("youtube.com")) continue;
                    try {
                        YoutubeLinkGrabberExtender.this.groupCount.increment((Object)((AbstractVariant)cl.gethPlugin().getActiveVariantByLink(cl.getDownloadLink())).getGroup());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                new EDTRunner(){

                    protected void runInEDT() {
                        int active = 0;
                        JMenuItem last = null;
                        for (VariantGroup g : VariantGroup.values()) {
                            if (g == VariantGroup.DESCRIPTION) continue;
                            if (YoutubeLinkGrabberExtender.this.groupCount.getInt((Object)g) > 0) {
                                ((JMenuItem)YoutubeLinkGrabberExtender.this.groupMenuItems.get((Object)g)).setEnabled(true);
                                last = (JMenuItem)YoutubeLinkGrabberExtender.this.groupMenuItems.get((Object)g);
                                ++active;
                            }
                            ((JMenuItem)YoutubeLinkGrabberExtender.this.groupMenuItems.get((Object)g)).setText(_GUI.T.youtube_choose_variant_group_linkcount(g.getLabel(), YoutubeLinkGrabberExtender.this.groupCount.getInt((Object)g)));
                        }
                        if (active == 1) {
                            YoutubeLinkGrabberExtender.this.youtubeMenu.remove(YoutubeLinkGrabberExtender.this.setVariantMenu);
                            YoutubeLinkGrabberExtender.this.youtubeMenu.remove(YoutubeLinkGrabberExtender.this.addVariants);
                            YoutubeLinkGrabberExtender.this.youtubeMenu.add(last);
                            YoutubeLinkGrabberExtender.this.youtubeMenu.add(YoutubeLinkGrabberExtender.this.addVariants);
                        }
                    }
                };
            }
        }.start();
        return ret;
    }

    private void aggregate(CrawledLink cl, VariantGroup variantGroupOnly, CounterMap<String> matchingLinks, Set<String> dupeAdd, ArrayList<VariantInfo> vs, List<VariantInfo> variants) {
        HashSet<String> dupe = new HashSet<String>();
        for (VariantInfo vi : variants) {
            AbstractVariant variant = vi.getVariant();
            if (variantGroupOnly != null && variant.getGroup() != variantGroupOnly) continue;
            String id = variant instanceof SubtitleVariant ? variant._getUniqueId() : (variant instanceof AudioVariant ? variant._getUniqueId() : (variant instanceof VideoVariant ? variant._getUniqueId() : new VariantIDStorable(variant).createUniqueID()));
            if (dupe.add(id)) {
                matchingLinks.increment((Object)id);
            }
            if (!dupeAdd.add(id)) continue;
            vs.add(vi);
        }
    }

    protected void addVariants() {
        if (this.pv.getChildren().size() == 1) {
            ((YoutubeHostPluginInterface)((Object)this.pv.getPlugin())).showChangeOrAddVariantDialog(this.pv.getChildren().get(0), null);
            return;
        }
        ProgressDialog.ProgressGetter pg = new ProgressDialog.ProgressGetter(){
            private int done;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws Exception {
                final CounterMap matchingLinks = new CounterMap();
                HashSet dupeAdd = new HashSet();
                final ArrayList vs = new ArrayList();
                final HashSet<String> videoIDDupe = new HashSet<String>();
                this.done = 0;
                for (CrawledLink cl : YoutubeLinkGrabberExtender.this.pv.getChildren()) {
                    try {
                        YoutubeHelper helper = new YoutubeHelper(new Browser(), LoggerFactory.getDefaultLogger());
                        YoutubeClipData clipData = ClipDataCache.get(helper, cl.getDownloadLink());
                        if (!videoIDDupe.add(clipData.videoID)) continue;
                        List<VariantInfo> variants = clipData.findVariants();
                        helper.extendedDataLoading(variants);
                        YoutubeLinkGrabberExtender.this.aggregate(cl, null, (CounterMap<String>)matchingLinks, dupeAdd, vs, variants);
                        YoutubeLinkGrabberExtender.this.aggregate(cl, null, (CounterMap<String>)matchingLinks, dupeAdd, vs, clipData.findDescriptionVariant());
                        YoutubeLinkGrabberExtender.this.aggregate(cl, null, (CounterMap<String>)matchingLinks, dupeAdd, vs, clipData.findSubtitleVariants());
                    }
                    finally {
                        ++this.done;
                    }
                }
                new Thread("Add Youtube Variant"){

                    @Override
                    public void run() {
                        try {
                            YoutubeVariantSelectionDialogAddMulti d = new YoutubeVariantSelectionDialogAddMulti((CounterMap<String>)matchingLinks, videoIDDupe.size(), vs);
                            ((YoutubeVariantSelectionDialogAddMulti)UIOManager.I().show(null, (UserIODefinition)d)).throwCloseExceptions();
                            boolean alternativesEnabled = d.isAutoAlternativesEnabled();
                            List<LinkVariant> choosenVariant = d.getVariants();
                            ArrayList<CrawledLink> checkableLinks = new ArrayList<CrawledLink>(1);
                            for (LinkVariant lv : choosenVariant) {
                                HashSet<String> dupe = new HashSet<String>();
                                for (CrawledLink cl : YoutubeLinkGrabberExtender.this.pv.getChildren()) {
                                    CrawledLink newLink;
                                    AbstractVariant found;
                                    if (!dupe.add(cl.getDownloadLink().getStringProperty("YT_ID")) || (found = YoutubeLinkGrabberExtender.this.findBestVariant(cl, ((AbstractVariant)lv).getGroup(), (AbstractVariant)lv, alternativesEnabled)) == null || (newLink = LinkCollector.getInstance().addAdditional(cl, found)) == null) continue;
                                    checkableLinks.add(newLink);
                                }
                            }
                            LinkChecker<ArrayList<CrawledLink>> linkChecker = new LinkChecker<ArrayList<CrawledLink>>(true);
                            linkChecker.check(checkableLinks);
                        }
                        catch (DialogClosedException e) {
                            e.printStackTrace();
                        }
                        catch (DialogCanceledException e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
            }

            public String getString() {
                return null;
            }

            public int getProgress() {
                return this.done * 100 / YoutubeLinkGrabberExtender.this.pv.getChildren().size();
            }

            public String getLabelString() {
                return null;
            }
        };
        ProgressDialog dialog = new ProgressDialog(pg, 0, _GUI.T.lit_please_wait(), _GUI.T.youtube_scan_variants(), (Icon)new AbstractIcon("wait", 32));
        UIOManager.I().show(null, (UserIODefinition)dialog);
    }

    protected void setVariants(final VariantGroup g) {
        if (this.pv.getChildren().size() == 1) {
            ((YoutubeHostPluginInterface)((Object)this.pv.getPlugin())).showChangeOrAddVariantDialog(this.pv.getChildren().get(0), (AbstractVariant)this.pv.getPlugin().getActiveVariantByLink(this.pv.getChildren().get(0).getDownloadLink()));
            return;
        }
        ProgressDialog.ProgressGetter pg = new ProgressDialog.ProgressGetter(){
            private int done;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws Exception {
                final CounterMap matchingLinks = new CounterMap();
                HashSet dupeAdd = new HashSet();
                final ArrayList vs = new ArrayList();
                HashSet<String> videoIDDupe = new HashSet<String>();
                final ArrayList<CrawledLink> children = new ArrayList<CrawledLink>();
                this.done = 0;
                for (CrawledLink child : YoutubeLinkGrabberExtender.this.pv.getChildren()) {
                    try {
                        DownloadLink downloadLink = child.getDownloadLink();
                        LinkVariant activeVariant = child.gethPlugin().getActiveVariantByLink(downloadLink);
                        if (((AbstractVariant)activeVariant).getGroup() != g) continue;
                        YoutubeHelper helper = new YoutubeHelper(new Browser(), LoggerFactory.getDefaultLogger());
                        YoutubeClipData clipData = ClipDataCache.get(helper, downloadLink);
                        if (!videoIDDupe.add(clipData.videoID)) continue;
                        children.add(child);
                        List<VariantInfo> variants = clipData.findVariants();
                        helper.extendedDataLoading(variants);
                        YoutubeLinkGrabberExtender.this.aggregate(child, g, (CounterMap<String>)matchingLinks, dupeAdd, vs, variants);
                        YoutubeLinkGrabberExtender.this.aggregate(child, g, (CounterMap<String>)matchingLinks, dupeAdd, vs, clipData.findDescriptionVariant());
                        YoutubeLinkGrabberExtender.this.aggregate(child, g, (CounterMap<String>)matchingLinks, dupeAdd, vs, clipData.findSubtitleVariants());
                    }
                    finally {
                        ++this.done;
                    }
                }
                new Thread("Choose Youtube Variant"){

                    @Override
                    public void run() {
                        try {
                            YoutubeVariantSelectionDialogSetMulti d = new YoutubeVariantSelectionDialogSetMulti((CounterMap<String>)matchingLinks, g, YoutubeLinkGrabberExtender.this.groupCount.getInt((Object)g), (List<VariantInfo>)vs);
                            ((YoutubeVariantSelectionDialogSetMulti)UIOManager.I().show(null, (UserIODefinition)d)).throwCloseExceptions();
                            boolean alternativesEnabled = d.isAutoAlternativesEnabled();
                            AbstractVariant choosenVariant = (AbstractVariant)d.getVariant();
                            for (CrawledLink child : children) {
                                AbstractVariant found = YoutubeLinkGrabberExtender.this.findBestVariant(child, g, choosenVariant, alternativesEnabled);
                                if (found == null) continue;
                                LinkCollector.getInstance().setActiveVariantForLink(child, (LinkVariant)found);
                            }
                        }
                        catch (DialogClosedException e) {
                            e.printStackTrace();
                        }
                        catch (DialogCanceledException e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
            }

            public String getString() {
                return null;
            }

            public int getProgress() {
                return this.done * 100 / YoutubeLinkGrabberExtender.this.pv.getChildren().size();
            }

            public String getLabelString() {
                return null;
            }
        };
        ProgressDialog dialog = new ProgressDialog(pg, 0, _GUI.T.lit_please_wait(), _GUI.T.youtube_scan_variants(), (Icon)new AbstractIcon("wait", 32));
        UIOManager.I().show(null, (UserIODefinition)dialog);
    }

    private void addAdditionalVariant(final SelectionInfo.PluginView<CrawledLink> pv, final String id, final AbstractVariant requested) {
        new Thread("Add Additional YoutubeLinks"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<CrawledLink> checkableLinks = new ArrayList<CrawledLink>(1);
                HashSet<String> dupecheck = new HashSet<String>();
                block3: for (CrawledLink cl : pv.getChildren()) {
                    String videoID = cl.getDownloadLink().getStringProperty("YT_ID");
                    if (!dupecheck.add(videoID)) continue;
                    if (requested != null) {
                        ArrayList<CrawledLink> lst;
                        CrawledPackage pkg = cl.getParentNode();
                        boolean readL = pkg.getModifyLock().readLock();
                        try {
                            lst = new ArrayList<CrawledLink>(pkg.getChildren());
                        }
                        finally {
                            pkg.getModifyLock().readUnlock(readL);
                        }
                        for (CrawledLink brother : lst) {
                            List<? extends LinkVariant> brotherVariants;
                            if (!StringUtils.equals((String)brother.getDownloadLink().getStringProperty("YT_ID", null), (String)cl.getDownloadLink().getStringProperty("YT_ID", null)) || (brotherVariants = YoutubeLinkGrabberExtender.this.plg.getVariantsByLink(brother.getDownloadLink())) == null) continue;
                            for (LinkVariant linkVariant : brotherVariants) {
                                if (linkVariant == null || !(linkVariant instanceof AbstractVariant) || !StringUtils.equals((String)((AbstractVariant)linkVariant).getTypeId(), (String)requested.getTypeId())) continue;
                                CrawledLink newLink = LinkCollector.getInstance().addAdditional(brother, linkVariant);
                                if (newLink != null) {
                                    checkableLinks.add(newLink);
                                    continue block3;
                                }
                                Toolkit.getDefaultToolkit().beep();
                            }
                        }
                    }
                    String dummyUrl = "https://www.youtube.com/watch?v=" + videoID + "#variant=" + Encoding.urlEncode((String)id);
                    LinkCollectingJob job = new LinkCollectingJob(cl.getOriginLink().getOrigin() == null ? LinkOrigin.ADD_LINKS_DIALOG.getLinkOriginDetails() : cl.getOriginLink().getOrigin());
                    job.setText(dummyUrl);
                    job.setCustomSourceUrl(cl.getOriginLink().getURL());
                    job.setDeepAnalyse(false);
                    LinkCollector.getInstance().addCrawlerJob(job);
                }
                LinkChecker<ArrayList<CrawledLink>> linkChecker = new LinkChecker<ArrayList<CrawledLink>>(true);
                linkChecker.check(checkableLinks);
            }
        }.start();
    }

    private AbstractVariant findBestVariant(CrawledLink cl, VariantGroup g, AbstractVariant choosenVariant, boolean alternativesEnabled) throws Exception {
        YoutubeHelper helper = new YoutubeHelper(new Browser(), LoggerFactory.getDefaultLogger());
        YoutubeClipData clipData = ClipDataCache.get(helper, cl.getDownloadLink());
        switch (g) {
            case DESCRIPTION: {
                return null;
            }
            case SUBTITLES: {
                List<VariantInfo> subtitles = clipData.findSubtitleVariants();
                if (subtitles == null) break;
                for (VariantInfo variantInfo : subtitles) {
                    if (!StringUtils.equals((String)variantInfo.getVariant()._getUniqueId(), (String)choosenVariant._getUniqueId())) continue;
                    return variantInfo.getVariant();
                }
                if (!alternativesEnabled) break;
                Locale choosenLocale = ((YoutubeSubtitleStorable)((SubtitleVariant)choosenVariant).getGenericInfo())._getLocale();
                for (VariantInfo v : subtitles) {
                    Locale vLocale = ((YoutubeSubtitleStorable)((SubtitleVariant)v.getVariant()).getGenericInfo())._getLocale();
                    if (!StringUtils.equals((String)vLocale.getLanguage(), (String)choosenLocale.getLanguage())) continue;
                    return v.getVariant();
                }
                break;
            }
            case AUDIO: 
            case IMAGE: 
            case VIDEO: {
                List<VariantInfo> variants = clipData.findVariants();
                helper.extendedDataLoading(variants);
                Collections.sort(variants, new Comparator<VariantInfo>(){

                    @Override
                    public int compare(VariantInfo o1, VariantInfo o2) {
                        return o2.compareTo(o1);
                    }
                });
                for (VariantInfo v : variants) {
                    if (!StringUtils.equals((String)v.getVariant()._getUniqueId(), (String)choosenVariant._getUniqueId())) continue;
                    return v.getVariant();
                }
                Object var9_13 = null;
                VariantInfo vLast = null;
                for (int i = 0; i < variants.size(); ++i) {
                    VariantInfo variantInfo = variants.get(i);
                    int comCur = choosenVariant.compareTo(variantInfo.getVariant());
                    if (comCur == 0) {
                        return variantInfo.getVariant();
                    }
                    if (comCur > 0) {
                        if (vLast != null) {
                            return vLast.getVariant();
                        }
                        return variantInfo.getVariant();
                    }
                    vLast = variantInfo;
                }
                for (VariantInfo v : variants) {
                    if (!StringUtils.equals((String)v.getVariant().getTypeId(), (String)choosenVariant.getTypeId())) continue;
                    return v.getVariant();
                }
                if (!alternativesEnabled) break;
                for (VariantInfo v : variants) {
                    if (v.getVariant().getGroup() != choosenVariant.getGroup() || v.getVariant().getContainer() != choosenVariant.getContainer() || !(choosenVariant instanceof VideoVariant && v.getVariant() instanceof VideoVariant ? ((VideoVariant)v.getVariant()).getVideoCodec() == ((VideoVariant)choosenVariant).getVideoCodec() && ((VideoVariant)v.getVariant()).getAudioCodec() == ((VideoVariant)choosenVariant).getAudioCodec() : choosenVariant instanceof AudioVariant && v.getVariant() instanceof AudioVariant && v.getVariant().getContainer() == choosenVariant.getContainer() && ((AudioVariant)v.getVariant()).getAudioCodec() == ((AudioVariant)choosenVariant).getAudioCodec())) continue;
                    return v.getVariant();
                }
                for (VariantInfo v : variants) {
                    if (v.getVariant().getGroup() != choosenVariant.getGroup() || v.getVariant().getContainer() != choosenVariant.getContainer()) continue;
                    return v.getVariant();
                }
                break;
            }
        }
        return null;
    }

    private String getHost() {
        return this.plg.getHost();
    }
}

