/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.configpanel;

import java.util.Locale;
import org.appwork.txtresource.TranslationFactory;
import org.jdownloader.plugins.components.youtube.Projection;
import org.jdownloader.plugins.components.youtube.VariantIDStorable;
import org.jdownloader.plugins.components.youtube.itag.AudioType;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.AudioInterface;
import org.jdownloader.plugins.components.youtube.variants.ImageVariant;
import org.jdownloader.plugins.components.youtube.variants.SubtitleVariant;
import org.jdownloader.plugins.components.youtube.variants.VideoVariant;

public class AbstractVariantWrapper {
    private VariantIDStorable blackListEntry;
    private boolean enabled = true;
    public final AbstractVariant variant;

    public AbstractVariantWrapper(AbstractVariant variant) {
        this.variant = variant;
        this.blackListEntry = new VariantIDStorable(variant);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AbstractVariantWrapper)) {
            return false;
        }
        return ((AbstractVariantWrapper)obj).blackListEntry.createUniqueID().equals(this.blackListEntry.createUniqueID());
    }

    public int hashCode() {
        return this.blackListEntry.createUniqueID().hashCode();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public AudioType getAudioType() {
        if (this.variant instanceof AudioInterface) {
            return ((AudioInterface)((Object)this.variant)).getAudioType();
        }
        return null;
    }

    public String getLanguageCode() {
        String lng = null;
        if (this.variant instanceof AudioInterface) {
            lng = ((AudioInterface)((Object)this.variant)).getAudioId();
        } else if (this.variant instanceof SubtitleVariant) {
            lng = ((SubtitleVariant)this.variant).getLanguageCode();
        }
        if (lng != null) {
            lng = lng.replaceAll("[^a-zA-Z\\-]*", "");
        }
        return lng;
    }

    public Locale getLanguageLocale() {
        if (this.variant instanceof AudioInterface) {
            return ((AudioInterface)((Object)this.variant)).getAudioLocale();
        }
        if (this.variant instanceof SubtitleVariant) {
            String lng = ((SubtitleVariant)this.variant).getLanguageCode();
            if (lng == null) {
                return null;
            }
            return TranslationFactory.stringToLocale((String)lng.replaceAll("[^a-zA-Z\\-]*", ""));
        }
        return null;
    }

    public int getWidth() {
        if (this.variant instanceof VideoVariant) {
            return ((VideoVariant)this.variant).getVideoWidth();
        }
        if (this.variant instanceof ImageVariant) {
            return ((ImageVariant)this.variant).getWidth();
        }
        return -1;
    }

    public int getAudioBitrate() {
        if (this.variant instanceof AudioInterface) {
            return ((AudioInterface)((Object)this.variant)).getAudioBitrate().getKbit();
        }
        return -1;
    }

    public int getFramerate() {
        if (this.variant instanceof VideoVariant) {
            return ((VideoVariant)this.variant).getVideoFrameRate();
        }
        return -1;
    }

    public String getVideoCodec() {
        if (this.variant instanceof VideoVariant) {
            return ((VideoVariant)this.variant).getVideoCodec().getLabel();
        }
        return "";
    }

    public String getAudioCodec() {
        if (this.variant instanceof AudioInterface) {
            return ((AudioInterface)((Object)this.variant)).getAudioCodec().getLabel();
        }
        return "";
    }

    public int getHeight() {
        if (this.variant instanceof VideoVariant) {
            return ((VideoVariant)this.variant).getVideoHeight();
        }
        if (this.variant instanceof ImageVariant) {
            return ((ImageVariant)this.variant).getHeight();
        }
        return -1;
    }

    public VariantIDStorable getVariableIDStorable() {
        return this.blackListEntry;
    }

    public Projection getProjection() {
        if (this.variant instanceof VideoVariant) {
            return ((VideoVariant)this.variant).getProjection();
        }
        return null;
    }
}

