/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.configpanel;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import jd.gui.swing.jdgui.BasicJDTable;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.swing.components.CheckBoxIcon;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.uio.InputDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.CounterMap;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.dialog.InputDialog;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.components.youtube.VariantIDStorable;
import org.jdownloader.plugins.components.youtube.configpanel.AbstractVariantWrapper;
import org.jdownloader.plugins.components.youtube.configpanel.VariantsMapTableModel;
import org.jdownloader.plugins.components.youtube.configpanel.YoutubeVariantCollection;
import org.jdownloader.plugins.components.youtube.variants.AudioVariant;
import org.jdownloader.plugins.components.youtube.variants.DescriptionVariant;
import org.jdownloader.plugins.components.youtube.variants.ImageVariant;
import org.jdownloader.plugins.components.youtube.variants.SubtitleVariant;
import org.jdownloader.plugins.components.youtube.variants.VideoVariant;
import org.jdownloader.settings.staticreferences.CFG_YOUTUBE;
import org.jdownloader.updatev2.gui.LAFOptions;

public class VariantsMapTable
extends BasicJDTable<AbstractVariantWrapper> {
    private final AlphaComposite alpha = AlphaComposite.getInstance(3, 0.3f);

    public VariantsMapTable(VariantsMapTableModel model) {
        super((ExtTableModel)model);
        this.setSearchEnabled(true);
        this.setColumnBottonVisibility(false);
    }

    public VariantsMapTableModel getModel() {
        return (VariantsMapTableModel)super.getModel();
    }

    protected JPopupMenu onContextMenu(JPopupMenu popup, AbstractVariantWrapper contextObject, final List<AbstractVariantWrapper> selection, ExtColumn<AbstractVariantWrapper> column, MouseEvent mouseEvent) {
        popup.add((Action)((Object)new AppAction(){
            {
                this.setSmallIcon(new AbstractIcon("add", 20));
                this.setName(_GUI.T.youtube_config_add_collection());
            }

            public void actionPerformed(ActionEvent e) {
                ArrayList<VariantIDStorable> variants = new ArrayList<VariantIDStorable>();
                HashSet<String> type = new HashSet<String>();
                HashSet<String> extensions = new HashSet<String>();
                AbstractVariantWrapper best = null;
                for (AbstractVariantWrapper w : selection) {
                    variants.add(w.getVariableIDStorable());
                    if (best == null || best.variant.compareTo(w.variant) == -1) {
                        best = w;
                    }
                    extensions.add(w.variant.getContainer().getLabel());
                    if (w.variant instanceof AudioVariant) {
                        type.add(w.variant.getGroup().getLabel());
                    }
                    if (w.variant instanceof SubtitleVariant) {
                        type.add(w.variant.getGroup().getLabel());
                    }
                    if (w.variant instanceof DescriptionVariant) {
                        type.add(w.variant.getGroup().getLabel());
                    }
                    if (w.variant instanceof ImageVariant) {
                        type.add(w.variant.getGroup().getLabel());
                    }
                    if (!(w.variant instanceof VideoVariant)) continue;
                    switch (((VideoVariant)w.variant).getProjection()) {
                        case ANAGLYPH_3D: {
                            type.add("3D " + w.variant.getGroup().getLabel());
                            break;
                        }
                        case NORMAL: {
                            type.add(w.variant.getGroup().getLabel());
                            break;
                        }
                        case SPHERICAL: {
                            type.add("360\u00b0 " + w.variant.getGroup().getLabel());
                            break;
                        }
                        case SPHERICAL_3D: {
                            type.add("3D 360\u00b0 " + w.variant.getGroup().getLabel());
                        }
                    }
                }
                StringBuilder sb = new StringBuilder();
                if (type.size() == 1) {
                    sb.append((String)type.iterator().next());
                }
                if (extensions.size() == 1) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append((String)extensions.iterator().next());
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append("Max " + best.variant._getName(null));
                String name = ((InputDialogInterface)UIOManager.I().show(InputDialogInterface.class, (UserIODefinition)new InputDialog(0, _GUI.T.lit_name(), "", sb.toString(), null, null, null))).getText();
                if (StringUtils.isNotEmpty((String)name)) {
                    YoutubeVariantCollection link = new YoutubeVariantCollection(name, variants);
                    List<YoutubeVariantCollection> links = CFG_YOUTUBE.CFG.getCollections();
                    links.add(link);
                    CFG_YOUTUBE.CFG.setCollections(links);
                }
            }
        }));
        popup.add(new JSeparator());
        popup.add((Action)((Object)new AppAction(){
            {
                this.setSmallIcon((Icon)new CheckBoxIcon(true));
                this.setName(_GUI.T.lit_enable());
            }

            public void actionPerformed(ActionEvent e) {
                for (AbstractVariantWrapper w : selection) {
                    w.setEnabled(true);
                }
                VariantsMapTable.this.getModel().updateEnabledMap();
            }
        }));
        popup.add((Action)((Object)new AppAction(){
            {
                this.setSmallIcon((Icon)new CheckBoxIcon(false));
                this.setName(_GUI.T.lit_disable());
            }

            public void actionPerformed(ActionEvent e) {
                for (AbstractVariantWrapper w : selection) {
                    w.setEnabled(false);
                }
                VariantsMapTable.this.getModel().updateEnabledMap();
            }
        }));
        return popup;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Composite comp = g2.getComposite();
        Rectangle visibleRect = this.getVisibleRect();
        g2.setComposite(this.alpha);
        if (this.getModel().getTableData().size() == 0) {
            g2.setColor(LAFOptions.getInstance().getColorForTableAccountErrorRowBackground());
            g2.fillRect(visibleRect.x, visibleRect.y, visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height);
            g2.setComposite(comp);
            g2.setFont(g2.getFont().deriveFont(g2.getFont().getStyle() ^ 1));
            String str = _GUI.T.youtube_empty_table();
            g2.setColor(LAFOptions.getInstance().getColorForTableAccountErrorRowForeground());
            g2.drawString(str, (this.getWidth() - g2.getFontMetrics().stringWidth(str)) / 2, (int)((double)this.getHeight() * 0.5));
        }
        g2.setComposite(comp);
    }

    protected void initAlternateRowHighlighter() {
        BooleanKeyHandler enabled = LAFOptions.TABLE_ALTERNATE_ROW_HIGHLIGHT_ENABLED;
        if (enabled == null || enabled.isEnabled()) {
            // empty if block
        }
    }

    public void load() {
        this.getModel().load();
    }

    public void save() {
        this.getModel().save();
    }

    public void setSelectionByLink(YoutubeVariantCollection link) {
        if (link == null) {
            return;
        }
        ArrayList<AbstractVariantWrapper> selection = new ArrayList<AbstractVariantWrapper>();
        HashSet<String> idSet = link.createUniqueIDSet();
        for (AbstractVariantWrapper v : this.getModel().getTableData()) {
            if (idSet.contains(v.getVariableIDStorable().createUniqueID())) {
                selection.add(v);
                continue;
            }
            if (StringUtils.equals((String)v.getVariableIDStorable().getContainer(), (String)link.getGroupingID())) {
                selection.add(v);
                continue;
            }
            if (!StringUtils.equals((String)v.getVariableIDStorable().createGroupingID(), (String)link.getGroupingID())) continue;
            selection.add(v);
        }
        this.getModel().setSelectedObjects(selection);
        this.scrollToSelection(0);
    }

    public void onEnabledMapUpdate(CounterMap<String> enabledMap) {
    }
}

