/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.configpanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jd.gui.swing.jdgui.views.settings.components.Checkbox;
import jd.gui.swing.jdgui.views.settings.components.ComboBox;
import jd.gui.swing.jdgui.views.settings.components.MultiComboBox;
import jd.gui.swing.jdgui.views.settings.components.Spinner;
import jd.gui.swing.jdgui.views.settings.components.TextInput;
import jd.gui.swing.jdgui.views.settings.panels.advanced.AdvancedConfigTableModel;
import jd.plugins.Plugin;
import jd.plugins.PluginConfigPanelNG;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.IntegerInterface;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.IntegerKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StringKeyHandler;
import org.appwork.utils.CounterMap;
import org.appwork.utils.logging2.extmanager.Log;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.PerfectHeightScrollPane;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.components.youtube.Projection;
import org.jdownloader.plugins.components.youtube.VariantIDStorable;
import org.jdownloader.plugins.components.youtube.YoutubeConfig;
import org.jdownloader.plugins.components.youtube.YoutubeHelper;
import org.jdownloader.plugins.components.youtube.YoutubeReplacer;
import org.jdownloader.plugins.components.youtube.configpanel.AbstractVariantWrapper;
import org.jdownloader.plugins.components.youtube.configpanel.CollectionsTable;
import org.jdownloader.plugins.components.youtube.configpanel.CollectionsTableModel;
import org.jdownloader.plugins.components.youtube.configpanel.EnumMultiComboBox;
import org.jdownloader.plugins.components.youtube.configpanel.VariantsMapTable;
import org.jdownloader.plugins.components.youtube.configpanel.VariantsMapTableModel;
import org.jdownloader.plugins.components.youtube.configpanel.YoutubeVariantCollection;
import org.jdownloader.plugins.components.youtube.itag.AudioBitrate;
import org.jdownloader.plugins.components.youtube.itag.AudioCodec;
import org.jdownloader.plugins.components.youtube.itag.VideoCodec;
import org.jdownloader.plugins.components.youtube.itag.VideoFrameRate;
import org.jdownloader.plugins.components.youtube.itag.VideoResolution;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.FileContainer;
import org.jdownloader.plugins.components.youtube.variants.VariantGroup;
import org.jdownloader.plugins.config.PluginJsonConfig;
import org.jdownloader.settings.staticreferences.CFG_YOUTUBE;

public class YoutubeDashConfigPanel
extends PluginConfigPanelNG {
    private AdvancedConfigTableModel model;
    private YoutubeConfig cf = PluginJsonConfig.get(YoutubeConfig.class);
    private boolean setting = false;
    private VariantsMapTable allowed;
    private CollectionsTable collections;

    public YoutubeDashConfigPanel(String description) {
        this.addStartDescription(description);
    }

    @Override
    protected void initPluginSettings(Plugin protoType) {
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_if_link_contains_video_and_playlist(), null, null, new ComboBox(this.cf._getStorageHandler().getKeyHandler("LinkIsVideoAndPlaylistUrlAction", KeyHandler.class), (Object[])YoutubeConfig.IfUrlisAVideoAndPlaylistAction.values(), null));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_if_link_equals_playlist(), null, null, new ComboBox(this.cf._getStorageHandler().getKeyHandler("LinkIsPlaylistUrlAction", KeyHandler.class), (Object[])YoutubeConfig.IfUrlisAPlaylistAction.values(), null));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_ProfileCrawlMode(), null, null, new ComboBox(this.cf._getStorageHandler().getKeyHandler("ProfileCrawlMode", KeyHandler.class), (Object[])YoutubeConfig.ProfileCrawlMode.values(), null));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_PlaylistAndProfileCrawlerMaxItemsLimit(), null, null, new Spinner((IntegerKeyHandler)this.cf._getStorageHandler().getKeyHandler("PlaylistAndProfileCrawlerMaxItemsLimit", IntegerKeyHandler.class)));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_ChannelCrawlerPreferredSortMode(), null, null, new ComboBox(this.cf._getStorageHandler().getKeyHandler("ChannelCrawlerPreferredSortMode", KeyHandler.class), (Object[])YoutubeConfig.ChannelCrawlerSortMode.values(), null));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_ChannelPlaylistCrawlerPackagingMode(), null, null, new ComboBox(this.cf._getStorageHandler().getKeyHandler("ChannelPlaylistCrawlerPackagingMode", KeyHandler.class), (Object[])YoutubeConfig.ChannelPlaylistCrawlerPackagingMode.values(), null));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_ProcessPlaylistItemsInReverseOrder(), null, new Checkbox((BooleanKeyHandler)this.cf._getStorageHandler().getKeyHandler("ProcessPlaylistItemsInReverseOrder", BooleanKeyHandler.class), new JComponent[0]));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_PlaylistVideosDuplicateDetectionMode(), null, null, new ComboBox(this.cf._getStorageHandler().getKeyHandler("PlaylistDupeDetectionMode", KeyHandler.class), (Object[])YoutubeConfig.PlaylistDupeDetectionMode.values(), null));
        ArrayList<AbstractVariantWrapper> sorted = new ArrayList<AbstractVariantWrapper>();
        for (AbstractVariant v : AbstractVariant.listVariants()) {
            sorted.add(new AbstractVariantWrapper(v));
        }
        this.addHeader(_GUI.T.YoutubeDashConfigPanel_allowedtypoes(), NewTheme.I().getIcon("mediaplayer", 18));
        this.addDescriptionPlain(_GUI.T.YoutubeDashConfigPanel_allowedtypoes_quick());
        this.collections = new CollectionsTable(new CollectionsTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
                super.onConfigValueModified(keyHandler, newValue);
                YoutubeDashConfigPanel.this.refreshLayout();
            }
        });
        this.allowed = new VariantsMapTable(new VariantsMapTableModel(sorted){
            private static final long serialVersionUID = 1L;

            @Override
            public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
                super.onConfigValueModified(keyHandler, newValue);
                YoutubeDashConfigPanel.this.refreshLayout();
            }
        }){
            private static final long serialVersionUID = 1L;

            @Override
            public void onEnabledMapUpdate(CounterMap<String> enabledMap) {
                YoutubeDashConfigPanel.this.collections.onEnabledMapUpdate(enabledMap);
            }
        };
        this.collections.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                try {
                    YoutubeVariantCollection link = (YoutubeVariantCollection)YoutubeDashConfigPanel.this.collections.getModel().getObjectbyRow(YoutubeDashConfigPanel.this.collections.getSelectedRow());
                    YoutubeDashConfigPanel.this.allowed.setSelectionByLink(link);
                }
                catch (Throwable e1) {
                    Log.log((Throwable)e1);
                }
            }
        });
        List<VariantGroup> groups = Arrays.asList(VariantGroup.values());
        Collections.sort(groups, LabelInterface.COMPARATOR_ASC);
        EnumMultiComboBox<VariantGroup> typeSel = new EnumMultiComboBox<VariantGroup>(groups, CFG_YOUTUBE.BLACKLISTED_GROUPS, true);
        List<FileContainer> container = Arrays.asList(FileContainer.values());
        Collections.sort(container, LabelInterface.COMPARATOR_ASC);
        EnumMultiComboBox<FileContainer> containerSel = new EnumMultiComboBox<FileContainer>(container, CFG_YOUTUBE.BLACKLISTED_FILE_CONTAINERS, true){

            protected String getLabel(int i, FileContainer sc) {
                return sc.getTooltip();
            }
        };
        List<Projection> projections = Arrays.asList(Projection.values());
        Collections.sort(projections, LabelInterface.COMPARATOR_ASC);
        EnumMultiComboBox<Projection> projectionSelect = new EnumMultiComboBox<Projection>(projections, CFG_YOUTUBE.BLACKLISTED_PROJECTIONS, true){

            protected String getLabel(int i, Projection sc) {
                return sc.getTooltip();
            }
        };
        List<VideoResolution> heights = Arrays.asList(VideoResolution.values());
        Collections.sort(heights, IntegerInterface.COMPARATOR_DESC);
        EnumMultiComboBox<VideoResolution> resolutionSelect = new EnumMultiComboBox<VideoResolution>(heights, CFG_YOUTUBE.BLACKLISTED_RESOLUTIONS, true);
        List<VideoFrameRate> fpss = Arrays.asList(VideoFrameRate.values());
        Collections.sort(fpss, IntegerInterface.COMPARATOR_DESC);
        EnumMultiComboBox<VideoFrameRate> fpsSelect = new EnumMultiComboBox<VideoFrameRate>(fpss, CFG_YOUTUBE.BLACKLISTED_VIDEO_FRAMERATES, true);
        List<VideoCodec> videoCodecs = Arrays.asList(VideoCodec.values());
        Collections.sort(videoCodecs, LabelInterface.COMPARATOR_ASC);
        EnumMultiComboBox<VideoCodec> vcodec = new EnumMultiComboBox<VideoCodec>(videoCodecs, CFG_YOUTUBE.BLACKLISTED_VIDEO_CODECS, true){

            protected String getLabel(int i, VideoCodec sc) {
                return sc.getTooltip();
            }
        };
        List<AudioCodec> audioCodecs = Arrays.asList(AudioCodec.values());
        Collections.sort(audioCodecs, LabelInterface.COMPARATOR_ASC);
        EnumMultiComboBox<AudioCodec> acodec = new EnumMultiComboBox<AudioCodec>(audioCodecs, CFG_YOUTUBE.BLACKLISTED_AUDIO_CODECS, true){

            protected String getLabel(int i, AudioCodec sc) {
                return sc.getTooltip();
            }
        };
        List<AudioBitrate> bitrates = Arrays.asList(AudioBitrate.values());
        Collections.sort(bitrates, IntegerInterface.COMPARATOR_DESC);
        EnumMultiComboBox<AudioBitrate> aBitrate = new EnumMultiComboBox<AudioBitrate>(bitrates, CFG_YOUTUBE.BLACKLISTED_AUDIO_BITRATES, true);
        containerSel.keyHandler.getEventSender().addListener((EventListener)new GenericConfigEventListener<Object>(){

            public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
            }

            public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
            }
        });
        this.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_TYPE(), (BooleanKeyHandler)null, typeSel);
        this.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_FILETYPE(), (BooleanKeyHandler)null, containerSel);
        this.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_PROJECTION(), (BooleanKeyHandler)null, projectionSelect);
        this.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_RESOLUTION(), (BooleanKeyHandler)null, resolutionSelect);
        this.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_FPS(), (BooleanKeyHandler)null, fpsSelect);
        this.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_VIDEO_CODEC(), (BooleanKeyHandler)null, vcodec);
        this.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_AUDIO_CODEC(), (BooleanKeyHandler)null, acodec);
        this.addPair(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_AUDIO_BITRATE(), (BooleanKeyHandler)null, aBitrate);
        this.addDescriptionPlain(_GUI.T.YoutubeDashConfigPanel_allowedtypoes_table());
        JScrollPane sp = new JScrollPane((Component)((Object)this.allowed)){

            @Override
            public Dimension getPreferredSize() {
                Dimension ret = super.getPreferredSize();
                Insets borderInsets = this.getBorder().getBorderInsets(this);
                Component view = this.getViewport().getView();
                JViewport ch = this.getColumnHeader();
                ret.height = Math.min(ret.height, view.getPreferredSize().height + 20 + borderInsets.top + borderInsets.bottom + (ch == null ? 0 : ch.getPreferredSize().height));
                return ret;
            }
        };
        this.add(sp, "pushx,growx,spanx,height n:n:300");
        sp.setHorizontalScrollBarPolicy(31);
        this.addHeader(_GUI.T.YoutubeDashConfigPanel_collections_header(), NewTheme.I().getIcon("list", 18));
        this.addDescriptionPlain(_GUI.T.YoutubeDashConfigPanel_links_description());
        this.add((Component)new PerfectHeightScrollPane((Component)((Object)this.collections)), "pushx,growx,spanx");
        this.addHeader(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_filename_or_package_pattern_header(), NewTheme.I().getIcon("file", 18));
        for (YoutubeReplacer r : YoutubeHelper.REPLACER) {
            StringBuilder sb = new StringBuilder();
            for (String s : r.getTags()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("*").append(s).append("*");
            }
            JLabel txt = new JLabel("<html>" + sb.toString().replace("\r\n", "<br>").replace("\r", "<br>").replace("\n", "<br>") + "<html>");
            SwingUtils.setOpaque((JComponent)txt, (boolean)false);
            txt.setEnabled(false);
            this.add(txt, "gaptop 0,growx,pushx,gapleft 10,gapbottom 0,gaptop 0,aligny top");
            txt = new JLabel("<html>" + r.getDescription().replace("\r\n", "<br>").replace("\r", "<br>").replace("\n", "<br>") + "<html>");
            SwingUtils.setOpaque((JComponent)txt, (boolean)false);
            txt.setEnabled(false);
            this.add(txt, "gaptop 0,spanx,growx,pushx,wmin 10,gapbottom 0,gaptop 0,aligny top");
        }
        this.addDescriptionPlain(_GUI.T.YoutubeHelper_getDescription_upperlowercasereplacetags_header());
        JLabel txt = new JLabel("<html>" + _GUI.T.YoutubeHelper_getDescription_upperlowercase().replace("\r\n", "<br>").replace("\r", "<br>").replace("\n", "<br>") + "<html>");
        SwingUtils.setOpaque((JComponent)txt, (boolean)false);
        txt.setEnabled(false);
        this.add(txt, "gaptop 0,growx,pushx,spanx,gapleft 10,gapbottom 0,gaptop 0,aligny top");
        txt = new JLabel("<html>" + _GUI.T.YoutubeHelper_getDescription_replacetags().replace("\r\n", "<br>").replace("\r", "<br>").replace("\n", "<br>") + "<html>");
        SwingUtils.setOpaque((JComponent)txt, (boolean)false);
        txt.setEnabled(false);
        this.add(txt, "gaptop 0,growx,pushx,spanx,gapleft 10,gapbottom 0,gaptop 0,aligny top");
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_package_pattern(), null, null, new TextInput((StringKeyHandler)this.cf._getStorageHandler().getKeyHandler("PackagePattern", StringKeyHandler.class)));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_package_pattern_channel(), null, null, new TextInput((StringKeyHandler)this.cf._getStorageHandler().getKeyHandler("PackagePatternForChannelPackages", StringKeyHandler.class)));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_package_pattern_playlist(), null, null, new TextInput((StringKeyHandler)this.cf._getStorageHandler().getKeyHandler("PackagePatternForPlaylists", StringKeyHandler.class)));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_filename_pattern_video(), null, null, new TextInput(CFG_YOUTUBE.VIDEO_FILENAME_PATTERN));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_filename_pattern_audio(), null, null, new TextInput(CFG_YOUTUBE.AUDIO_FILENAME_PATTERN));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_filename_pattern_image(), null, null, new TextInput(CFG_YOUTUBE.IMAGE_FILENAME_PATTERN));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_filename_pattern_subtitle(), null, null, new TextInput(CFG_YOUTUBE.SUBTITLE_FILENAME_PATTERN));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_filename_pattern_description(), null, null, new TextInput(CFG_YOUTUBE.DESCRIPTION_FILENAME_PATTERN));
        this.addPair(_GUI.T.YoutubeDashConfigPanel_YoutubeDashConfigPanel_PlaylistItemsIncludePlaylistPositionAtBeginningOfFilenames(), null, new Checkbox((BooleanKeyHandler)this.cf._getStorageHandler().getKeyHandler("PlaylistItemsIncludePlaylistPositionAtBeginningOfFilenames", BooleanKeyHandler.class), new JComponent[0]));
        this.updateBest();
    }

    protected void refreshLayout() {
        new EDTRunner(){

            protected void runInEDT() {
                YoutubeDashConfigPanel.this.revalidate();
            }
        };
    }

    private void updateBest() {
    }

    @Override
    public void reset() {
        for (KeyHandler m : this.cf._getStorageHandler().getKeyHandler()) {
            m.setValue(m.getDefaultValue());
        }
        new EDTRunner(){

            protected void runInEDT() {
                YoutubeDashConfigPanel.this.updateContents();
            }
        };
    }

    @Override
    public void save() {
        if (this.setting) {
            return;
        }
        this.allowed.save();
    }

    public void getWhitelist(List<VariantIDStorable> whitelist, MultiVariantBox<?> list) {
        for (AbstractVariant v : list.getValues()) {
            if (!list.isItemSelected(v)) continue;
            whitelist.add(new VariantIDStorable(v));
        }
    }

    public void getBlacklist(List<VariantIDStorable> blacklistSet, MultiVariantBox<?> list) {
        for (AbstractVariant v : list.getValues()) {
            if (list.isItemSelected(v)) continue;
            blacklistSet.add(new VariantIDStorable(v));
        }
    }

    @Override
    public void updateContents() {
        this.setting = true;
        try {
            this.allowed.load();
            this.collections.load();
        }
        finally {
            this.setting = false;
        }
    }

    public void setWhitelist(List<VariantIDStorable> whitelist, MultiVariantBox<?> list) {
        ArrayList<AbstractVariant> vList = new ArrayList<AbstractVariant>();
        for (AbstractVariant v : list.getValues()) {
            if (!whitelist.contains(new VariantIDStorable(v))) continue;
            vList.add(v);
        }
        list.setSelectedItems(vList);
    }

    public void setBlacklist(List<VariantIDStorable> blacklistSet, MultiVariantBox<?> list) {
        ArrayList<AbstractVariant> vList = new ArrayList<AbstractVariant>();
        for (AbstractVariant v : list.getValues()) {
            VariantIDStorable be = new VariantIDStorable(v);
            if (blacklistSet.contains(be)) continue;
            vList.add(v);
        }
        list.setSelectedItems(vList);
    }

    public abstract class MultiVariantBox<Type extends AbstractVariant>
    extends MultiComboBox<Type> {
        private YoutubeDashConfigPanel panel;

        public MultiVariantBox(YoutubeDashConfigPanel youtubeDashConfigPanel, List<Type> list) {
            super(list);
            this.panel = youtubeDashConfigPanel;
        }

        public void onChanged() {
            super.onChanged();
            this.panel.save();
        }

        protected String getLabel(int i, Type sc) {
            String name = this.variantToName(sc, true);
            if (i == 0) {
                return _GUI.T.YoutubeDashConfigPanel_MultiVariantBox_getLabel_(name) + " (" + _GUI.T.YoutubeDashConfigPanel_getLabel_best() + ")";
            }
            if (i == this.getValues().size() - 1) {
                return _GUI.T.YoutubeDashConfigPanel_MultiVariantBox_getLabel_(name) + " (" + _GUI.T.YoutubeDashConfigPanel_getLabel_worst() + ")";
            }
            return _GUI.T.YoutubeDashConfigPanel_MultiVariantBox_getLabel_(name);
        }

        protected abstract String variantToName(Type var1, boolean var2);

        protected String getLabel(Type sc) {
            return this.variantToName(sc, true);
        }

        protected String getLabel(List<Type> list) {
            if (list.size() == 0) {
                return super.getLabel(list);
            }
            StringBuilder sb = new StringBuilder();
            HashSet<String> dupes = new HashSet<String>();
            for (int i = 0; i < list.size(); ++i) {
                String name = this.variantToName((AbstractVariant)list.get(i), false);
                if (!dupes.add(name)) continue;
                if (sb.length() > 0) {
                    if (i == list.size() - 1) {
                        sb.append(" & ");
                    } else {
                        sb.append(", ");
                    }
                }
                sb.append(name);
            }
            return "(" + list.size() + "/" + this.getValues().size() + ") " + sb.toString();
        }
    }
}

