/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.itag;

import org.jdownloader.gui.translate._GUI;
import org.jdownloader.plugins.components.youtube.YT_STATICS;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.ImagePlaylistCoverVariant;
import org.jdownloader.plugins.components.youtube.variants.ImageVariant;

public enum ImageQuality {
    HIGHEST(4.0, 10.0){

        @Override
        public String getLocaleName() {
            return _GUI.T.YoutubeVariant_name_IMAGE_MAX();
        }

        @Override
        public String getLocaleTag() {
            return _GUI.T.YoutubeVariant_filenametag_IMAGE_MAX();
        }
    }
    ,
    HIGH(3.0, 10.0){

        @Override
        public String getLocaleName() {
            return _GUI.T.YoutubeVariant_name_IMAGE_HQ();
        }

        @Override
        public String getLocaleTag() {
            return _GUI.T.YoutubeVariant_filenametag_IMAGE_HQ();
        }
    }
    ,
    MEDIUM(2.0, 10.0){

        @Override
        public String getLocaleName() {
            return _GUI.T.YoutubeVariant_name_IMAGE_MQ();
        }

        @Override
        public String getLocaleTag() {
            return _GUI.T.YoutubeVariant_filenametag_IMAGE_MQ();
        }
    }
    ,
    LOW(1.0, 10.0){

        @Override
        public String getLocaleName() {
            return _GUI.T.YoutubeVariant_name_IMAGE_LQ();
        }

        @Override
        public String getLocaleTag() {
            return _GUI.T.YoutubeVariant_filenametag_IMAGE_LQ();
        }
    };

    private double rating = -1.0;

    private ImageQuality(double rating, double modifier) {
        this.rating = rating / modifier;
    }

    public abstract String getLocaleName();

    public abstract String getLocaleTag();

    public double getRating() {
        return this.rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }

    public static ImageQuality getByVariant(AbstractVariant o1) {
        if (o1 instanceof ImageVariant) {
            return ((ImageVariant)o1).getImageQuality();
        }
        if (o1 instanceof ImagePlaylistCoverVariant) {
            return ((ImagePlaylistCoverVariant)o1).getImageQuality();
        }
        return null;
    }

    public static int getSortId(AbstractVariant v) {
        ImageQuality res = ImageQuality.getByVariant(v);
        if (res == null) {
            return -1;
        }
        Number intObj = YT_STATICS.SORTIDS_IMAGE_QUALITY.get((Object)res);
        if (intObj == null) {
            return -1;
        }
        return intObj.intValue();
    }
}

