/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.itag;

import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.utils.CompareUtils;
import org.jdownloader.plugins.components.youtube.itag.AudioBitrate;
import org.jdownloader.plugins.components.youtube.itag.AudioCodec;
import org.jdownloader.plugins.components.youtube.itag.AudioType;
import org.jdownloader.plugins.components.youtube.itag.ImageQuality;
import org.jdownloader.plugins.components.youtube.itag.VideoCodec;
import org.jdownloader.plugins.components.youtube.itag.VideoFrameRate;
import org.jdownloader.plugins.components.youtube.itag.VideoResolution;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.AudioVariant;
import org.jdownloader.plugins.components.youtube.variants.FileContainer;
import org.jdownloader.translate._JDT;

public enum QualitySortIdentifier implements LabelInterface
{
    RESOLUTION{

        public String getLabel() {
            return _JDT.T.lit_resolution();
        }

        @Override
        public int compare(AbstractVariant o1, AbstractVariant o2) {
            return CompareUtils.compareInt((int)VideoResolution.getSortId(o1), (int)VideoResolution.getSortId(o2));
        }
    }
    ,
    IMAGE_QUALITY{

        public String getLabel() {
            return _JDT.T.lit_image_quality();
        }

        @Override
        public int compare(AbstractVariant o1, AbstractVariant o2) {
            return CompareUtils.compareInt((int)ImageQuality.getSortId(o1), (int)ImageQuality.getSortId(o2));
        }
    }
    ,
    VIDEO_CODEC{

        public String getLabel() {
            return _JDT.T.lit_video_codec();
        }

        @Override
        public int compare(AbstractVariant o1, AbstractVariant o2) {
            return CompareUtils.compareInt((int)VideoCodec.getSortId(o1), (int)VideoCodec.getSortId(o2));
        }
    }
    ,
    VIDEO_FRAMERATE{

        public String getLabel() {
            return _JDT.T.lit_video_framerate();
        }

        @Override
        public int compare(AbstractVariant o1, AbstractVariant o2) {
            return CompareUtils.compareInt((int)VideoFrameRate.getSortId(o1), (int)VideoFrameRate.getSortId(o2));
        }
    }
    ,
    AUDIO_TYPE{

        public String getLabel() {
            return _JDT.T.lit_audio_type();
        }

        @Override
        public int compare(AbstractVariant o1, AbstractVariant o2) {
            return CompareUtils.compareInt((int)AudioType.getSortId(o1), (int)AudioType.getSortId(o2));
        }
    }
    ,
    AUDIO_BITRATE{

        public String getLabel() {
            return _JDT.T.lit_audio_bitrate();
        }

        @Override
        public int compare(AbstractVariant o1, AbstractVariant o2) {
            return CompareUtils.compareInt((int)AudioBitrate.getSortId(o1), (int)AudioBitrate.getSortId(o2));
        }
    }
    ,
    AUDIO_CODEC{

        public String getLabel() {
            return _JDT.T.lit_audio_codec();
        }

        @Override
        public int compare(AbstractVariant o1, AbstractVariant o2) {
            return CompareUtils.compareInt((int)AudioCodec.getSortId(o1), (int)AudioCodec.getSortId(o2));
        }
    }
    ,
    CONTAINER{

        public String getLabel() {
            return _JDT.T.lit_file_container();
        }

        @Override
        public int compare(AbstractVariant o1, AbstractVariant o2) {
            return CompareUtils.compareInt((int)FileContainer.getSortId(o1), (int)FileContainer.getSortId(o2));
        }
    }
    ,
    SEGMENT_STREAM{

        public String getLabel() {
            return _JDT.T.youtube_segment();
        }

        @Override
        public int compare(AbstractVariant o1, AbstractVariant o2) {
            boolean b1 = o1.getVariantInfo() != null && o1.getVariantInfo().hasDefaultSegmentsStream();
            boolean b2 = o2.getVariantInfo() != null && o2.getVariantInfo().hasDefaultSegmentsStream();
            return CompareUtils.compareBoolean((boolean)b2, (boolean)b1);
        }
    }
    ,
    DEMUX_AUDIO{

        public String getLabel() {
            return _JDT.T.youtube_demux();
        }

        @Override
        public int compare(AbstractVariant o1, AbstractVariant o2) {
            boolean b1 = o1 instanceof AudioVariant && o1.getBaseVariant().getiTagAudio() == null;
            boolean b2 = o2 instanceof AudioVariant && o2.getBaseVariant().getiTagAudio() == null;
            return CompareUtils.compareBoolean((boolean)b2, (boolean)b1);
        }
    };


    public abstract int compare(AbstractVariant var1, AbstractVariant var2);
}

