/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.itag;

import org.appwork.storage.config.annotations.IntegerInterface;
import org.appwork.storage.config.annotations.LabelInterface;
import org.jdownloader.plugins.components.youtube.YT_STATICS;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.VideoVariant;

public enum VideoFrameRate implements IntegerInterface,
LabelInterface
{
    FPS_60(60.0),
    FPS_50(50.0),
    FPS_30(30.0),
    FPS_24(24.0),
    FPS_15(15.0),
    FPS_6(6.0);

    private final double fps;

    public final double getFps() {
        return this.fps;
    }

    private VideoFrameRate(double fps) {
        this.fps = fps;
    }

    public String getLabel() {
        return (int)Math.ceil(this.getFps()) + "fps";
    }

    public int getInt() {
        return (int)Math.ceil(this.getFps());
    }

    public static VideoFrameRate getByVariant(AbstractVariant o1) {
        if (o1 instanceof VideoVariant) {
            return ((VideoVariant)o1).getiTagVideo().getVideoFrameRate();
        }
        return null;
    }

    public static int getSortId(AbstractVariant v) {
        VideoFrameRate res = VideoFrameRate.getByVariant(v);
        if (res == null) {
            return -1;
        }
        Number intObj = YT_STATICS.SORTIDS_VIDEO_FRAMERATE.get((Object)res);
        if (intObj == null) {
            return -1;
        }
        return intObj.intValue();
    }
}

