/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.itag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.appwork.utils.parser.UrlQuery;
import org.jdownloader.plugins.components.youtube.itag.AudioBitrate;
import org.jdownloader.plugins.components.youtube.itag.AudioCodec;
import org.jdownloader.plugins.components.youtube.itag.ImageQuality;
import org.jdownloader.plugins.components.youtube.itag.MediaTagsVarious;
import org.jdownloader.plugins.components.youtube.itag.StreamContainer;
import org.jdownloader.plugins.components.youtube.itag.VideoCodec;
import org.jdownloader.plugins.components.youtube.itag.VideoFrameRate;
import org.jdownloader.plugins.components.youtube.itag.VideoResolution;

public enum YoutubeITAG {
    DASH_VIDEO_144p_AV1(394, StreamContainer.DASH_VIDEO, VideoResolution.P_144, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_144p_AV1_HIGHER_BITRATE(694, StreamContainer.DASH_VIDEO, VideoResolution.P_144, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_240p_AV1(395, StreamContainer.DASH_VIDEO, VideoResolution.P_240, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_240p_AV1_HIGHER_BITRATE(695, StreamContainer.DASH_VIDEO, VideoResolution.P_240, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_360p_AV1(396, StreamContainer.DASH_VIDEO, VideoResolution.P_360, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_360p_AV1_HIGHER_BITRATE(696, StreamContainer.DASH_VIDEO, VideoResolution.P_360, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_480p_AV1(397, StreamContainer.DASH_VIDEO, VideoResolution.P_480, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_480p_AV1_HIGHER_BITRATE(697, StreamContainer.DASH_VIDEO, VideoResolution.P_480, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_720p_AV1(398, StreamContainer.DASH_VIDEO, VideoResolution.P_720, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_720p_AV1_HIGHER_BITRATE(698, StreamContainer.DASH_VIDEO, VideoResolution.P_720, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_1080p_AV1(399, StreamContainer.DASH_VIDEO, VideoResolution.P_1080, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_1080p_AV1_HIGHER_BITRATE(699, StreamContainer.DASH_VIDEO, VideoResolution.P_1080, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_1440p_AV1(400, StreamContainer.DASH_VIDEO, VideoResolution.P_1440, VideoCodec.AV1, VideoFrameRate.FPS_60),
    DASH_VIDEO_1440p_AV1_HIGHER_BITRATE(700, StreamContainer.DASH_VIDEO, VideoResolution.P_1440, VideoCodec.AV1, VideoFrameRate.FPS_60),
    DASH_VIDEO_2160p_AV1(401, StreamContainer.DASH_VIDEO, VideoResolution.P_2160, VideoCodec.AV1, VideoFrameRate.FPS_60),
    DASH_VIDEO_2160p_AV1_HIGHER_BITRATE(701, StreamContainer.DASH_VIDEO, VideoResolution.P_2160, VideoCodec.AV1, VideoFrameRate.FPS_60),
    DASH_VIDEO_4320p_AV1(402, StreamContainer.DASH_VIDEO, VideoResolution.P_4320, VideoCodec.AV1, VideoFrameRate.FPS_60),
    DASH_VIDEO_4320p_AV1_HIGHER_BITRATE(571, StreamContainer.DASH_VIDEO, VideoResolution.P_4320, VideoCodec.AV1, VideoFrameRate.FPS_60),
    DASH_VIDEO_4320p_AV1_HFR_HIGH(702, StreamContainer.DASH_VIDEO, VideoResolution.P_4320, VideoCodec.AV1, VideoFrameRate.FPS_60),
    DASH_VIDEO_1080x608_AV1(788, StreamContainer.DASH_VIDEO, VideoResolution.P_1080_608, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_608x1080_AV1(788, StreamContainer.DASH_VIDEO, VideoResolution.P_608_1080, VideoCodec.AV1, VideoFrameRate.FPS_30),
    DASH_VIDEO_1080x608_VP9_EFFICIENCY(779, StreamContainer.DASH_VIDEO, VideoResolution.P_1080_608, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DASH_VIDEO_608x1080_VP9_EFFICIENCY(779, StreamContainer.DASH_VIDEO, VideoResolution.P_608_1080, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DASH_VIDEO_1080x608_VP9_BEST(780, StreamContainer.DASH_VIDEO, VideoResolution.P_1080_608, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DASH_VIDEO_608x1080_VP9_BEST(780, StreamContainer.DASH_VIDEO, VideoResolution.P_608_1080, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DASH_AUDIO_128K_AAC(140, StreamContainer.DASH_AUDIO, AudioCodec.AAC, AudioBitrate.KBIT_128),
    DASH_AUDIO_128K_WEBM(171, StreamContainer.DASH_AUDIO, AudioCodec.VORBIS, AudioBitrate.KBIT_128),
    DASH_AUDIO_192K_WEBM(172, StreamContainer.DASH_AUDIO, AudioCodec.VORBIS, AudioBitrate.KBIT_192),
    DASH_AUDIO_256K_WEBM_SPATIAL(339, StreamContainer.DASH_AUDIO, AudioCodec.VORBIS_SPATIAL, AudioBitrate.KBIT_256),
    DASH_AUDIO_384K_DTSE_SPATIAL(325, StreamContainer.DASH_AUDIO, AudioCodec.DTSE_SPATIAL, AudioBitrate.KBIT_384),
    DASH_AUDIO_384K_EC3_SPATIAL(328, StreamContainer.DASH_AUDIO, AudioCodec.EC3_SPATIAL, AudioBitrate.KBIT_384),
    DASH_AUDIO_384K_AC3_SPATIAL(380, StreamContainer.DASH_AUDIO, AudioCodec.AC3_SPATIAL, AudioBitrate.KBIT_384),
    DASH_AUDIO_256K_AAC_SPATIAL(327, StreamContainer.DASH_AUDIO, AudioCodec.AAC_SPATIAL, AudioBitrate.KBIT_256),
    DASH_AUDIO_192K_AAC_SPATIAL(256, StreamContainer.DASH_AUDIO, AudioCodec.AAC_SPATIAL, AudioBitrate.KBIT_192),
    DASH_AUDIO_384K_AAC_SPATIAL(258, StreamContainer.DASH_AUDIO, AudioCodec.AAC_SPATIAL, AudioBitrate.KBIT_384),
    DASH_AUDIO_256K_AAC(141, StreamContainer.DASH_AUDIO, AudioCodec.AAC, AudioBitrate.KBIT_256),
    DASH_AUDIO_48K_AAC(139, StreamContainer.DASH_AUDIO, AudioCodec.AAC, AudioBitrate.KBIT_48),
    DASH_AUDIO_32K_AAC(599, StreamContainer.DASH_AUDIO, AudioCodec.AAC, AudioBitrate.KBIT_32),
    DASH_AUDIO_512K_OPUS_SPATIAL(338, StreamContainer.DASH_AUDIO, AudioCodec.OPUS_SPATIAL, AudioBitrate.KBIT_512),
    DASH_AUDIO_OPUS_256KBIT(774, StreamContainer.DASH_AUDIO, AudioCodec.OPUS, AudioBitrate.KBIT_256),
    DASH_AUDIO_OPUS_160KBIT(251, StreamContainer.DASH_AUDIO, AudioCodec.OPUS, AudioBitrate.KBIT_160),
    DASH_AUDIO_OPUS_64KBIT(250, StreamContainer.DASH_AUDIO, AudioCodec.OPUS, AudioBitrate.KBIT_64),
    DASH_AUDIO_OPUS_48KBIT(249, StreamContainer.DASH_AUDIO, AudioCodec.OPUS, AudioBitrate.KBIT_48),
    DASH_AUDIO_OPUS_32KBIT(600, StreamContainer.DASH_AUDIO, AudioCodec.OPUS, AudioBitrate.KBIT_32),
    DASH_VIDEO_1080_H264_FPS60(299, StreamContainer.DASH_VIDEO, VideoResolution.P_1080, VideoCodec.H264, VideoFrameRate.FPS_60),
    DASH_VIDEO_1080P_H264(137, StreamContainer.DASH_VIDEO, VideoResolution.P_1080, VideoCodec.H264, VideoFrameRate.FPS_30),
    DASH_VIDEO_1440P_H264(264, StreamContainer.DASH_VIDEO, VideoResolution.P_1440, VideoCodec.H264, VideoFrameRate.FPS_30),
    DASH_VIDEO_144P_H264(160, StreamContainer.DASH_VIDEO, VideoResolution.P_144, VideoCodec.H264, VideoFrameRate.FPS_30),
    DASH_VIDEO_144P_H264_FPS15(597, StreamContainer.DASH_VIDEO, VideoResolution.P_144, VideoCodec.H264, VideoFrameRate.FPS_15),
    DASH_VIDEO_1920_H264_FPS_60(266, StreamContainer.DASH_VIDEO, VideoResolution.P_1920, VideoCodec.H264, VideoFrameRate.FPS_60),
    DASH_VIDEO_2160_H264_FPS_60(266, StreamContainer.DASH_VIDEO, VideoResolution.P_2160, VideoCodec.H264, VideoFrameRate.FPS_60),
    DASH_VIDEO_2160_H264(266, StreamContainer.DASH_VIDEO, VideoResolution.P_2160, VideoCodec.H264, VideoFrameRate.FPS_30),
    DASH_VIDEO_1920_H264(266, StreamContainer.DASH_VIDEO, VideoResolution.P_1920, VideoCodec.H264, VideoFrameRate.FPS_30),
    DASH_VIDEO_240P_H264(133, StreamContainer.DASH_VIDEO, VideoResolution.P_240, VideoCodec.H264, VideoFrameRate.FPS_30),
    DASH_VIDEO_360P_H264(134, StreamContainer.DASH_VIDEO, VideoResolution.P_360, VideoCodec.H264, VideoFrameRate.FPS_30),
    DASH_VIDEO_480P_H264(135, StreamContainer.DASH_VIDEO, VideoResolution.P_480, VideoCodec.H264, VideoFrameRate.FPS_30),
    DASH_VIDEO_480P_H264_2(212, StreamContainer.DASH_VIDEO, VideoResolution.P_480, VideoCodec.H264, VideoFrameRate.FPS_30),
    DASH_VIDEO_720_H264_FPS60(298, StreamContainer.DASH_VIDEO, VideoResolution.P_720, VideoCodec.H264, VideoFrameRate.FPS_60),
    DASH_VIDEO_720P_H264(136, StreamContainer.DASH_VIDEO, VideoResolution.P_720, VideoCodec.H264, VideoFrameRate.FPS_30),
    DASH_VIDEO_ITAG304_MP4_1280P_60FPS(304, StreamContainer.DASH_VIDEO, VideoResolution.P_1280, VideoCodec.H264, VideoFrameRate.FPS_60),
    DASH_VIDEO_ITAG305_MP4_1280P_60FPS(305, StreamContainer.DASH_VIDEO, VideoResolution.P_1920, VideoCodec.H264, VideoFrameRate.FPS_60),
    DASH_VIDEO_ITAG308_VP9_1440P_60FPS(308, StreamContainer.DASH_VIDEO, VideoResolution.P_1440, VideoCodec.VP9, VideoFrameRate.FPS_60),
    DASH_VIDEO_ITAG313_VP9_1920P_30FPS(313, StreamContainer.DASH_VIDEO, VideoResolution.P_1920, VideoCodec.VP9_WORSE_PROFILE_1, VideoFrameRate.FPS_30),
    DASH_VIDEO_ITAG313_VP9_2160P_30FPS(313, StreamContainer.DASH_VIDEO, VideoResolution.P_2160, VideoCodec.VP9_WORSE_PROFILE_1, VideoFrameRate.FPS_30),
    DASH_VIDEO_ITAG315_VP9_1920P_60FPS(315, StreamContainer.DASH_VIDEO, VideoResolution.P_1920, VideoCodec.VP9, VideoFrameRate.FPS_60),
    DASH_VIDEO_ITAG315_VP9_2160P_60FPS(315, StreamContainer.DASH_VIDEO, VideoResolution.P_2160, VideoCodec.VP9, VideoFrameRate.FPS_60),
    DASH_VIDEO_VP9_1080P_PREMIUM(356, StreamContainer.DASH_VIDEO, VideoResolution.P_1080, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DASH_VIDEO_VP9_2160P_60FPS(337, StreamContainer.DASH_VIDEO, VideoResolution.P_2160, VideoCodec.VP9_HDR, VideoFrameRate.FPS_60),
    DASH_VIDEO_VP9_1440P_60FPS(336, StreamContainer.DASH_VIDEO, VideoResolution.P_1440, VideoCodec.VP9_HDR, VideoFrameRate.FPS_60),
    DASH_VIDEO_VP9_1080P_60FPS(335, StreamContainer.DASH_VIDEO, VideoResolution.P_1080, VideoCodec.VP9_HDR, VideoFrameRate.FPS_60),
    DASH_VIDEO_VP9_720P_60FPS(334, StreamContainer.DASH_VIDEO, VideoResolution.P_720, VideoCodec.VP9_HDR, VideoFrameRate.FPS_60),
    DASH_VIDEO_VP9_480P_60FPS(333, StreamContainer.DASH_VIDEO, VideoResolution.P_480, VideoCodec.VP9_HDR, VideoFrameRate.FPS_60),
    DASH_VIDEO_VP9_360P_60FPS(332, StreamContainer.DASH_VIDEO, VideoResolution.P_360, VideoCodec.VP9_HDR, VideoFrameRate.FPS_60),
    DASH_VIDEO_VP9_240P_60FPS(331, StreamContainer.DASH_VIDEO, VideoResolution.P_240, VideoCodec.VP9_HDR, VideoFrameRate.FPS_60),
    DASH_VIDEO_VP9_144P_60FPS(330, StreamContainer.DASH_VIDEO, VideoResolution.P_144, VideoCodec.VP9_HDR, VideoFrameRate.FPS_60),
    DASH_VIDEO_ORIGINAL_H264_GENERIC_4K(138, StreamContainer.DASH_VIDEO, VideoResolution.P_2160, VideoCodec.H264, VideoFrameRate.FPS_30),
    DASH_VIDEO_ORIGINAL_H264_GENERIC_1080P(138, StreamContainer.DASH_VIDEO, VideoResolution.P_1080, VideoCodec.H264, VideoFrameRate.FPS_30),
    DASH_VIDEO_ORIGINAL_H264_GENERIC_8K(138, StreamContainer.DASH_VIDEO, VideoResolution.P_4320, VideoCodec.H264, VideoFrameRate.FPS_30),
    DASH_WEBM_VIDEO_1080P_VP9(248, StreamContainer.DASH_VIDEO, VideoResolution.P_1080, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DASH_WEBM_VIDEO_1080P_VP9_60FPS(303, StreamContainer.DASH_VIDEO, VideoResolution.P_1080, VideoCodec.VP9, VideoFrameRate.FPS_60),
    DASH_WEBM_VIDEO_1440P_VP9(271, StreamContainer.DASH_VIDEO, VideoResolution.P_1440, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DASH_WEBM_VIDEO_144P_VP9(278, StreamContainer.DASH_VIDEO, VideoResolution.P_144, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DASH_WEBM_VIDEO_144P_VP9_15FPS(598, StreamContainer.DASH_VIDEO, VideoResolution.P_144, VideoCodec.VP9, VideoFrameRate.FPS_15),
    DASH_WEBM_VIDEO_4320P_VP9(272, StreamContainer.DASH_VIDEO, VideoResolution.P_4320, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DASH_WEBM_VIDEO_2160P_VP9(272, StreamContainer.DASH_VIDEO, VideoResolution.P_2160, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DASH_WEBM_VIDEO_240P_VP9(242, StreamContainer.DASH_VIDEO, VideoResolution.P_240, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DASH_WEBM_VIDEO_360P_VP9(243, StreamContainer.DASH_VIDEO, VideoResolution.P_360, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DASH_WEBM_VIDEO_480P_VP9(244, StreamContainer.DASH_VIDEO, VideoResolution.P_480, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DESCRIPTION(10002, StreamContainer.PLAIN, MediaTagsVarious.DESCRIPTION),
    DASH_WEBM_VIDEO_480P_VP9_2(245, StreamContainer.DASH_VIDEO, VideoResolution.P_480, VideoCodec.VP9_BETTER_PROFILE_1, VideoFrameRate.FPS_30),
    DASH_WEBM_VIDEO_480P_VP9_3(246, StreamContainer.DASH_VIDEO, VideoResolution.P_480, VideoCodec.VP9_BETTER_PROFILE_2, VideoFrameRate.FPS_30),
    DASH_WEBM_VIDEO_480P_VP9_4(779, StreamContainer.DASH_VIDEO, VideoResolution.P_480, VideoCodec.VP9_BETTER_PROFILE_2, VideoFrameRate.FPS_30),
    DASH_WEBM_VIDEO_480P_VP9_5(780, StreamContainer.DASH_VIDEO, VideoResolution.P_480, VideoCodec.VP9_BETTER_PROFILE_2, VideoFrameRate.FPS_30),
    DASH_WEBM_VIDEO_720P_VP9(247, StreamContainer.DASH_VIDEO, VideoResolution.P_720, VideoCodec.VP9, VideoFrameRate.FPS_30),
    DASH_WEBM_VIDEO_720P_VP9_60FPS(302, StreamContainer.DASH_VIDEO, VideoResolution.P_720, VideoCodec.VP9, VideoFrameRate.FPS_60),
    FLV_VIDEO_360P_H264_AUDIO_AAC(34, StreamContainer.FLV, VideoResolution.P_360, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_128),
    FLV_VIDEO_480P_H264_AUDIO_AAC(35, StreamContainer.FLV, VideoResolution.P_480, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_128),
    FLV_VIDEO_HIGH_270P_H263_AUDIO_MP3(6, StreamContainer.FLV, VideoResolution.P_270, VideoCodec.H263, VideoFrameRate.FPS_30, AudioCodec.MP3, AudioBitrate.KBIT_64),
    FLV_VIDEO_LOW_240P_H263_AUDIO_MP3(5, StreamContainer.FLV, VideoResolution.P_240, VideoCodec.H263, VideoFrameRate.FPS_30, AudioCodec.MP3, AudioBitrate.KBIT_64),
    THREEGP4_ITAG13_H263_144P_15FPS_AMRNB_12KBIT(13, StreamContainer.THREEGP, VideoResolution.P_144, VideoCodec.H263, VideoFrameRate.FPS_15, AudioCodec.AMR, AudioBitrate.KBIT_12),
    IMAGE_MAX(10001, StreamContainer.PLAIN, ImageQuality.HIGHEST),
    IMAGE_HQ(10002, StreamContainer.PLAIN, ImageQuality.HIGH),
    IMAGE_MQ(10003, StreamContainer.PLAIN, ImageQuality.MEDIUM),
    IMAGE_LQ(10004, StreamContainer.PLAIN, ImageQuality.LOW),
    COVER_MAX(11001, StreamContainer.PLAIN, ImageQuality.HIGHEST),
    COVER_HQ(11002, StreamContainer.PLAIN, ImageQuality.HIGH),
    COVER_MQ(11003, StreamContainer.PLAIN, ImageQuality.MEDIUM),
    COVER_LQ(11004, StreamContainer.PLAIN, ImageQuality.LOW),
    MP4_VIDEO_1080P_H264_AUDIO_AAC(37, StreamContainer.MP4, VideoResolution.P_1080, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_192),
    MP4_VIDEO_1080P_H264_AUDIO_AAC_3D(85, StreamContainer.MP4, VideoResolution.P_1080, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_192),
    MP4_VIDEO_240P_H264_AUDIO_AAC_3D(83, StreamContainer.MP4, VideoResolution.P_240, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_96),
    MP4_VIDEO_360P_H264_AUDIO_AAC_3D_V1(82, StreamContainer.MP4, VideoResolution.P_360, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_96),
    MP4_VIDEO_360P_H264_AUDIO_AAC_V1(18, StreamContainer.MP4, VideoResolution.P_360, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_96),
    MP4_VIDEO_720P_H264_AUDIO_AAC_3D(84, StreamContainer.MP4, VideoResolution.P_720, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_192),
    MP4_VIDEO_720P_H264_AUDIO_AAC_3D_V1(84, StreamContainer.MP4, VideoResolution.P_720, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_128),
    MP4_VIDEO_720P_H264_AUDIO_AAC_3D_V3(84, StreamContainer.MP4, VideoResolution.P_720, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_152),
    MP4_VIDEO_720P_H264_AUDIO_AAC(22, StreamContainer.MP4, VideoResolution.P_720, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_192),
    MP4_VIDEO_720P_H264_AUDIO_AAC_V3(22, StreamContainer.MP4, VideoResolution.P_720, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_152),
    MP4_VIDEO_720P_H264_AUDIO_AAC_V1(22, StreamContainer.MP4, VideoResolution.P_720, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_128),
    MP4_VIDEO_AUDIO_ORIGINAL(38, StreamContainer.MP4, VideoResolution.P_2160, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_192),
    SUBTITLE(10002, StreamContainer.PLAIN, MediaTagsVarious.SUBTITLE),
    THREEGP_VIDEO_144P_H264_AUDIO_AAC(17, StreamContainer.THREEGP, VideoResolution.P_144, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_32_ESTIMATED),
    THREEGP_VIDEO_240P_H263_AUDIO_AAC(132, StreamContainer.THREEGP, VideoResolution.P_240, VideoCodec.H263, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_32),
    THREEGP_VIDEO_240P_H264_AUDIO_AAC(36, StreamContainer.THREEGP, VideoResolution.P_240, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_32),
    WEBM_VIDEO_1080P_VP8_AUDIO_VORBIS(46, StreamContainer.WEBM, VideoResolution.P_1080, VideoCodec.VP8, VideoFrameRate.FPS_30, AudioCodec.VORBIS, AudioBitrate.KBIT_192),
    WEBM_VIDEO_360P_VP8_AUDIO_128K_VORBIS_3D(100, StreamContainer.WEBM, VideoResolution.P_360, VideoCodec.VP9, VideoFrameRate.FPS_30, AudioCodec.VORBIS, AudioBitrate.KBIT_128),
    WEBM_VIDEO_360P_VP8_AUDIO_192K_VORBIS_3D(101, StreamContainer.WEBM, VideoResolution.P_360, VideoCodec.VP9, VideoFrameRate.FPS_30, AudioCodec.VORBIS, AudioBitrate.KBIT_192),
    WEBM_VIDEO_360P_VP8_AUDIO_VORBIS(43, StreamContainer.WEBM, VideoResolution.P_360, VideoCodec.VP8, VideoFrameRate.FPS_30, AudioCodec.VORBIS, AudioBitrate.KBIT_128),
    WEBM_VIDEO_480P_VP8_AUDIO_VORBIS(44, StreamContainer.WEBM, VideoResolution.P_480, VideoCodec.VP8, VideoFrameRate.FPS_30, AudioCodec.VORBIS, AudioBitrate.KBIT_128),
    WEBM_VIDEO_720P_VP8_AUDIO_192K_VORBIS_3D(102, StreamContainer.WEBM, VideoResolution.P_720, VideoCodec.VP8, VideoFrameRate.FPS_30, AudioCodec.VORBIS, AudioBitrate.KBIT_192),
    MP4_ITAG59_H264_480P_24FPS_AAC_128KBIT(59, StreamContainer.MP4, VideoResolution.P_480, VideoCodec.H264, VideoFrameRate.FPS_24, AudioCodec.AAC, AudioBitrate.KBIT_128),
    MP4_ITAG78_H264_480P_24FPS_AAC_128KBIT(78, StreamContainer.MP4, VideoResolution.P_480, VideoCodec.H264, VideoFrameRate.FPS_24, AudioCodec.AAC, AudioBitrate.KBIT_128),
    WEBM_VIDEO_720P_VP8_AUDIO_VORBIS(45, StreamContainer.WEBM, VideoResolution.P_720, VideoCodec.VP8, VideoFrameRate.FPS_30, AudioCodec.VORBIS, AudioBitrate.KBIT_192),
    HLS_VIDEO_MP4_72P_6FPS_AUDIO_AAC(151, StreamContainer.MP4, VideoResolution.P_72, VideoCodec.H264, VideoFrameRate.FPS_6, AudioCodec.AAC, AudioBitrate.KBIT_24),
    HLS_VIDEO_MP4_240P_15FPS_AUDIO_AAC(132, StreamContainer.MP4, VideoResolution.P_240, VideoCodec.H264, VideoFrameRate.FPS_15, AudioCodec.AAC, AudioBitrate.KBIT_48),
    HLS_VIDEO_MP4_144P_AUDIO_AAC(91, StreamContainer.MP4, VideoResolution.P_144, VideoCodec.H264, VideoFrameRate.FPS_15, AudioCodec.AAC, AudioBitrate.KBIT_48),
    HLS_VIDEO_MP4_240P_AUDIO_AAC_2(92, StreamContainer.MP4, VideoResolution.P_240, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_48),
    HLS_VIDEO_MP4_360P_AUDIO_AAC(93, StreamContainer.MP4, VideoResolution.P_360, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_128),
    HLS_VIDEO_MP4_480P_AUDIO_AAC(94, StreamContainer.MP4, VideoResolution.P_480, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_128),
    HLS_VIDEO_MP4_720P_AUDIO_AAC(95, StreamContainer.MP4, VideoResolution.P_720, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_256),
    HLS_VIDEO_MP4_720P_AUDIO_AAC_300(300, StreamContainer.MP4, VideoResolution.P_720, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_256),
    HLS_VIDEO_MP4_1080P_AUDIO_AAC(96, StreamContainer.MP4, VideoResolution.P_1080, VideoCodec.H264, VideoFrameRate.FPS_30, AudioCodec.AAC, AudioBitrate.KBIT_256);

    private static HashMap<Integer, List<YoutubeITAG>> TAG_MAP;
    private final int itag;
    private MediaTagsVarious[] qualityTags;
    private VideoResolution videoResolution;
    private VideoCodec videoCodec;
    private AudioCodec audioCodec;
    private AudioBitrate audioBitrate;
    private ImageQuality imageQuality;
    private StreamContainer rawContainer;
    private VideoFrameRate videoFrameRate = null;

    public static YoutubeITAG get(int itag, int width, int height, int fps, String type, UrlQuery query, long uploadDate) {
        YoutubeITAGVersion version = null;
        if (query == null) {
            query = new UrlQuery();
        }
        switch (itag) {
            case 132: {
                if ("hls_playlist".equals(query.get("manifest")) || type != null && (type.contains("avc") || type.contains("mp4"))) {
                    return HLS_VIDEO_MP4_240P_15FPS_AUDIO_AAC;
                }
                return THREEGP_VIDEO_240P_H263_AUDIO_AAC;
            }
            case 22: {
                if (version == null) {
                    version = YoutubeITAGVersion.getByDate(uploadDate);
                }
                switch (version) {
                    case V1: 
                    case V2: {
                        return MP4_VIDEO_720P_H264_AUDIO_AAC_V1;
                    }
                    case V3: {
                        return MP4_VIDEO_720P_H264_AUDIO_AAC_V3;
                    }
                }
                return MP4_VIDEO_720P_H264_AUDIO_AAC;
            }
            case 84: {
                if (version == null) {
                    version = YoutubeITAGVersion.getByDate(uploadDate);
                }
                switch (version) {
                    case V1: 
                    case V2: {
                        return MP4_VIDEO_720P_H264_AUDIO_AAC_3D_V1;
                    }
                    case V3: {
                        return MP4_VIDEO_720P_H264_AUDIO_AAC_3D_V3;
                    }
                }
                return MP4_VIDEO_720P_H264_AUDIO_AAC_3D;
            }
        }
        List<YoutubeITAG> options = TAG_MAP.get(itag);
        if (options == null) {
            return null;
        }
        YoutubeITAG best = null;
        double bestValue = Double.MAX_VALUE;
        for (YoutubeITAG tag : options) {
            double value = 0.0;
            if (tag.getVideoResolution() != null) {
                value += (double)Math.abs(height - tag.getVideoResolution().getHeight());
                value += Math.abs((double)fps - tag.getVideoFrameRate().getFps());
            }
            if (best != null && !(bestValue > value)) continue;
            bestValue = value;
            best = tag;
            if (value != 0.0) continue;
            break;
        }
        if (bestValue == 0.0 || height <= 0 || fps > 3) {
            // empty if block
        }
        return best;
    }

    public VideoResolution getVideoResolution() {
        return this.videoResolution;
    }

    public VideoCodec getVideoCodec() {
        return this.videoCodec;
    }

    public AudioCodec getAudioCodec() {
        return this.audioCodec;
    }

    public AudioBitrate getAudioBitrate() {
        return this.audioBitrate;
    }

    public ImageQuality getImageQuality() {
        return this.imageQuality;
    }

    public VideoFrameRate getVideoFrameRate() {
        return this.videoFrameRate;
    }

    private YoutubeITAG(int itag, StreamContainer streamcontainer, MediaTagsVarious various) {
        this(itag);
        this.qualityTags = new MediaTagsVarious[]{various};
        this.rawContainer = streamcontainer;
    }

    private YoutubeITAG(int itag, StreamContainer streamcontainer, ImageQuality image) {
        this(itag);
        this.imageQuality = image;
        this.rawContainer = streamcontainer;
    }

    private YoutubeITAG(int itag, StreamContainer streamcontainer, AudioCodec tags, AudioBitrate bitrate) {
        this(itag);
        this.audioCodec = tags;
        this.audioBitrate = bitrate;
        this.rawContainer = streamcontainer;
    }

    private YoutubeITAG(int itag, StreamContainer streamcontainer, VideoResolution resolution, VideoCodec codec, VideoFrameRate fps, AudioCodec audioCodec, AudioBitrate bitrate, MediaTagsVarious various) {
        this(itag);
        this.videoResolution = resolution;
        this.videoCodec = codec;
        this.audioCodec = audioCodec;
        this.audioBitrate = bitrate;
        this.videoFrameRate = fps;
        this.qualityTags = new MediaTagsVarious[]{various};
        this.rawContainer = streamcontainer;
    }

    private YoutubeITAG(int itag, StreamContainer streamcontainer, VideoResolution resolution, VideoCodec codec, VideoFrameRate fps, AudioCodec audioCodec, AudioBitrate bitrate) {
        this(itag);
        this.videoResolution = resolution;
        this.videoCodec = codec;
        this.audioCodec = audioCodec;
        this.audioBitrate = bitrate;
        this.videoFrameRate = fps;
        this.rawContainer = streamcontainer;
    }

    private YoutubeITAG(int itag, StreamContainer streamcontainer, VideoResolution resolution, VideoCodec codec, VideoFrameRate fps, MediaTagsVarious various) {
        this(itag);
        this.videoResolution = resolution;
        this.rawContainer = streamcontainer;
        this.videoCodec = codec;
        this.videoFrameRate = fps;
        this.qualityTags = new MediaTagsVarious[]{various};
    }

    private YoutubeITAG(int itag, StreamContainer streamcontainer, VideoResolution resolution, VideoCodec codec, VideoFrameRate fps) {
        this(itag);
        this.videoResolution = resolution;
        this.rawContainer = streamcontainer;
        this.videoCodec = codec;
        this.videoFrameRate = fps;
        this.qualityTags = new MediaTagsVarious[0];
    }

    public boolean containsTag(MediaTagsVarious tag) {
        for (MediaTagsVarious s : this.qualityTags) {
            if (s != tag) continue;
            return true;
        }
        return false;
    }

    public MediaTagsVarious[] getQualityTags() {
        return this.qualityTags;
    }

    private YoutubeITAG(int itag) {
        this.itag = itag;
    }

    public int getITAG() {
        return this.itag;
    }

    public static List<YoutubeITAG> getTagList(int itag) {
        return Collections.unmodifiableList(TAG_MAP.get(itag));
    }

    public StreamContainer getRawContainer() {
        return this.rawContainer;
    }

    static {
        TAG_MAP = new HashMap();
        for (YoutubeITAG tag : YoutubeITAG.values()) {
            List<YoutubeITAG> lst = TAG_MAP.get(tag.getITAG());
            if (lst == null) {
                lst = new ArrayList<YoutubeITAG>();
                TAG_MAP.put(tag.getITAG(), lst);
            }
            lst.add(tag);
        }
    }

    public static enum YoutubeITAGVersion {
        V1(0L, new Date(111, 2, 1, 23, 59, 59).getTime()),
        V2(new Date(111, 2, 1, 0, 0, 0).getTime(), new Date(111, 4, 1, 23, 59, 59).getTime()),
        V3(new Date(111, 4, 1, 0, 0, 0).getTime(), new Date(112, 6, 1, 23, 59, 59).getTime()),
        V4(new Date(112, 6, 1, 0, 0, 0).getTime(), Long.MAX_VALUE);

        private long from;
        private long to;

        private YoutubeITAGVersion(long from, long to) {
            this.from = from;
            this.to = to;
        }

        public boolean matches(long uploadDate) {
            return uploadDate >= this.from && uploadDate < this.to;
        }

        public static YoutubeITAGVersion getByDate(long uploadDate) {
            for (YoutubeITAGVersion v : YoutubeITAGVersion.values()) {
                if (!v.matches(uploadDate)) continue;
                return v;
            }
            return V4;
        }
    }
}

