/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.variants;

import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import jd.plugins.DownloadLink;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.utils.DebugMode;
import org.appwork.utils.StringUtils;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.components.youtube.YoutubeClipData;
import org.jdownloader.plugins.components.youtube.YoutubeConfig;
import org.jdownloader.plugins.components.youtube.YoutubeStreamData;
import org.jdownloader.plugins.components.youtube.itag.AudioBitrate;
import org.jdownloader.plugins.components.youtube.itag.AudioCodec;
import org.jdownloader.plugins.components.youtube.itag.AudioType;
import org.jdownloader.plugins.components.youtube.itag.YoutubeITAG;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.AudioInterface;
import org.jdownloader.plugins.components.youtube.variants.VariantBase;
import org.jdownloader.plugins.components.youtube.variants.generics.AbstractGenericVariantInfo;
import org.jdownloader.plugins.components.youtube.variants.generics.GenericAudioInfo;
import org.jdownloader.plugins.config.PluginJsonConfig;
import org.jdownloader.translate._JDT;

public class AudioVariant
extends AbstractVariant<GenericAudioInfo>
implements AudioInterface {
    private static final Icon AUDIO = new AbstractIcon("audio", 16);
    protected String uniqueIDString = null;
    private static final String TYPE_ID_PATTERN = PluginJsonConfig.get(YoutubeConfig.class).getVariantNamePatternAudio();

    public AudioVariant(VariantBase base) {
        super(base);
    }

    @Override
    public void setJson(String jsonString) {
        this.setGenericInfo((AbstractGenericVariantInfo)JSonStorage.restoreFromString((String)jsonString, (TypeRef)new TypeRef<GenericAudioInfo>(){}));
    }

    @Override
    protected void fill(YoutubeClipData vid, List<YoutubeStreamData> audio, List<YoutubeStreamData> video, List<YoutubeStreamData> data) {
        if (audio != null && vid != null) {
            for (YoutubeStreamData a : audio) {
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                    if (audio.size() > 1) {
                        DebugMode.debugger();
                    } else if (((GenericAudioInfo)this.getGenericInfo()).getaId() != null && !StringUtils.equals((String)((GenericAudioInfo)this.getGenericInfo()).getaId(), (String)a.getLngId())) {
                        DebugMode.debugger();
                    } else if (((GenericAudioInfo)this.getGenericInfo()).isDrc() != a.isDrc()) {
                        DebugMode.debugger();
                    }
                }
                ((GenericAudioInfo)this.getGenericInfo()).setaId(a.getLngId());
                ((GenericAudioInfo)this.getGenericInfo()).setDrc(a.isDrc());
                if (a.getBitrate() <= 0 || vid.duration <= 0 || a.getContentLength() <= 0L) continue;
                long abr = 8L * a.getContentLength() / (1024L * (long)vid.duration / 1000L);
                ((GenericAudioInfo)this.getGenericInfo()).setaBitrate((int)abr);
                break;
            }
        }
    }

    @Override
    public Icon _getIcon(Object caller) {
        return AUDIO;
    }

    @Override
    public synchronized String _getUniqueId() {
        if (this.uniqueIDString == null) {
            this.uniqueIDString = super._getUniqueId();
            String aId = ((GenericAudioInfo)this.getGenericInfo()).getaId();
            if (aId != null) {
                this.uniqueIDString = this.uniqueIDString + ".aid" + aId;
            }
            if (((GenericAudioInfo)this.getGenericInfo()).isDrc()) {
                this.uniqueIDString = this.uniqueIDString + ".drc";
            }
        }
        return this.uniqueIDString;
    }

    @Override
    public String getFileNameQualityTag() {
        return this.getAudioBitrate().getKbit() + "kbits " + this.getAudioCodec().getLabel();
    }

    @Override
    public String _getName(Object caller) {
        String id = TYPE_ID_PATTERN;
        id = id.replace("*CONTAINER*", this.getContainer().getLabel().toUpperCase(Locale.ENGLISH) + "");
        id = id.replace("*AUDIO_CODEC*", this.getAudioCodec().getLabel() + "");
        id = id.replace("*AUDIO_BITRATE*", this.getAudioBitrate().getKbit() + "");
        id = id.replace("*LNG*", StringUtils.valueOrEmpty((String)AudioVariant.getAudioIdForPattern(this)));
        id = id.replace("*DEMUX*", this.getBaseVariant().getiTagAudio() == null ? "[DEMUX]" : "");
        switch (this.getiTagAudioOrVideoItagEquivalent().getAudioCodec()) {
            case AAC_SPATIAL: 
            case VORBIS_SPATIAL: 
            case OPUS_SPATIAL: {
                id = id.replace("*SPATIAL*", _JDT.T.YOUTUBE_surround());
                break;
            }
            default: {
                id = id.replace("*SPATIAL*", "");
            }
        }
        id = id.replace(" - ", "-").trim().replaceAll("[ ]+", " ");
        return id;
    }

    @Override
    public AudioCodec getAudioCodec() {
        return this.getiTagAudioOrVideoItagEquivalent().getAudioCodec();
    }

    @Override
    public AudioBitrate getAudioBitrate() {
        int bitRate = ((GenericAudioInfo)this.getGenericInfo()).getaBitrate();
        if (bitRate > 0) {
            return AudioBitrate.getByInt(bitRate);
        }
        return this.getiTagAudioOrVideoItagEquivalent().getAudioBitrate();
    }

    @Override
    public String getFileNamePattern(DownloadLink downloadLink) {
        return PluginJsonConfig.get(YoutubeConfig.class).getAudioFilenamePattern2();
    }

    public static String getAudioIdForPattern(AudioInterface variant) {
        Locale locale = variant.getAudioLocale();
        if (locale != null) {
            String displayName = locale.getDisplayName();
            AudioType audioType = variant.getAudioType();
            if (audioType == null) {
                return displayName;
            }
            return displayName + " (" + audioType.getLabel() + ")";
        }
        return null;
    }

    @Override
    public String getTypeId() {
        String id = TYPE_ID_PATTERN;
        id = id.replace("*CONTAINER*", this.getContainer().name() + "");
        id = id.replace("*AUDIO_CODEC*", (Object)((Object)this.getAudioCodec()) + "");
        id = id.replace("*AUDIO_BITRATE*", this.getAudioBitrate().getKbit() + "");
        id = id.replace("*LNG*", StringUtils.valueOrEmpty((String)this.getAudioId()));
        id = id.replace("*DEMUX*", this.getBaseVariant().getiTagAudio() == null ? "DEMUX" : "");
        switch (this.getiTagAudioOrVideoItagEquivalent().getAudioCodec()) {
            case AAC_SPATIAL: 
            case VORBIS_SPATIAL: 
            case OPUS_SPATIAL: {
                id = id.replace("*SURROUND*", "Spatial");
                break;
            }
            default: {
                id = id.replace("*SURROUND*", "");
            }
        }
        id = id.trim().replaceAll("\\s+", "_").toUpperCase(Locale.ENGLISH);
        return id;
    }

    @Override
    public YoutubeITAG getAudioITAG() {
        return this.getiTagAudioOrVideoItagEquivalent();
    }

    @Override
    public String getAudioId() {
        return ((GenericAudioInfo)this.getGenericInfo()).getaId();
    }

    @Override
    public Locale getAudioLocale() {
        return ((GenericAudioInfo)this.getGenericInfo())._getLocale();
    }

    @Override
    public AudioType getAudioType() {
        return AudioType.getAudioType(this);
    }

    @Override
    public boolean isDrc() {
        return ((GenericAudioInfo)this.getGenericInfo()).isDrc();
    }
}

