/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.variants;

import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.TooltipInterface;
import org.jdownloader.plugins.components.youtube.YT_STATICS;
import org.jdownloader.plugins.components.youtube.itag.YoutubeITAG;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;

public enum FileContainer implements LabelInterface,
TooltipInterface
{
    MP4("mp4", "MP4 Video"),
    MKV("mkv", "Matro\u0161ka MKV Video"),
    WEBM("webm", "Google WebM Video"),
    FLV("flv", "Flash FLV Video"),
    THREEGP("3gp", "3GP Video"),
    M4A("m4a", "M4A Audio"),
    AAC("aac", "AAC Audio"),
    OPUS("opus", "Opus Audio"),
    OGG("ogg", "Vorbis Audio"),
    MP3("mp3", "MP3 Audio"),
    JPG("jpg", "JPEG Image"),
    SRT("srt", "Subtitle"),
    TXT("txt", "Text");

    private final String extension;
    private final String longLabel;

    private FileContainer(String fileExtension, String longLabel) {
        this.extension = fileExtension;
        this.longLabel = longLabel;
    }

    public String getLabel() {
        return this.extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getTooltip() {
        return this.longLabel;
    }

    public static FileContainer getVideoContainer(YoutubeITAG dashVideo, YoutubeITAG dashAudio) {
        return FileContainer.getAllVideoContainer(dashVideo, dashAudio)[0];
    }

    public static FileContainer[] getAllVideoContainer(YoutubeITAG dashVideo, YoutubeITAG dashAudio) {
        switch (dashVideo.getVideoCodec()) {
            case AV1: {
                return new FileContainer[]{MP4, MKV};
            }
        }
        switch (dashVideo.getRawContainer()) {
            case DASH_VIDEO: {
                switch (dashVideo.getVideoCodec()) {
                    case H264: {
                        return new FileContainer[]{MP4, MKV};
                    }
                    case AV1: {
                        return new FileContainer[]{MP4, MKV};
                    }
                    case H263: {
                        throw new WTFException("Unsupported:" + (Object)((Object)dashVideo.getVideoCodec()));
                    }
                }
                boolean isOpus = dashAudio.getAudioCodec().name().startsWith("OPUS");
                boolean isVorbis = dashAudio.getAudioCodec().name().startsWith("VORBIS");
                boolean isVPx = dashVideo.getVideoCodec().name().startsWith("VP");
                if (isVPx && (isOpus || isVorbis)) {
                    return new FileContainer[]{WEBM, MKV};
                }
                return new FileContainer[]{MKV};
            }
            case FLV: {
                return new FileContainer[]{FLV};
            }
            case MP4: {
                return new FileContainer[]{MP4};
            }
            case THREEGP: {
                return new FileContainer[]{THREEGP};
            }
            case WEBM: {
                return new FileContainer[]{WEBM};
            }
        }
        throw new WTFException("Unsupported:" + (Object)((Object)dashVideo.getVideoCodec()));
    }

    public static FileContainer getAudioContainer(YoutubeITAG dashVideo, YoutubeITAG audioCodec) {
        switch (audioCodec.getAudioCodec()) {
            case AAC: 
            case AAC_SPATIAL: {
                return AAC;
            }
            case OPUS: 
            case OPUS_SPATIAL: {
                return OPUS;
            }
            case VORBIS: 
            case VORBIS_SPATIAL: {
                return OGG;
            }
            case MP3: {
                return MP3;
            }
        }
        return MKV;
    }

    public static int getSortId(AbstractVariant v) {
        FileContainer res = v.getContainer();
        if (res == null) {
            return -1;
        }
        Integer intObj = YT_STATICS.SORTIDS_FILE_CONTAINER.get((Object)res);
        if (intObj == null) {
            return -1;
        }
        return ((Number)intObj).intValue();
    }
}

