/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jd.plugins.Account;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storage;
import org.appwork.storage.StorageException;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.annotations.CryptedStorage;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.ListHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.DebugMode;
import org.appwork.utils.IO;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.config.AccountConfigInterface;

public class AccountJsonConfig {
    private static final WeakHashMap<ClassLoader, HashMap<String, WeakReference<ConfigInterface>>> CONFIG_CACHE = new WeakHashMap();
    private static final String PREFIX_PRIMITIVE = "configInterface.primitive.";
    private static final String PREFIX_OBJECT = "configInterface.object.";

    public static synchronized <T extends AccountConfigInterface> T get(final PluginForHost plugin, final Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("plugin is null");
        }
        Class<? extends AccountConfigInterface> configInterface = plugin.getAccountConfigInterface(account);
        if (configInterface == null) {
            throw new WTFException("no ConfigInterface in:" + plugin.getLazyP());
        }
        String CACHEID = plugin.getHost() + "/" + account.getId().getID();
        ClassLoader classloader = configInterface.getClassLoader();
        HashMap<String, WeakReference<Object>> classLoaderMap = CONFIG_CACHE.get(classloader);
        if (classLoaderMap == null) {
            classLoaderMap = new HashMap();
            CONFIG_CACHE.put(classloader, classLoaderMap);
        }
        WeakReference<ConfigInterface> ret = classLoaderMap.get(CACHEID);
        ConfigInterface intf = null;
        if (ret != null && (intf = (ConfigInterface)ret.get()) != null) {
            plugin.getLogger().info("Reuse cached ConfigInterface " + CACHEID + "|" + plugin.getLazyP() + "|" + classloader);
            return (T)((AccountConfigInterface)intf);
        }
        plugin.getLogger().info("Create new ConfigInterface " + CACHEID + "|" + plugin.getLazyP() + "|" + classloader);
        final Storage storage = new Storage(){

            public void clear() throws StorageException {
                for (String key : account.getProperties().keySet()) {
                    if (!key.startsWith(AccountJsonConfig.PREFIX_PRIMITIVE)) continue;
                    account.removeProperty(key);
                }
            }

            public void close() {
            }

            private final LogInterface getLogger() {
                LogInterface ret = plugin.getLogger();
                if (ret != null) {
                    return ret;
                }
                return LogController.CL();
            }

            public <E> E get(String key, E def, Boolean autoPutValue) throws StorageException {
                Object ret;
                boolean contains = this.hasProperty(key);
                boolean autoPutDefaultValue = autoPutValue == null ? this.isAutoPutValues() : Boolean.TRUE.equals(autoPutValue);
                Object object = ret = contains ? account.getProperty(AccountJsonConfig.PREFIX_PRIMITIVE + key) : null;
                if (ret != null && def != null && ret.getClass() != def.getClass()) {
                    if (def instanceof Byte) {
                        if (ret instanceof Number) {
                            ret = ((Number)ret).byteValue();
                        } else if (ret instanceof String) {
                            ret = Byte.parseByte((String)ret);
                        }
                    } else if (def instanceof Short) {
                        if (ret instanceof Number) {
                            ret = ((Number)ret).shortValue();
                        } else if (ret instanceof String) {
                            ret = Short.parseShort((String)ret);
                        }
                    } else if (def instanceof Long) {
                        if (ret instanceof Number) {
                            ret = ((Number)ret).longValue();
                        } else if (ret instanceof String) {
                            ret = Long.parseLong((String)ret);
                        }
                    } else if (def instanceof Integer) {
                        if (ret instanceof Number) {
                            ret = ((Number)ret).intValue();
                        } else if (ret instanceof String) {
                            ret = Integer.parseInt((String)ret);
                        }
                    } else if (def instanceof Double) {
                        if (ret instanceof Float) {
                            ret = (double)((Double)ret);
                        } else if (ret instanceof String) {
                            ret = Double.parseDouble((String)ret);
                        }
                    } else if (def instanceof Float) {
                        if (ret instanceof Double) {
                            ret = Float.valueOf(((Float)ret).floatValue());
                        } else if (ret instanceof String) {
                            ret = Float.valueOf(Float.parseFloat((String)ret));
                        }
                    }
                }
                if (!contains) {
                    ret = def;
                    if (autoPutDefaultValue) {
                        if (def instanceof Byte) {
                            this.put(key, (Byte)def);
                        } else if (def instanceof Short) {
                            this.put(key, (Short)def);
                        } else if (def instanceof Long) {
                            this.put(key, (Long)def);
                        } else if (def instanceof Integer) {
                            this.put(key, (Integer)def);
                        } else if (def instanceof Double) {
                            this.put(key, (Double)def);
                        } else if (def instanceof Float) {
                            this.put(key, (Float)def);
                        } else if (def instanceof Boolean) {
                            this.put(key, (Boolean)def);
                        } else if (def instanceof String || def == null) {
                            this.put(key, (String)def);
                        } else if (def instanceof Enum) {
                            this.put(key, (Enum)def);
                        } else {
                            throw new StorageException("Invalid datatype: " + (def != null ? def.getClass() : "null"));
                        }
                    }
                }
                if (def instanceof Enum && ret instanceof String) {
                    try {
                        ret = Enum.valueOf(((Enum)def).getDeclaringClass(), (String)ret);
                    }
                    catch (Throwable e) {
                        this.getLogger().log(e);
                        if (e instanceof IllegalArgumentException) {
                            this.getLogger().info("Could not restore the enum. There is no value for " + ret + " in " + ((Enum)def).getDeclaringClass());
                        }
                        ret = def;
                    }
                }
                return (E)ret;
            }

            public <E> E get(String key, E def) throws StorageException {
                return this.get(key, def, null);
            }

            public byte[] getCryptKey() {
                return null;
            }

            public String getID() {
                return null;
            }

            public boolean hasProperty(String key) {
                if (key != null) {
                    return account.hasProperty(AccountJsonConfig.PREFIX_PRIMITIVE + key);
                }
                return false;
            }

            public boolean isAutoPutValues() {
                return false;
            }

            public void put(String key, Boolean value) throws StorageException {
                this.putInternal(key, value);
            }

            public void put(String key, Short value) throws StorageException {
                this.putInternal(key, value);
            }

            public void put(String key, Byte value) throws StorageException {
                this.putInternal(key, value);
            }

            public void put(String key, Double value) throws StorageException {
                this.putInternal(key, value);
            }

            public void put(String key, Enum<?> value) throws StorageException {
                this.putInternal(key, value);
            }

            public void put(String key, Float value) throws StorageException {
                this.putInternal(key, value);
            }

            public void put(String key, Integer value) throws StorageException {
                this.putInternal(key, value);
            }

            public void put(String key, Long value) throws StorageException {
                this.putInternal(key, value);
            }

            public void put(String key, String value) throws StorageException {
                this.putInternal(key, value);
            }

            private void putInternal(String key, Object value) {
                if (key != null) {
                    account.setProperty(AccountJsonConfig.PREFIX_PRIMITIVE + key, value);
                }
            }

            public Object remove(String key) {
                if (key != null) {
                    return account.removeProperty(AccountJsonConfig.PREFIX_PRIMITIVE + key);
                }
                return null;
            }

            public void save() throws StorageException {
            }

            public void setAutoPutValues(boolean b) {
            }

            public int size() {
                int size = 0;
                for (String key : account.getProperties().keySet()) {
                    if (!key.startsWith(AccountJsonConfig.PREFIX_PRIMITIVE)) continue;
                    ++size;
                }
                return size;
            }

            public IO.SYNC getStorageSyncMode() {
                return IO.SYNC.META_AND_DATA;
            }

            public void setStorageSyncMode(IO.SYNC storageSyncMode) {
            }
        };
        StorageHandler storageHandler = new StorageHandler<T>(configInterface){

            private final LogInterface getLogger() {
                LogInterface ret = plugin.getLogger();
                if (ret != null) {
                    return ret;
                }
                return LogController.CL();
            }

            protected void error(final Throwable e) {
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                    new Thread("ERROR THROWER"){

                        @Override
                        public void run() {
                            Dialog.getInstance().showExceptionDialog(e.getClass().getSimpleName(), e.getMessage(), e);
                        }
                    }.start();
                }
            }

            protected void requestSave() {
            }

            public Storage getPrimitiveStorage() {
                return storage;
            }

            protected boolean isDelayedWriteAllowed(KeyHandler<?> keyHandler) {
                return false;
            }

            protected void addStorageHandler(StorageHandler<? extends ConfigInterface> storageHandler, String interfaceName, String storage2) {
            }

            public void write() {
            }

            protected void writeObject(ListHandler<?> keyHandler, Object object) {
                String key = AccountJsonConfig.PREFIX_OBJECT + keyHandler.getKey();
                String jsonString = JSonStorage.serializeToJson((Object)object);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    GZIPOutputStream gzip = new GZIPOutputStream(bos);
                    gzip.write(jsonString.getBytes("UTF-8"));
                    gzip.close();
                    String compressedJSonString = Base64.encodeToString((byte[])bos.toByteArray(), (boolean)false);
                    account.setProperty(key, compressedJSonString);
                }
                catch (Exception e) {
                    this.getLogger().log((Throwable)e);
                }
            }

            protected Object readObject(ListHandler<?> keyHandler, AtomicBoolean readFlag) {
                Object readObject = null;
                try {
                    String key = AccountJsonConfig.PREFIX_OBJECT + keyHandler.getKey();
                    String compressedJSonString = account.getStringProperty(key);
                    if (compressedJSonString != null) {
                        byte[] bytes = Base64.decode((String)compressedJSonString);
                        String jsonString = IO.readInputStreamToString((InputStream)new GZIPInputStream(new ByteArrayInputStream(bytes)));
                        readFlag.set(true);
                        readObject = JSonStorage.restoreFromString((String)jsonString, (TypeRef)keyHandler.getTypeRef(), null);
                    }
                }
                catch (Exception e) {
                    this.getLogger().log((Throwable)e);
                }
                return readObject;
            }

            protected void validateKeys(CryptedStorage crypted) {
            }
        };
        intf = (AccountConfigInterface)Proxy.newProxyInstance(classloader, new Class[]{configInterface}, (InvocationHandler)storageHandler);
        classLoaderMap.put(CACHEID, new WeakReference<ConfigInterface>(intf));
        return (T)((AccountConfigInterface)intf);
    }
}

