/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.PluginWrapper;
import jd.config.Property;
import jd.plugins.Plugin;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.MinTimeWeakReference;
import org.appwork.storage.config.MinTimeWeakReferenceCleanup;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.TooltipInterface;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.jdownloader.DomainInfo;
import org.jdownloader.plugins.controller.LazyPluginClass;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.translate._JDT;

public abstract class LazyPlugin<T extends Plugin>
implements MinTimeWeakReferenceCleanup {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final byte[] patternBytes;
    private volatile MinTimeWeakReference<Pattern> compiledPattern = null;
    private final String displayName;
    protected volatile WeakReference<Class<T>> pluginClass;
    protected volatile WeakReference<T> prototypeInstance;
    private volatile WeakReference<PluginClassLoader.PluginClassLoaderChild> classLoader;
    private volatile MinTimeWeakReference<Matcher> matcher = null;
    private FEATURE[] features = null;
    private final LazyPluginClass lazyPluginClass;

    public boolean hasFeature(FEATURE ... features) {
        FEATURE[] thisPluginFeatures = this.getFeatures();
        if (features != null && features.length > 0 && thisPluginFeatures != null && thisPluginFeatures.length > 0) {
            for (FEATURE feature : features) {
                if (!feature.isSet(thisPluginFeatures)) continue;
                return true;
            }
        }
        return false;
    }

    public FEATURE[] getFeatures() {
        return this.features;
    }

    public abstract DomainInfo getDomainInfo();

    protected void setFeatures(FEATURE[] features) {
        this.features = features == null || features.length == 0 ? null : features;
    }

    public PluginWrapper getPluginWrapper() {
        return new PluginWrapper(this){};
    }

    public final LazyPluginClass getLazyPluginClass() {
        return this.lazyPluginClass;
    }

    public LazyPlugin(LazyPluginClass lazyPluginClass, String patternString, String displayName, Class<T> class1, PluginClassLoader.PluginClassLoaderChild classLoader) {
        this.patternBytes = patternString.getBytes(UTF8);
        this.lazyPluginClass = lazyPluginClass;
        if (class1 != null) {
            this.pluginClass = new WeakReference<Class<Class<T>>>(class1);
        }
        this.displayName = Property.dedupeString(displayName.toLowerCase(Locale.ENGLISH));
        if (classLoader != null) {
            this.classLoader = new WeakReference<PluginClassLoader.PluginClassLoaderChild>(classLoader);
        }
    }

    public String getID() {
        return this.getClassName() + "/" + this.getDisplayName();
    }

    public boolean equals(Object lazyPlugin) {
        if (lazyPlugin == this) {
            return true;
        }
        if (lazyPlugin != null && lazyPlugin instanceof LazyPlugin && this.getClass().isAssignableFrom(lazyPlugin.getClass())) {
            LazyPlugin other = (LazyPlugin)lazyPlugin;
            if (!StringUtils.equals((String)this.getDisplayName(), (String)other.getDisplayName())) {
                return false;
            }
            return StringUtils.equals((String)this.getClassName(), (String)other.getClassName());
        }
        return false;
    }

    public int hashCode() {
        return this.displayName.hashCode();
    }

    public final long getVersion() {
        return this.getLazyPluginClass().getRevision();
    }

    public abstract String getClassName();

    public final String getDisplayName() {
        return this.displayName;
    }

    public synchronized void setPluginClass(Class<T> pluginClass) {
        this.pluginClass = pluginClass == null ? null : new WeakReference<Class<Class<T>>>(pluginClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canHandle(String url) {
        Matcher matcher;
        if (this.patternBytes.length <= 0) return false;
        Matcher matcher2 = matcher = this.getMatcher();
        synchronized (matcher2) {
            try {
                if (!matcher.reset(url).find()) return false;
                int matchLength = matcher.end() - matcher.start();
                boolean bl = matchLength > 0;
                return bl;
            }
            finally {
                matcher.reset("");
            }
        }
    }

    public abstract T getPrototype(PluginClassLoader.PluginClassLoaderChild var1, boolean var2) throws UpdateRequiredClassNotFoundException;

    public synchronized T getPrototype(PluginClassLoader.PluginClassLoaderChild classLoader) throws UpdateRequiredClassNotFoundException {
        if (classLoader != null && classLoader != this.getClassLoader(false)) {
            return this.newInstance(classLoader);
        }
        Plugin ret = null;
        if (this.prototypeInstance != null && (ret = (Plugin)this.prototypeInstance.get()) != null) {
            return (T)ret;
        }
        this.prototypeInstance = null;
        ret = this.newInstance(null);
        if (ret != null) {
            this.prototypeInstance = new WeakReference<Plugin>(ret);
        }
        return (T)ret;
    }

    public boolean isPrototype(T pluginInstance) {
        WeakReference<T> prototypeInstance = this.prototypeInstance;
        return prototypeInstance != null && prototypeInstance.get() == pluginInstance;
    }

    public abstract T newInstance(PluginClassLoader.PluginClassLoaderChild var1, boolean var2) throws UpdateRequiredClassNotFoundException;

    public T newInstance(PluginClassLoader.PluginClassLoaderChild classLoader) throws UpdateRequiredClassNotFoundException {
        Plugin ret = null;
        try {
            Class<T> clazz = this.getPluginClass(classLoader);
            Constructor<T> cons = this.getConstructor(clazz);
            ret = cons.getParameterTypes().length != 0 ? (Plugin)cons.newInstance(this.getPluginWrapper()) : (Plugin)cons.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            this.handleUpdateRequiredClassNotFoundException(e, true);
        }
        return (T)ret;
    }

    private Constructor<T> getConstructor(Class<T> clazz) throws UpdateRequiredClassNotFoundException {
        try {
            return clazz.getConstructor(PluginWrapper.class);
        }
        catch (Throwable e) {
            this.handleUpdateRequiredClassNotFoundException(e, false);
            try {
                return clazz.getConstructor(new Class[0]);
            }
            catch (Throwable e2) {
                this.handleUpdateRequiredClassNotFoundException(e, true);
                return null;
            }
        }
    }

    public void handleUpdateRequiredClassNotFoundException(Throwable e, boolean ThrowWTF) throws UpdateRequiredClassNotFoundException {
        if (e != null) {
            if (e instanceof NoClassDefFoundError) {
                PluginClassLoader.PluginClassLoaderChild pcl;
                NoClassDefFoundError ncdf = (NoClassDefFoundError)e;
                String classNotFound = ncdf.getMessage();
                ClassLoader lcl = Thread.currentThread().getContextClassLoader();
                if (lcl == null || !(lcl instanceof PluginClassLoader.PluginClassLoaderChild)) {
                    lcl = this.getClassLoader(true);
                }
                if (lcl != null && lcl instanceof PluginClassLoader.PluginClassLoaderChild && (pcl = (PluginClassLoader.PluginClassLoaderChild)lcl).isUpdateRequired(classNotFound)) {
                    throw new UpdateRequiredClassNotFoundException(classNotFound);
                }
            }
            if (e instanceof UpdateRequiredClassNotFoundException) {
                throw (UpdateRequiredClassNotFoundException)e;
            }
            if (ThrowWTF) {
                throw new WTFException(e);
            }
        }
    }

    public synchronized Class<T> getPluginClass(PluginClassLoader.PluginClassLoaderChild classLoader) {
        if (classLoader != null && classLoader != this.getClassLoader(false)) {
            try {
                return classLoader.loadClass(this.getClassName());
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new WTFException(e);
            }
        }
        Class<?> ret = null;
        if (this.pluginClass != null && (ret = (Class<?>)this.pluginClass.get()) != null) {
            return ret;
        }
        this.pluginClass = null;
        try {
            ret = this.getClassLoader(true).loadClass(this.getClassName());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new WTFException(e);
        }
        if (ret != null) {
            this.pluginClass = new WeakReference(ret);
        }
        return ret;
    }

    public final String getPatternSource() {
        if (this.patternBytes.length == 0) {
            return "";
        }
        return new String(this.patternBytes, UTF8);
    }

    public final Matcher getMatcher() {
        Matcher ret = null;
        MinTimeWeakReference<Matcher> lMatcher = this.matcher;
        if (lMatcher != null && (ret = (Matcher)lMatcher.get()) != null) {
            return ret;
        }
        ret = this.getPattern().matcher("");
        this.matcher = new MinTimeWeakReference((Object)ret, 60000L, this.displayName, (MinTimeWeakReferenceCleanup)this);
        return ret;
    }

    public final Pattern getCompiledPattern() {
        MinTimeWeakReference<Pattern> lCompiledPattern = this.compiledPattern;
        if (lCompiledPattern != null) {
            return (Pattern)lCompiledPattern.get();
        }
        return null;
    }

    public final Pattern getPattern() {
        Pattern ret = this.getCompiledPattern();
        if (ret == null) {
            ret = Application.getJavaVersion() >= Application.JAVA17 ? Pattern.compile(this.getPatternSource(), 258) : Pattern.compile(this.getPatternSource(), 2);
            this.compiledPattern = new MinTimeWeakReference((Object)ret, 60000L, this.displayName, (MinTimeWeakReferenceCleanup)this);
        }
        return ret;
    }

    public synchronized void onMinTimeWeakReferenceCleanup(MinTimeWeakReference<?> minTimeWeakReference) {
        if (minTimeWeakReference == this.compiledPattern) {
            this.compiledPattern = null;
        } else if (minTimeWeakReference == this.classLoader) {
            this.classLoader = null;
        } else if (minTimeWeakReference == this.matcher) {
            this.matcher = null;
        }
    }

    public synchronized PluginClassLoader.PluginClassLoaderChild getClassLoader(boolean createNew) {
        PluginClassLoader.PluginClassLoaderChild ret = null;
        if (this.classLoader != null && (ret = (PluginClassLoader.PluginClassLoaderChild)this.classLoader.get()) != null) {
            return ret;
        }
        if (!createNew) {
            return null;
        }
        ret = PluginClassLoader.getSharedChild(this);
        this.setClassLoader(ret);
        return ret;
    }

    public synchronized void setClassLoader(PluginClassLoader.PluginClassLoaderChild cl) {
        this.classLoader = cl == null ? null : new WeakReference<PluginClassLoader.PluginClassLoaderChild>(cl);
    }

    public String toString() {
        return this.getDisplayName() + "@" + this.getLazyPluginClass();
    }

    public static enum FEATURE implements LabelInterface,
    TooltipInterface
    {
        IMAGE_GALLERY{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_IMAGE_GALLERY();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_IMAGE_GALLERY_TOOLTIP();
            }

            @Override
            public boolean isInternal() {
                return false;
            }
        }
        ,
        IMAGE_HOST{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_IMAGE_HOST();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_IMAGE_HOST_TOOLTIP();
            }

            @Override
            public boolean isInternal() {
                return false;
            }
        }
        ,
        AUDIO_STREAMING{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_AUDIO_STREAMING();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_AUDIO_STREAMING_TOOLTIP();
            }

            @Override
            public boolean isInternal() {
                return false;
            }
        }
        ,
        VIDEO_STREAMING{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_VIDEO_STREAMING();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_VIDEO_STREAMING_TOOLTIP();
            }

            @Override
            public boolean isInternal() {
                return false;
            }
        }
        ,
        USENET{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_USENET();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_USENET_TOOLTIP();
            }

            @Override
            public boolean isInternal() {
                return false;
            }
        }
        ,
        MULTIHOST{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_MULTIHOST();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_MULTIHOST_TOOLTIP();
            }

            @Override
            public boolean isInternal() {
                return false;
            }
        }
        ,
        CAPTCHA_SOLVER{

            public String getLabel() {
                return _JDT.FIX_ME("Captcha solver plugin");
            }

            public String getTooltip() {
                return _JDT.FIX_ME("Captcha solver plugin");
            }

            @Override
            public boolean isInternal() {
                return false;
            }
        }
        ,
        PASTEBIN{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_PASTEBIN();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_PASTEBIN_TOOLTIP();
            }

            @Override
            public boolean isInternal() {
                return false;
            }
        }
        ,
        XXX{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_XXX();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_XXX_TOOLTIP();
            }

            @Override
            public boolean isInternal() {
                return false;
            }
        }
        ,
        GENERIC{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_GENERIC();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_GENERIC_TOOLTIP();
            }

            @Override
            public boolean isInternal() {
                return true;
            }
        }
        ,
        FAVICON{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_FAVICON();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_FAVICON_TOOLTIP();
            }

            @Override
            public boolean isInternal() {
                return true;
            }
        }
        ,
        INTERNAL{

            public String getLabel() {
                return "INTERNAL";
            }

            public String getTooltip() {
                return "INTERNAL";
            }

            @Override
            public boolean isInternal() {
                return true;
            }
        }
        ,
        ASSIGN_PLUGIN{

            public String getLabel() {
                return "ASSIGN_PLUGIN";
            }

            public String getTooltip() {
                return "ASSIGN_PLUGIN";
            }

            @Override
            public boolean isInternal() {
                return true;
            }
        }
        ,
        COOKIE_LOGIN_ONLY{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_COOKIE_LOGIN_ONLY();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_COOKIE_LOGIN_ONLY_TOOLTIP();
            }

            @Override
            public boolean isInternal() {
                return false;
            }
        }
        ,
        COOKIE_LOGIN_OPTIONAL{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_COOKIE_LOGIN_OPTIONAL();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_COOKIE_LOGIN_OPTIONAL_TOOLTIP();
            }

            @Override
            public boolean isInternal() {
                return false;
            }
        }
        ,
        API_KEY_LOGIN{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_API_KEY_LOGIN();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_API_KEY_LOGIN_TOOLTIP();
            }

            @Override
            public boolean isInternal() {
                return false;
            }
        }
        ,
        USERNAME_IS_EMAIL{

            public String getLabel() {
                return _JDT.T.LazyHostPlugin_FEATURE_USERNAME_IS_EMAIL();
            }

            public String getTooltip() {
                return _JDT.T.LazyHostPlugin_FEATURE_USERNAME_IS_EMAIL();
            }

            @Override
            public boolean isInternal() {
                return false;
            }
        }
        ,
        REQUIRES_HLS_DOWNLOADS_ONLY{

            public String getLabel() {
                return "This plugin performs only HLS downloads";
            }

            public String getTooltip() {
                return "This plugin performs only HLS downloads";
            }

            @Override
            public boolean isInternal() {
                return true;
            }
        }
        ,
        REQUIRES_HLS_DOWNLOADS{

            public String getLabel() {
                return "This plugin performs HLS downloads and other downloads";
            }

            public String getTooltip() {
                return "This plugin performs HLS downloads and other downloads";
            }

            @Override
            public boolean isInternal() {
                return true;
            }
        }
        ,
        BUBBLE_NOTIFICATION{

            public String getLabel() {
                return "This plugin can display bubble notifications";
            }

            public String getTooltip() {
                return "This plugin can display bubble notifications";
            }

            @Override
            public boolean isInternal() {
                return true;
            }
        };

        public static final long CACHEVERSION;

        public boolean isSet(FEATURE[] features) {
            if (features == null) {
                return false;
            }
            for (FEATURE feature : features) {
                if (!this.equals((Object)feature)) continue;
                return true;
            }
            return false;
        }

        public abstract boolean isInternal();

        static {
            CACHEVERSION = Math.abs(StringUtils.join((Object[])FEATURE.values(), (String)"<->").hashCode()) + Math.abs(StringUtils.join((Object[])FEATURE.values(), (String)":").hashCode()) + Math.abs(StringUtils.join((Object[])FEATURE.values(), (String)"<=>").hashCode());
        }
    }
}

