/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import jd.SecondLevelLaunch;
import jd.plugins.Plugin;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.UniqueAlltimeID;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.LazyPluginClass;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.PluginController;
import org.jdownloader.plugins.controller.PluginInfo;

public class PluginScannerFiles<T extends Plugin> {
    private static final boolean isJava16orOlder = Application.getJavaVersion() <= Application.JAVA16;
    private final PluginController<T> pluginController;

    protected PluginController<T> getPluginController() {
        return this.pluginController;
    }

    public PluginScannerFiles(PluginController<T> pluginController) {
        this.pluginController = pluginController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PluginInfo<T>> scan(LogSource logger, String hosterpath, List<? extends LazyPlugin<T>> pluginCache, AtomicLong lastFolderModification) throws Exception, OutOfMemoryError {
        ArrayList<PluginInfo<T>> ret = new ArrayList<PluginInfo<T>>();
        long timeStamp = System.currentTimeMillis();
        HashMap<Object, List<String>> dependenciesCache = new HashMap<Object, List<String>>();
        try {
            File[] stream;
            HashMap<String, ArrayList<LazyPlugin<T>>> lazyPluginClassMap;
            long lastFolderModifiedCheck = lastFolderModification != null ? lastFolderModification.get() : -1L;
            File folder = Application.getRootByClass(SecondLevelLaunch.class, (String)hosterpath);
            long lastFolderModifiedScanStart = folder.lastModified();
            if (pluginCache == null || pluginCache.size() == 0 || lastFolderModifiedCheck <= 0L) {
                logger.info("@PluginController(Files): no plugin cache available|LastModified:" + lastFolderModifiedCheck);
            } else {
                boolean lastModifiedTimestampUnchanged;
                boolean bl = lastModifiedTimestampUnchanged = lastFolderModifiedScanStart == lastFolderModifiedCheck;
                if (lastModifiedTimestampUnchanged) {
                    try {
                        long l;
                        String uniqueID;
                        File file;
                        while ((file = new File(folder, uniqueID = UniqueAlltimeID.create())).exists()) {
                        }
                        IO.secureWrite((File)file, (String)uniqueID, (IO.SYNC)IO.SYNC.META_AND_DATA);
                        if (!file.delete()) {
                            file.deleteOnExit();
                        }
                        if ((l = folder.lastModified()) == lastFolderModifiedScanStart) {
                            logger.info("@PluginController(Files): lastModified timestamp change test: failed");
                            lastModifiedTimestampUnchanged = false;
                        } else {
                            logger.info("@PluginController(Files): lastModified timestamp change test: successful");
                            lastFolderModifiedScanStart = l;
                        }
                    }
                    catch (IOException e) {
                        logger.exception("@PluginController(Files): lastModified timestamp change test: error", (Throwable)e);
                        lastModifiedTimestampUnchanged = false;
                    }
                }
                if (lastModifiedTimestampUnchanged) {
                    for (LazyPlugin<T> lazyPlugin : pluginCache) {
                        PluginInfo<T> pluginInfo = new PluginInfo<T>(lazyPlugin.getLazyPluginClass(), lazyPlugin);
                        ret.add(pluginInfo);
                    }
                    logger.info("@PluginController(Files): plugin cache valid|Size:" + pluginCache.size() + "|LastModified:" + lastFolderModifiedScanStart);
                    if (lastFolderModification != null) {
                        lastFolderModification.set(lastFolderModifiedScanStart);
                    }
                    ArrayList<PluginInfo<T>> e = ret;
                    return e;
                }
                logger.info("@PluginController(Files): plugin cache invalid|Size:" + pluginCache.size() + "|LastModified:" + lastFolderModifiedScanStart);
            }
            String pkg = hosterpath.replace("/", ".");
            if (pluginCache != null && pluginCache.size() > 0) {
                lazyPluginClassMap = new HashMap<String, ArrayList<LazyPlugin<T>>>();
                for (LazyPlugin<T> lazyPlugin : pluginCache) {
                    ArrayList<LazyPlugin<T>> list = (ArrayList<LazyPlugin<T>>)lazyPluginClassMap.get(lazyPlugin.getLazyPluginClass().getClassName());
                    if (list == null) {
                        list = new ArrayList<LazyPlugin<T>>();
                        lazyPluginClassMap.put(lazyPlugin.getLazyPluginClass().getClassName(), list);
                    }
                    list.add(lazyPlugin);
                }
            } else {
                lazyPluginClassMap = null;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = new byte[Short.MAX_VALUE];
            PluginClassLoader.PluginClassLoaderChild cl = null;
            for (File path : stream = folder.listFiles()) {
                try {
                    LazyPluginClass lazyPluginClass;
                    List lazyPlugins;
                    String className;
                    String pathFileName = path.getName();
                    if (!pathFileName.endsWith(".class") || (className = pathFileName.substring(0, pathFileName.length() - 6)).indexOf("$") >= 0 || PluginController.IGNORELIST.contains(className)) continue;
                    if (cl == null || isJava16orOlder) {
                        cl = PluginClassLoader.getInstance().getChild();
                        cl.setMapStaticFields(false);
                    }
                    long lastFileModification = path.lastModified();
                    if (lazyPluginClassMap != null && (lazyPlugins = (List)lazyPluginClassMap.get(className)) != null && lazyPlugins.size() > 0) {
                        lazyPluginClass = ((LazyPlugin)lazyPlugins.get(0)).getLazyPluginClass();
                        try {
                            if (lazyPluginClass != null && PluginController.CHECK_RESULT.isSuccessFul(this.getPluginController().checkForChanges(dependenciesCache, cl, lazyPluginClass, lastFileModification))) {
                                for (LazyPlugin lazyPlugin : lazyPlugins) {
                                    PluginInfo pluginInfo = new PluginInfo(lazyPluginClass, lazyPlugin);
                                    ret.add(pluginInfo);
                                }
                                continue;
                            }
                        }
                        catch (Throwable e) {
                            logger.exception("Failed: " + className, e);
                        }
                    }
                    PluginController.PluginClassInfo<T> pluginClassInfo = null;
                    try {
                        Class<?> pluginClass = cl.loadClass(pkg + "." + className);
                        if (Modifier.isAbstract(pluginClass.getModifiers()) || !Plugin.class.isAssignableFrom(pluginClass) || (pluginClassInfo = this.getPluginController().getPluginClassInfo(dependenciesCache, pluginClass)) == null) continue;
                        pluginClassInfo.sha256 = PluginController.getFileHashBytes(path, messageDigest, byArray);
                    }
                    catch (OutOfMemoryError e) {
                        logger.exception("Failed: " + className, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable e) {
                        logger.exception("Failed: " + className, e);
                        continue;
                    }
                    lazyPluginClass = new LazyPluginClass(className, pluginClassInfo.sha256, lastFileModification, pluginClassInfo.interfaceVersion, pluginClassInfo.revision, pluginClassInfo.dependencies);
                    PluginInfo pluginInfo = new PluginInfo(lazyPluginClass, pluginClassInfo.clazz);
                    ret.add(pluginInfo);
                }
                catch (OutOfMemoryError e) {
                    logger.exception("Failed: " + path, (Throwable)e);
                    throw e;
                }
                catch (Throwable e) {
                    logger.exception("Failed: " + path, e);
                }
            }
            long lastFolderModifiedScanStop = folder.lastModified();
            if (lastFolderModifiedScanStart != lastFolderModifiedScanStop) {
                logger.info("@PluginController(Files): folder modification during scan detected!LastModified:" + lastFolderModifiedScanStart + "!=" + lastFolderModifiedScanStop);
                Thread.sleep(1000L);
                List<PluginInfo<T>> list = this.scan(logger, hosterpath, pluginCache, lastFolderModification);
                return list;
            }
            if (lastFolderModification != null) {
                lastFolderModification.set(lastFolderModifiedScanStop);
            }
            ArrayList<PluginInfo<T>> arrayList = ret;
            return arrayList;
        }
        finally {
            logger.info("@PluginController(Files): scan took " + (System.currentTimeMillis() - timeStamp) + "ms for " + ret.size());
        }
    }
}

