/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.filechooser.FileFilter;
import jd.nutils.io.JDFileFilter;
import jd.plugins.PluginsC;
import org.appwork.utils.Regex;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.container.AMZ;
import org.jdownloader.container.C;
import org.jdownloader.container.D;
import org.jdownloader.container.InternetShortcut;
import org.jdownloader.container.JD2AccountsImport;
import org.jdownloader.container.JD2Import;
import org.jdownloader.container.MetaLink;
import org.jdownloader.container.NZB;
import org.jdownloader.container.R;
import org.jdownloader.container.SFDL;
import org.jdownloader.container.SFT;
import org.jdownloader.logging.LogController;

public class ContainerPluginController {
    private static final ContainerPluginController INSTANCE = new ContainerPluginController();
    private List<PluginsC> list = null;

    public static ContainerPluginController getInstance() {
        return INSTANCE;
    }

    private ContainerPluginController() {
    }

    public void init() {
        ArrayList<Object> plugins = new ArrayList<Object>();
        try {
            plugins.add(new NZB());
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        try {
            plugins.add(new AMZ());
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        try {
            plugins.add(new JD2Import());
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        try {
            plugins.add(new C());
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        try {
            plugins.add(new D());
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        try {
            plugins.add(new MetaLink());
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        try {
            plugins.add(new R());
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        try {
            plugins.add(new SFT());
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        try {
            plugins.add(new InternetShortcut());
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        try {
            plugins.add(new SFDL());
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        try {
            plugins.add(new JD2AccountsImport());
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        this.list = Collections.unmodifiableList(plugins);
    }

    public List<PluginsC> list() {
        this.lazyInit();
        return this.list;
    }

    public void setList(List<PluginsC> list) {
        if (list == null) {
            return;
        }
        this.list = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.list != null) {
            return;
        }
        ContainerPluginController containerPluginController = this;
        synchronized (containerPluginController) {
            if (this.list != null) {
                return;
            }
            this.init();
        }
    }

    public synchronized boolean add(PluginsC plugin) {
        if (plugin != null) {
            ArrayList<PluginsC> plugins = new ArrayList<PluginsC>(this.list());
            if (plugins.contains(plugin)) {
                return false;
            }
            plugins.add(plugin);
            this.list = Collections.unmodifiableList(plugins);
            return true;
        }
        return false;
    }

    public synchronized boolean remove(PluginsC plugin) {
        if (plugin != null) {
            ArrayList<PluginsC> plugins = new ArrayList<PluginsC>(this.list());
            boolean ret = plugins.remove(plugin);
            this.list = Collections.unmodifiableList(plugins);
            return ret;
        }
        return false;
    }

    public PluginsC get(String displayName) {
        for (PluginsC p : this.list()) {
            if (!p.getName().equalsIgnoreCase(displayName)) continue;
            return p;
        }
        return null;
    }

    public FileFilter[] getContainerFileFilter(String filter) {
        ArrayList<JDFileFilter> ret = new ArrayList<JDFileFilter>();
        StringBuilder sb = new StringBuilder();
        sb.append(".*(");
        for (PluginsC act : this.list()) {
            String match;
            if (filter != null && !new Regex(act.getName(), filter).matches() || (match = new Regex(act.getSupportedLinks().pattern(), "file:/\\.\\+(.+?)\\$").getMatch(0)) == null) continue;
            ret.add(new JDFileFilter(act.getName(), Pattern.compile(".*" + match + "$", 2), true));
            sb.append(match);
            sb.append("|");
        }
        sb.setLength(sb.length() - 1);
        sb.append(")");
        try {
            ret.add(0, new JDFileFilter(null, Pattern.compile(sb.toString(), 2), true));
        }
        catch (PatternSyntaxException e) {
            LogController.CL().log((Throwable)e);
        }
        return ret.toArray(new FileFilter[0]);
    }
}

