/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.premium;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jd.gui.swing.dialog.AddAccountDialog;
import jd.gui.swing.dialog.InputOKButtonAdapter;
import jd.plugins.Account;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.WTFException;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.DomainInfo;
import org.jdownloader.gui.InputChangedCallbackInterface;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.accounts.AccountBuilderInterface;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.premium.BuyAndAddPremiumDialogInterface;
import org.jdownloader.premium.OpenURLAction;

public class BuyAndAddPremiumAccount
extends AbstractDialog<Boolean>
implements BuyAndAddPremiumDialogInterface,
InputChangedCallbackInterface {
    private AccountBuilderInterface accountBuilderUI;
    private final PluginClassLoader.PluginClassLoaderChild cl = PluginClassLoader.getInstance().getChild();
    private final OpenURLAction openURLAction;

    public BuyAndAddPremiumAccount(DomainInfo info, String id) {
        super(0, _GUI.T.BuyAndAddPremiumAccount_BuyAndAddPremiumAccount_title_(), null, null, null);
        this.openURLAction = new OpenURLAction(info, id == null ? "BuyAndAddDialog" : id);
    }

    protected Boolean createReturnValue() {
        return null;
    }

    public OpenURLAction getOpenURLAction() {
        return this.openURLAction;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            LoggerFactory.getDefaultLogger().fine("Answer: Button<OK:" + this.okButton.getText() + ">");
            Account ac = this.accountBuilderUI.getAccount();
            ac.setHoster(this.getOpenURLAction().getInfo().getTld());
            try {
                if (!AddAccountDialog.addAccount((Account)ac)) {
                    return;
                }
                this.dispose();
            }
            catch (DialogNoAnswerException e2) {
                this.dispose();
            }
            this.setReturnmask(true);
        } else if (e.getSource() == this.cancelButton) {
            LoggerFactory.getDefaultLogger().fine("Answer: Button<CANCEL:" + this.cancelButton.getText() + ">");
            this.setReturnmask(false);
        }
        this.dispose();
    }

    protected void layoutDialog() {
        DomainInfo info = this.getOpenURLAction().getInfo();
        final Image back = NewTheme.I().hasIcon("fav/footer." + info.getTld()) ? NewTheme.I().getImage("fav/footer." + info.getTld(), -1) : null;
        super.layoutDialog();
        this.getDialog().setContentPane((Container)new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (back != null) {
                    Graphics2D g2 = (Graphics2D)g;
                    double faktor = Math.max((double)back.getWidth(null) / (double)this.getWidth(), (double)back.getHeight(null) / (double)this.getHeight());
                    int width = Math.max((int)((double)back.getWidth(null) / faktor), 1);
                    int height = Math.max((int)((double)back.getHeight(null) / faktor), 1);
                    g2.drawImage(back, 0, this.getHeight() - height, width, this.getHeight(), 0, 0, back.getWidth(null), back.getHeight(null), this.getBackground(), null);
                }
            }
        });
    }

    public JComponent layoutDialogContent() {
        PluginForHost plg;
        Image logo;
        DomainInfo info = this.getOpenURLAction().getInfo();
        MigPanel ret = new MigPanel("ins 0,wrap 1", "[grow,fill]", "[]");
        Image image = logo = NewTheme.I().hasIcon("fav/large." + info.getTld()) ? NewTheme.I().getImage("fav/large." + info.getTld(), -1) : null;
        if (logo != null) {
            JLabel ico = new JLabel(new ImageIcon(logo));
            ret.add((Component)ico);
        }
        ret.add((Component)this.header(_GUI.T.BuyAndAddPremiumAccount_layoutDialogContent_get()), (Object)"gapleft 15,pushx,growx");
        ExtButton bt = new ExtButton((AbstractAction)((Object)this.openURLAction));
        ret.add((Component)bt, (Object)"gapleft 27");
        ret.add((Component)this.header(_GUI.T.BuyAndAddPremiumAccount_layoutDialogContent_enter()), (Object)"gapleft 15,pushx,growx");
        try {
            plg = HostPluginController.getInstance().get(info.getTld()).newInstance(this.cl);
        }
        catch (UpdateRequiredClassNotFoundException e) {
            throw new WTFException((Throwable)e);
        }
        this.accountBuilderUI = plg.getAccountFactory(this);
        ret.add((Component)this.accountBuilderUI.getComponent(), (Object)"gapleft 27");
        if (this.accountBuilderUI.handleClipboardAutoFill()) {
            this.accountBuilderUI.validateInputs();
        }
        this.onChangedInput(null);
        return ret;
    }

    private JComponent header(String buyAndAddPremiumAccount_layoutDialogContent_get) {
        JLabel ret = SwingUtils.toBold((JLabel)new JLabel(buyAndAddPremiumAccount_layoutDialogContent_get));
        ret.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ret.getForeground()));
        return ret;
    }

    @Override
    public void onChangedInput(Object component) {
        InputOKButtonAdapter.register((AbstractDialog)this, (AccountBuilderInterface)this.accountBuilderUI);
    }
}

