/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.scripting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.jdownloader.logging.LogController;
import org.jdownloader.scripting.JavaScriptEngineFactory;

public class CustomRhinoScriptEngineFactory
implements ScriptEngineFactory {
    private static final List<String> NAMES;
    private static final List<String> MIME_TYPES;
    private static final List<String> EXTENSIONS;

    @Override
    public Object getParameter(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Invalid key:null");
        }
        if (key.equals("javax.script.name")) {
            return "javascript";
        }
        if (key.equals("javax.script.engine")) {
            return "Mozilla Rhino";
        }
        if (key.equals("javax.script.engine_version")) {
            return "1.6 release 2";
        }
        if (key.equals("javax.script.language")) {
            return "javascript";
        }
        if (key.equals("javax.script.language_version")) {
            return "1.6";
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        throw new IllegalArgumentException("Invalid key:" + key);
    }

    @Override
    public ScriptEngine getScriptEngine() {
        try {
            JavaScriptEngineFactory.RhinoScriptEngine ret = new JavaScriptEngineFactory.RhinoScriptEngine();
            ret.setEngineFactory(this);
            return ret;
        }
        catch (RuntimeException e) {
            LogController.CL().log((Throwable)e);
            throw e;
        }
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... args) {
        String ret = obj + "." + method + "(";
        int len = args.length;
        if (len == 0) {
            ret = ret + ")";
            return ret;
        }
        for (int i = 0; i < len; ++i) {
            ret = ret + args[i];
            ret = i != len - 1 ? ret + "," : ret + ")";
        }
        return ret;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuffer buf = new StringBuffer();
        int len = toDisplay.length();
        buf.append("print(\"");
        block4: for (int i = 0; i < len; ++i) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\"': {
                    buf.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append("\")");
        return buf.toString();
    }

    @Override
    public String getProgram(String ... statements) {
        int len = statements.length;
        String ret = "";
        for (int i = 0; i < len; ++i) {
            ret = ret + statements[i] + ";";
        }
        return ret;
    }

    public String getName() {
        return "javascript";
    }

    @Override
    public String getEngineName() {
        return "Mozilla Rhino";
    }

    @Override
    public String getEngineVersion() {
        return "1.6 release 2";
    }

    @Override
    public String getLanguageName() {
        return "javascript";
    }

    @Override
    public String getLanguageVersion() {
        return "1.6";
    }

    @Override
    public List<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public List<String> getMimeTypes() {
        return MIME_TYPES;
    }

    @Override
    public List<String> getNames() {
        return NAMES;
    }

    static {
        ArrayList<String> names = new ArrayList<String>(6);
        names.add("js");
        names.add("rhino");
        names.add("JavaScript");
        names.add("javascript");
        NAMES = Collections.unmodifiableList(names);
        ArrayList<String> mimeTypes = new ArrayList<String>(4);
        mimeTypes.add("application/javascript");
        mimeTypes.add("application/ecmascript");
        mimeTypes.add("text/javascript");
        mimeTypes.add("text/ecmascript");
        MIME_TYPES = Collections.unmodifiableList(mimeTypes);
        ArrayList<String> extensions = new ArrayList<String>(1);
        extensions.add("js");
        EXTENSIONS = Collections.unmodifiableList(extensions);
    }
}

