/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.scripting;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.StringUtils;
import org.jdownloader.logging.LogController;
import org.jdownloader.scripting.JSShutterDelegate;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.tools.shell.Global;

public class JSRhinoPermissionRestricter {
    public static final ConcurrentHashMap<Thread, Boolean> TRUSTED_THREAD = new ConcurrentHashMap();
    public static final ConcurrentHashMap<Thread, JSShutterDelegate> THREAD_JSSHUTTER = new ConcurrentHashMap();
    private static final CopyOnWriteArraySet<String> LOADED = new CopyOnWriteArraySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluateTrustedString(Context cx, Global scope, String source, String sourceName, int lineno, Object securityDomain) {
        Thread thread = Thread.currentThread();
        try {
            TRUSTED_THREAD.put(thread, true);
            Object object = cx.evaluateString((Scriptable)scope, source, sourceName, lineno, securityDomain);
            return object;
        }
        finally {
            TRUSTED_THREAD.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Script compileTrustedString(Context cx, Global scope, String source, String sourceName, int lineno, Object securityDomain) {
        Thread thread = Thread.currentThread();
        try {
            TRUSTED_THREAD.put(thread, true);
            Script script = cx.compileString(source, sourceName, lineno, securityDomain);
            return script;
        }
        finally {
            TRUSTED_THREAD.remove(thread);
        }
    }

    public static List<String> getLoaded() {
        ArrayList<String> ret = new ArrayList<String>(LOADED);
        Collections.sort(ret, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        return ret;
    }

    public static void init() {
        try {
            ContextFactory.initGlobal((ContextFactory)new SandboxContextFactory());
            try {
                try {
                    Context cx = ContextFactory.getGlobal().enterContext();
                    cx.evaluateString((Scriptable)cx.initStandardObjects(), "java.lang.System.out.println('TEST')", "<cmd>", 1, null);
                }
                finally {
                    Context.exit();
                }
                throw new SecurityException("Could not install the sun.org.mozilla.javascript.internal Sandbox!");
            }
            catch (SandboxException e) {
                if (!StringUtils.startsWithCaseInsensitive((String)e.getMessage(), (String)"Security Violation:org")) {
                    throw e;
                }
            }
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
    }

    public static class SandboxNativeJavaObject
    extends NativeJavaObject {
        private static final long serialVersionUID = -2783084485265910840L;

        public SandboxNativeJavaObject(Scriptable scope, Object javaObject, Class<?> staticType) {
            super(scope, javaObject, staticType);
        }

        public Object get(String name, Scriptable start) {
            if (name.equals("getClass")) {
                LogController.CL().severe("JS Security Exception:" + name + "|" + start);
                return NOT_FOUND;
            }
            return super.get(name, start);
        }
    }

    public static class SandboxNativeJavaMapWrapper
    extends NativeJavaObject {
        private static final long serialVersionUID = -3786257752907047381L;
        private final Map<Object, Object> map;

        public SandboxNativeJavaMapWrapper(Scriptable scope, Object map) {
            super(scope, map, map.getClass());
            assert (map instanceof Map);
            this.map = (Map)map;
        }

        public String getClassName() {
            return "JavaMap";
        }

        public boolean has(String name, Scriptable start) {
            Context cx = Context.getCurrentContext();
            if (cx != null && this.map.containsKey(name)) {
                return true;
            }
            return super.has(name, start);
        }

        public boolean has(int index, Scriptable start) {
            Context cx = Context.getCurrentContext();
            if (cx != null && this.map.containsKey(index)) {
                return true;
            }
            return super.has(index, start);
        }

        public Object get(String name, Scriptable start) {
            if (name.equals("getClass")) {
                LogController.CL().severe("JS Security Exception:" + name + "|" + start);
                return NOT_FOUND;
            }
            Context cx = Context.getCurrentContext();
            if (cx != null && this.map.containsKey(name)) {
                Object obj = this.map.get(name);
                return cx.getWrapFactory().wrap(cx, (Scriptable)this, obj, obj == null ? null : obj.getClass());
            }
            return super.get(name, start);
        }

        public Object get(int index, Scriptable start) {
            Context cx = Context.getCurrentContext();
            if (cx != null && this.map.containsKey(index)) {
                Object obj = this.map.get(index);
                return cx.getWrapFactory().wrap(cx, (Scriptable)this, obj, obj == null ? null : obj.getClass());
            }
            return super.get(index, start);
        }

        public void put(String name, Scriptable start, Object value) {
            Context cx = Context.getCurrentContext();
            if (cx != null) {
                this.map.put(name, Context.jsToJava((Object)value, Object.class));
            } else {
                super.put(name, start, value);
            }
        }

        public void put(int index, Scriptable start, Object value) {
            Context cx = Context.getCurrentContext();
            if (cx != null) {
                this.map.put(index, Context.jsToJava((Object)value, Object.class));
            } else {
                super.put(index, start, value);
            }
        }

        public Object[] getIds() {
            Context cx = Context.getCurrentContext();
            if (cx != null) {
                ArrayList<Object> ids = new ArrayList<Object>(this.map.size());
                for (Object key : this.map.keySet()) {
                    if (key instanceof Integer) {
                        ids.add(key);
                        continue;
                    }
                    ids.add(ScriptRuntime.toString((Object)key));
                }
                return ids.toArray();
            }
            return super.getIds();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class SandboxWrapFactory
    extends WrapFactory {
        public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
            if (javaObject instanceof Map) {
                return new SandboxNativeJavaMapWrapper(scope, javaObject);
            }
            if (javaObject instanceof EcmaError) {
                LogController.CL().log((Throwable)((Exception)javaObject));
            }
            return new SandboxNativeJavaObject(scope, javaObject, staticType);
        }
    }

    public static class SandboxContextFactory
    extends ContextFactory {
        protected void observeInstructionCount(Context cx, int instructionCount) {
        }

        protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            return super.doTopCall(callable, cx, scope, thisObj, args);
        }

        protected Context makeContext() {
            final MyContext cx = new MyContext(this);
            try {
                Field field = Context.class.getDeclaredField("factory");
                field.setAccessible(true);
                if (field.get((Object)cx) != this) {
                    field.set((Object)cx, (Object)this);
                    field.setAccessible(false);
                }
            }
            catch (Throwable e) {
                throw new WTFException(e);
            }
            cx.setWrapFactory(new SandboxWrapFactory());
            cx.setClassShutter(new ClassShutter(){

                public boolean visibleToScripts(String className) {
                    JSShutterDelegate jsShutter;
                    Thread thread = Thread.currentThread();
                    boolean threadTrusted = TRUSTED_THREAD.containsKey(thread);
                    Boolean jsShutterResult = null;
                    if (thread instanceof JSShutterDelegate) {
                        jsShutterResult = ((JSShutterDelegate)((Object)thread)).isClassVisibleToScript(threadTrusted, className) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if ((jsShutter = THREAD_JSSHUTTER.get(thread)) != null) {
                        jsShutterResult = jsShutter.isClassVisibleToScript(threadTrusted, className) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (jsShutterResult != null) {
                        if (jsShutterResult.booleanValue()) {
                            LOADED.add(className);
                        }
                        return jsShutterResult;
                    }
                    if (threadTrusted) {
                        LOADED.add(className);
                        LogController.CL().severe("Trusted Thread Loads: " + className + "|Thread:" + thread);
                        return true;
                    }
                    if (className.startsWith("adapter")) {
                        LOADED.add(className);
                        return true;
                    }
                    if (className.startsWith("org.mozilla.javascript.ConsString")) {
                        LOADED.add(className);
                        return true;
                    }
                    if (className.startsWith("org.mozilla.javascript.JavaScriptException")) {
                        LOADED.add(className);
                        return true;
                    }
                    if (className.startsWith("org.mozilla.javascript.EvaluatorException")) {
                        LOADED.add(className);
                        return true;
                    }
                    if (className.equals("org.mozilla.javascript.EcmaError")) {
                        LOADED.add(className);
                        LogController.CL().severe("Javascript error occured");
                        return true;
                    }
                    throw new SandboxException(cx, thread, className, "Security Violation:" + className + "|Thread:" + thread);
                }
            });
            return cx;
        }

        public static class MyContext
        extends Context {
            private MyContext(ContextFactory factory) {
                super(factory);
            }
        }
    }

    public static class SandboxException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final Context cx;
        private final Thread thread;
        private final String className;

        public Context getContext() {
            return this.cx;
        }

        public Thread getThread() {
            return this.thread;
        }

        public String getClassName() {
            return this.className;
        }

        public SandboxException(Context cx, Thread thread, String className, String message) {
            super(message);
            this.cx = cx;
            this.thread = thread;
            this.className = className;
        }
    }
}

