/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.scripting;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import jd.parser.Regex;
import jd.plugins.MinimalMemoryJSonParser;
import jd.plugins.components.ThrowingRunnable;
import org.appwork.storage.JSonMapperException;
import org.appwork.storage.simplejson.MinimalMemoryMap;
import org.appwork.storage.simplejson.ParserException;
import org.appwork.utils.Exceptions;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.jdownloader.logging.LogController;
import org.jdownloader.scripting.CustomRhinoScriptEngineFactory;
import org.jdownloader.scripting.JSRhinoPermissionRestricter;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Synchronizer;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class JavaScriptEngineFactory {
    public static ScriptEngineManager getScriptEngineManager(Object requestor) {
        return new CustomizedScriptEngineManager();
    }

    public static Map<String, Object> jsonToJavaMap(String string) throws Exception {
        return (Map)JavaScriptEngineFactory.jsonToJavaObject(string);
    }

    public static Object convertJavaScriptToJava(Object param) {
        if (param == null) {
            return null;
        }
        if (param instanceof Boolean) {
            return param;
        }
        if (param instanceof String) {
            return param;
        }
        if (param instanceof CharSequence) {
            return param.toString();
        }
        if (param instanceof Number) {
            return param;
        }
        if (ReflectionUtils.isInstanceOf((String)"net.sourceforge.htmlunit.corejs.javascript.NativeArray", (Object)param) || ReflectionUtils.isInstanceOf((String)"org.mozilla.javascript.NativeArray", (Object)param)) {
            List na = (List)param;
            int length = na.size();
            ArrayList<Object> elem = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                elem.add(JavaScriptEngineFactory.convertJavaScriptToJava(na.get(i)));
            }
            return elem;
        }
        if (ReflectionUtils.isInstanceOf((String)"net.sourceforge.htmlunit.corejs.javascript.NativeObject", (Object)param) || ReflectionUtils.isInstanceOf((String)"org.mozilla.javascript.NativeObject", (Object)param)) {
            Map no = (Map)param;
            HashMap<Object, Object> elem = new HashMap<Object, Object>();
            for (Map.Entry entry : no.entrySet()) {
                Object key = JavaScriptEngineFactory.convertJavaScriptToJava(entry.getKey());
                Object value = JavaScriptEngineFactory.convertJavaScriptToJava(entry.getValue());
                if (key instanceof String) {
                    elem.put(key, value);
                    continue;
                }
                elem.put(String.valueOf(key), value);
            }
            return elem;
        }
        System.out.println("TODO:" + param);
        return param;
    }

    public static Object[] convertJavaScriptToJava(Object ... parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object param : parameters) {
            if (param == null) {
                ret.add(null);
                continue;
            }
            if (param instanceof Boolean) {
                ret.add(param);
                continue;
            }
            if (param instanceof String) {
                ret.add(param);
                continue;
            }
            if (param instanceof CharSequence) {
                ret.add(param.toString());
                continue;
            }
            if (param instanceof Number) {
                ret.add(param);
                continue;
            }
            if (ReflectionUtils.isInstanceOf((String)"net.sourceforge.htmlunit.corejs.javascript.NativeArray", (Object)param) || ReflectionUtils.isInstanceOf((String)"org.mozilla.javascript.NativeArray", (Object)param)) {
                List na = (List)param;
                int length = na.size();
                ArrayList<Object> elem = new ArrayList<Object>();
                for (int i = 0; i < length; ++i) {
                    elem.add(JavaScriptEngineFactory.convertJavaScriptToJava(na.get(i)));
                }
                ret.add(elem);
                continue;
            }
            if (ReflectionUtils.isInstanceOf((String)"net.sourceforge.htmlunit.corejs.javascript.NativeObject", (Object)param) || ReflectionUtils.isInstanceOf((String)"org.mozilla.javascript.NativeObject", (Object)param)) {
                Map no = (Map)param;
                HashMap<Object, Object> elem = new HashMap<Object, Object>();
                for (Map.Entry entry : no.entrySet()) {
                    Object key = JavaScriptEngineFactory.convertJavaScriptToJava(entry.getKey());
                    Object value = JavaScriptEngineFactory.convertJavaScriptToJava(entry.getValue());
                    if (key instanceof String) {
                        elem.put(key, value);
                        continue;
                    }
                    elem.put(String.valueOf(key), value);
                }
                ret.add(elem);
                continue;
            }
            System.out.println("TODO:" + param);
            ret.add(param);
        }
        return ret.toArray(new Object[0]);
    }

    public static Object jsonToJavaObject(String string) throws Exception {
        try {
            try {
                return new MinimalMemoryJSonParser(string).parse();
            }
            catch (ParserException e) {
                throw new JSonMapperException((Throwable)e);
            }
        }
        catch (JSonMapperException e) {
            try {
                ScriptEngineManager mgr = JavaScriptEngineFactory.getScriptEngineManager(null);
                ScriptEngine engine = mgr.getEngineByName("JavaScript");
                if (engine == null) {
                    throw e;
                }
                engine.eval("var response=" + string + ";");
                return JavaScriptEngineFactory.convertJavaScriptToJava(engine.get("response"));
            }
            catch (ScriptException e2) {
                Exceptions.addSuppressed((Throwable)e2, (Throwable)e);
                throw new Exception("JavaScript to Java failed: " + string, e2);
            }
        }
    }

    public static long toLong(Object value, long fallback) {
        try {
            if (value instanceof String) {
                String numberStr = (String)value;
                if (StringUtils.isEmpty((String)numberStr)) {
                    return fallback;
                }
                if (numberStr.matches("-?\\d+")) {
                    return Long.parseLong((String)value);
                }
                if (numberStr.matches("-?\\d+\\.\\d+")) {
                    return Double.valueOf(numberStr).longValue();
                }
                throw new Exception("no number?" + numberStr);
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value == null) {
                return fallback;
            }
            throw new Exception("no number?" + value);
        }
        catch (Throwable e) {
            LogController.CL(true).log(e);
            return fallback;
        }
    }

    public static int toInteger(Object value, int fallback) {
        try {
            if (value instanceof String) {
                String numberStr = (String)value;
                if (StringUtils.isEmpty((String)numberStr)) {
                    return fallback;
                }
                if (numberStr.matches("-?\\d+")) {
                    return Integer.parseInt((String)value);
                }
                if (numberStr.matches("-?\\d+\\.\\d+")) {
                    return Double.valueOf(numberStr).intValue();
                }
                throw new Exception("no number?" + numberStr);
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value == null) {
                return fallback;
            }
            throw new Exception("no number?" + value);
        }
        catch (Throwable e) {
            LogController.CL(true).log(e);
            return fallback;
        }
    }

    public static Object walkJson(Object json, String walk) {
        if (walk == null) {
            return null;
        }
        String[] walkParts = walk.split("/");
        return JavaScriptEngineFactory.walkJson(json, walkParts);
    }

    public static Object walkJson(Object json, String ... walk) {
        if (walk == null || walk.length == 0) {
            return null;
        }
        String[] crawlparts = walk;
        String walkedBegin = "";
        String walkedRemains = StringUtils.join((Object[])walk, (String)"/");
        Object currentObject = json;
        try {
            for (int i = 0; i < crawlparts.length; ++i) {
                if (currentObject == null) {
                    return null;
                }
                String crawlpart = crawlparts[i];
                walkedBegin = walkedBegin.length() == 0 ? crawlpart : walkedBegin + "/" + crawlpart;
                walkedRemains = walkedRemains.replaceFirst("^" + Pattern.quote(crawlpart) + "/?", "");
                String crawlpart_crawlnumber = new Regex(crawlpart, "\\{(\\d*)\\}").getMatch(0);
                int crawlentry_number = crawlpart_crawlnumber != null ? (crawlpart_crawlnumber.matches("\\d+") ? Integer.parseInt(crawlpart_crawlnumber) : -1) : -2;
                if ((currentObject instanceof LinkedHashMap || currentObject instanceof MinimalMemoryMap) && crawlentry_number >= -1) {
                    Map tmp_linkedmap = (Map)currentObject;
                    Iterator it = tmp_linkedmap.entrySet().iterator();
                    int position = 0;
                    boolean success = false;
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        if (crawlentry_number >= 0 && position == crawlentry_number) {
                            currentObject = entry.getValue();
                            success = true;
                            break;
                        }
                        ++position;
                    }
                    if (success) continue;
                    currentObject = null;
                    continue;
                }
                if (currentObject instanceof Map) {
                    Map tmp_map = (Map)currentObject;
                    currentObject = tmp_map.get(crawlpart);
                    continue;
                }
                if (currentObject instanceof List) {
                    if (crawlentry_number == -2) {
                        return null;
                    }
                    List tmp_list = (List)currentObject;
                    if (crawlentry_number == -1) {
                        for (Object list : tmp_list) {
                            Object test = JavaScriptEngineFactory.walkJson(list, walkedRemains);
                            if (test == null) continue;
                            return test;
                        }
                        currentObject = null;
                        continue;
                    }
                    currentObject = tmp_list.get(crawlentry_number);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LogController.CL(true).log((Throwable)e);
            return null;
        }
        return currentObject;
    }

    public static <T extends Exception> void runTrusted(ThrowingRunnable<T> runnable) throws T {
        try {
            JSRhinoPermissionRestricter.TRUSTED_THREAD.put(Thread.currentThread(), true);
            runnable.run();
        }
        finally {
            JSRhinoPermissionRestricter.TRUSTED_THREAD.remove(Thread.currentThread());
        }
    }

    public static class CustomizedScriptEngineManager
    extends ScriptEngineManager {
        @Override
        public ScriptEngine getEngineByName(String shortName) {
            ScriptEngine ret = super.getEngineByName(shortName);
            if (ret instanceof RhinoScriptEngine) {
                return ret;
            }
            throw new RuntimeException("Bad ScriptEngine:name=" + shortName + "|" + ret.getClass());
        }

        @Override
        public ScriptEngine getEngineByExtension(String extension) {
            ScriptEngine ret = super.getEngineByExtension(extension);
            if (ret instanceof RhinoScriptEngine) {
                return ret;
            }
            throw new RuntimeException("Bad ScriptEngine:extension=" + extension + "|" + ret.getClass());
        }

        @Override
        public ScriptEngine getEngineByMimeType(String mimeType) {
            ScriptEngine ret = super.getEngineByMimeType(mimeType);
            if (ret instanceof RhinoScriptEngine) {
                return ret;
            }
            throw new RuntimeException("Bad ScriptEngine:mime=" + mimeType + "|" + ret.getClass());
        }

        public CustomizedScriptEngineManager() {
            CustomRhinoScriptEngineFactory factory = new CustomRhinoScriptEngineFactory();
            for (String name : factory.getNames()) {
                this.registerEngineName(name, factory);
            }
            for (String extension : factory.getExtensions()) {
                this.registerEngineExtension(extension, factory);
            }
            for (String mimeType : factory.getMimeTypes()) {
                this.registerEngineMimeType(mimeType, factory);
            }
        }
    }

    public static class RhinoScriptEngine
    extends AbstractScriptEngine
    implements Invocable,
    Compilable {
        private static final boolean DEBUG = false;
        private RhinoTopLevel topLevel;
        private Map<Object, Object> indexedProps;
        private ScriptEngineFactory factory;
        private InterfaceImplementor implementor;
        private static final String printSource = "function print(str, newline) {                \n    if (typeof(str) == 'undefined') {         \n        str = 'undefined';                    \n    } else if (str == null) {                 \n        str = 'null';                         \n    }                                         \n    var out = context.getWriter();            \n    out.print(String(str));                   \n    if (newline) out.print('\\n');            \n    out.flush();                              \n}\nfunction println(str) {                       \n    print(str, true);                         \n}";

        public RhinoScriptEngine() {
            Context cx = RhinoScriptEngine.enterContext();
            try {
                this.topLevel = new RhinoTopLevel(cx, this);
            }
            finally {
                Context.exit();
            }
            this.indexedProps = new HashMap<Object, Object>();
            this.implementor = new InterfaceImplementor(this){

                @Override
                protected Object convertResult(Method method, Object res) throws ScriptException {
                    Class<?> desiredType = method.getReturnType();
                    if (desiredType == Void.TYPE) {
                        return null;
                    }
                    return Context.jsToJava((Object)res, desiredType);
                }
            };
        }

        @Override
        public Object eval(Reader reader, ScriptContext ctxt) throws ScriptException {
            Object ret;
            Context cx = RhinoScriptEngine.enterContext();
            try {
                Scriptable scope = this.getRuntimeScope(ctxt);
                String filename = (String)this.get("javax.script.filename");
                filename = filename == null ? "<Unknown source>" : filename;
                ret = cx.evaluateReader(scope, reader, filename, 1, null);
            }
            catch (RhinoException re) {
                int line = re.lineNumber();
                line = line == 0 ? -1 : line;
                String msg = re instanceof JavaScriptException ? String.valueOf(((JavaScriptException)re).getValue()) : re.toString();
                ScriptException se = new ScriptException(msg, re.sourceName(), line);
                se.initCause(re);
                throw se;
            }
            catch (IOException ee) {
                throw new ScriptException(ee);
            }
            finally {
                cx.exit();
            }
            return this.unwrapReturnValue(ret);
        }

        @Override
        public Object eval(String script, ScriptContext ctxt) throws ScriptException {
            if (script == null) {
                throw new NullPointerException("null script");
            }
            return this.eval((Reader)new StringReader(script), ctxt);
        }

        @Override
        public ScriptEngineFactory getFactory() {
            if (this.factory != null) {
                return this.factory;
            }
            return new CustomRhinoScriptEngineFactory();
        }

        @Override
        public Bindings createBindings() {
            return new SimpleBindings();
        }

        @Override
        public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
            return this.invoke(null, name, args);
        }

        @Override
        public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
            if (thiz == null) {
                throw new IllegalArgumentException("script object can not be null");
            }
            return this.invoke(thiz, name, args);
        }

        private Object invoke(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
            Context cx = RhinoScriptEngine.enterContext();
            try {
                if (name == null) {
                    throw new NullPointerException("method name is null");
                }
                if (thiz != null && !(thiz instanceof Scriptable)) {
                    thiz = Context.toObject((Object)thiz, (Scriptable)this.topLevel);
                }
                Scriptable engineScope = this.getRuntimeScope(this.context);
                Scriptable localScope = thiz != null ? (Scriptable)thiz : engineScope;
                Object obj = ScriptableObject.getProperty((Scriptable)localScope, (String)name);
                if (!(obj instanceof Function)) {
                    throw new NoSuchMethodException("no such method: " + name);
                }
                Function func = (Function)obj;
                Scriptable scope = func.getParentScope();
                if (scope == null) {
                    scope = engineScope;
                }
                Object result = func.call(cx, scope, localScope, this.wrapArguments(args));
                Object object = this.unwrapReturnValue(result);
                return object;
            }
            catch (RhinoException re) {
                int line = re.lineNumber();
                line = line == 0 ? -1 : line;
                throw new ScriptException(re.toString(), re.sourceName(), line);
            }
            finally {
                cx.exit();
            }
        }

        @Override
        public <T> T getInterface(Class<T> clasz) {
            try {
                return this.implementor.getInterface(null, clasz);
            }
            catch (ScriptException e) {
                return null;
            }
        }

        @Override
        public <T> T getInterface(Object thiz, Class<T> clasz) {
            if (thiz == null) {
                throw new IllegalArgumentException("script object can not be null");
            }
            try {
                return this.implementor.getInterface(thiz, clasz);
            }
            catch (ScriptException e) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Scriptable getRuntimeScope(ScriptContext ctxt) {
            if (ctxt == null) {
                throw new NullPointerException("null script context");
            }
            ExternalScriptable newScope = new ExternalScriptable(ctxt, this.indexedProps);
            newScope.setPrototype((Scriptable)this.topLevel);
            newScope.put("context", newScope, ctxt);
            Context cx = RhinoScriptEngine.enterContext();
            try {
                cx.evaluateString((Scriptable)newScope, printSource, "print", 1, null);
            }
            finally {
                cx.exit();
            }
            return newScope;
        }

        @Override
        public CompiledScript compile(String script) throws ScriptException {
            return this.compile(new StringReader(script));
        }

        @Override
        public CompiledScript compile(Reader script) throws ScriptException {
            RhinoCompiledScript ret = null;
            Context cx = RhinoScriptEngine.enterContext();
            try {
                String fileName = (String)this.get("javax.script.filename");
                if (fileName == null) {
                    fileName = "<Unknown Source>";
                }
                Scriptable scope = this.getRuntimeScope(this.context);
                Script scr = cx.compileReader(scope, script, fileName, 1, null);
                ret = new RhinoCompiledScript(this, scr);
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
            finally {
                cx.exit();
            }
            return ret;
        }

        static Context enterContext() {
            return Context.enter();
        }

        void setEngineFactory(ScriptEngineFactory fac) {
            this.factory = fac;
        }

        Object[] wrapArguments(Object[] args) {
            if (args == null) {
                return Context.emptyArgs;
            }
            Object[] res = new Object[args.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = Context.javaToJS((Object)args[i], (Scriptable)this.topLevel);
            }
            return res;
        }

        Object unwrapReturnValue(Object result) {
            if (result instanceof Wrapper) {
                result = ((Wrapper)result).unwrap();
            }
            return result instanceof Undefined ? null : result;
        }

        public static void main(String[] args) throws Exception {
            if (args.length == 0) {
                System.out.println("No file specified");
                return;
            }
            InputStreamReader r = new InputStreamReader(new FileInputStream(args[0]));
            RhinoScriptEngine engine = new RhinoScriptEngine();
            engine.put("x", "y");
            engine.put("javax.script.filename", args[0]);
            engine.eval(r);
            System.out.println(engine.get("x"));
        }
    }

    public static class InterfaceImplementor {
        private Invocable engine;

        public InterfaceImplementor(Invocable engine) {
            this.engine = engine;
        }

        public <T> T getInterface(Object thiz, Class<T> iface) throws ScriptException {
            if (iface == null || !iface.isInterface()) {
                throw new IllegalArgumentException("interface Class expected");
            }
            return iface.cast(Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new InterfaceImplementorInvocationHandler(this.engine, thiz)));
        }

        protected Object convertResult(Method method, Object res) throws ScriptException {
            return res;
        }

        protected Object[] convertArguments(Method method, Object[] args) throws ScriptException {
            return args;
        }

        public class InterfaceImplementorInvocationHandler
        implements InvocationHandler {
            private Invocable engine;
            private Object thiz;

            public InterfaceImplementorInvocationHandler(Invocable engine, Object thiz) {
                this.engine = engine;
                this.thiz = thiz;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                args = InterfaceImplementor.this.convertArguments(method, args);
                Object result = this.engine.invokeMethod(this.thiz, method.getName(), args);
                return InterfaceImplementor.this.convertResult(method, result);
            }
        }
    }

    public static class RhinoCompiledScript
    extends CompiledScript {
        private RhinoScriptEngine engine;
        private Script script;

        RhinoCompiledScript(RhinoScriptEngine engine, Script script) {
            this.engine = engine;
            this.script = script;
        }

        @Override
        public Object eval(ScriptContext context) throws ScriptException {
            Object result = null;
            Context cx = RhinoScriptEngine.enterContext();
            try {
                Scriptable scope = this.engine.getRuntimeScope(context);
                Object ret = this.script.exec(cx, scope);
                result = this.engine.unwrapReturnValue(ret);
            }
            catch (RhinoException re) {
                int line = re.lineNumber();
                line = line == 0 ? -1 : line;
                String msg = re instanceof JavaScriptException ? String.valueOf(((JavaScriptException)re).getValue()) : re.toString();
                ScriptException se = new ScriptException(msg, re.sourceName(), line);
                se.initCause(re);
                throw se;
            }
            finally {
                Context.exit();
            }
            return result;
        }

        @Override
        public ScriptEngine getEngine() {
            return this.engine;
        }
    }

    public static class RhinoTopLevel
    extends ImporterTopLevel {
        private RhinoScriptEngine engine;

        RhinoTopLevel(Context cx, RhinoScriptEngine engine) {
            super(cx);
            this.engine = engine;
            new LazilyLoadedCtor((ScriptableObject)this, "JSAdapter", "com.sun.script.javascript.JSAdapter", false);
            JavaAdapter.init((Context)cx, (Scriptable)this, (boolean)false);
            String[] names = new String[]{"bindings", "scope", "sync"};
            this.defineFunctionProperties(names, RhinoTopLevel.class, 2);
        }

        public static Object bindings(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
            if (args.length == 1) {
                Object arg = args[0];
                if (arg instanceof Wrapper) {
                    arg = ((Wrapper)arg).unwrap();
                }
                if (arg instanceof ExternalScriptable) {
                    ScriptContext ctx = ((ExternalScriptable)arg).getContext();
                    Bindings bind = ctx.getBindings(100);
                    return Context.javaToJS((Object)bind, (Scriptable)ScriptableObject.getTopLevelScope((Scriptable)thisObj));
                }
            }
            return cx.getUndefinedValue();
        }

        public static Object scope(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
            if (args.length == 1) {
                Object arg = args[0];
                if (arg instanceof Wrapper) {
                    arg = ((Wrapper)arg).unwrap();
                }
                if (arg instanceof Bindings) {
                    SimpleScriptContext ctx = new SimpleScriptContext();
                    ctx.setBindings((Bindings)arg, 100);
                    ExternalScriptable res = new ExternalScriptable(ctx);
                    res.setPrototype(ScriptableObject.getObjectPrototype((Scriptable)thisObj));
                    res.setParentScope(ScriptableObject.getTopLevelScope((Scriptable)thisObj));
                    return res;
                }
            }
            return cx.getUndefinedValue();
        }

        public static Object sync(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
            if (args.length == 1 && args[0] instanceof Function) {
                return new Synchronizer((Scriptable)((Function)args[0]));
            }
            throw Context.reportRuntimeError((String)"wrong argument(s) for sync");
        }

        RhinoScriptEngine getScriptEngine() {
            return this.engine;
        }
    }

    public static class ExternalScriptable
    implements Scriptable {
        private ScriptContext context;
        private Map<Object, Object> indexedProps;
        private Scriptable prototype;
        private Scriptable parent;

        ExternalScriptable(ScriptContext context) {
            this(context, new HashMap<Object, Object>());
        }

        ExternalScriptable(ScriptContext context, Map<Object, Object> indexedProps) {
            if (context == null) {
                throw new NullPointerException("context is null");
            }
            this.context = context;
            this.indexedProps = indexedProps;
        }

        ScriptContext getContext() {
            return this.context;
        }

        private boolean isEmpty(String name) {
            return name.equals("");
        }

        public String getClassName() {
            return "Global";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Object get(String name, Scriptable start) {
            if (this.isEmpty(name)) {
                if (this.indexedProps.containsKey(name)) {
                    return this.indexedProps.get(name);
                }
                return NOT_FOUND;
            }
            ScriptContext scriptContext = this.context;
            synchronized (scriptContext) {
                int scope = this.context.getAttributesScope(name);
                if (scope != -1) {
                    Object value = this.context.getAttribute(name, scope);
                    if (value instanceof ConsString) {
                        value = value.toString();
                    }
                    return Context.javaToJS((Object)value, (Scriptable)this);
                }
                return NOT_FOUND;
            }
        }

        public synchronized Object get(int index, Scriptable start) {
            Integer key = index;
            if (this.indexedProps.containsKey(index)) {
                return this.indexedProps.get(key);
            }
            return NOT_FOUND;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean has(String name, Scriptable start) {
            if (this.isEmpty(name)) {
                return this.indexedProps.containsKey(name);
            }
            ScriptContext scriptContext = this.context;
            synchronized (scriptContext) {
                return this.context.getAttributesScope(name) != -1;
            }
        }

        public synchronized boolean has(int index, Scriptable start) {
            Integer key = index;
            return this.indexedProps.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(String name, Scriptable start, Object value) {
            if (start == this) {
                ExternalScriptable externalScriptable = this;
                synchronized (externalScriptable) {
                    if (this.isEmpty(name)) {
                        this.indexedProps.put(name, value);
                    } else {
                        ScriptContext scriptContext = this.context;
                        synchronized (scriptContext) {
                            int scope = this.context.getAttributesScope(name);
                            if (scope == -1) {
                                scope = 100;
                            }
                            this.context.setAttribute(name, this.jsToJava(value), scope);
                        }
                    }
                }
            }
            start.put(name, start, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(int index, Scriptable start, Object value) {
            if (start == this) {
                ExternalScriptable externalScriptable = this;
                synchronized (externalScriptable) {
                    this.indexedProps.put(index, value);
                }
            } else {
                start.put(index, start, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void delete(String name) {
            if (this.isEmpty(name)) {
                this.indexedProps.remove(name);
            } else {
                ScriptContext scriptContext = this.context;
                synchronized (scriptContext) {
                    int scope = this.context.getAttributesScope(name);
                    if (scope != -1) {
                        this.context.removeAttribute(name, scope);
                    }
                }
            }
        }

        public void delete(int index) {
            this.indexedProps.remove(index);
        }

        public Scriptable getPrototype() {
            return this.prototype;
        }

        public void setPrototype(Scriptable prototype) {
            this.prototype = prototype;
        }

        public Scriptable getParentScope() {
            return this.parent;
        }

        public void setParentScope(Scriptable parent) {
            this.parent = parent;
        }

        public synchronized Object[] getIds() {
            String[] keys = this.getAllKeys();
            int size = keys.length + this.indexedProps.size();
            Object[] res = new Object[size];
            System.arraycopy(keys, 0, res, 0, keys.length);
            int i = keys.length;
            for (Object index : this.indexedProps.keySet()) {
                res[i++] = index;
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getDefaultValue(Class typeHint) {
            for (int i = 0; i < 2; ++i) {
                Object u;
                Object[] args;
                String methodName;
                boolean tryToString;
                if (typeHint == ScriptRuntime.StringClass) {
                    tryToString = i == 0;
                } else {
                    boolean bl = tryToString = i == 1;
                }
                if (tryToString) {
                    methodName = "toString";
                    args = ScriptRuntime.emptyArgs;
                } else {
                    String hint;
                    methodName = "valueOf";
                    args = new Object[1];
                    if (typeHint == null) {
                        hint = "undefined";
                    } else if (typeHint == ScriptRuntime.StringClass) {
                        hint = "string";
                    } else if (typeHint == ScriptRuntime.ScriptableClass) {
                        hint = "object";
                    } else if (typeHint == ScriptRuntime.FunctionClass) {
                        hint = "function";
                    } else if (typeHint == ScriptRuntime.BooleanClass || typeHint == Boolean.TYPE) {
                        hint = "boolean";
                    } else if (typeHint == ScriptRuntime.NumberClass || typeHint == ScriptRuntime.ByteClass || typeHint == Byte.TYPE || typeHint == ScriptRuntime.ShortClass || typeHint == Short.TYPE || typeHint == ScriptRuntime.IntegerClass || typeHint == Integer.TYPE || typeHint == ScriptRuntime.FloatClass || typeHint == Float.TYPE || typeHint == ScriptRuntime.DoubleClass || typeHint == Double.TYPE) {
                        hint = "number";
                    } else {
                        throw Context.reportRuntimeError((String)("Invalid JavaScript value of type " + typeHint.toString()));
                    }
                    args[0] = hint;
                }
                Object v = ScriptableObject.getProperty((Scriptable)this, (String)methodName);
                if (!(v instanceof Function)) continue;
                Function fun = (Function)v;
                Context cx = RhinoScriptEngine.enterContext();
                try {
                    v = fun.call(cx, fun.getParentScope(), (Scriptable)this, args);
                }
                finally {
                    cx.exit();
                }
                if (v == null) continue;
                if (!(v instanceof Scriptable)) {
                    return v;
                }
                if (typeHint == ScriptRuntime.ScriptableClass || typeHint == ScriptRuntime.FunctionClass) {
                    return v;
                }
                if (!tryToString || !(v instanceof Wrapper) || !((u = ((Wrapper)v).unwrap()) instanceof String)) continue;
                return u;
            }
            String arg = typeHint == null ? "undefined" : typeHint.getName();
            throw Context.reportRuntimeError((String)("Cannot find default value for object " + arg));
        }

        public boolean hasInstance(Scriptable instance) {
            for (Scriptable proto = instance.getPrototype(); proto != null; proto = proto.getPrototype()) {
                if (!proto.equals(this)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] getAllKeys() {
            ArrayList<String> list = new ArrayList<String>();
            ScriptContext scriptContext = this.context;
            synchronized (scriptContext) {
                for (int scope : this.context.getScopes()) {
                    Bindings bindings = this.context.getBindings(scope);
                    if (bindings == null) continue;
                    list.ensureCapacity(bindings.size());
                    for (String key : bindings.keySet()) {
                        list.add(key);
                    }
                }
            }
            String[] res = new String[list.size()];
            list.toArray(res);
            return res;
        }

        private Object jsToJava(Object jsObj) {
            if (jsObj instanceof Wrapper) {
                Wrapper njb = (Wrapper)jsObj;
                if (njb instanceof NativeJavaClass) {
                    return njb;
                }
                Object obj = njb.unwrap();
                if (obj instanceof Number || obj instanceof String || obj instanceof Boolean || obj instanceof Character) {
                    return njb;
                }
                return obj;
            }
            return jsObj;
        }
    }
}

