/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.settings.advanced;

import org.appwork.exceptions.WTFException;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableDeprecatedSince;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.StringUtils;
import org.jdownloader.myjdownloader.client.bindings.AdvancedConfigEntryDataStorable;
import org.jdownloader.settings.advanced.AdvancedConfigEntry;

public class AdvancedConfigAPIEntry
extends AdvancedConfigEntryDataStorable
implements Storable {
    public AdvancedConfigAPIEntry(AdvancedConfigEntry entry, boolean returnDescription, boolean addValue, boolean defaultValues) {
        AdvancedConfigEntryDataStorable.AbstractType abstractType;
        KeyHandler<?> kh = entry.getKeyHandler();
        if (returnDescription && entry.hasDescription() && StringUtils.isNotEmpty((String)entry.getDescription())) {
            this.setDocs(entry.getDescription());
        }
        this.setType(kh.getTypeString());
        String configInterfaceName = kh.getStorageHandler().getConfigInterface().getName();
        this.setInterfaceName(configInterfaceName);
        this.setKey(this.createKey(kh));
        try {
            abstractType = AdvancedConfigEntryDataStorable.AbstractType.valueOf(kh.getAbstractType().name());
            this.setAbstractType(abstractType);
        }
        catch (Exception e) {
            throw new WTFException((Throwable)e);
        }
        String storage = kh.getStorageHandler().getStorageID();
        if (storage != null) {
            this.setStorage(storage);
        }
        if (addValue) {
            Object value = kh.getValue();
            if (value != null && AdvancedConfigEntryDataStorable.AbstractType.OBJECT.equals((Object)abstractType)) {
                this.setValue(JSonStorage.toString((Object)value));
            } else {
                this.setValue(value);
            }
        }
        if (defaultValues) {
            Object defValue = entry.getDefault();
            if (defValue != null && AdvancedConfigEntryDataStorable.AbstractType.OBJECT.equals((Object)abstractType)) {
                this.setDefaultValue(JSonStorage.toString((Object)defValue));
            } else {
                this.setDefaultValue(defValue);
            }
        }
    }

    protected String createKey(KeyHandler<?> kh) {
        String getterName = kh.getGetMethod().getName();
        if (getterName.startsWith("is")) {
            return getterName.substring(2);
        }
        if (getterName.startsWith("get")) {
            return getterName.substring(3);
        }
        return getterName;
    }

    @Override
    @AllowNonStorableObjects
    public Object getDefaultValue() {
        return super.getDefaultValue();
    }

    @Override
    @AllowNonStorableObjects
    public Object getValue() {
        return super.getValue();
    }

    public AdvancedConfigAPIEntry() {
    }

    @Override
    @Deprecated
    @StorableDeprecatedSince(value="2022-10-18T00:00+0200")
    public String getType() {
        return super.getType();
    }

    @Override
    @Deprecated
    @StorableDeprecatedSince(value="2022-10-18T00:00+0200")
    public void setType(String type) {
        super.setType(type);
    }
}

