/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.settings.advanced;

import java.awt.Dialog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.ConfigEntryKeywords;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.DoubleSpinnerValidator;
import org.appwork.storage.config.annotations.FloatSpinnerValidator;
import org.appwork.storage.config.annotations.HexColorString;
import org.appwork.storage.config.annotations.MultiLineString;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.advanced.AdvancedValueEditorFactory;
import org.jdownloader.settings.advanced.AdvandedValueEditor;
import org.jdownloader.settings.advanced.RangeValidator;
import org.jdownloader.settings.advanced.Validator;

public class AdvancedConfigEntry {
    private final ConfigInterface configInterface;
    private final KeyHandler<?> keyHandler;
    public String[] internalKey = null;
    private String key = null;
    private String configInterfaceName = null;
    private String keyText = null;
    private Boolean hasDescription = null;
    private Boolean isMultiLineString = null;
    private Boolean hasHexColorString = null;
    private Boolean hasDefaultValue = null;
    private Boolean hasKeywords = null;
    private Boolean hasValidator = null;

    public KeyHandler<?> getKeyHandler() {
        return this.keyHandler;
    }

    public AdvancedConfigEntry(ConfigInterface cf, KeyHandler<?> m) {
        this.configInterface = cf;
        this.keyHandler = m;
    }

    public ConfigInterface getConfigInterface() {
        return this.configInterface;
    }

    public String[] getInternalKey() {
        if (this.internalKey == null) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(this.getKey());
            String[] lookupKeys = this.getKeyHandler().getBackwardsCompatibilityLookupKeys();
            if (lookupKeys != null) {
                ret.addAll(Arrays.asList(lookupKeys));
            }
            for (int i = 0; i < ret.size(); ++i) {
                String key = ((String)ret.get(i)).replaceAll("[^a-zA-Z0-9 ]+", "").replace("colour", "color").replace("directory", "folder").toLowerCase(Locale.ENGLISH);
                ret.set(i, key);
            }
            this.internalKey = ret.toArray(new String[0]);
            return this.internalKey;
        }
        return this.internalKey;
    }

    public String getKey() {
        if (this.key == null) {
            String ret;
            this.key = ret = this.getConfigInterfaceName().concat(".").concat(this.getHandlerKey());
            return ret;
        }
        return this.key;
    }

    public static boolean equals(Object x, Object y) {
        if (x == null && y == null) {
            return true;
        }
        if (x != null && y != null) {
            if (x == y || x.equals(y)) {
                return true;
            }
            if (ReflectionUtils.isList((Object)x) && ReflectionUtils.isList((Object)y)) {
                int yL;
                int xL = ReflectionUtils.getListLength((Object)x);
                if (xL == (yL = ReflectionUtils.getListLength((Object)y))) {
                    for (int index = 0; index < xL; ++index) {
                        Object yE;
                        Object xE = ReflectionUtils.getListElement((Object)x, (int)index);
                        if (AdvancedConfigEntry.equals(xE, yE = ReflectionUtils.getListElement((Object)y, (int)index))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public String getHandlerKey() {
        return this.keyHandler.getKey();
    }

    public String getConfigInterfaceName() {
        if (this.configInterfaceName == null) {
            String ret = this.configInterface._getStorageHandler().getConfigInterface().getSimpleName();
            if (ret.contains("Config")) {
                ret = ret.replace("Config", "");
            }
            this.configInterfaceName = ret;
            return ret;
        }
        return this.configInterfaceName;
    }

    public String getKeyText() {
        if (this.keyText == null) {
            this.keyText = this.getConfigInterfaceName() + ": " + this.getKeyHandler().getReadableName();
            return this.keyText;
        }
        return this.keyText;
    }

    public Object getValue() {
        return this.keyHandler.getValue();
    }

    public Type getType() {
        return this.keyHandler.getRawType();
    }

    public boolean hasDescription() {
        if (this.hasDescription == null) {
            this.hasDescription = this.getKeyHandler().getAnnotation(DescriptionForConfigEntry.class) != null;
        }
        return this.hasDescription;
    }

    public boolean isMultiLineString() {
        if (this.isMultiLineString == null) {
            this.isMultiLineString = this.getKeyHandler().getAnnotation(MultiLineString.class) != null;
        }
        return this.isMultiLineString;
    }

    public boolean hasHexColorString() {
        if (this.hasHexColorString == null) {
            this.hasHexColorString = this.getKeyHandler().getAnnotation(HexColorString.class) != null;
        }
        return this.hasHexColorString;
    }

    public boolean hasDefaultValue() {
        if (this.hasDefaultValue == null) {
            this.hasDefaultValue = this.getKeyHandler().hasDefaultValue();
        }
        return this.hasDefaultValue;
    }

    public String getDescription() {
        if (!this.hasDescription()) {
            return null;
        }
        DescriptionForConfigEntry an = (DescriptionForConfigEntry)this.getKeyHandler().getAnnotation(DescriptionForConfigEntry.class);
        if (an != null) {
            return an.value();
        }
        return null;
    }

    public Class<? extends AdvandedValueEditor> getAdvancedValueEditor() {
        AdvancedValueEditorFactory an = (AdvancedValueEditorFactory)this.getKeyHandler().getAnnotation(AdvancedValueEditorFactory.class);
        if (an != null) {
            return an.value();
        }
        return null;
    }

    public boolean hasKeywords() {
        if (this.hasKeywords == null) {
            this.hasKeywords = this.getKeyHandler().getAnnotation(ConfigEntryKeywords.class) != null;
        }
        return this.hasKeywords;
    }

    public String[] getKeywords() {
        if (!this.hasKeywords()) {
            return null;
        }
        ConfigEntryKeywords an = (ConfigEntryKeywords)this.getKeyHandler().getAnnotation(ConfigEntryKeywords.class);
        if (an != null) {
            return an.value();
        }
        return null;
    }

    public boolean hasValidator() {
        if (this.hasValidator == null) {
            this.hasValidator = this.getKeyHandler().getAnnotation(SpinnerValidator.class) != null || this.getKeyHandler().getAnnotation(DoubleSpinnerValidator.class) != null || this.getKeyHandler().getAnnotation(FloatSpinnerValidator.class) != null;
        }
        return this.hasValidator;
    }

    public Validator getValidator() {
        if (!this.hasValidator()) {
            return null;
        }
        SpinnerValidator fixedSpinner = (SpinnerValidator)this.getKeyHandler().getAnnotation(SpinnerValidator.class);
        if (fixedSpinner != null) {
            return new RangeValidator(fixedSpinner.min(), fixedSpinner.max(), fixedSpinner.step());
        }
        DoubleSpinnerValidator doubleSpinner = (DoubleSpinnerValidator)this.getKeyHandler().getAnnotation(DoubleSpinnerValidator.class);
        if (doubleSpinner != null) {
            return new RangeValidator(doubleSpinner.min(), doubleSpinner.max(), doubleSpinner.step());
        }
        FloatSpinnerValidator floatSpinner = (FloatSpinnerValidator)this.getKeyHandler().getAnnotation(FloatSpinnerValidator.class);
        if (floatSpinner != null) {
            return new RangeValidator(Float.valueOf(floatSpinner.min()), Float.valueOf(floatSpinner.max()), Float.valueOf(floatSpinner.step()));
        }
        return null;
    }

    public void setValue(Object value) {
        block8: {
            try {
                Method setMethod = this.keyHandler.getSetMethod();
                if (setMethod == null) {
                    return;
                }
                Object valueBefore = this.getValue();
                if (value instanceof Number) {
                    value = ReflectionUtils.castNumber((Number)((Number)value), this.getClazz());
                }
                setMethod.invoke((Object)this.configInterface, value);
                Object valueAfter = this.getValue();
                if (AdvancedConfigEntry.equals(valueBefore, valueAfter)) {
                    return;
                }
                if (!AdvancedConfigEntry.equals(valueBefore, value) && this.keyHandler.getAnnotation(RequiresRestart.class) != null && JDGui.bugme((WarnLevel)WarnLevel.NORMAL)) {
                    new Thread("RestartRequired:" + this.keyHandler.getKey()){
                        {
                            this.setDaemon(true);
                        }

                        @Override
                        public void run() {
                            ConfirmDialog d = new ConfirmDialog(48, _GUI.T.AdvancedConfigEntry_setValue_restart_warning_title(AdvancedConfigEntry.this.keyHandler.getKey()), _GUI.T.AdvancedConfigEntry_setValue_restart_warning(AdvancedConfigEntry.this.keyHandler.getKey()), NewTheme.I().getIcon("warning", 32), null, null){

                                public String getDontShowAgainKey() {
                                    return "RestartRequiredAdvancedConfig_" + AdvancedConfigEntry.this.getKey();
                                }
                            };
                            d.show();
                        }
                    }.start();
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                if (!(e.getTargetException() instanceof ValidationException)) break block8;
                new Thread(){
                    {
                        this.setDaemon(true);
                    }

                    @Override
                    public void run() {
                        ConfirmDialog confirm = new ConfirmDialog(20, _AWU.T.DIALOG_MESSAGE_TITLE(), e.getTargetException().getMessage(), null, null, null){

                            public Dialog.ModalityType getModalityType() {
                                return Dialog.ModalityType.MODELESS;
                            }

                            public boolean isRemoteAPIEnabled() {
                                return true;
                            }
                        };
                        UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)confirm);
                    }
                }.start();
            }
        }
    }

    public Object getDefault() {
        return this.getKeyHandler().getDefaultValue();
    }

    public String getTypeString() {
        Validator v = this.getValidator();
        Type gen = this.getKeyHandler().getGetMethod().getGenericReturnType();
        String ret = gen instanceof Class ? ((Class)gen).getSimpleName() : gen.toString();
        if (v != null) {
            ret = ret + " [" + v + "]";
        }
        return ret;
    }

    public boolean isEditable() {
        return true;
    }

    public Class<?> getClazz() {
        return this.getKeyHandler().getRawClass();
    }
}

