/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import java.util.Scanner;
import jd.parser.Regex;

public class SubtitleConverter {
    private static final String LINE_SEPERATOR = System.getProperty("line.separator");
    private static final String[][] REPLACE = new String[][]{{LINE_SEPERATOR, " "}, {"&gt;", ">"}, {"&lt;", "<"}, {"&amp;", "&"}, {"&quot;", "\""}, {"&#39;", "'"}};

    private static String convertSubtitleTime(double time) {
        int itime = (int)time;
        String hour = SubtitleConverter.leadingZero(itime / 3600, 2);
        String minute = SubtitleConverter.leadingZero(itime % 3600 / 60, 2);
        String second = SubtitleConverter.leadingZero(itime % 60, 2);
        String millisecond = SubtitleConverter.leadingZero((int)((time - (double)itime) * 1000.0), 3);
        String result = hour + ":" + minute + ":" + second + "," + millisecond;
        return result;
    }

    private static String leadingZero(int number, int digits) {
        int numberDigits = String.valueOf(number).length();
        assert (numberDigits <= digits) : "The number is bigger then expected!";
        String stringNumber = String.format(Locale.ROOT, "%0" + digits + "d", number);
        return stringNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean convertGoogleCC2SRTSubtitles(File in, File out) {
        BufferedWriter dest = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(out);
            dest = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
        }
        catch (IOException e1) {
            boolean bl = false;
            try {
                dest.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                fos.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return bl;
        }
        StringBuilder xml = new StringBuilder();
        int counter = 1;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(in);
            Scanner scan = new Scanner(new InputStreamReader((InputStream)fis, "UTF-8"));
            while (scan.hasNext()) {
                xml.append(scan.nextLine() + LINE_SEPERATOR);
            }
            scan.close();
        }
        catch (Exception e) {
            boolean bl = false;
            try {
                dest.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                fos.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return bl;
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
        String[][] matches = new Regex(xml.toString(), "<text start=\"(.*?)\".*?(dur=\"(.*?)\")?>(.*?)</text>").getMatches();
        try {
            String[] prevMatch = null;
            for (String[] match : matches) {
                if (prevMatch != null) {
                    SubtitleConverter.writeNewLine(dest, (String)prevMatch[0], match[0], prevMatch[3], counter++);
                    prevMatch = null;
                }
                if (match[1] == null) {
                    prevMatch = match;
                    continue;
                }
                SubtitleConverter.writeNewLine(dest, match[0], match[2], match[3], counter++);
            }
        }
        catch (Exception e) {
            boolean bl = false;
            try {
                dest.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                fos.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return bl;
        }
        finally {
            try {
                dest.close();
            }
            catch (Throwable throwable) {}
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
        in.delete();
        return true;
    }

    private static void writeNewLine(BufferedWriter dest, String from, String duration, String text, int counter) throws IOException {
        dest.write(counter + LINE_SEPERATOR);
        double start = Double.valueOf(from);
        double end = start + Double.valueOf(duration);
        dest.write(SubtitleConverter.convertSubtitleTime(start) + " --> " + SubtitleConverter.convertSubtitleTime(end) + LINE_SEPERATOR);
        text = text.trim();
        for (String[] replaceString : REPLACE) {
            text = text.replaceAll(replaceString[0], replaceString[1]);
        }
        dest.write(text + LINE_SEPERATOR + LINE_SEPERATOR);
    }
}

