/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.io.IOException;
import java.net.URL;
import jd.http.Authentication;
import jd.http.Browser;
import jd.http.Request;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.URLHelper;

public class BearerAuthentication
extends Authentication {
    protected final String token;

    public String getToken() {
        return this.token;
    }

    public BearerAuthentication(String host, String token, String realm) {
        super(false, host, null, null, realm);
        this.token = token;
    }

    @Override
    public boolean authorize(Browser browser, Request request) {
        if (StringUtils.endsWithCaseInsensitive((String)request.getURL().getHost(), (String)this.getHost()) && !this.isProxyAuthentication()) {
            request.getHeaders().put("Authorization", "Bearer " + this.getToken());
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BearerAuthentication)) {
            return false;
        }
        BearerAuthentication other = (BearerAuthentication)obj;
        if (!StringUtils.equals((String)this.getHost(), (String)other.getHost())) {
            return false;
        }
        if (!StringUtils.equals((String)this.getToken(), (String)other.getToken())) {
            return false;
        }
        return StringUtils.equals((String)this.getRealm(), (String)other.getRealm());
    }

    public int hashCode() {
        return BearerAuthentication.class.hashCode();
    }

    @Override
    public boolean retry(Browser browser, Request request) {
        return false;
    }

    @Override
    public String getURLWithUserInfo(URL url) throws IOException {
        if (url != null) {
            return URLHelper.createURL((String)url.getProtocol(), null, (String)url.getHost(), (int)url.getPort(), (String)url.getPath(), (String)url.getQuery(), (String)url.getRef());
        }
        return null;
    }

    public String toString() {
        return "Bearer Authorization[Host:" + this.getHost() + "|Realm:" + this.getRealm() + "|Token:" + this.getToken() + "]";
    }
}

