/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import jd.http.AbstractAuthenticationFactory;
import jd.http.Authentication;
import jd.http.BasicAuthentication;
import jd.http.Browser;
import jd.http.DigestAuthentication;
import jd.http.Request;
import org.appwork.utils.StringUtils;

public class DefaultAuthenticanFactory
extends AbstractAuthenticationFactory {
    protected final String host;
    protected final String realm;
    protected final String username;
    protected final String password;

    public String getRealm() {
        return this.realm;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public DefaultAuthenticanFactory(String host, String realm, String username, String password) {
        this.host = host;
        this.realm = realm;
        this.username = username;
        this.password = password;
    }

    @Override
    protected Authentication buildBasicAuthentication(Browser browser, Request request, String realm) {
        if (this.matches(browser, request, realm)) {
            return new BasicAuthentication(this.getHost(), this.getUsername(), this.getPassword(), realm);
        }
        return null;
    }

    protected boolean matchesHost(Request request) {
        return StringUtils.endsWithCaseInsensitive((String)request.getURL().getHost(), (String)this.getHost());
    }

    protected boolean matchesRealm(String realm) {
        return this.getRealm() == null || StringUtils.equalsIgnoreCase((String)realm, (String)this.getRealm()) || StringUtils.isEmpty((String)this.getRealm()) && StringUtils.isEmpty((String)realm);
    }

    protected boolean matches(Browser browser, Request request, String realm) {
        return this.matchesHost(request) && this.matchesRealm(realm) && (StringUtils.isNotEmpty((String)this.getUsername()) || StringUtils.isNotEmpty((String)this.getPassword()));
    }

    @Override
    protected Authentication buildDigestAuthentication(Browser browser, Request request, String realm) {
        if (this.matches(browser, request, realm)) {
            return DigestAuthentication.build(browser, request, realm, this.getUsername(), this.getPassword());
        }
        return null;
    }

    @Override
    public Authentication buildAuthentication(Browser browser, Request request) {
        if (this.matches(browser, request, this.getRealm(request))) {
            return super.buildAuthentication(browser, request);
        }
        return null;
    }

    @Override
    protected Authentication buildBearerAuthentication(Browser browser, Request request, String realm) {
        return null;
    }
}

