/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Arrays;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.WrappedBrotliInputStream;
import jd.http.requests.PostFormDataRequest;
import jd.http.requests.PostRequest;
import jd.parser.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.CountingPushbackInputStream;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.SSLSocketStreamInterface;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.appwork.utils.net.socketconnection.SocketConnection;

public class URLConnectionAdapterDirectImpl
extends HTTPConnectionImpl
implements URLConnectionAdapter {
    private Request request;
    private boolean allResponseCodesAllowed = false;
    protected SocketAddress endPointSocketAddress;
    private PushbackInputStream pushbackInputStream = null;

    public URLConnectionAdapterDirectImpl(URL url) {
        super(url);
    }

    @Override
    public void setAllResponseCodesAllowed(boolean b) {
        this.allResponseCodesAllowed = b;
    }

    @Override
    public boolean isAllResponseCodesAllowed() {
        return this.allResponseCodesAllowed;
    }

    protected boolean isResponseCodeAllowed(int code) {
        return this.isAllResponseCodesAllowed() || super.isResponseCodeAllowed(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] peek(URLConnectionAdapter con, int numBytes) throws IOException {
        CountingPushbackInputStream is;
        InputStream conInputStream = con.getInputStream();
        if (conInputStream instanceof CountingPushbackInputStream && ((CountingPushbackInputStream)conInputStream).capacity() >= numBytes) {
            is = (CountingPushbackInputStream)conInputStream;
        } else {
            is = new CountingPushbackInputStream(conInputStream, numBytes);
            con.setInputStream((InputStream)is);
        }
        byte[] probe = new byte[numBytes];
        int probeIndex = 0;
        try {
            int read;
            for (probeIndex = 0; probeIndex < probe.length && (read = is.read()) != -1; ++probeIndex) {
                probe[probeIndex] = (byte)read;
            }
            byte[] byArray = Arrays.copyOf(probe, probeIndex);
            return byArray;
        }
        finally {
            if (probeIndex > 0) {
                is.unread(probe, 0, probeIndex);
            }
        }
    }

    @Override
    public byte[] peek(int numBytes) throws IOException {
        return URLConnectionAdapterDirectImpl.peek(this, numBytes);
    }

    protected SSLSocketStreamOptions getSSLSocketStreamOptions(SSLSocketStreamOptions options) {
        Request request = this.getRequest();
        if (request != null) {
            return request.getSSLSocketStreamOptions(options, this);
        }
        return options;
    }

    public URLConnectionAdapterDirectImpl(URL url, HTTPProxy proxy) {
        super(url, proxy);
    }

    @Override
    public InputStream getErrorStream() {
        try {
            return super.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isLegacyConnectEnabled() {
        return false;
    }

    public long[] getRange() {
        long[] ret = super.getRange();
        if (ret == null && this.getResponseCode() == 206) {
            this.ranges = URLConnectionAdapterDirectImpl.buildFakeContentRange(this);
            return this.ranges;
        }
        return ret;
    }

    protected static long[] buildFakeContentRange(HTTPConnection connection) {
        if (connection.getResponseCode() == 206 && connection.getHeaderField("Content-Range") == null) {
            long contentLength = connection.getContentLength();
            String rangeRequested = connection.getRequestProperty("Range");
            if (rangeRequested != null && contentLength >= 0L) {
                String fromByte = new Regex(rangeRequested, "bytes\\s*=\\s*(\\d*)\\s*-").getMatch(0);
                String toByte = new Regex(rangeRequested, "bytes\\s*=\\s*.*?-\\s*(\\d*)").getMatch(0);
                if (StringUtils.isNotEmpty((String)fromByte)) {
                    if (StringUtils.isNotEmpty((String)toByte)) {
                        if (contentLength == Long.parseLong(toByte) - Long.parseLong(fromByte) + 1L) {
                            return new long[]{Long.parseLong(fromByte), Long.parseLong(toByte), -1L};
                        }
                    } else {
                        long from = Long.parseLong(fromByte);
                        long to = from + contentLength - 1L;
                        return new long[]{from, to, to + 1L};
                    }
                }
            }
        }
        return null;
    }

    @Override
    public long getLongContentLength() {
        return this.getContentLength();
    }

    protected boolean isRequiresOutputStream() {
        return super.isRequiresOutputStream() || this.request != null && this.request.requireOutputStream();
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(Request request) {
        InetAddress customInetAddress;
        this.request = request;
        if (request != null && (customInetAddress = request.getCustomInetAddress()) != null) {
            this.setRemoteIPs(new InetAddress[]{customInetAddress});
        }
    }

    protected boolean isKeepAliveOK() {
        return (this.request == null || this.request.isKeepAlivePermitted(this)) && super.isKeepAliveOK();
    }

    public InputStream getInputStream() throws IOException {
        if (this.convertedInputStream == null && !HTTPConnection.RequestMethod.HEAD.equals((Object)this.getRequestMethod())) {
            String encoding;
            super.getInputStream();
            if (!this.isContentDecoded() && "br".equalsIgnoreCase(encoding = this.getHeaderField("Content-Encoding"))) {
                this.convertedInputStream = new WrappedBrotliInputStream(this.convertedInputStream);
                this.contentDecoded = true;
            }
        }
        return super.getInputStream();
    }

    @Override
    public InputStream setInputStream(InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        InputStream ret = this.convertedInputStream;
        if (ret == null) {
            ret = this.getInputStream();
        }
        if (is == ret) {
            return is;
        }
        this.convertedInputStream = is;
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(300);
        Request req = this.getRequest();
        if (req != null) {
            sb.append("Caller: " + req.getCaller());
            sb.append("\r\n");
            sb.append("BrowserID:" + req.getBrowserID() + "|BrowserParentID:" + req.getBrowserParentID() + "|RequestID:" + req.getRequestID() + "|URL:" + req.getURL());
            sb.append("\r\n");
        }
        sb.append(this.getRequestInfo());
        if (req != null) {
            String postDataString;
            if (req instanceof PostRequest) {
                String log = ((PostRequest)req).log();
                if (log != null) {
                    sb.append("\r\n");
                    sb.append(log);
                }
            } else if (req instanceof PostFormDataRequest && (postDataString = ((PostFormDataRequest)req).getPostDataString()) != null) {
                sb.append("\r\n");
                sb.append(postDataString);
            }
            sb.append("\r\n");
        }
        sb.append(this.getResponseInfo());
        return sb.toString();
    }

    public void disconnect() {
        try {
            this.getEndPointSocketAddress();
        }
        finally {
            super.disconnect();
        }
    }

    @Override
    public SocketAddress getEndPointSocketAddress() {
        if (this.endPointSocketAddress == null) {
            this.endPointSocketAddress = SocketConnection.getRootEndPointSocketAddress((SocketStreamInterface)this.getConnectionSocket());
        }
        return this.endPointSocketAddress;
    }

    @Override
    public String getCipherSuite() {
        SocketStreamInterface socket = this.getConnectionSocket();
        if (socket != null && socket instanceof SSLSocketStreamInterface) {
            return ((SSLSocketStreamInterface)socket).getCipherSuite();
        }
        return null;
    }

    protected void resetConnection() {
        super.resetConnection();
        this.pushbackInputStream = null;
    }
}

