/*
 * Decompiled with CFR 0.152.
 */
package jd.http.requests;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class FormData {
    private static final String DEFAULT_MIME = "application/octet-stream";
    private byte[] data;
    private File file;
    private String mime;
    private final String name;
    private final Type type;
    private final String value;
    private FormDataOutputStream stream;

    public FormDataOutputStream getStream() {
        return this.stream;
    }

    public FormData(String name, String value) {
        this.type = Type.VARIABLE;
        this.name = name;
        this.value = value;
    }

    public FormData(String name, String filename, byte[] data) {
        this(name, filename, null, data);
    }

    public FormData(String name, String filename, File file) {
        this(name, filename, null, file);
    }

    public FormData(String name, String filename, String mime, byte[] data) {
        this.mime = mime == null ? DEFAULT_MIME : mime;
        this.type = Type.DATA;
        this.name = name;
        this.value = filename;
        this.data = data;
    }

    public FormData(String name, String filename, String mime, File file) {
        this.mime = mime == null ? DEFAULT_MIME : mime;
        this.type = Type.FILE;
        this.name = name;
        this.value = filename;
        this.file = file;
    }

    public FormData(String name, String filename, String mime, FormDataOutputStream stream) {
        this.mime = mime == null ? DEFAULT_MIME : mime;
        this.type = Type.STREAM;
        this.name = name;
        this.value = filename;
        this.stream = stream;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getDataType() {
        String ret = this.mime;
        if (ret != null) {
            return ret;
        }
        return DEFAULT_MIME;
    }

    public String toString() {
        switch (this.getType()) {
            case DATA: 
            case STREAM: {
                return (Object)((Object)this.getType()) + ":" + this.getName();
            }
            case FILE: {
                return (Object)((Object)this.getType()) + ":" + this.getName() + "=" + this.getFile();
            }
        }
        return (Object)((Object)this.getType()) + ":" + this.getName() + "=" + this.getValue();
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public static enum Type {
        DATA,
        FILE,
        VARIABLE,
        STREAM;

    }

    public static interface FormDataOutputStream {
        public void writeTo(OutputStream var1) throws IOException;

        public void onIOException(IOException var1) throws IOException;

        public void onClosed();
    }
}

