/*
 * Decompiled with CFR 0.152.
 */
package jd.http.requests;

import java.io.IOException;
import java.net.URL;
import jd.http.Request;
import jd.http.RequestHeader;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpconnection.HTTPConnection;

public class HeadRequest
extends Request {
    public HeadRequest(Request cloneRequest) {
        super(cloneRequest);
    }

    public HeadRequest(String url) throws IOException {
        super(url);
    }

    public HeadRequest(URL url) throws IOException {
        super(url);
    }

    @Override
    protected boolean sendHTTPHeader(HTTPHeader header) {
        return super.sendHTTPHeader(header) && !StringUtils.equalsIgnoreCase((String)header.getKey(), (String)"Content-Length");
    }

    @Override
    public HeadRequest cloneRequest() {
        return new HeadRequest(this);
    }

    @Override
    protected RequestHeader getDefaultRequestHeader(URL url) {
        RequestHeader ret = super.getDefaultRequestHeader(url);
        ret.put("Accept-Encoding", "identity");
        return ret;
    }

    @Override
    public HeadRequest setXHR(boolean b) {
        super.setXHR(b);
        return this;
    }

    @Override
    public long postRequest() throws IOException {
        return 0L;
    }

    @Override
    public HTTPConnection.RequestMethod getRequestMethod() {
        return HTTPConnection.RequestMethod.HEAD;
    }

    @Override
    public void preRequest() throws IOException {
        this.httpConnection.setRequestMethod(this.getRequestMethod());
    }
}

