/*
 * Decompiled with CFR 0.152.
 */
package jd.http.requests;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import org.appwork.utils.KeyValueEntry;
import org.appwork.utils.KeyValueStringEntry;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.CountingOutputStream;
import org.appwork.utils.net.NullOutputStream;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.parser.UrlQuery;

public class PostRequest
extends Request {
    private final List<KeyValueStringEntry> postVariables = new ArrayList<KeyValueStringEntry>();
    private String postString = null;
    private String contentType = null;
    private byte[] postBytes = null;
    private SEND sendWHAT = null;

    public static List<KeyValueStringEntry> queryToVariableList(UrlQuery post) {
        if (post == null) {
            return null;
        }
        ArrayList<KeyValueStringEntry> ret = new ArrayList<KeyValueStringEntry>();
        for (KeyValueEntry entry : post.list()) {
            ret.add(new KeyValueStringEntry((String)entry.getKey(), (String)entry.getValue()));
        }
        return ret;
    }

    public PostRequest(Request cloneRequest) {
        super(cloneRequest);
        if (cloneRequest instanceof PostRequest) {
            PostRequest postRequest = (PostRequest)cloneRequest;
            this.addAll(postRequest.postVariables);
            this.sendWHAT = postRequest.sendWHAT;
            this.postString = postRequest.postString;
            this.setContentType(postRequest.getContentType());
            this.setPostBytes(postRequest.getPostBytes());
        }
    }

    @Override
    public PostRequest setXHR(boolean b) {
        super.setXHR(b);
        return this;
    }

    public PostRequest(String url) throws IOException {
        super(url);
    }

    public PostRequest(URL url) throws IOException {
        super(url);
    }

    public void addAll(HashMap<String, String> post) {
        for (Map.Entry<String, String> entry : post.entrySet()) {
            this.postVariables.add(new KeyValueStringEntry(entry));
        }
    }

    public void addAll(List<KeyValueStringEntry> post) {
        this.postVariables.addAll(post);
    }

    public void addVariable(String key, String value) {
        this.postVariables.add(new KeyValueStringEntry(key, value));
    }

    public void put(String key, String value) {
        int index;
        KeyValueStringEntry existing = this.getKeyValue(key);
        KeyValueStringEntry newEntry = new KeyValueStringEntry(key, value);
        int n = index = existing != null ? this.postVariables.indexOf(existing) : -1;
        if (index != -1) {
            this.postVariables.set(index, newEntry);
        } else {
            this.postVariables.add(newEntry);
        }
    }

    public KeyValueStringEntry getKeyValue(String key) {
        for (KeyValueStringEntry input : this.postVariables) {
            if (input.getKey() == null || !((String)input.getKey()).equalsIgnoreCase(key)) continue;
            return input;
        }
        return null;
    }

    @Override
    public PostRequest cloneRequest() {
        PostRequest ret = this.cloneRequestRaw();
        ret.addAll(this.postVariables);
        ret.sendWHAT = this.sendWHAT;
        ret.postString = this.postString;
        ret.setContentType(this.getContentType());
        ret.setPostBytes(this.getPostBytes());
        return ret;
    }

    protected PostRequest cloneRequestRaw() {
        return new PostRequest(this);
    }

    public String getPostDataString() {
        SEND mode = this.getMode();
        if (mode != null) {
            switch (mode) {
                case STRING: {
                    return this.postString;
                }
                case VARIABLES: {
                    StringBuilder buffer = new StringBuilder();
                    for (KeyValueStringEntry rv : this.postVariables) {
                        if (rv.getKey() == null) continue;
                        buffer.append("&");
                        buffer.append((String)rv.getKey());
                        buffer.append("=");
                        String value = (String)rv.getValue();
                        if (value == null) continue;
                        buffer.append(value);
                    }
                    if (buffer.length() == 0) {
                        return "";
                    }
                    return buffer.substring(1);
                }
            }
            return null;
        }
        return null;
    }

    public String log() {
        if (this.sendWHAT == null) {
            return null;
        }
        switch (this.sendWHAT) {
            case NOTHING: {
                return "zero content send";
            }
            case BYTES: {
                return this.postBytes.length + " raw-bytes send";
            }
            case STRING: 
            case VARIABLES: {
                return this.getPostDataString();
            }
        }
        return "unknown postData send:" + (Object)((Object)this.sendWHAT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long postContent(URLConnectionAdapter httpConnection) throws IOException {
        if (this.sendWHAT == null) {
            throw new IOException("preRequest needs to be called first!");
        }
        Object os = httpConnection != null && httpConnection.getOutputStream() != null ? httpConnection.getOutputStream() : new CountingOutputStream((OutputStream)new NullOutputStream());
        CountingOutputStream output = new CountingOutputStream((OutputStream)os){

            public void close() throws IOException {
            }
        };
        try {
            switch (this.sendWHAT) {
                case NOTHING: {
                    long l = 0L;
                    return l;
                }
                case BYTES: {
                    output.write(this.postBytes);
                    break;
                }
                case STRING: 
                case VARIABLES: {
                    String postString = this.getPostDataString();
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
                    writer.write(postString);
                    writer.flush();
                    writer.close();
                    break;
                }
                default: {
                    throw new IOException("not implemented " + this.sendWHAT.name());
                }
            }
            long l = output.transferedBytes();
            return l;
        }
        finally {
            output.close();
        }
    }

    @Override
    public long postRequest() throws IOException {
        this.httpConnection.connect();
        return this.postContent(this.httpConnection);
    }

    @Override
    public void preRequest() throws IOException {
        this.httpConnection.setRequestMethod(this.getRequestMethod());
        if (this.contentType != null) {
            this.httpConnection.setRequestProperty("Content-Type", this.contentType);
        }
        if (this.postVariables != null && this.postVariables.size() > 0) {
            this.sendWHAT = SEND.VARIABLES;
            this.httpConnection.setRequestProperty("Content-Length", this.postContent(null) + "");
        } else if (!StringUtils.isEmpty((String)this.postString)) {
            this.sendWHAT = SEND.STRING;
            this.httpConnection.setRequestProperty("Content-Length", this.postContent(null) + "");
        } else if (this.postBytes != null) {
            this.sendWHAT = SEND.BYTES;
            this.httpConnection.setRequestProperty("Content-Length", this.postContent(null) + "");
        } else {
            this.sendWHAT = SEND.NOTHING;
            this.httpConnection.setRequestProperty("Content-Length", "0");
        }
    }

    public SEND getMode() {
        return this.sendWHAT;
    }

    @Override
    public HTTPConnection.RequestMethod getRequestMethod() {
        return HTTPConnection.RequestMethod.POST;
    }

    @Override
    protected boolean requireOutputStream() {
        return true;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setPostBytes(byte[] post) {
        this.postBytes = post;
    }

    public byte[] getPostBytes() {
        return this.postBytes;
    }

    public void setPostDataString(String post) {
        this.postString = post;
    }

    private static enum SEND {
        VARIABLES,
        STRING,
        BYTES,
        NOTHING;

    }
}

