/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.SSLSocketUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ProvSSLSocketBase
extends SSLSocket
implements BCSSLSocket {
    protected static final boolean provAssumeOriginalHostName = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.assumeOriginalHostName", false);
    protected static final boolean provJdkTlsTrustNameService = PropertyUtils.getBooleanSystemProperty("jdk.tls.trustNameService", false);
    protected final Closeable socketCloser = new Closeable(){

        public void close() throws IOException {
            ProvSSLSocketBase.this.closeSocket();
        }
    };
    protected final Map<HandshakeCompletedListener, AccessControlContext> listeners = Collections.synchronizedMap(new HashMap(4));

    protected ProvSSLSocketBase() {
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (handshakeCompletedListener == null) {
            throw new IllegalArgumentException("'listener' cannot be null");
        }
        this.listeners.put(handshakeCompletedListener, AccessController.getContext());
    }

    protected void closeSocket() throws IOException {
        super.close();
    }

    @Override
    public void connect(String string, int n, int n2) throws IOException {
        this.setHost(string);
        this.connect(this.createInetSocketAddress(string, n), n2);
    }

    @Override
    public final boolean getOOBInline() throws SocketException {
        throw new SocketException("This method is ineffective, since sending urgent data is not supported by SSLSockets");
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (handshakeCompletedListener == null) {
            throw new IllegalArgumentException("'listener' cannot be null");
        }
        if (null == this.listeners.remove(handshakeCompletedListener)) {
            throw new IllegalArgumentException("'listener' is not registered");
        }
    }

    @Override
    public final void sendUrgentData(int n) throws IOException {
        throw new SocketException("This method is not supported by SSLSockets");
    }

    @Override
    public final void setOOBInline(boolean bl) throws SocketException {
        throw new SocketException("This method is ineffective, since sending urgent data is not supported by SSLSockets");
    }

    protected InetSocketAddress createInetSocketAddress(InetAddress inetAddress, int n) throws IOException {
        return new InetSocketAddress(inetAddress, n);
    }

    protected InetSocketAddress createInetSocketAddress(String string, int n) throws IOException {
        return null == string ? new InetSocketAddress(InetAddress.getByName(null), n) : new InetSocketAddress(string, n);
    }

    protected void implBind(InetAddress inetAddress, int n) throws IOException {
        this.bind(this.createInetSocketAddress(inetAddress, n));
    }

    protected void implConnect(InetAddress inetAddress, int n) throws IOException {
        this.connect(this.createInetSocketAddress(inetAddress, n), 0);
    }

    protected void implConnect(String string, int n) throws IOException, UnknownHostException {
        this.connect(this.createInetSocketAddress(string, n), 0);
    }

    protected void notifyHandshakeCompletedListeners(SSLSession sSLSession) {
        final Collection<Map.Entry<HandshakeCompletedListener, AccessControlContext>> collection = this.getHandshakeCompletedEntries();
        if (null == collection) {
            return;
        }
        final HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent(this, sSLSession);
        Runnable runnable = new Runnable(){

            public void run() {
                for (Map.Entry entry : collection) {
                    final HandshakeCompletedListener handshakeCompletedListener = (HandshakeCompletedListener)entry.getKey();
                    AccessControlContext accessControlContext = (AccessControlContext)entry.getValue();
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            handshakeCompletedListener.handshakeCompleted(handshakeCompletedEvent);
                            return null;
                        }
                    }, accessControlContext);
                }
            }
        };
        SSLSocketUtil.handshakeCompleted(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Map.Entry<HandshakeCompletedListener, AccessControlContext>> getHandshakeCompletedEntries() {
        Map<HandshakeCompletedListener, AccessControlContext> map = this.listeners;
        synchronized (map) {
            return this.listeners.isEmpty() ? null : new ArrayList<Map.Entry<HandshakeCompletedListener, AccessControlContext>>(this.listeners.entrySet());
        }
    }
}

