/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvX509Key;
import org.bouncycastle.jsse.provider.ProvX509KeyManager;
import org.bouncycastle.jsse.provider.TransportData;
import org.bouncycastle.tls.TlsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvX509KeyManagerSimple
extends BCX509ExtendedKeyManager {
    private static final Logger LOG = Logger.getLogger(ProvX509KeyManagerSimple.class.getName());
    private final boolean fipsMode;
    private final JcaJceHelper helper;
    private final Map<String, Credential> credentials;

    private static Map<String, Credential> loadCredentials(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        HashMap<String, Credential> hashMap = new HashMap<String, Credential>(4);
        if (null != keyStore) {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray;
                PrivateKey privateKey;
                String string = enumeration.nextElement();
                if (!keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class) || null == (privateKey = (PrivateKey)keyStore.getKey(string, cArray)) || TlsUtils.isNullOrEmpty(objectArray = JsseUtils.getX509CertificateChain(keyStore.getCertificateChain(string)))) continue;
                hashMap.put(string, new Credential(string, privateKey, (X509Certificate[])objectArray));
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    ProvX509KeyManagerSimple(boolean bl, JcaJceHelper jcaJceHelper, KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.fipsMode = bl;
        this.helper = jcaJceHelper;
        this.credentials = ProvX509KeyManagerSimple.loadCredentials(keyStore, cArray);
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(stringArray), principalArray, TransportData.from(socket), false);
    }

    @Override
    public BCX509Key chooseClientKeyBC(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(stringArray), principalArray, TransportData.from(socket), false);
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(stringArray), principalArray, TransportData.from(sSLEngine), false);
    }

    @Override
    public BCX509Key chooseEngineClientKeyBC(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(stringArray), principalArray, TransportData.from(sSLEngine), false);
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(string), principalArray, TransportData.from(sSLEngine), true);
    }

    @Override
    public BCX509Key chooseEngineServerKeyBC(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(stringArray), principalArray, TransportData.from(sSLEngine), true);
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(string), principalArray, TransportData.from(socket), true);
    }

    @Override
    public BCX509Key chooseServerKeyBC(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(stringArray), principalArray, TransportData.from(socket), true);
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        Credential credential = this.getCredential(string);
        return null == credential ? null : (X509Certificate[])credential.certificateChain.clone();
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.getAliases(ProvX509KeyManager.getKeyTypes(string), principalArray, null, false);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        Credential credential = this.getCredential(string);
        return null == credential ? null : credential.privateKey;
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.getAliases(ProvX509KeyManager.getKeyTypes(string), principalArray, null, true);
    }

    @Override
    protected BCX509Key getKeyBC(String string, String string2) {
        Credential credential = this.getCredential(string2);
        return this.createKeyBC(string, credential);
    }

    private String chooseAlias(List<String> list, Principal[] principalArray, TransportData transportData, boolean bl) {
        Match match = this.getBestMatch(list, principalArray, transportData, bl);
        if (match.compareTo(Match.NOTHING) < 0) {
            String string = list.get(match.keyTypeIndex);
            String string2 = ProvX509KeyManagerSimple.getAlias(match);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Found matching key of type: " + string + ", returning alias: " + string2);
            }
            return string2;
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key chooseKeyBC(List<String> list, Principal[] principalArray, TransportData transportData, boolean bl) {
        String string;
        BCX509Key bCX509Key;
        Match match = this.getBestMatch(list, principalArray, transportData, bl);
        if (match.compareTo(Match.NOTHING) < 0 && null != (bCX509Key = this.createKeyBC(string = list.get(match.keyTypeIndex), match.credential))) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Found matching key of type: " + string + ", from alias: " + ProvX509KeyManagerSimple.getAlias(match));
            }
            return bCX509Key;
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key createKeyBC(String string, Credential credential) {
        return null == credential ? null : new ProvX509Key(string, credential.privateKey, credential.certificateChain);
    }

    private String[] getAliases(List<String> list, Principal[] principalArray, TransportData transportData, boolean bl) {
        if (!this.credentials.isEmpty() && !list.isEmpty()) {
            int n = list.size();
            Set<Principal> set = ProvX509KeyManager.getUniquePrincipals(principalArray);
            BCAlgorithmConstraints bCAlgorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date date = new Date();
            String string = ProvX509KeyManager.getRequestedHostName(transportData, bl);
            List<Match> list2 = null;
            for (Credential credential : this.credentials.values()) {
                Match match = this.getPotentialMatch(credential, list, n, set, bCAlgorithmConstraints, bl, date, string);
                if (match.compareTo(Match.NOTHING) >= 0) continue;
                list2 = ProvX509KeyManagerSimple.addToMatches(list2, match);
            }
            if (null != list2 && !list2.isEmpty()) {
                Collections.sort(list2);
                return ProvX509KeyManagerSimple.getAliases(list2);
            }
        }
        return null;
    }

    private Match getBestMatch(List<String> list, Principal[] principalArray, TransportData transportData, boolean bl) {
        Match match = Match.NOTHING;
        if (!this.credentials.isEmpty() && !list.isEmpty()) {
            int n = list.size();
            Set<Principal> set = ProvX509KeyManager.getUniquePrincipals(principalArray);
            BCAlgorithmConstraints bCAlgorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date date = new Date();
            String string = ProvX509KeyManager.getRequestedHostName(transportData, bl);
            for (Credential credential : this.credentials.values()) {
                Match match2 = this.getPotentialMatch(credential, list, n, set, bCAlgorithmConstraints, bl, date, string);
                if (match2.compareTo(match) >= 0) continue;
                match = match2;
                if (match.isIdeal()) {
                    return match;
                }
                if (!match.isValid()) continue;
                n = Math.min(n, match.keyTypeIndex + 1);
            }
        }
        return match;
    }

    private Match getPotentialMatch(Credential credential, List<String> list, int n, Set<Principal> set, BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl, Date date, String string) {
        ProvX509KeyManager.MatchQuality matchQuality;
        X509Certificate[] x509CertificateArray = credential.certificateChain;
        int n2 = ProvX509KeyManager.getPotentialKeyType(list, n, set, bCAlgorithmConstraints, bl, x509CertificateArray);
        if (n2 >= 0 && ProvX509KeyManager.MatchQuality.NONE != (matchQuality = ProvX509KeyManager.getKeyTypeQuality(this.fipsMode, this.helper, list, bCAlgorithmConstraints, bl, date, string, x509CertificateArray, n2))) {
            return new Match(matchQuality, n2, credential);
        }
        return Match.NOTHING;
    }

    private Credential getCredential(String string) {
        return null == string ? null : this.credentials.get(string);
    }

    private static List<Match> addToMatches(List<Match> list, Match match) {
        if (null == list) {
            list = new ArrayList<Match>();
        }
        list.add(match);
        return list;
    }

    private static String getAlias(Match match) {
        return match.credential.alias;
    }

    private static String[] getAliases(List<Match> list) {
        int n = list.size();
        int n2 = 0;
        String[] stringArray = new String[n];
        for (Match match : list) {
            stringArray[n2++] = ProvX509KeyManagerSimple.getAlias(match);
        }
        return stringArray;
    }

    private static class Credential {
        private final String alias;
        private final PrivateKey privateKey;
        private final X509Certificate[] certificateChain;

        Credential(String string, PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
            this.alias = string;
            this.privateKey = privateKey;
            this.certificateChain = x509CertificateArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Match
    implements Comparable<Match> {
        static final ProvX509KeyManager.MatchQuality INVALID = ProvX509KeyManager.MatchQuality.MISMATCH_SNI;
        static final Match NOTHING = new Match(ProvX509KeyManager.MatchQuality.NONE, Integer.MAX_VALUE, null);
        final ProvX509KeyManager.MatchQuality quality;
        final int keyTypeIndex;
        final Credential credential;

        Match(ProvX509KeyManager.MatchQuality matchQuality, int n, Credential credential) {
            this.quality = matchQuality;
            this.keyTypeIndex = n;
            this.credential = credential;
        }

        @Override
        public int compareTo(Match match) {
            boolean bl;
            boolean bl2 = this.isValid();
            if (bl2 != (bl = match.isValid())) {
                return bl2 ? -1 : 1;
            }
            if (this.keyTypeIndex != match.keyTypeIndex) {
                return this.keyTypeIndex < match.keyTypeIndex ? -1 : 1;
            }
            return this.quality.compareTo(match.quality);
        }

        boolean isIdeal() {
            return ProvX509KeyManager.MatchQuality.OK == this.quality && 0 == this.keyTypeIndex;
        }

        boolean isValid() {
            return this.quality.compareTo(INVALID) < 0;
        }
    }
}

