/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.util;

import java.net.Socket;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.util.CustomSSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetHostSocketFactory
extends CustomSSLSocketFactory {
    private static final Logger LOG = Logger.getLogger(SetHostSocketFactory.class.getName());
    protected static final ThreadLocal<SetHostSocketFactory> threadLocal = new ThreadLocal();
    protected final String host;

    public static SocketFactory getDefault() {
        SSLSocketFactory sSLSocketFactory = threadLocal.get();
        if (null != sSLSocketFactory) {
            return sSLSocketFactory;
        }
        return SSLSocketFactory.getDefault();
    }

    public SetHostSocketFactory(SSLSocketFactory sSLSocketFactory, URL uRL) {
        this(sSLSocketFactory, uRL == null ? null : uRL.getHost());
    }

    public SetHostSocketFactory(SSLSocketFactory sSLSocketFactory, String string) {
        super(sSLSocketFactory);
        this.host = string;
    }

    public <V> V call(Callable<V> callable) throws Exception {
        try {
            threadLocal.set(this);
            V v = callable.call();
            return v;
        }
        finally {
            threadLocal.remove();
        }
    }

    @Override
    protected Socket configureSocket(Socket socket) {
        if (this.host != null && socket instanceof BCSSLSocket) {
            BCSSLSocket bCSSLSocket = (BCSSLSocket)((Object)socket);
            LOG.fine("Setting host on socket: " + this.host);
            bCSSLSocket.setHost(this.host);
        }
        return socket;
    }
}

